/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataSerializerFactory;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformTransaction;
import com.nexacro.xapi.tx.ProtocolDecoder;
import com.nexacro.xapi.tx.ProtocolFilterFactory;
import com.nexacro.xapi.tx.StreamLog;
import com.nexacro.xapi.tx.StreamLogInputStream;
import com.nexacro.xapi.tx.StreamLogReader;
import com.nexacro.xapi.util.PlatformGlobals;
import com.nexacro.xapi.util.SequenceReader;
import java.io.ByteArrayInputStream;
import java.io.CharArrayReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformRequest
extends PlatformTransaction {
    private Log log = LogFactory.getLog((Class)PlatformRequest.class);
    private static final String IO_CLOSE_KEY = "platform.tx.PlatformRequest.ioclose";
    private static final String STREAM_LOG_ENABLED_KEY = "platform.tx.PlatformRequest.streamlog.enabled";
    private static final String STREAM_LOG_DIR_KEY = "platform.tx.PlatformRequest.streamlog.dir";
    private static final String STREAM_LOG_MAXSIZE_KEY = "platform.tx.PlatformRequest.streamlog.maxsize";
    private static final String STREAM_LOG_PREFIX_KEY = "platform.tx.PlatformRequest.streamlog.prefix";
    private static final String STREAM_LOG_SUFFIX_KEY = "platform.tx.PlatformRequest.streamlog.suffix";
    private static final String STREAM_LOG_EXCEEDED_SIZE_KEY = "platform.tx.PlatformRequest.streamlog.exceededsize";
    private InputStream in;
    private Reader reader;
    private StreamLogInputStream logStream;
    private StreamLogReader logReader;
    private StreamLog streamLog;

    public PlatformRequest() {
    }

    public PlatformRequest(String string) {
        this(string, null);
    }

    public PlatformRequest(String string, String string2) {
        super(string, string2);
    }

    public PlatformRequest(InputStream inputStream) {
        this(inputStream, null);
    }

    public PlatformRequest(InputStream inputStream, String string) {
        this(inputStream, string, null);
    }

    public PlatformRequest(InputStream inputStream, String string, String string2) {
        super(string, string2);
        this.in = inputStream;
    }

    public PlatformRequest(Reader reader) {
        this(reader, null);
    }

    public PlatformRequest(Reader reader, String string) {
        this(reader, string, null);
    }

    public PlatformRequest(Reader reader, String string, String string2) {
        super(string, string2);
        this.reader = reader;
    }

    public Object getProperty(String string) {
        return super.getProperty(string);
    }

    public void setProperty(String string, Object object) {
        super.setProperty(string, object);
    }

    public void receiveData() throws PlatformException {
        this.checkLicense();
        this.checkGlobalStreamLog();
        boolean bl = this.isCurrentVerbose();
        long l = System.currentTimeMillis();
        if (bl) {
            if (this.log.isInfoEnabled()) {
                try {
                    this.log.info((Object)("Receiving data: " + URLEncoder.encode(this.toSimpleString(), "UTF-8") + ", contentType=" + (this.getContentType() != null ? URLEncoder.encode(this.getContentType(), "UTF-8") : null) + ", charset=" + (this.getCharset() != null ? URLEncoder.encode(this.getCharset(), "UTF-8") : null)));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        } else if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Receiving data: " + URLEncoder.encode(this.toSimpleString(), "UTF-8") + ", contentType=" + (this.getContentType() != null ? URLEncoder.encode(this.getContentType(), "UTF-8") : null) + ", charset=" + (this.getCharset() != null ? URLEncoder.encode(this.getCharset(), "UTF-8") : null) + ", startTime=" + l));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            this.checkStream();
            if (this.useInputStream()) {
                this.readFrom(this.getInputStream());
            } else {
                this.readFrom(this.getReader());
            }
        }
        catch (PlatformException platformException) {
            block22: {
                try {
                    this.storeStreamLog();
                }
                catch (IOException iOException) {
                    if (!this.log.isErrorEnabled()) break block22;
                    this.log.error((Object)"Storing stream failed", (Throwable)iOException);
                }
            }
            throw platformException;
        }
        catch (Throwable throwable) {
            block23: {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Receiving data failed", throwable);
                }
                try {
                    this.storeStreamLog();
                }
                catch (IOException iOException) {
                    if (!this.log.isErrorEnabled()) break block23;
                    this.log.error((Object)"Storing stream failed", (Throwable)iOException);
                }
            }
            throw new PlatformException("Receiving data failed", throwable);
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (bl) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Received data: " + this.toSimpleString() + ", elapsedTime=" + l3));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received data: " + this.toSimpleString() + ", elapsedTime=" + l3 + ", endTime=" + l2));
        }
    }

    public boolean isStreamLogEnabled() {
        return this.streamLog == null ? false : this.streamLog.isLogEnabled();
    }

    public void setStreamLogEnabled(boolean bl) {
        this.checkStreamLog();
        this.streamLog.setLogEnabled(bl);
    }

    public String getStreamLogDir() {
        return this.streamLog == null ? null : this.streamLog.getLogDir();
    }

    public void setStreamLogDir(String string) {
        this.checkStreamLog();
        this.streamLog.setLogDir(string);
    }

    public int getStreamLogMaxSize() {
        return this.streamLog == null ? 0 : this.streamLog.getLogMaxSize();
    }

    public void setStreamLogMaxSize(int n) {
        this.checkStreamLog();
        this.streamLog.setLogMaxSize(n);
    }

    public String getStreamLogPrefix() {
        return this.streamLog == null ? null : this.streamLog.getLogPrefix();
    }

    public void setStreamLogPrefix(String string) {
        this.checkStreamLog();
        this.streamLog.setLogPrefix(string);
    }

    public String getStreamLogSuffix() {
        return this.streamLog == null ? null : this.streamLog.getLogSuffix();
    }

    public void setStreamLogSuffix(String string) {
        this.checkStreamLog();
        this.streamLog.setLogSuffix(string);
    }

    public void storeStreamLog() throws IOException {
        if (this.isStreamLogEnabled()) {
            if (this.useInputStream()) {
                if (this.logStream == null) {
                    new StreamLogInputStream(null, this.streamLog).storeStreamLog();
                } else {
                    this.logStream.storeStreamLog();
                }
            } else if (this.logReader == null) {
                new StreamLogReader(null, this.streamLog).storeStreamLog();
            } else {
                this.logReader.storeStreamLog();
            }
        }
    }

    InputStream getInputStream() {
        if (this.isStreamLogEnabled()) {
            if (this.logStream == null) {
                this.logStream = new StreamLogInputStream(this.in, this.streamLog);
            }
            return this.logStream;
        }
        return this.in;
    }

    void setInputStream(InputStream inputStream) {
        this.in = inputStream;
    }

    Reader getReader() {
        if (this.isStreamLogEnabled()) {
            if (this.logReader == null) {
                this.logReader = new StreamLogReader(this.reader, this.streamLog);
            }
            return this.logReader;
        }
        return this.reader;
    }

    void setReader(Reader reader) {
        this.reader = reader;
    }

    boolean useInputStream() {
        return this.reader == null;
    }

    private void readFrom(InputStream inputStream) throws PlatformException {
        String string;
        InputStream inputStream2 = this.checkInputStream(inputStream);
        if (inputStream2 == null) {
            this.setData(new PlatformData());
            return;
        }
        int n = this.getProtocolTypeCount();
        InputStream[] inputStreamArray = null;
        InputStream inputStream3 = inputStream2;
        if (n == 0) {
            try {
                inputStream3 = this.checkProtocolFilter(inputStream3);
                n = this.getProtocolTypeCount();
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Checking ProtocolFilter failed", (Throwable)iOException);
                }
                throw new PlatformException("Checking ProtocolFilter failed", iOException);
            }
        }
        if (n > 0) {
            inputStreamArray = new InputStream[n];
            for (int i = 0; i < n; ++i) {
                string = this.getProtocolType(i);
                inputStreamArray[i] = inputStream3 = ProtocolFilterFactory.getDecoder(string, inputStream3);
                if (inputStream3 != null) continue;
                throw new PlatformException("Could not create ProtocolDecoder: " + string);
            }
        }
        InputStream inputStream4 = this.checkDefaultContentType(inputStream3);
        string = this.getCurrentContentType();
        DataDeserializer dataDeserializer = DataSerializerFactory.getDeserializer(string);
        if (dataDeserializer == null) {
            throw new PlatformException("Could not create DataDeserializer: " + string);
        }
        String string2 = "deserializer.data.emptytonull";
        dataDeserializer.setProperty(string2, this.getProperty(string2));
        this.setData(dataDeserializer.readData(inputStream4 == null ? inputStream3 : inputStream4, this.getDataTypeChanger(), this.getCurrentCharset()));
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                inputStream3.close();
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing InputStream failed", (Throwable)iOException);
                }
                throw new PlatformException("Closing InputStream failed", iOException);
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ((ProtocolDecoder)((Object)inputStreamArray[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolDecoder: decoders[" + i + "]=" + inputStreamArray[i]));
            }
        }
    }

    private void readFrom(Reader reader) throws PlatformException {
        String string;
        Reader reader2 = this.checkReader(reader);
        if (reader2 == null) {
            this.setData(new PlatformData());
            return;
        }
        int n = this.getProtocolTypeCount();
        Reader[] readerArray = null;
        Reader reader3 = reader2;
        if (n > 0) {
            readerArray = new Reader[n];
            for (int i = 0; i < n; ++i) {
                string = this.getProtocolType(i);
                readerArray[i] = reader3 = ProtocolFilterFactory.getDecoder(string, reader3);
                if (reader3 != null) continue;
                throw new PlatformException("Could not create ProtocolDecoder: " + string);
            }
        }
        Reader reader4 = this.checkDefaultContentType(reader3);
        string = this.getCurrentContentType();
        DataDeserializer dataDeserializer = DataSerializerFactory.getDeserializer(string);
        if (dataDeserializer == null) {
            throw new PlatformException("Could not create DataDeserializer: " + string);
        }
        String string2 = "deserializer.data.emptytonull";
        dataDeserializer.setProperty(string2, this.getProperty(string2));
        this.setData(dataDeserializer.readData(reader4 == null ? reader3 : reader4, this.getDataTypeChanger(), this.getCurrentCharset()));
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                reader3.close();
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing Reader failed", (Throwable)iOException);
                }
                throw new PlatformException("Closing Reader failed", iOException);
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ((ProtocolDecoder)((Object)readerArray[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolDecoder: decoders[" + i + "]=" + readerArray[i]));
            }
        }
    }

    private InputStream checkDefaultContentType(InputStream inputStream) throws PlatformException {
        String string = this.getContentType();
        if (string == null || "".equals(string)) {
            try {
                int n;
                int n2 = 4;
                byte[] byArray = new byte[n2];
                int n3 = 0;
                while ((n = inputStream.read(byArray, n3, n2 - n3)) != -1) {
                    if (n == 0) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Check Default Content-Type: n=" + n + ", offset=" + n3 + ", count=" + n2));
                        continue;
                    }
                    if ((n3 += n) != n2) continue;
                    break;
                }
                if (n3 == 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Check Default Content-Type: offset=" + n3));
                    }
                    return null;
                }
                if (n3 == n2) {
                    String string2 = new String(byArray);
                    if (string2.equalsIgnoreCase("SSV:")) {
                        this.setContentType("PlatformSsv");
                    } else if (string2.equalsIgnoreCase("<?xm")) {
                        this.setContentType("PlatformXml");
                    } else {
                        this.setContentType("PlatformBinary");
                    }
                    return new SequenceInputStream(new ByteArrayInputStream(byArray), inputStream);
                }
                throw new PlatformException("Check Default Content-Type failed: offset=" + n3);
            }
            catch (EOFException eOFException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Check Default Content-Type: ex=" + eOFException));
                }
                throw new PlatformException("Check Default Content-Type: ex=", eOFException);
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Check Default Content-Type failed", (Throwable)iOException);
                }
                throw new PlatformException("Check Default Content-Type failed", iOException);
            }
        }
        return null;
    }

    private Reader checkDefaultContentType(Reader reader) throws PlatformException {
        String string = this.getContentType();
        if (string == null || "".equals(string)) {
            try {
                int n;
                int n2 = 4;
                char[] cArray = new char[n2];
                int n3 = 0;
                while ((n = reader.read(cArray, n3, n2 - n3)) != -1) {
                    if (n == 0) {
                        if (!this.log.isDebugEnabled()) continue;
                        this.log.debug((Object)("Check Default Content-Type: n=" + n + ", offset=" + n3 + ", count=" + n2));
                        continue;
                    }
                    if ((n3 += n) != n2) continue;
                    break;
                }
                if (n3 == 0) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Check Default Content-Type: offset=" + n3));
                    }
                    return null;
                }
                if (n3 == n2) {
                    String string2 = new String(cArray);
                    if (string2.equalsIgnoreCase("SSV:")) {
                        this.setContentType("PlatformSsv");
                    } else if (string2.equalsIgnoreCase("<?xm")) {
                        this.setContentType("PlatformXml");
                    } else {
                        this.setContentType("PlatformBinary");
                    }
                    return new SequenceReader(new CharArrayReader(cArray), reader);
                }
                throw new PlatformException("Check Default Content-Type failed: offset=" + n3);
            }
            catch (EOFException eOFException) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Check Default Content-Type: ex=" + eOFException));
                }
                throw new PlatformException("Check Default Content-Type: ex=", eOFException);
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Check Default Content-Type failed", (Throwable)iOException);
                }
                throw new PlatformException("Check Default Content-Type failed", iOException);
            }
        }
        return null;
    }

    private InputStream checkInputStream(InputStream inputStream) throws PlatformException {
        try {
            int n;
            int n2 = 4;
            byte[] byArray = new byte[n2];
            int n3 = 0;
            while ((n = inputStream.read(byArray, n3, n2 - n3)) != -1) {
                if (n == 0) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Check InputStream: n=" + n + ", offset=" + n3 + ", count=" + n2));
                    continue;
                }
                if ((n3 += n) != n2) continue;
                break;
            }
            if (n3 == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Check InputStream: offset=" + n3));
                }
                return null;
            }
            if (n3 == n2) {
                return new SequenceInputStream(new ByteArrayInputStream(byArray), inputStream);
            }
            throw new PlatformException("Checking InputStream failed: offset=" + n3);
        }
        catch (EOFException eOFException) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Check InputStream: ex=" + eOFException));
            }
            return null;
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Checking InputStream failed", (Throwable)iOException);
            }
            throw new PlatformException("Checking InputStream failed", iOException);
        }
    }

    private Reader checkReader(Reader reader) throws PlatformException {
        try {
            int n;
            int n2 = 8;
            char[] cArray = new char[n2];
            int n3 = 0;
            while ((n = reader.read(cArray)) != -1) {
                if (n == 0) {
                    if (!this.log.isDebugEnabled()) continue;
                    this.log.debug((Object)("Check Reader: n=" + n + ", offset=" + n3 + ", count=" + n2));
                    continue;
                }
                if ((n3 += n) != n2) continue;
                break;
            }
            if (n3 == 0) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Check Reader: offset=" + n3));
                }
                return null;
            }
            if (n3 == 8) {
                return new SequenceReader(new CharArrayReader(cArray), reader);
            }
            throw new PlatformException("Checking Reader failed: offset=" + n3);
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Checking Reader failed", (Throwable)iOException);
            }
            throw new PlatformException("Checking Reader failed", iOException);
        }
    }

    private InputStream checkProtocolFilter(InputStream inputStream) throws IOException {
        byte[] byArray = new byte[2];
        int n = inputStream.read(byArray);
        if (n == 2) {
            if (byArray[0] == -1 && byArray[1] == -83) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Adding protocol type: PlatformZlib");
                }
                this.addProtocolType("PlatformZlib");
            }
        } else {
            throw new IOException("Checking protocol filter failed: n=" + n);
        }
        return new SequenceInputStream(new ByteArrayInputStream(byArray), inputStream);
    }

    private void checkStreamLog() {
        if (this.streamLog == null) {
            this.streamLog = new StreamLog();
        }
    }

    private void checkGlobalStreamLog() {
        boolean bl;
        if (this.streamLog == null && (bl = PlatformGlobals.getBooleanProperty(STREAM_LOG_ENABLED_KEY, false))) {
            this.streamLog = this.createGlobalStreamLog();
        }
    }

    private void checkStream() throws PlatformException {
        if (this.in == null && this.reader == null) {
            throw new PlatformException("InputStream and Reader are null");
        }
    }

    private StreamLog createGlobalStreamLog() {
        String string = PlatformGlobals.getStringProperty(STREAM_LOG_DIR_KEY);
        int n = PlatformGlobals.getIntProperty(STREAM_LOG_MAXSIZE_KEY, -1);
        String string2 = PlatformGlobals.getStringProperty(STREAM_LOG_PREFIX_KEY);
        String string3 = PlatformGlobals.getStringProperty(STREAM_LOG_SUFFIX_KEY);
        boolean bl = PlatformGlobals.getBooleanProperty(STREAM_LOG_EXCEEDED_SIZE_KEY, false);
        StreamLog streamLog = new StreamLog();
        streamLog.setLogEnabled(true);
        streamLog.setLogDir(string);
        streamLog.setLogMaxSize(n);
        streamLog.setLogPrefix(string2);
        streamLog.setLogSuffix(string3);
        streamLog.setExceededSize(bl);
        return streamLog;
    }
}

