/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.DataSerializerFactory;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformTransaction;
import com.nexacro.xapi.tx.ProtocolEncoder;
import com.nexacro.xapi.tx.ProtocolFilterFactory;
import com.nexacro.xapi.util.PlatformGlobals;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformResponse
extends PlatformTransaction {
    private Log log = LogFactory.getLog((Class)PlatformResponse.class);
    private static final String IO_CLOSE_KEY = "platform.tx.PlatformResponse.ioclose";
    private OutputStream out;
    private Writer writer;

    public PlatformResponse() {
    }

    public PlatformResponse(String string) {
        this(string, null);
    }

    public PlatformResponse(String string, String string2) {
        super(string, string2);
    }

    public PlatformResponse(PlatformRequest platformRequest) {
        this(platformRequest.getContentType(), platformRequest.getCharset());
        this.setCheckLicense(platformRequest.isCheckLicense());
    }

    public PlatformResponse(OutputStream outputStream) {
        this(outputStream, (String)null);
    }

    public PlatformResponse(OutputStream outputStream, String string) {
        this(outputStream, string, null);
    }

    public PlatformResponse(OutputStream outputStream, String string, String string2) {
        super(string, string2);
        this.out = outputStream;
    }

    public PlatformResponse(OutputStream outputStream, PlatformRequest platformRequest) {
        this(outputStream, platformRequest.getContentType(), platformRequest.getCharset());
        this.setCheckLicense(platformRequest.isCheckLicense());
    }

    public PlatformResponse(Writer writer) {
        this(writer, (String)null);
    }

    public PlatformResponse(Writer writer, String string) {
        this(writer, string, null);
    }

    public PlatformResponse(Writer writer, String string, String string2) {
        super(string, string2);
        this.writer = writer;
    }

    public PlatformResponse(Writer writer, PlatformRequest platformRequest) {
        this(writer, platformRequest.getContentType(), platformRequest.getCharset());
        this.setCheckLicense(platformRequest.isCheckLicense());
    }

    public void sendData() throws PlatformException {
        this.checkLicense();
        boolean bl = this.isCurrentVerbose();
        long l = System.currentTimeMillis();
        if (bl) {
            if (this.log.isInfoEnabled()) {
                try {
                    this.log.info((Object)("Sending data: " + URLEncoder.encode(this.toSimpleString(), "UTF-8") + ", contentType=" + (this.getContentType() != null ? URLEncoder.encode(this.getContentType(), "UTF-8") : null) + ", charset=" + (this.getCharset() != null ? URLEncoder.encode(this.getCharset(), "UTF-8") : null)));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            }
        } else if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Sending data: " + URLEncoder.encode(this.toSimpleString(), "UTF-8") + ", contentType=" + (this.getContentType() != null ? URLEncoder.encode(this.getContentType(), "UTF-8") : null) + ", charset=" + (this.getCharset() != null ? URLEncoder.encode(this.getCharset(), "UTF-8") : null) + ", startTime=" + l));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.checkData();
        this.checkStream();
        if (this.useOutputStream()) {
            this.writeTo(this.getOutputStream());
        } else {
            this.writeTo(this.getWriter());
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (bl) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + l3));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + l3 + ", endTime=" + l2));
        }
    }

    void writeTo(OutputStream outputStream) throws PlatformException {
        int n;
        String string = this.getCurrentContentType();
        DataSerializer dataSerializer = DataSerializerFactory.getSerializer(string);
        if (dataSerializer == null) {
            throw new PlatformException("Could not create DataSerializer: " + string);
        }
        int n2 = this.getProtocolTypeCount();
        OutputStream[] outputStreamArray = null;
        OutputStream outputStream2 = outputStream;
        if (n2 > 0) {
            outputStreamArray = new OutputStream[n2];
            for (n = 0; n < n2; ++n) {
                String string2 = this.getProtocolType(n);
                outputStreamArray[n] = outputStream2 = ProtocolFilterFactory.getEncoder(string2, outputStream2);
                if (outputStream2 != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + string2);
            }
        }
        dataSerializer.writeData(outputStream2, this.getData(), this.getDataTypeChanger(), this.getCurrentCharset());
        try {
            outputStream2.flush();
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing OutputStream failed", (Throwable)iOException);
            }
            throw new PlatformException("Flushing OutputStream failed", iOException);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                outputStream2.close();
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing OutputStream failed", (Throwable)iOException);
                }
                throw new PlatformException("Closing OutputStream failed", iOException);
            }
        }
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                ((ProtocolEncoder)((Object)outputStreamArray[n])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + n + "]=" + outputStreamArray[n]));
            }
        }
    }

    void writeTo(Writer writer) throws PlatformException {
        int n;
        String string = this.getCurrentContentType();
        DataSerializer dataSerializer = DataSerializerFactory.getSerializer(string);
        if (dataSerializer == null) {
            throw new PlatformException("Could not create DataSerializer: " + string);
        }
        int n2 = this.getProtocolTypeCount();
        Writer[] writerArray = null;
        Writer writer2 = writer;
        if (n2 > 0) {
            writerArray = new Writer[n2];
            for (n = 0; n < n2; ++n) {
                String string2 = this.getProtocolType(n);
                writerArray[n] = writer2 = ProtocolFilterFactory.getEncoder(string2, writer2);
                if (writer2 != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + string2);
            }
        }
        dataSerializer.writeData(writer2, this.getData(), this.getDataTypeChanger(), this.getCurrentCharset());
        try {
            writer2.flush();
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing Writer failed", (Throwable)iOException);
            }
            throw new PlatformException("Flushing Writer failed", iOException);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                writer2.close();
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing Writer failed", (Throwable)iOException);
                }
                throw new PlatformException("Closing Writer failed", iOException);
            }
        }
        if (n2 > 0) {
            for (n = 0; n < n2; ++n) {
                ((ProtocolEncoder)((Object)writerArray[n])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + n + "]=" + writerArray[n]));
            }
        }
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    Writer getWriter() {
        return this.writer;
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    boolean useOutputStream() {
        return this.writer == null;
    }

    private void checkData() throws PlatformException {
        if (this.getData() == null) {
            throw new PlatformException("PlatformData is null");
        }
    }

    private void checkStream() throws PlatformException {
        if (this.out == null && this.writer == null) {
            throw new PlatformException("OutputStream and Writer are null");
        }
    }
}

