/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.license.InvalidLicenseException;
import com.nexacro.xapi.license.License;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.util.StringUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

abstract class PlatformTransaction {
    private Log log = LogFactory.getLog((Class)PlatformTransaction.class);
    private static final boolean CHECK_LICENSE = true;
    static final String USER_CONTENT_TYPE = "__contentType__";
    static final String USER_CHARSET = "__charset__";
    static final String USER_PROTOCOL_TYPE = "__protocolType__";
    static final String USER_VERBOSE = "__verbose__";
    static final String HTTP_DATA = "httpData";
    static final String HTTP_DATA_COUNT = "httpDataCount";
    private boolean checkLicense = true;
    private String contentType;
    private String charset;
    private List protocolTypes;
    private PlatformData data;
    private DataTypeChanger dataTypeChanger;
    private boolean verbose;
    private Map properties;

    protected PlatformTransaction() {
    }

    protected PlatformTransaction(String string) {
        this(string, null);
    }

    protected PlatformTransaction(String string, String string2) {
        this.contentType = string;
        this.charset = string2;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getProtocolType(int n) {
        int n2 = this.getUserProtocolTypeCount();
        if (n2 == -1) {
            return this.protocolTypes == null ? null : (String)this.protocolTypes.get(n);
        }
        return this.getUserProtocolType(n);
    }

    public void addProtocolType(String string) {
        if (this.protocolTypes == null) {
            this.protocolTypes = new ArrayList();
        }
        if (this.protocolTypes.contains(string)) {
            throw new IllegalArgumentException("Duplicate protocol type: " + string);
        }
        this.protocolTypes.add(string);
    }

    public void removeProtocolType(int n) {
        this.protocolTypes.remove(n);
    }

    public void removeProtocolType(String string) {
        this.protocolTypes.remove(string);
    }

    public boolean containsProtocolType(String string) {
        return this.protocolTypes == null ? false : this.protocolTypes.contains(string);
    }

    public void clearProtocolTypes() {
        if (this.getProtocolTypeCount() > 0) {
            this.protocolTypes.clear();
        }
    }

    public int getProtocolTypeCount() {
        int n = this.getUserProtocolTypeCount();
        if (n == -1) {
            return this.protocolTypes == null ? 0 : this.protocolTypes.size();
        }
        return n;
    }

    public PlatformData getData() {
        return this.data;
    }

    public void setData(PlatformData platformData) {
        this.data = platformData;
    }

    public DataTypeChanger getDataTypeChanger() {
        return this.dataTypeChanger;
    }

    public void setDataTypeChanger(DataTypeChanger dataTypeChanger) {
        this.dataTypeChanger = dataTypeChanger;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public Object getProperty(String string) {
        return this.properties == null ? null : this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }

    protected String getCurrentContentType() {
        String string = this.getUserContentType();
        if (string != null) {
            string = string.trim();
            if (this.log.isDebugEnabled()) {
                try {
                    this.log.debug((Object)("User content type: " + URLEncoder.encode(string, "UTF-8")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if (string == null || "".equals(string)) {
            string = this.getContentType();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || "".equals(string)) {
                string = this.getDefaultContentType();
            }
        }
        return string;
    }

    protected String getCurrentCharset() {
        String string = this.getUserCharset();
        if (string != null) {
            string = string.trim();
            if (this.log.isDebugEnabled()) {
                try {
                    this.log.debug((Object)("User charset: " + URLEncoder.encode(string, "UTF-8")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        if (string == null || "".equals(string)) {
            string = this.getCharset();
            if (string != null) {
                string = string.trim();
            }
            if (string == null || "".equals(string)) {
                string = this.getDefaultCharset();
            }
        }
        return string;
    }

    protected boolean isCurrentVerbose() {
        return this.isVerbose() || this.isUserVerbose();
    }

    protected String getDefaultContentType() {
        return "PlatformXml";
    }

    protected String getDefaultCharset() {
        return "UTF-8";
    }

    boolean isCheckLicense() {
        return this.checkLicense;
    }

    void setCheckLicense(boolean bl) {
        this.checkLicense = bl;
    }

    void checkLicense() throws InvalidLicenseException {
        if (this.isInternalPackage()) {
            return;
        }
        if (this.isCheckLicense()) {
            try {
                License license = License.getInstance(0);
                if (!license.isValidTime()) {
                    throw new InvalidLicenseException(3, "License has expired");
                }
            }
            catch (InvalidLicenseException invalidLicenseException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Invalid license", (Throwable)invalidLicenseException);
                }
                invalidLicenseException.printStackTrace();
            }
        }
    }

    String toSimpleString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string + "@" + Integer.toHexString(this.hashCode());
        }
        return string.substring(n + 1) + "@" + Integer.toHexString(this.hashCode());
    }

    private String getUserContentType() {
        return this.getUserData(USER_CONTENT_TYPE);
    }

    private String getUserCharset() {
        return this.getUserData(USER_CHARSET);
    }

    private String getUserProtocolType(int n) {
        if (this.getUserProtocolTypeCount() > 0) {
            List list = StringUtils.split(this.getUserProtocolTypes().trim(), '|');
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("User protocol type: protocolTypeList=" + list));
            }
            return (String)list.get(n);
        }
        return null;
    }

    private int getUserProtocolTypeCount() {
        String string = this.getUserProtocolTypes();
        if (string == null) {
            return -1;
        }
        if ("".equals(string = string.trim())) {
            return 0;
        }
        return StringUtils.split(string, '|').size();
    }

    private String getUserProtocolTypes() {
        return this.getUserData(USER_PROTOCOL_TYPE);
    }

    private boolean isUserVerbose() {
        return "true".equals(this.getUserData(USER_VERBOSE));
    }

    private String getUserData(String string) {
        if (this.data == null) {
            return null;
        }
        String string2 = this.data.getVariableList().getString(string);
        if (string2 == null) {
            DataSet dataSet = this.data.getDataSet(HTTP_DATA);
            if (dataSet == null || dataSet.getRowCount() == 0) {
                return null;
            }
            return dataSet.getString(0, string);
        }
        return string2;
    }

    private boolean isInternalPackage() {
        String string = this.getClass().getName();
        int n = string.length();
        if (n > 20 && string.substring(0, 20).hashCode() == 2054388934) {
            return true;
        }
        return n > 30 && string.substring(0, 30).hashCode() == 1422498297;
    }
}

