/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.StreamLog;
import com.nexacro.xapi.tx.StreamLogReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StreamLogInputStream
extends InputStream {
    private InputStream in;
    private StreamLog streamLog;
    private ByteArrayOutputStream buffer;

    public StreamLogInputStream(InputStream inputStream, StreamLog streamLog) {
        this.in = inputStream;
        this.streamLog = streamLog;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1 && this.checkBuffer(1)) {
            this.buffer.write(n);
        }
        return n;
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.in.read(byArray, n, n2);
        if (n3 > 0 && this.checkBuffer(n3)) {
            this.buffer.write(byArray, n, n3);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2;
        int n;
        if (l <= 0L) {
            return 0L;
        }
        byte[] byArray = new byte[2048];
        for (l2 = l; l2 > 0L && (n = this.in.read(byArray, 0, (int)Math.min(2048L, l2))) >= 0; l2 -= (long)n) {
            if (n <= 0 || !this.checkBuffer(n)) continue;
            this.buffer.write(byArray, 0, n);
        }
        return l - l2;
    }

    public int available() throws IOException {
        return this.in.available();
    }

    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeStreamLog() throws IOException {
        File file;
        Log log = LogFactory.getLog((Class)StreamLogReader.class);
        String string = this.streamLog.getLogPath();
        File file2 = new File(string);
        boolean bl = file2.exists();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing stream: path=" + URLEncoder.encode(string, "UTF-8") + ", exists=" + bl));
        }
        if (bl) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            string = this.streamLog.getLogPath();
            file2 = new File(string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Storing stream: path=" + URLEncoder.encode(string, "UTF-8")));
            }
        }
        if (!(file = file2.getParentFile()).exists()) {
            file.mkdirs();
        }
        FileOutputStream fileOutputStream = new FileOutputStream(file2);
        try {
            if (this.buffer == null) {
                if (this.in == null) {
                    fileOutputStream.write("The buffer does not exist. in=null".getBytes());
                } else if (this.in.available() > 0) {
                    this.copy(this.in, fileOutputStream);
                } else {
                    fileOutputStream.write("The buffer does not exist. in.available()=0".getBytes());
                }
            } else {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("buffer=" + this.buffer.size()));
                }
                fileOutputStream.write(this.buffer.toByteArray());
                if (this.streamLog.isExceededSize()) {
                    int n = this.streamLog.getLogMaxSize();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The buffer was exceeded. maxSize=" + n));
                    }
                    fileOutputStream.write(System.getProperty("line.separator").getBytes());
                    fileOutputStream.write(("The buffer was exceeded. maxSize=" + n).getBytes());
                } else if (this.in.available() > 0) {
                    this.copy(this.in, fileOutputStream);
                }
            }
        }
        finally {
            fileOutputStream.close();
        }
    }

    private long copy(InputStream inputStream, OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[4096];
        long l = 0L;
        int n = 0;
        while (-1 != (n = inputStream.read(byArray))) {
            outputStream.write(byArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    private boolean checkBuffer(int n) {
        if (this.streamLog.isExceededSize()) {
            return false;
        }
        if (this.buffer == null) {
            this.buffer = new ByteArrayOutputStream();
        }
        if (this.buffer.size() + n > this.streamLog.getLogMaxSize()) {
            this.streamLog.setExceededSize(true);
            return false;
        }
        return true;
    }
}

