/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MiBinaryDataDeserializer
implements DataDeserializer {
    private Log log = LogFactory.getLog((Class)MiBinaryDataDeserializer.class);
    private static final String CHARSET = "UTF-8";
    private static final double HALF_SECOND = 5.787037037037037E-6;
    private static final long MIN_DATE = 0L;
    private static final long MAX_DATE = 3652424L;
    private static final int[] MONTH_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final int BUFFER_SIZE = 4096;
    private static final String PREFIX_FILE = "xapi_";
    private static final String SUFFIX_FILE = ".tmp";
    private byte[] buffer;

    public void setProperty(String string, Object object) {
    }

    public PlatformData readData(InputStream inputStream, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        try {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Reading data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, CHARSET) : null)));
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        try {
            return this.read(inputStream, dataTypeChanger);
        }
        catch (IOException iOException) {
            String string2 = "MiBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string2), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string2, iOException);
        }
    }

    public PlatformData readData(Reader reader, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        String string2 = "MiBinary";
        throw new UnsupportedOperationException("Unsupported content type: " + string2);
    }

    private PlatformData read(InputStream inputStream, DataTypeChanger dataTypeChanger) throws IOException {
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        PlatformData platformData = new PlatformData();
        short s = dataInputStream.readShort();
        this.readVariableList(dataInputStream, platformData, dataTypeChanger);
        for (int i = 0; i < s - 1; ++i) {
            this.readDataSet(dataInputStream, platformData, dataTypeChanger, i);
        }
        this.readUnknown(dataInputStream);
        return platformData;
    }

    private void readVariableList(DataInputStream dataInputStream, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        int n = this.readLength(dataInputStream);
        int n2 = dataInputStream.readShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading VariableList: mark=0x" + Integer.toHexString(s) + ", version=" + s2 + ", size=" + n + ", count=" + n2));
        }
        if (s != -496) {
            throw new IOException("Invalid VariableList mark: 0x" + Integer.toHexString(s));
        }
        if (s2 != 4000) {
            throw new IOException("Invalid version: " + s2);
        }
        for (int i = 0; i < n2; ++i) {
            this.readVariable(dataInputStream, platformData, dataTypeChanger, i);
        }
    }

    private void readVariable(DataInputStream dataInputStream, PlatformData platformData, DataTypeChanger dataTypeChanger, int n) throws IOException {
        short s = dataInputStream.readShort();
        String string = new String(this.readBytes(dataInputStream, s), CHARSET);
        short s2 = dataInputStream.readShort();
        int n2 = this.variantTypeToDataType(s2);
        Object object = this.readValue(dataInputStream, s2);
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Reading Variable: index=" + n + ", length=" + s + ", name=" + URLEncoder.encode(string, CHARSET) + ", type=" + s2 + ", dataType=" + n2));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        Variable variable = new Variable(string, n2);
        variable.set(object);
        platformData.addVariable(variable);
    }

    private void readDataSet(DataInputStream dataInputStream, PlatformData platformData, DataTypeChanger dataTypeChanger, int n) throws IOException {
        short s = this.readShort(dataInputStream);
        if (s == -1) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Reading DataSet: mark=-1");
            }
            return;
        }
        short s2 = dataInputStream.readShort();
        int n2 = this.readLength(dataInputStream);
        short s3 = dataInputStream.readShort();
        String string = new String(this.readBytes(dataInputStream, s3), CHARSET);
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Reading DataSet: index=" + n + ", mark=0x" + URLEncoder.encode(Integer.toHexString(s), CHARSET) + ", version=" + s2 + ", size=" + n2 + ", name=" + URLEncoder.encode(string, CHARSET)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        if (s != -511) {
            throw new IOException("Invalid DataSet mark: 0x" + Integer.toHexString(s));
        }
        if (s2 != 4000) {
            throw new IOException("Invalid version: " + s2);
        }
        DataSet dataSet = new DataSet(string);
        boolean bl = dataSet.isStoreDataChanges();
        boolean bl2 = dataSet.isCheckingSetterDataIndex();
        if (bl) {
            dataSet.stopStoreDataChanges();
        }
        if (bl2) {
            dataSet.setCheckingSetterDataIndex(false);
        }
        this.readConstantColumnHeaders(dataInputStream, dataSet);
        this.readDefaultColumnHeaders(dataInputStream, dataSet);
        int[] nArray = this.getSourceDataTypes(dataSet, dataTypeChanger);
        this.readDataRows(dataInputStream, dataSet, nArray);
        if (bl) {
            dataSet.startStoreDataChanges(true);
        }
        if (bl2) {
            dataSet.setCheckingSetterDataIndex(true);
        }
        platformData.addDataSet(dataSet);
    }

    private void readDefaultColumnHeaders(DataInputStream dataInputStream, DataSet dataSet) throws IOException {
        int n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            short s = dataInputStream.readShort();
            String string = new String(this.readBytes(dataInputStream, s), CHARSET);
            short s2 = dataInputStream.readShort();
            int n2 = this.columnTypeToDataType(s2);
            short s3 = dataInputStream.readShort();
            short s4 = dataInputStream.readShort();
            if ((s4 & 0xF0) == 96) {
                short s5 = dataInputStream.readShort();
                String string2 = new String(this.readBytes(dataInputStream, s5), CHARSET);
                dataSet.addColumn(string, n2, (int)s3);
                continue;
            }
            dataSet.addColumn(string, n2, (int)s3);
        }
    }

    private void readConstantColumnHeaders(DataInputStream dataInputStream, DataSet dataSet) throws IOException {
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        int n = this.readLength(dataInputStream);
        int n2 = dataInputStream.readShort();
        if (s != -496) {
            throw new IOException("Invalid ConstantColumnHeader mark: 0x" + Integer.toHexString(s));
        }
        if (s2 != 4000) {
            throw new IOException("Invalid version: " + s2);
        }
        for (int i = 0; i < n2; ++i) {
            short s3 = dataInputStream.readShort();
            String string = new String(this.readBytes(dataInputStream, s3), CHARSET);
            short s4 = dataInputStream.readShort();
            int n3 = this.variantTypeToDataType(s4);
            int n4 = DataTypes.getDefaultSize(n3);
            Object object = this.readValue(dataInputStream, s4);
            dataSet.addConstantColumn(string, n3, n4, object);
        }
    }

    private void readDataRows(DataInputStream dataInputStream, DataSet dataSet, int[] nArray) throws IOException {
        int n;
        int[] nArray2 = this.getColumnIndexes(dataSet);
        int[] nArray3 = new int[nArray2.length];
        for (n = 0; n < nArray3.length; ++n) {
            nArray3[n] = dataSet.getColumn(nArray2[n]).getDataType();
        }
        n = 0;
        while (true) {
            Object object;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = this.readLength(dataInputStream);
            short s = dataInputStream.readShort();
            if (n7 == 0 && s == 0) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("Finish reading rows: i=" + n + ", size=" + n7 + ", rowType=0x" + Integer.toHexString(s)));
                break;
            }
            int n8 = dataInputStream.readShort();
            if (s == 8) {
                n6 = dataSet.newRemovedRow();
                for (n5 = 0; n5 < n8; ++n5) {
                    n4 = nArray2[n5];
                    n3 = nArray3[n5];
                    n2 = nArray[n4];
                    Object object2 = null;
                    if (n3 == 13) {
                        if (n2 == 2 || n2 == 12) {
                            object = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                            this.readValueToFile(dataInputStream, (File)object);
                            object2 = ((File)object).getAbsolutePath();
                        }
                    } else {
                        object2 = this.readValue(dataInputStream);
                    }
                    dataSet.setRemovedData(n6, n4, object2);
                }
            } else {
                n6 = dataSet.newRow();
                for (n5 = 0; n5 < n8; ++n5) {
                    n4 = nArray2[n5];
                    n3 = nArray3[n5];
                    n2 = nArray[n4];
                    Object object3 = null;
                    if (n3 == 13) {
                        if (n2 == 2 || n2 == 12) {
                            object = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                            this.readValueToFile(dataInputStream, (File)object);
                            object3 = ((File)object).getAbsolutePath();
                        }
                    } else {
                        object3 = this.readValue(dataInputStream);
                    }
                    dataSet.set(n6, n4, object3);
                }
                if (s != 0 && s != 1) {
                    if (s == 2) {
                        dataSet.setRowType(n6, 1);
                    } else if (s == 4) {
                        dataSet.setRowType(n6, 2);
                        n5 = dataInputStream.readShort();
                        if (n5 >= 0) {
                            for (n4 = 0; n4 < n8; ++n4) {
                                n3 = nArray2[n4];
                                n2 = nArray3[n4];
                                int n9 = nArray[n3];
                                object = null;
                                if (n2 == 13) {
                                    if (n9 == 2 || n9 == 12) {
                                        File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                                        this.readValueToFile(dataInputStream, file);
                                        object = file.getAbsolutePath();
                                    }
                                } else {
                                    object = this.readValue(dataInputStream);
                                }
                                dataSet.setSavedData(n6, n3, object);
                            }
                        }
                    }
                }
            }
            ++n;
        }
    }

    private Object readValue(DataInputStream dataInputStream) throws IOException {
        return this.readValue(dataInputStream, dataInputStream.readShort());
    }

    private Object readValue(DataInputStream dataInputStream, short s) throws IOException {
        switch (s) {
            case 0: {
                return null;
            }
            case 3: {
                int n = dataInputStream.readInt();
                return new Integer(n);
            }
            case 5: {
                double d = dataInputStream.readDouble();
                return new Double(d);
            }
            case 6: {
                int n = dataInputStream.readInt();
                int n2 = dataInputStream.readInt();
                return new BigDecimal(this.toDecimalStr(n, n2));
            }
            case 7: {
                double d = dataInputStream.readDouble();
                return this.toDate(d);
            }
            case 8: {
                int n = this.readLength(dataInputStream);
                String string = new String(this.readBytes(dataInputStream, n), CHARSET);
                return string;
            }
            case 13: {
                int n = this.readLength(dataInputStream);
                byte[] byArray = this.readBytes(dataInputStream, n);
                return byArray;
            }
        }
        throw new IOException("Invalid data type: 0x" + Integer.toHexString(s));
    }

    private void readValueToFile(DataInputStream dataInputStream, File file) throws IOException {
        this.readValueToFile(dataInputStream, dataInputStream.readShort(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void readValueToFile(DataInputStream dataInputStream, short s, File file) throws IOException {
        if (s != 8 && s != 13) throw new IOException("Invalid data type: 0x" + Integer.toHexString(s));
        int n = this.readLength(dataInputStream);
        byte[] byArray = this.getBuffer();
        int n2 = byArray.length;
        int n3 = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n4;
            do {
                int n5;
                if ((n5 = n - n3) > n2) {
                    n5 = n2;
                }
                if ((n4 = dataInputStream.read(byArray, 0, n5)) == -1) {
                    throw new EOFException();
                }
                fileOutputStream.write(byArray, 0, n4);
            } while ((n3 += n4) != n);
            if (!this.log.isDebugEnabled()) return;
            this.log.debug((Object)("Saving data to file: type=" + s + ", file=" + file));
            return;
        }
        finally {
            fileOutputStream.close();
        }
    }

    private int readLength(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        if ((n & 0x8000) == 0) {
            return n;
        }
        n = n << 16 & 0xFFFF0000 | dataInputStream.readShort() & 0xFFFF;
        return n &= Integer.MAX_VALUE;
    }

    private byte[] readBytes(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while ((n3 += (n2 = dataInputStream.read(byArray, n3, n - n3))) != n) {
        }
        return byArray;
    }

    private int[] getSourceDataTypes(DataSet dataSet, DataTypeChanger dataTypeChanger) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            String string;
            String string2;
            int n2;
            int n3;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            nArray[i] = n3 = columnHeader.getDataType();
            if (dataTypeChanger == null || (n2 = dataTypeChanger.getDataType(string2 = dataSet.getAlias(), string = columnHeader.getName(), n3)) == n3) continue;
            int n4 = columnHeader.getDataSize();
            if (columnHeader.isConstant()) {
                object = ((ConstantColumnHeader)columnHeader).getValue();
                ConstantColumnHeader constantColumnHeader = new ConstantColumnHeader(string, object, n2, n4);
                dataSet.setColumn(i, constantColumnHeader);
                continue;
            }
            object = new ColumnHeader(string, n2, n4);
            dataSet.setColumn(i, (ColumnHeader)object);
        }
        return nArray;
    }

    private int[] getColumnIndexes(DataSet dataSet) {
        int n;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = dataSet.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            object = dataSet.getColumn(i);
            if (((ColumnHeader)object).isConstant()) continue;
            arrayList.add(((ColumnHeader)object).getName());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        object = arrayList.iterator();
        block1: while (object.hasNext()) {
            String string = (String)object.next();
            int n3 = arrayList2.size();
            for (n = 0; n < n3; ++n) {
                String string2 = (String)arrayList2.get(n);
                if (string.compareToIgnoreCase(string2) >= 0) continue;
                arrayList2.add(n, string);
                continue block1;
            }
            arrayList2.add(string);
        }
        int n4 = arrayList2.size();
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = dataSet.indexOfColumn(arrayList2.get(n).toString());
        }
        return nArray;
    }

    private int variantTypeToDataType(short s) {
        switch (s) {
            case 0: {
                return 0;
            }
            case 3: {
                return 3;
            }
            case 5: {
                return 7;
            }
            case 6: {
                return 8;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 2;
            }
            case 13: {
                return 12;
            }
        }
        return 0;
    }

    private int columnTypeToDataType(short s) {
        switch (s) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 4: {
                return 7;
            }
            case 5: {
                return 8;
            }
            case 8: {
                return 11;
            }
            case 9: {
                return 12;
            }
            case 10: {
                return 2;
            }
            case 11: {
                return 2;
            }
            case 12: {
                return 2;
            }
        }
        return 0;
    }

    private void readUnknown(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.available();
        if (n > 0) {
            int n2 = 0;
            while (true) {
                int n3 = dataInputStream.read();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Unknown data: ch[" + n2 + "]=0x" + Integer.toHexString(n3)));
                }
                if (n3 == -1) break;
                ++n2;
            }
        }
    }

    private short readShort(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            return -1;
        }
        return (short)((n2 << 8) + (n << 0));
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }

    private String toDecimalStr(int n, int n2) {
        long l = 0xFFFFFFFFL & (long)n;
        long l2 = 0xFFFFFFFFL & (long)n2;
        long l3 = l << 32 | l2;
        String string = String.valueOf(l3);
        int n3 = string.length();
        string = n3 < 4 ? "0" : (n3 == 4 ? "0." + string : string.substring(0, n3 - 4) + '.' + string.substring(n3 - 4));
        return string;
    }

    private Date toDate(double d) {
        int n;
        int n2;
        int n3;
        long l;
        long l2;
        long l3;
        if (d > 3652424.0 || d < 0.0) {
            return null;
        }
        boolean bl = true;
        double d2 = d;
        long l4 = (long)(d2 += d > 0.0 ? 5.787037037037037E-6 : -5.787037037037037E-6);
        d2 = Math.abs(d2);
        long l5 = (long)((d2 - Math.floor(d2)) * 86400.0);
        long l6 = l4 / 146097L;
        long l7 = ((l4 %= 146097L) - 1L) / 36524L;
        if (l7 != 0L) {
            l3 = ((l4 = (l4 - 1L) % 36524L) + 1L) / 1461L;
            if (l3 != 0L) {
                l2 = (l4 + 1L) % 1461L;
            } else {
                bl = false;
                l2 = l4;
            }
        } else {
            l3 = l4 / 1461L;
            l2 = l4 % 1461L;
        }
        if (bl) {
            l = (l2 - 1L) / 365L;
            if (l != 0L) {
                l2 = (l2 - 1L) % 365L;
            }
        } else {
            l = l2 / 365L;
            l2 %= 365L;
        }
        int n4 = (int)(l6 * 400L + l7 * 100L + l3 * 4L + l);
        Calendar calendar = Calendar.getInstance();
        if (l == 0L && bl) {
            if (l2 == 59L) {
                int n5;
                int n6;
                int n7;
                int n8 = 2;
                int n9 = 29;
                if (l5 == 0L) {
                    n7 = 0;
                    n6 = 0;
                    n5 = 0;
                } else {
                    n7 = (int)l5 % 60;
                    long l8 = l5 / 60L;
                    n6 = (int)l8 % 60;
                    n5 = (int)l8 / 60;
                }
                calendar.set(1, n4);
                calendar.set(2, n8 - 1);
                calendar.set(5, n9);
                calendar.set(11, n5);
                calendar.set(12, n6);
                calendar.set(13, n7);
                return calendar.getTime();
            }
            if (l2 >= 60L) {
                --l2;
            }
        }
        int n10 = (int)(++l2 >> 5) + 1;
        while (l2 > (long)MONTH_DAYS[n10]) {
            ++n10;
        }
        int n11 = (int)(l2 - (long)MONTH_DAYS[n10 - 1]);
        if (l5 == 0L) {
            n3 = 0;
            n2 = 0;
            n = 0;
        } else {
            n3 = (int)l5 % 60;
            long l9 = l5 / 60L;
            n2 = (int)l9 % 60;
            n = (int)l9 / 60;
        }
        calendar.set(1, n4);
        calendar.set(2, n10 - 1);
        calendar.set(5, n11);
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        return calendar.getTime();
    }
}

