/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.PlatformCodec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformBinaryDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformBinaryDataSerializer.class);
    private static final String CHARSET = "UTF-8";
    private static final int BUFFER_SIZE = 4096;
    private static final boolean COLUMN_SORT = false;
    private static final int TIMEZONE_OFFSET = PlatformBinaryDataSerializer.getTimezoneOffset();
    private PlatformCodec platformCodec = new PlatformCodec();
    private Map columnIndexesMap = new HashMap();
    private byte[] buffer;

    private static int getTimezoneOffset() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(15) + calendar.get(16);
    }

    public void setProperty(String string, Object object) {
    }

    public void writeData(OutputStream outputStream, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, CHARSET) : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            this.write(outputStream, platformData, dataTypeChanger);
        }
        catch (IOException iOException) {
            String string2 = "PlatformBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string2), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string2, iOException);
        }
    }

    public void writeData(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        String string2 = "PlatformBinary";
        throw new UnsupportedOperationException("Unsupported content type: " + string2);
    }

    protected void write(OutputStream outputStream, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        DataOutputStream dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        this.writeVariableList(dataOutputStream, platformData, dataTypeChanger);
        this.writeDataSetList(dataOutputStream, platformData, dataTypeChanger);
        dataOutputStream.flush();
    }

    protected void writeVariableList(DataOutputStream dataOutputStream, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        VariableList variableList = platformData.getVariableList();
        int n = variableList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + n));
        }
        if (n == 0) {
            return;
        }
        dataOutputStream.writeShort(65040);
        dataOutputStream.writeShort(5000);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeShort(n);
        for (int i = 0; i < n; ++i) {
            Variable variable = variableList.get(i);
            this.writeVariable(dataOutputStream2, variable, dataTypeChanger);
        }
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.writeLength(dataOutputStream, byArray.length);
        dataOutputStream.write(byArray);
    }

    protected void writeVariable(DataOutputStream dataOutputStream, Variable variable, DataTypeChanger dataTypeChanger) throws IOException {
        String string = variable.getName();
        int n = variable.getType();
        byte[] byArray = string.getBytes(CHARSET);
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
        switch (n) {
            case 2: {
                this.writeValue(dataOutputStream, variable.getString());
                break;
            }
            case 3: {
                this.writeValue(dataOutputStream, variable.getInt());
                break;
            }
            case 4: {
                this.writeValue(dataOutputStream, variable.getBoolean());
                break;
            }
            case 5: {
                this.writeValue(dataOutputStream, variable.getLong());
                break;
            }
            case 6: {
                this.writeValue(dataOutputStream, variable.getFloat());
                break;
            }
            case 7: {
                this.writeValue(dataOutputStream, variable.getDouble());
                break;
            }
            case 8: {
                this.writeValue(dataOutputStream, variable.getBigDecimal());
                break;
            }
            case 9: {
                this.writeDateValue(dataOutputStream, variable.getDateTime());
                break;
            }
            case 10: {
                this.writeTimeValue(dataOutputStream, variable.getDateTime());
                break;
            }
            case 11: {
                this.writeValue(dataOutputStream, variable.getDateTime());
                break;
            }
            case 12: {
                this.writeValue(dataOutputStream, variable.getBlob());
                break;
            }
            case 13: {
                this.writeEmptyValue(dataOutputStream);
                break;
            }
            case 1: {
                this.writeEmptyValue(dataOutputStream);
                break;
            }
            default: {
                this.writeEmptyValue(dataOutputStream);
            }
        }
    }

    protected void writeDataSetList(DataOutputStream dataOutputStream, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        DataSetList dataSetList = platformData.getDataSetList();
        int n = dataSetList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + n));
        }
        for (int i = 0; i < n; ++i) {
            DataSet dataSet = dataSetList.get(i);
            this.writeDataSet(dataOutputStream, platformData, dataSet, dataTypeChanger);
        }
    }

    protected void writeDataSet(DataOutputStream dataOutputStream, PlatformData platformData, DataSet dataSet, DataTypeChanger dataTypeChanger) throws IOException {
        String string = dataSet.getName();
        String string2 = dataSet.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + (string != null ? URLEncoder.encode(string, CHARSET) : null) + ", alias=" + (string2 != null ? URLEncoder.encode(string2, CHARSET) : null) + ", columnCount=" + dataSet.getColumnCount() + ", rowCount=" + dataSet.getRowCount() + ", removedRowCount=" + dataSet.getRemovedRowCount()));
        }
        dataOutputStream.writeShort(65025);
        dataOutputStream.writeShort(5000);
        int[] nArray = this.getTargetDataTypes(dataSet, dataTypeChanger);
        this.writeColumnHeaders(dataOutputStream, dataSet, nArray);
        this.writeRows(dataOutputStream, platformData, dataSet, nArray);
        dataOutputStream.writeInt(0);
    }

    protected void writeColumnHeaders(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray) throws IOException {
        String string = dataSet.getAlias();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = string.getBytes(CHARSET);
        dataOutputStream2.writeShort(byArray.length);
        dataOutputStream2.write(byArray);
        this.writeConstantColumnHeaders(dataOutputStream2, dataSet, nArray);
        this.writeDefaultColumnHeaders(dataOutputStream2, dataSet, nArray);
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.writeLength(dataOutputStream, byArray2.length);
        dataOutputStream.write(byArray2);
    }

    protected void writeDefaultColumnHeaders(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray) throws IOException {
        ColumnHeader columnHeader;
        int n;
        int n2 = dataSet.getColumnCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            columnHeader = dataSet.getColumn(n);
            if (columnHeader.isConstant()) continue;
            ++n3;
        }
        dataOutputStream.writeShort(n3);
        for (n = 0; n < n2; ++n) {
            columnHeader = dataSet.getColumn(n);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            byte[] byArray = string.getBytes(CHARSET);
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            int n4 = nArray[n];
            int n5 = columnHeader.getDataSize();
            switch (n4) {
                case 2: {
                    dataOutputStream.writeShort(1);
                    break;
                }
                case 3: {
                    dataOutputStream.writeShort(2);
                    break;
                }
                case 4: {
                    dataOutputStream.writeShort(2);
                    break;
                }
                case 5: {
                    dataOutputStream.writeShort(4);
                    break;
                }
                case 6: {
                    dataOutputStream.writeShort(3);
                    break;
                }
                case 7: {
                    dataOutputStream.writeShort(3);
                    break;
                }
                case 8: {
                    dataOutputStream.writeShort(4);
                    break;
                }
                case 9: {
                    dataOutputStream.writeShort(5);
                    break;
                }
                case 10: {
                    dataOutputStream.writeShort(6);
                    break;
                }
                case 11: {
                    dataOutputStream.writeShort(7);
                    break;
                }
                case 12: {
                    dataOutputStream.writeShort(8);
                    break;
                }
                case 13: {
                    dataOutputStream.writeShort(8);
                    break;
                }
                case 1: {
                    dataOutputStream.writeShort(0);
                    break;
                }
                default: {
                    dataOutputStream.writeShort(0);
                }
            }
            dataOutputStream.writeShort(n5);
            dataOutputStream.writeShort(1);
        }
    }

    protected void writeConstantColumnHeaders(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray) throws IOException {
        ColumnHeader columnHeader;
        int n;
        dataOutputStream.writeShort(65040);
        dataOutputStream.writeShort(5000);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        int n2 = dataSet.getColumnCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            columnHeader = dataSet.getColumn(n);
            if (!columnHeader.isConstant()) continue;
            ++n3;
        }
        dataOutputStream2.writeShort(n3);
        block15: for (n = 0; n < n2; ++n) {
            columnHeader = dataSet.getColumn(n);
            if (!columnHeader.isConstant()) continue;
            ConstantColumnHeader constantColumnHeader = (ConstantColumnHeader)columnHeader;
            String string = constantColumnHeader.getName();
            byte[] byArray = string.getBytes(CHARSET);
            dataOutputStream2.writeShort(byArray.length);
            dataOutputStream2.write(byArray);
            int n4 = constantColumnHeader.getDataType();
            int n5 = nArray[n];
            if (n4 == 13) {
                this.writeValue(dataOutputStream2, constantColumnHeader.getStringValue(dataSet));
                continue;
            }
            if (n5 == 13) {
                n5 = n4;
            }
            switch (n5) {
                case 2: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getStringValue(dataSet));
                    continue block15;
                }
                case 3: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getIntValue(dataSet));
                    continue block15;
                }
                case 4: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getBooleanValue(dataSet));
                    continue block15;
                }
                case 5: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getLongValue(dataSet));
                    continue block15;
                }
                case 6: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getFloatValue(dataSet));
                    continue block15;
                }
                case 7: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getDoubleValue(dataSet));
                    continue block15;
                }
                case 8: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getBigDecimalValue(dataSet));
                    continue block15;
                }
                case 9: {
                    this.writeDateValue(dataOutputStream2, constantColumnHeader.getDateTimeValue(dataSet));
                    continue block15;
                }
                case 10: {
                    this.writeTimeValue(dataOutputStream2, constantColumnHeader.getDateTimeValue(dataSet));
                    continue block15;
                }
                case 11: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getDateTimeValue(dataSet));
                    continue block15;
                }
                case 12: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getBlobValue(dataSet));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(dataOutputStream2);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(dataOutputStream2);
                }
            }
        }
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.writeLength(dataOutputStream, byArray.length);
        dataOutputStream.write(byArray);
    }

    protected void writeRows(DataOutputStream dataOutputStream, PlatformData platformData, DataSet dataSet, int[] nArray) throws IOException {
        Object object;
        OutputStream outputStream;
        int n;
        boolean bl;
        int n2 = dataSet.getSaveType();
        if (n2 == 0) {
            n2 = platformData.getSaveType();
        }
        if (n2 == 0) {
            n2 = 2;
        }
        int n3 = dataSet.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + n3));
        }
        if (bl = dataSet.isCheckingGetterDataIndex()) {
            dataSet.setCheckingGetterDataIndex(false);
        }
        for (n = 0; n < n3; ++n) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = new DataOutputStream(byteArrayOutputStream);
            this.writeRow((DataOutputStream)outputStream, dataSet, nArray, n, n2);
            ((FilterOutputStream)outputStream).close();
            byteArrayOutputStream.close();
            object = byteArrayOutputStream.toByteArray();
            if (((byte[])object).length <= 0) continue;
            this.writeLength(dataOutputStream, ((byte[])object).length);
            dataOutputStream.write((byte[])object);
        }
        if (n2 == 1 || n2 == 4 || n2 == 5) {
            n = dataSet.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + n));
            }
            for (int i = 0; i < n; ++i) {
                outputStream = new ByteArrayOutputStream();
                object = new DataOutputStream(outputStream);
                this.writeRemovedRow((DataOutputStream)object, dataSet, nArray, i);
                ((FilterOutputStream)object).close();
                ((ByteArrayOutputStream)outputStream).close();
                byte[] byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                if (byArray.length <= 0) continue;
                this.writeLength(dataOutputStream, byArray.length);
                dataOutputStream.write(byArray);
            }
        }
        if (bl) {
            dataSet.setCheckingGetterDataIndex(true);
        }
    }

    protected void writeRow(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray, int n, int n2) throws IOException {
        int n3 = dataSet.getRowType(n);
        if (n2 != 1 && (n2 == 2 ? n3 == 3 : (n2 == 3 ? n3 == 0 || n3 == 3 : (n2 == 4 ? n3 == 0 || n3 == 1 || n3 == 2 : n2 == 5 && n3 == 0)))) {
            return;
        }
        int[] nArray2 = this.getColumnIndexes(dataSet);
        int n4 = nArray2.length;
        if (n2 == 2) {
            dataOutputStream.writeShort(1);
        } else {
            switch (n3) {
                case 0: {
                    dataOutputStream.writeShort(1);
                    break;
                }
                case 1: {
                    dataOutputStream.writeShort(2);
                    break;
                }
                case 2: {
                    dataOutputStream.writeShort(4);
                    break;
                }
                case 3: {
                    dataOutputStream.writeShort(8);
                    break;
                }
                default: {
                    dataOutputStream.writeShort(1);
                }
            }
        }
        dataOutputStream.writeShort(n4);
        block21: for (int i = 0; i < n4; ++i) {
            int n5 = nArray2[i];
            int n6 = dataSet.getColumn(n5).getDataType();
            int n7 = nArray[n5];
            if (n6 == 13) {
                if (n7 == 2) {
                    this.writeStringFromFile(dataOutputStream, dataSet.getString(n, n5));
                    continue;
                }
                if (n7 == 12 || n7 == 13) {
                    this.writeBlobFromFile(dataOutputStream, dataSet.getString(n, n5));
                    continue;
                }
                this.writeEmptyValue(dataOutputStream);
                continue;
            }
            switch (n7) {
                case 2: {
                    this.writeValue(dataOutputStream, dataSet.getString(n, n5));
                    continue block21;
                }
                case 3: {
                    this.writeIntValue(dataOutputStream, dataSet, n, n5, dataSet.getObject(n, n5));
                    continue block21;
                }
                case 4: {
                    this.writeBooleanValue(dataOutputStream, dataSet, n, n5, dataSet.getObject(n, n5));
                    continue block21;
                }
                case 5: {
                    this.writeLongValue(dataOutputStream, dataSet, n, n5, dataSet.getObject(n, n5));
                    continue block21;
                }
                case 6: {
                    this.writeFloatValue(dataOutputStream, dataSet, n, n5, dataSet.getObject(n, n5));
                    continue block21;
                }
                case 7: {
                    this.writeDoubleValue(dataOutputStream, dataSet, n, n5, dataSet.getObject(n, n5));
                    continue block21;
                }
                case 8: {
                    this.writeValue(dataOutputStream, dataSet.getBigDecimal(n, n5));
                    continue block21;
                }
                case 9: {
                    this.writeDateValue(dataOutputStream, dataSet.getDateTime(n, n5));
                    continue block21;
                }
                case 10: {
                    this.writeTimeValue(dataOutputStream, dataSet.getDateTime(n, n5));
                    continue block21;
                }
                case 11: {
                    this.writeValue(dataOutputStream, dataSet.getDateTime(n, n5));
                    continue block21;
                }
                case 12: {
                    this.writeValue(dataOutputStream, dataSet.getBlob(n, n5));
                    continue block21;
                }
                case 13: {
                    this.writeValue(dataOutputStream, dataSet.getBlob(n, n5));
                    continue block21;
                }
                case 1: {
                    this.writeEmptyValue(dataOutputStream);
                    continue block21;
                }
                default: {
                    this.writeEmptyValue(dataOutputStream);
                }
            }
        }
        if ((n2 == 1 || n2 == 3 || n2 == 5) && n3 == 2) {
            this.writeSavedRow(dataOutputStream, dataSet, nArray, n);
        }
    }

    protected void writeSavedRow(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray, int n) throws IOException {
        int[] nArray2 = this.getColumnIndexes(dataSet);
        int n2 = nArray2.length;
        dataOutputStream.writeShort(n2);
        block15: for (int i = 0; i < n2; ++i) {
            int n3 = nArray2[i];
            int n4 = dataSet.getColumn(n3).getDataType();
            int n5 = nArray[n3];
            if (n4 == 13) {
                if (n5 == 2) {
                    this.writeStringFromFile(dataOutputStream, dataSet.getSavedStringData(n, n3));
                    continue;
                }
                if (n5 == 12 || n5 == 13) {
                    this.writeBlobFromFile(dataOutputStream, dataSet.getSavedStringData(n, n3));
                    continue;
                }
                this.writeEmptyValue(dataOutputStream);
                continue;
            }
            switch (n5) {
                case 2: {
                    this.writeValue(dataOutputStream, dataSet.getSavedStringData(n, n3));
                    continue block15;
                }
                case 3: {
                    this.writeIntValue(dataOutputStream, dataSet, n, n3, dataSet.getSavedData(n, n3));
                    continue block15;
                }
                case 4: {
                    this.writeBooleanValue(dataOutputStream, dataSet, n, n3, dataSet.getSavedData(n, n3));
                    continue block15;
                }
                case 5: {
                    this.writeLongValue(dataOutputStream, dataSet, n, n3, dataSet.getSavedData(n, n3));
                    continue block15;
                }
                case 6: {
                    this.writeFloatValue(dataOutputStream, dataSet, n, n3, dataSet.getSavedData(n, n3));
                    continue block15;
                }
                case 7: {
                    this.writeDoubleValue(dataOutputStream, dataSet, n, n3, dataSet.getSavedData(n, n3));
                    continue block15;
                }
                case 8: {
                    this.writeValue(dataOutputStream, dataSet.getSavedBigDecimalData(n, n3));
                    continue block15;
                }
                case 9: {
                    this.writeDateValue(dataOutputStream, dataSet.getSavedDateTimeData(n, n3));
                    continue block15;
                }
                case 10: {
                    this.writeTimeValue(dataOutputStream, dataSet.getSavedDateTimeData(n, n3));
                    continue block15;
                }
                case 11: {
                    this.writeValue(dataOutputStream, dataSet.getSavedDateTimeData(n, n3));
                    continue block15;
                }
                case 12: {
                    this.writeValue(dataOutputStream, dataSet.getSavedBlobData(n, n3));
                    continue block15;
                }
                case 13: {
                    this.writeValue(dataOutputStream, dataSet.getSavedBlobData(n, n3));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(dataOutputStream);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(dataOutputStream);
                }
            }
        }
    }

    protected void writeRemovedRow(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray, int n) throws IOException {
        int[] nArray2 = this.getColumnIndexes(dataSet);
        int n2 = nArray2.length;
        dataOutputStream.writeShort(8);
        dataOutputStream.writeShort(n2);
        block15: for (int i = 0; i < n2; ++i) {
            int n3 = nArray2[i];
            int n4 = dataSet.getColumn(n3).getDataType();
            int n5 = nArray[n3];
            if (n4 == 13) {
                if (n5 == 2) {
                    this.writeStringFromFile(dataOutputStream, dataSet.getRemovedStringData(n, n3));
                    continue;
                }
                if (n5 == 12 || n5 == 13) {
                    this.writeBlobFromFile(dataOutputStream, dataSet.getRemovedStringData(n, n3));
                    continue;
                }
                this.writeEmptyValue(dataOutputStream);
                continue;
            }
            switch (n5) {
                case 2: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedStringData(n, n3));
                    continue block15;
                }
                case 3: {
                    this.writeIntValue(dataOutputStream, dataSet, n, n3, dataSet.getRemovedData(n, n3));
                    continue block15;
                }
                case 4: {
                    this.writeBooleanValue(dataOutputStream, dataSet, n, n3, dataSet.getRemovedData(n, n3));
                    continue block15;
                }
                case 5: {
                    this.writeLongValue(dataOutputStream, dataSet, n, n3, dataSet.getRemovedData(n, n3));
                    continue block15;
                }
                case 6: {
                    this.writeFloatValue(dataOutputStream, dataSet, n, n3, dataSet.getRemovedData(n, n3));
                    continue block15;
                }
                case 7: {
                    this.writeDoubleValue(dataOutputStream, dataSet, n, n3, dataSet.getRemovedData(n, n3));
                    continue block15;
                }
                case 8: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedBigDecimalData(n, n3));
                    continue block15;
                }
                case 9: {
                    this.writeDateValue(dataOutputStream, dataSet.getRemovedDateTimeData(n, n3));
                    continue block15;
                }
                case 10: {
                    this.writeTimeValue(dataOutputStream, dataSet.getRemovedDateTimeData(n, n3));
                    continue block15;
                }
                case 11: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedDateTimeData(n, n3));
                    continue block15;
                }
                case 12: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedBlobData(n, n3));
                    continue block15;
                }
                case 13: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedBlobData(n, n3));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(dataOutputStream);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(dataOutputStream);
                }
            }
        }
    }

    protected void writeValue(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeShort(0);
        } else {
            String string2 = this.platformCodec.encode(string);
            dataOutputStream.writeShort(21);
            byte[] byArray = string2.getBytes(CHARSET);
            this.writeLength(dataOutputStream, byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    protected void writeValue(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeShort(3);
        dataOutputStream.writeInt(n);
    }

    protected void writeValue(DataOutputStream dataOutputStream, boolean bl) throws IOException {
        dataOutputStream.writeShort(3);
        int n = bl ? 1 : 0;
        dataOutputStream.writeInt(n);
    }

    protected void writeValue(DataOutputStream dataOutputStream, long l) throws IOException {
        dataOutputStream.writeShort(40);
        String string = String.valueOf(l);
        byte[] byArray = string.getBytes();
        this.writeLength(dataOutputStream, byArray.length);
        dataOutputStream.write(byArray);
    }

    protected void writeValue(DataOutputStream dataOutputStream, float f) throws IOException {
        dataOutputStream.writeShort(4);
        double d = Double.parseDouble(String.valueOf(f));
        dataOutputStream.writeDouble(d);
    }

    protected void writeValue(DataOutputStream dataOutputStream, double d) throws IOException {
        dataOutputStream.writeShort(4);
        dataOutputStream.writeDouble(d);
    }

    protected void writeValue(DataOutputStream dataOutputStream, BigDecimal bigDecimal) throws IOException {
        if (bigDecimal == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(40);
            String string = bigDecimal.toString();
            byte[] byArray = string.getBytes();
            this.writeLength(dataOutputStream, byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    protected void writeDateValue(DataOutputStream dataOutputStream, Date date) throws IOException {
        if (date == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(41);
            long l = this.reviseTimeValue(date.getTime());
            dataOutputStream.writeDouble(l);
        }
    }

    protected void writeTimeValue(DataOutputStream dataOutputStream, Date date) throws IOException {
        if (date == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(41);
            long l = this.reviseTimeValue(date.getTime());
            dataOutputStream.writeDouble(l);
        }
    }

    protected void writeValue(DataOutputStream dataOutputStream, Date date) throws IOException {
        if (date == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(41);
            long l = this.reviseTimeValue(date.getTime());
            dataOutputStream.writeDouble(l);
        }
    }

    protected void writeValue(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        if (byArray == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(26);
            this.writeLength(dataOutputStream, byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    protected void writeEmptyValue(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeStringFromFile(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeShort(0);
            return;
        } else {
            File file = new File(string);
            if (file.canRead()) {
                dataOutputStream.writeShort(21);
                int n = (int)file.length();
                this.writeLength(dataOutputStream, n);
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = this.getBuffer();
                try {
                    int n2;
                    while ((n2 = fileInputStream.read(byArray)) != -1) {
                        dataOutputStream.write(byArray, 0, n2);
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)("Load data from file: file=" + file));
                    return;
                }
                finally {
                    fileInputStream.close();
                }
            } else {
                dataOutputStream.writeShort(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void writeBlobFromFile(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeShort(0);
            return;
        } else {
            File file = new File(string);
            if (file.canRead()) {
                dataOutputStream.writeShort(26);
                int n = (int)file.length();
                this.writeLength(dataOutputStream, n);
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = this.getBuffer();
                try {
                    int n2;
                    while ((n2 = fileInputStream.read(byArray)) != -1) {
                        dataOutputStream.write(byArray, 0, n2);
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)("Load data from file: file=" + file));
                    return;
                }
                finally {
                    fileInputStream.close();
                }
            } else {
                dataOutputStream.writeShort(0);
            }
        }
    }

    protected void writeLength(DataOutputStream dataOutputStream, int n) throws IOException {
        if (n < 32768) {
            dataOutputStream.writeShort(n);
        } else {
            dataOutputStream.writeInt(n | Integer.MIN_VALUE);
        }
    }

    protected int[] getTargetDataTypes(DataSet dataSet, DataTypeChanger dataTypeChanger) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (dataTypeChanger == null) {
                nArray[i] = columnHeader.getDataType();
                continue;
            }
            String string = dataSet.getAlias();
            String string2 = columnHeader.getName();
            int n2 = columnHeader.getDataType();
            nArray[i] = dataTypeChanger.getDataType(string, string2, n2);
        }
        return nArray;
    }

    protected int[] getColumnIndexes(DataSet dataSet) {
        String string = dataSet.getName() + "@" + dataSet.hashCode();
        int[] nArray = (int[])this.columnIndexesMap.get(string);
        if (nArray == null) {
            nArray = this.getNormalColumnIndexes(dataSet);
            this.columnIndexesMap.put(string, nArray);
        }
        return nArray;
    }

    private void writeIntValue(DataOutputStream dataOutputStream, DataSet dataSet, int n, int n2, Object object) throws IOException {
        if (object == null) {
            this.writeEmptyValue(dataOutputStream);
        } else {
            int n3 = dataSet.getCurrentDataConverter().toInt(dataSet, n, n2, object);
            this.writeValue(dataOutputStream, n3);
        }
    }

    private void writeBooleanValue(DataOutputStream dataOutputStream, DataSet dataSet, int n, int n2, Object object) throws IOException {
        if (object == null) {
            this.writeEmptyValue(dataOutputStream);
        } else {
            boolean bl = dataSet.getCurrentDataConverter().toBoolean(dataSet, n, n2, object);
            this.writeValue(dataOutputStream, bl);
        }
    }

    private void writeLongValue(DataOutputStream dataOutputStream, DataSet dataSet, int n, int n2, Object object) throws IOException {
        if (object == null) {
            this.writeEmptyValue(dataOutputStream);
        } else {
            long l = dataSet.getCurrentDataConverter().toLong(dataSet, n, n2, object);
            this.writeValue(dataOutputStream, l);
        }
    }

    private void writeFloatValue(DataOutputStream dataOutputStream, DataSet dataSet, int n, int n2, Object object) throws IOException {
        if (object == null) {
            this.writeEmptyValue(dataOutputStream);
        } else {
            float f = dataSet.getCurrentDataConverter().toFloat(dataSet, n, n2, object);
            this.writeValue(dataOutputStream, f);
        }
    }

    private void writeDoubleValue(DataOutputStream dataOutputStream, DataSet dataSet, int n, int n2, Object object) throws IOException {
        if (object == null) {
            this.writeEmptyValue(dataOutputStream);
        } else {
            double d = dataSet.getCurrentDataConverter().toDouble(dataSet, n, n2, object);
            this.writeValue(dataOutputStream, d);
        }
    }

    private int[] sortColumnIndexes(DataSet dataSet) {
        int n;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = dataSet.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            object = dataSet.getColumn(i);
            if (((ColumnHeader)object).isConstant()) continue;
            arrayList.add(((ColumnHeader)object).getName());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        object = arrayList.iterator();
        block1: while (object.hasNext()) {
            String string = (String)object.next();
            int n3 = arrayList2.size();
            for (n = 0; n < n3; ++n) {
                String string2 = (String)arrayList2.get(n);
                if (string.compareToIgnoreCase(string2) >= 0) continue;
                arrayList2.add(n, string);
                continue block1;
            }
            arrayList2.add(string);
        }
        int n4 = arrayList2.size();
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = dataSet.indexOfColumn(arrayList2.get(n).toString());
        }
        return nArray;
    }

    private int[] getNormalColumnIndexes(DataSet dataSet) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    private long reviseTimeValue(long l) {
        return l + (long)TIMEZONE_OFFSET;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

