/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformHtmlDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformHtmlDataSerializer.class);
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final String DOC_TYPE = "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Strict//EN\" \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-strict.dtd\">";
    private static final String XML_NS = "http://www.w3.org/1999/xhtml";
    private static final String[] STYLE = new String[]{"<style type=\"text/css\">", "<!--/*--><![CDATA[/*><!--*/", "body {", TABS[1] + "font-family:Verdana, Helvetica, sans-serif;", "}", "table, tr, th, td {", TABS[1] + "margin:0;", TABS[1] + "padding:0;", TABS[1] + "border:0;", TABS[1] + "outline:0;", TABS[1] + "vertical-align:baseline;", "}", "table {", TABS[1] + "border-collapse:collapse;", TABS[1] + "border-spacing:0;", TABS[1] + "empty-cells:show;", TABS[1] + "border:1px solid #bbb;", TABS[1] + "margin:0.5em 0.25em;", "}", "th, td {", TABS[1] + "padding:0.25em 0.5em;", "}", "th {", TABS[1] + "border:1px solid #bbb;", TABS[1] + "background-color:#d7d7d7;", "}", "td {", TABS[1] + "border:1px solid #bbb;", "}", "tr.odd td {", TABS[1] + "background-color:#eee;", "}", "/*]]>*/-->", "</style>"};
    private static final String[] JAVA_SCRIPT = new String[]{"<script type=\"text/javascript\">", "<!--//--><![CDATA[//><!--", "function init() {", TABS[1] + ";", "}", "//--><!]]>", "</script>"};

    public void setProperty(String string, Object object) {
    }

    public void writeData(OutputStream outputStream, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            this.writeData(new OutputStreamWriter(outputStream, string), platformData, dataTypeChanger, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.log.isErrorEnabled()) {
                try {
                    this.log.error((Object)("Unsupported charset: " + (string != null ? URLEncoder.encode(string, "UTF-8") : null)), (Throwable)unsupportedEncodingException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    // empty catch block
                }
            }
            throw new PlatformException("Unsupported charset: " + string, unsupportedEncodingException);
        }
    }

    public void writeData(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            this.write(writer, platformData, string);
        }
        catch (IOException iOException) {
            String string2 = "PlatformHtml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string2), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string2, iOException);
        }
    }

    protected void write(Writer writer, PlatformData platformData, String string) throws IOException {
        int n = 0;
        this.writeHeader(writer, string, n);
        this.writeHtmlHead(writer, platformData, string, n);
        this.writeHtmlBody(writer, platformData, string, n);
        this.writeFooter(writer, string, n);
        writer.flush();
    }

    protected void writeHeader(Writer writer, String string, int n) throws IOException {
        this.write(writer, DOC_TYPE, n);
        this.write(writer, "<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">", n);
    }

    protected void writeFooter(Writer writer, String string, int n) throws IOException {
        this.write(writer, "</html>", n);
    }

    protected void writeHtmlHead(Writer writer, PlatformData platformData, String string, int n) throws IOException {
        this.write(writer, "<head>", n);
        this.writeMeta(writer, string, n);
        this.writeTitle(writer, platformData, n);
        this.writeStyle(writer, n);
        this.writeJavaScript(writer, n);
        this.write(writer, "</head>", n);
    }

    protected void writeMeta(Writer writer, String string, int n) throws IOException {
        if (string == null) {
            this.write(writer, "<meta http-equiv=\"Content-Type\" content=\"text/html\" />", n);
        } else {
            this.write(writer, "<meta http-equiv=\"Content-Type\" content=\"text/html; charset=" + string + "\" />", n);
        }
    }

    protected void writeTitle(Writer writer, PlatformData platformData, int n) throws IOException {
        this.write(writer, "<title>" + platformData.toString() + "</title>", n);
    }

    protected void writeStyle(Writer writer, int n) throws IOException {
        int n2 = STYLE.length;
        for (int i = 0; i < n2; ++i) {
            this.write(writer, STYLE[i], n);
        }
    }

    protected void writeJavaScript(Writer writer, int n) throws IOException {
        int n2 = JAVA_SCRIPT.length;
        for (int i = 0; i < n2; ++i) {
            this.write(writer, JAVA_SCRIPT[i], n);
        }
    }

    protected void writeHtmlBody(Writer writer, PlatformData platformData, String string, int n) throws IOException {
        this.write(writer, "<body onload=\"init()\">", n);
        this.writeDate(writer, n);
        this.writeLine(writer, n);
        this.writeVariableList(writer, platformData.getVariableList(), n);
        this.writeLine(writer, n);
        this.writeDataSetList(writer, platformData.getDataSetList(), n);
        this.write(writer, "</body>", n);
    }

    protected void writeDate(Writer writer, int n) throws IOException {
        this.write(writer, "<p>Date: " + new Date() + "</p>", n);
    }

    protected void writeLine(Writer writer, int n) throws IOException {
        this.write(writer, "<hr />", n);
    }

    protected void writeVariableList(Writer writer, VariableList variableList, int n) throws IOException {
        int n2 = variableList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + n2));
        }
        this.write(writer, "<p>Variable count=" + n2 + "</p>", n);
        this.write(writer, "<table>", n++);
        this.write(writer, "<tr>", n++);
        this.write(writer, "<th>Index</th>", n);
        this.write(writer, "<th>Name</th>", n);
        this.write(writer, "<th>DataType</th>", n);
        this.write(writer, "<th>Value</th>", n);
        this.write(writer, "</tr>", --n);
        for (int i = 0; i < n2; ++i) {
            this.writeVariable(writer, i, variableList.get(i), n);
        }
        this.write(writer, "</table>", --n);
    }

    protected void writeVariable(Writer writer, int n, Variable variable, int n2) throws IOException {
        String string = variable.getName();
        String string2 = DataTypes.toStringType(variable.getType());
        String string3 = variable.getString();
        if (n % 2 == 1) {
            this.write(writer, "<tr class=\"odd\">", n2++);
        } else {
            this.write(writer, "<tr>", n2++);
        }
        this.write(writer, "<td>" + n + "</td>", n2);
        this.write(writer, "<td>" + string + "</td>", n2);
        this.write(writer, "<td>" + string2 + "</td>", n2);
        this.write(writer, "<td>" + string3 + "</td>", n2);
        this.write(writer, "</tr>", --n2);
    }

    protected void writeDataSetList(Writer writer, DataSetList dataSetList, int n) throws IOException {
        int n2 = dataSetList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + n2));
        }
        this.write(writer, "<p>DataSet count=" + n2 + "</p>", n);
        for (int i = 0; i < n2; ++i) {
            this.writeLine(writer, n);
            this.writeDataSet(writer, i, dataSetList.get(i), n);
        }
    }

    protected void writeDataSet(Writer writer, int n, DataSet dataSet, int n2) throws IOException {
        String string = dataSet.getName();
        String string2 = dataSet.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", alias=" + (string2 != null ? URLEncoder.encode(string2, "UTF-8") : null) + ", columnCount=" + dataSet.getColumnCount() + ", rowCount=" + dataSet.getRowCount() + ", removedRowCount=" + dataSet.getRemovedRowCount()));
        }
        this.write(writer, "<p>DataSet index=" + n + ", name=" + string2 + "</p>", n2);
        this.writeColumns(writer, dataSet, n2);
        this.writeRows(writer, dataSet, n2);
    }

    protected void writeColumns(Writer writer, DataSet dataSet, int n) throws IOException {
        int n2 = dataSet.getColumnCount();
        this.write(writer, "<p>Header column=" + n2 + "</p>", n);
        this.write(writer, "<table>", n);
        this.write(writer, "<tr>", n++);
        this.write(writer, "<th>Index</th>", n);
        this.write(writer, "<th>Name</th>", n);
        this.write(writer, "<th>Type</th>", n);
        this.write(writer, "<th>DataType</th>", n);
        this.write(writer, "<th>DataSize</th>", n);
        this.write(writer, "<th>Value</th>", n);
        this.write(writer, "</tr>", --n);
        for (int i = 0; i < n2; ++i) {
            this.writeColumnHeader(writer, i, dataSet, dataSet.getColumn(i), n);
        }
        this.write(writer, "</table>", n);
    }

    protected void writeColumnHeader(Writer writer, int n, DataSet dataSet, ColumnHeader columnHeader, int n2) throws IOException {
        String string;
        String string2 = columnHeader.getName();
        String string3 = columnHeader.isConstant() ? "constant" : "normal";
        String string4 = DataTypes.toStringType(columnHeader.getDataType());
        int n3 = columnHeader.getDataSize();
        String string5 = string = columnHeader.isConstant() ? ((ConstantColumnHeader)columnHeader).getStringValue(dataSet) : null;
        if (n % 2 == 1) {
            this.write(writer, "<tr class=\"odd\">", n2++);
        } else {
            this.write(writer, "<tr>", n2++);
        }
        this.write(writer, "<td>" + n + "</td>", n2);
        this.write(writer, "<td>" + string2 + "</td>", n2);
        this.write(writer, "<td>" + string3 + "</td>", n2);
        this.write(writer, "<td>" + string4 + "</td>", n2);
        this.write(writer, "<td>" + n3 + "</td>", n2);
        this.write(writer, "<td>" + string + "</td>", n2);
        this.write(writer, "</tr>", --n2);
    }

    protected void writeRows(Writer writer, DataSet dataSet, int n) throws IOException {
        int n2 = dataSet.getColumnCount();
        int n3 = dataSet.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: columnCount=" + n2 + ", rowCount=" + n3));
        }
        this.write(writer, "<p>Data row=" + n3 + "</p>", n);
        this.write(writer, "<table>", n++);
        boolean bl = dataSet.isCheckingGetterDataIndex();
        if (bl) {
            dataSet.setCheckingGetterDataIndex(false);
        }
        this.writeRow(writer, -1, dataSet, -1, n);
        for (int i = 0; i < n3; ++i) {
            this.writeRow(writer, i, dataSet, i, n);
        }
        if (bl) {
            dataSet.setCheckingGetterDataIndex(true);
        }
        this.write(writer, "</table>", --n);
    }

    protected void writeRow(Writer writer, int n, DataSet dataSet, int n2, int n3) throws IOException {
        if (n % 2 == 1) {
            this.write(writer, "<tr class=\"odd\">", n3);
        } else {
            this.write(writer, "<tr>", n3);
        }
        int n4 = dataSet.getColumnCount();
        for (int i = 0; i < n4; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            if (n2 == -1) {
                this.write(writer, "<th>" + columnHeader.getName() + "</th>", n3);
                continue;
            }
            this.write(writer, "<td>" + dataSet.getString(n2, i) + "</td>", n3);
        }
        this.write(writer, "</tr>", n3);
    }

    protected void write(Writer writer, String string, int n) throws IOException {
        if (n == 0) {
            writer.write(string);
            writer.write(NL);
        } else if (n < 6) {
            writer.write(TABS[n]);
            writer.write(string);
            writer.write(NL);
        } else {
            for (int i = 0; i < n; ++i) {
                writer.write(TABS[0]);
            }
            writer.write(string);
            writer.write(NL);
        }
    }
}

