/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PartDataSerializer;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.Base64;
import com.nexacro.xapi.tx.impl.PlatformCodec;
import com.nexacro.xapi.tx.impl.XmlCodec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformXmlPartDataSerializer
implements PartDataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformXmlPartDataSerializer.class);
    private static final boolean NULL_IS_SINGLE_TAG = true;
    private static final boolean WRITE_NULL_VALUE = false;
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final String XML_NS = "http://www.nexacro.com/platform/dataset";
    private static final String VERSION = "5000";
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private XmlCodec xmlCodec = new XmlCodec();
    private byte[] buffer;
    private String charset;
    private DataTypeChanger dataTypeChanger;
    private Writer out;
    private int depth;
    private Object data;

    public void setProperty(String string, Object object) {
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public void setDataTypeChanger(DataTypeChanger dataTypeChanger) {
        this.dataTypeChanger = dataTypeChanger;
    }

    public void setOutputStream(OutputStream outputStream) throws PlatformException {
        try {
            this.out = this.charset == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, this.charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)unsupportedEncodingException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, unsupportedEncodingException);
        }
    }

    public void setWriter(Writer writer) throws PlatformException {
        this.out = writer;
    }

    public void writeHead() throws PlatformException {
        try {
            if (this.charset == null) {
                this.writeString(this.out, "<?xml version=\"1.0\"?>", this.depth);
            } else {
                this.writeString(this.out, "<?xml version=\"1.0\" encoding=\"" + this.charset + "\"?>", this.depth);
            }
            this.writeString(this.out, "<Root xmlns=\"http://www.nexacro.com/platform/dataset\" ver=\"5000\">", this.depth);
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    public void writeTail() throws PlatformException {
        try {
            if (this.data instanceof Variable) {
                --this.depth;
                this.writeString(this.out, "</Parameters>", this.depth);
                --this.depth;
            } else if (this.data instanceof DataSet) {
                --this.depth;
                this.writeString(this.out, "</Rows>", this.depth);
                --this.depth;
                this.writeString(this.out, "</Dataset>", this.depth);
                --this.depth;
            }
            this.writeString(this.out, "</Root>", this.depth);
            this.out.flush();
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    public void writeVariable(Variable variable) throws PlatformException {
        try {
            if (this.data == null) {
                ++this.depth;
                this.writeString(this.out, "<Parameters>", this.depth);
                ++this.depth;
            }
            if (DataTypes.isBinary(variable.getType())) {
                this.writeBinaryVariable(variable);
            } else {
                this.writeStringVariable(variable);
            }
            this.out.flush();
            this.data = variable;
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    public void writeDataSet(DataSet dataSet) throws PlatformException {
        try {
            String string = dataSet.getName();
            String string2 = dataSet.getAlias();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing DataSet: name=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", alias=" + (string2 != null ? URLEncoder.encode(string2, "UTF-8") : null) + ", columnCount=" + dataSet.getColumnCount() + ", rowCount=" + dataSet.getRowCount() + ", removedRowCount=" + dataSet.getRemovedRowCount()));
            }
            if (this.data == dataSet) {
                int[] nArray = this.getTargetDataTypes(dataSet, this.dataTypeChanger);
                this.writeRowData(dataSet, nArray);
            } else {
                if (this.data instanceof Variable) {
                    --this.depth;
                    this.writeString(this.out, "</Parameters>", this.depth);
                } else if (this.data instanceof DataSet) {
                    --this.depth;
                    this.writeString(this.out, "</Rows>", this.depth);
                    --this.depth;
                    this.writeString(this.out, "</Dataset>", this.depth);
                } else {
                    ++this.depth;
                }
                this.writeString(this.out, "<Dataset id=\"" + string2 + "\">", this.depth);
                ++this.depth;
                int[] nArray = this.getTargetDataTypes(dataSet, this.dataTypeChanger);
                this.writeColumns(dataSet, nArray);
                this.writeString(this.out, "<Rows>", this.depth);
                ++this.depth;
                this.writeRowData(dataSet, nArray);
            }
            this.out.flush();
            this.data = dataSet;
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    private void writeStringVariable(Variable variable) throws IOException {
        String string = variable.getName();
        String string2 = this.getDataType(variable.getType());
        String string3 = this.getStringValue(variable);
        int n = string3 == null ? 0 : string3.length();
        StringBuffer stringBuffer = new StringBuffer(n + 64);
        stringBuffer.append("<Parameter id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        if (string3 == null) {
            stringBuffer.append("\"/>");
        } else {
            stringBuffer.append("\">").append(string3);
            stringBuffer.append("</Parameter>");
        }
        this.writeString(this.out, stringBuffer.toString(), this.depth);
    }

    private void writeBinaryVariable(Variable variable) throws IOException {
        String string = variable.getName();
        String string2 = this.getDataType(variable.getType());
        byte[] byArray = this.getBinaryValue(variable);
        if (byArray == null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("<Parameter id=\"").append(string);
            stringBuffer.append("\" type=\"").append(string2);
            stringBuffer.append("\"/>");
            this.writeString(this.out, stringBuffer.toString(), this.depth);
        } else {
            String string3 = "<Parameter id=\"" + string + "\" type=\"" + string2 + "\" encrypt=\"base64\">";
            String string4 = "</Parameter>";
            this.writeBinary(this.out, byArray, string3, string4, this.depth);
        }
    }

    private String getStringValue(Variable variable) {
        int n = variable.getType();
        if (n == 4) {
            return variable.getBoolean() ? "1" : "0";
        }
        String string = variable.getString();
        if (string == null) {
            return string;
        }
        if (n == 2) {
            return this.encode(string);
        }
        return string;
    }

    private byte[] getBinaryValue(Variable variable) {
        return variable.getBlob();
    }

    private void writeColumns(DataSet dataSet, int[] nArray) throws IOException {
        this.writeString(this.out, "<ColumnInfo>", this.depth++);
        int n = dataSet.getColumnCount();
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            int n2 = nArray[i];
            if (columnHeader.getType() == 0) {
                this.writeDefaultColumnHeader(columnHeader, n2);
                continue;
            }
            if (columnHeader.getType() == 1) {
                this.writeConstantColumnHeader(dataSet, columnHeader, n2);
                continue;
            }
            throw new IOException("Invalid column type: " + columnHeader.getType());
        }
        this.writeString(this.out, "</ColumnInfo>", --this.depth);
    }

    private void writeDefaultColumnHeader(ColumnHeader columnHeader, int n) throws IOException {
        String string = columnHeader.getName();
        String string2 = this.getDataType(n);
        int n2 = columnHeader.getDataSize();
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("<Column id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        stringBuffer.append("\" size=\"").append(n2);
        if (n == 13 || DataTypes.isBinary(n)) {
            stringBuffer.append("\" encrypt=\"").append("base64");
        }
        stringBuffer.append("\"/>");
        this.writeString(this.out, stringBuffer.toString(), this.depth);
    }

    private void writeConstantColumnHeader(DataSet dataSet, ColumnHeader columnHeader, int n) throws IOException {
        if (DataTypes.isBinary(n)) {
            this.writeBinaryColumnHeader(dataSet, (ConstantColumnHeader)columnHeader, n);
        } else {
            this.writeStringColumnHeader(dataSet, (ConstantColumnHeader)columnHeader, n);
        }
    }

    private void writeStringColumnHeader(DataSet dataSet, ConstantColumnHeader constantColumnHeader, int n) throws IOException {
        if (n == 13) {
            n = 2;
        }
        String string = constantColumnHeader.getName();
        String string2 = this.getDataType(n);
        int n2 = constantColumnHeader.getDataSize();
        String string3 = this.getStringValue(dataSet, constantColumnHeader);
        int n3 = string3 == null ? 0 : string3.length();
        StringBuffer stringBuffer = new StringBuffer(n3 + 64);
        stringBuffer.append("<ConstColumn id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        stringBuffer.append("\" size=\"").append(n2);
        if (string3 != null) {
            stringBuffer.append("\" value=\"").append(string3);
        }
        stringBuffer.append("\"/>");
        this.writeString(this.out, stringBuffer.toString(), this.depth);
    }

    private void writeBinaryColumnHeader(DataSet dataSet, ConstantColumnHeader constantColumnHeader, int n) throws IOException {
        String string = constantColumnHeader.getName();
        String string2 = this.getDataType(n);
        int n2 = constantColumnHeader.getDataSize();
        byte[] byArray = this.getBinaryValue(dataSet, constantColumnHeader);
        if (byArray == null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("<ConstColumn id=\"").append(string);
            stringBuffer.append("\" type=\"").append(string2);
            stringBuffer.append("\" size=\"").append(n2);
            stringBuffer.append("\"/>");
            this.writeString(this.out, stringBuffer.toString(), this.depth);
        } else {
            String string3 = "<ConstColumn id=\"" + string + "\" type=\"" + string2 + "\" size=\"" + n2 + "\" encrypt=\"base64\" value=\"";
            String string4 = "\"></ConstColumn>";
            this.writeBinary(this.out, byArray, string3, string4, this.depth);
        }
    }

    private String getStringValue(DataSet dataSet, ConstantColumnHeader constantColumnHeader) {
        int n = constantColumnHeader.getDataType();
        if (n == 4) {
            return constantColumnHeader.getBooleanValue(dataSet) ? "1" : "0";
        }
        String string = constantColumnHeader.getStringValue(dataSet);
        if (string == null) {
            return string;
        }
        if (n == 2) {
            return this.encode(string);
        }
        return string;
    }

    private byte[] getBinaryValue(DataSet dataSet, ConstantColumnHeader constantColumnHeader) {
        return constantColumnHeader.getBlobValue(dataSet);
    }

    private void writeRowData(DataSet dataSet, int[] nArray) throws IOException {
        int n;
        boolean bl;
        int n2 = dataSet.getSaveType();
        if (n2 == 0) {
            n2 = 2;
        }
        int n3 = dataSet.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + n3));
        }
        if (bl = dataSet.isCheckingGetterDataIndex()) {
            dataSet.setCheckingGetterDataIndex(false);
        }
        for (n = 0; n < n3; ++n) {
            this.writeRow(dataSet, nArray, n, n2);
        }
        if (n2 == 1 || n2 == 4 || n2 == 5) {
            n = dataSet.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + n));
            }
            for (int i = 0; i < n; ++i) {
                this.writeRemovedRow(dataSet, nArray, i);
            }
        }
        if (bl) {
            dataSet.setCheckingGetterDataIndex(true);
        }
    }

    private void writeRow(DataSet dataSet, int[] nArray, int n, int n2) throws IOException {
        int n3 = dataSet.getRowType(n);
        if (n2 != 1 && (n2 == 2 ? n3 == 3 : (n2 == 3 ? n3 == 0 || n3 == 3 : (n2 == 4 ? n3 == 0 || n3 == 1 || n3 == 2 : n2 == 5 && n3 == 0)))) {
            return;
        }
        if (n2 == 2) {
            this.writeString(this.out, "<Row>", this.depth++);
        } else if (n3 == 1) {
            this.writeString(this.out, "<Row type=\"insert\">", this.depth++);
        } else if (n3 == 2) {
            this.writeString(this.out, "<Row type=\"update\">", this.depth++);
        } else if (n3 == 3) {
            this.writeString(this.out, "<Row type=\"delete\">", this.depth++);
        } else {
            this.writeString(this.out, "<Row>", this.depth++);
        }
        int n4 = dataSet.getColumnCount();
        for (int i = 0; i < n4; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            int n5 = columnHeader.getDataType();
            int n6 = nArray[i];
            if (n6 == 13 || DataTypes.isBinary(n6)) {
                byte[] byArray = object = n5 == 13 ? this.getBinaryValueFromFile(dataSet, n, i, n6) : this.getBinaryValue(dataSet, n, i);
                if (object == null) continue;
                String string2 = "<Col id=\"" + string + "\">";
                String string3 = "</Col>";
                this.writeBinary(this.out, (byte[])object, string2, string3, this.depth);
                continue;
            }
            object = n5 == 13 ? this.getStringValueFromFile(dataSet, n, i, n6) : this.getStringValue(dataSet, n, i);
            if (object == null) continue;
            this.writeString(this.out, "<Col id=\"" + string + "\">" + (String)object + "</Col>", this.depth);
        }
        if ((n2 == 1 || n2 == 3 || n2 == 5) && n3 == 2) {
            this.writeSavedRow(dataSet, nArray, n);
        }
        this.writeString(this.out, "</Row>", --this.depth);
    }

    private void writeSavedRow(DataSet dataSet, int[] nArray, int n) throws IOException {
        this.writeString(this.out, "<OrgRow>", this.depth++);
        int n2 = dataSet.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            int n3 = columnHeader.getDataType();
            int n4 = nArray[i];
            if (n4 == 13 || DataTypes.isBinary(n4)) {
                byte[] byArray = object = n3 == 13 ? this.getSavedBinaryValueFromFile(dataSet, n, i, n4) : this.getSavedBinaryValue(dataSet, n, i);
                if (object == null) continue;
                String string2 = "<Col id=\"" + string + "\">";
                String string3 = "</Col>";
                this.writeBinary(this.out, (byte[])object, string2, string3, this.depth);
                continue;
            }
            object = n3 == 13 ? this.getSavedStringValueFromFile(dataSet, n, i, n4) : this.getSavedStringValue(dataSet, n, i);
            if (object == null) continue;
            this.writeString(this.out, "<Col id=\"" + string + "\">" + (String)object + "</Col>", this.depth);
        }
        this.writeString(this.out, "</OrgRow>", --this.depth);
    }

    private void writeRemovedRow(DataSet dataSet, int[] nArray, int n) throws IOException {
        this.writeString(this.out, "<Row type=\"delete\">", this.depth++);
        int n2 = dataSet.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            int n3 = columnHeader.getDataType();
            int n4 = nArray[i];
            if (n4 == 13 || DataTypes.isBinary(n4)) {
                byte[] byArray = object = n3 == 13 ? this.getRemovedBinaryValueFromFile(dataSet, n, i, n4) : this.getRemovedBinaryValue(dataSet, n, i);
                if (object == null) continue;
                String string2 = "<Col id=\"" + string + "\">";
                String string3 = "</Col>";
                this.writeBinary(this.out, (byte[])object, string2, string3, this.depth);
                continue;
            }
            object = n3 == 13 ? this.getRemovedStringValueFromFile(dataSet, n, i, n4) : this.getRemovedStringValue(dataSet, n, i);
            if (object == null) continue;
            this.writeString(this.out, "<Col id=\"" + string + "\">" + (String)object + "</Col>", this.depth);
        }
        this.writeString(this.out, "</Row>", --this.depth);
    }

    private String getStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getBoolean(n, n2) ? "1" : "0";
        }
        String string = dataSet.getString(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    private byte[] getBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getBlob(n, n2);
    }

    private String getStringValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 2) {
            String string = dataSet.getString(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray == null ? null : this.encode(new String(byArray));
        }
        return null;
    }

    private byte[] getBinaryValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 12 || n3 == 13) {
            String string = dataSet.getString(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray;
        }
        return null;
    }

    private String getSavedStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getSavedBooleanData(n, n2) ? "1" : "0";
        }
        String string = dataSet.getSavedStringData(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    private byte[] getSavedBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getSavedBlobData(n, n2);
    }

    private String getSavedStringValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 2) {
            String string = dataSet.getSavedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray == null ? null : this.encode(new String(byArray));
        }
        return null;
    }

    private byte[] getSavedBinaryValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 12 || n3 == 13) {
            String string = dataSet.getSavedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray;
        }
        return null;
    }

    private String getRemovedStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getRemovedBooleanData(n, n2) ? "1" : "0";
        }
        String string = dataSet.getRemovedStringData(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    private byte[] getRemovedBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getRemovedBlobData(n, n2);
    }

    private String getRemovedStringValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 2) {
            String string = dataSet.getRemovedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray == null ? null : this.encode(new String(byArray));
        }
        return null;
    }

    private byte[] getRemovedBinaryValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 12 || n3 == 13) {
            String string = dataSet.getRemovedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray;
        }
        return null;
    }

    private void writeString(Writer writer, String string, int n) throws IOException {
        if (n == 0) {
            writer.write(string);
            writer.write(NL);
        } else if (n < 6) {
            writer.write(TABS[n]);
            writer.write(string);
            writer.write(NL);
        } else {
            for (int i = 0; i < n; ++i) {
                writer.write(TABS[1]);
            }
            writer.write(string);
            writer.write(NL);
        }
    }

    private void writeBinary(Writer writer, byte[] byArray, String string, String string2, int n) throws IOException {
        if (n == 0) {
            writer.write(string);
            String string3 = Base64.encodeBytes(byArray, 8);
            writer.write(string3);
            writer.write(string2);
            writer.write(NL);
        } else if (n < 6) {
            writer.write(TABS[n]);
            writer.write(string);
            String string4 = Base64.encodeBytes(byArray, 8);
            writer.write(string4);
            writer.write(string2);
            writer.write(NL);
        } else {
            for (int i = 0; i < n; ++i) {
                writer.write(TABS[1]);
            }
            writer.write(string);
            String string5 = Base64.encodeBytes(byArray, 8);
            writer.write(string5);
            writer.write(string2);
            writer.write(NL);
        }
    }

    private int[] getTargetDataTypes(DataSet dataSet, DataTypeChanger dataTypeChanger) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (dataTypeChanger == null) {
                nArray[i] = columnHeader.getDataType();
                continue;
            }
            String string = dataSet.getAlias();
            String string2 = columnHeader.getName();
            int n2 = columnHeader.getDataType();
            nArray[i] = dataTypeChanger.getDataType(string, string2, n2);
        }
        return nArray;
    }

    private String getDataType(int n) {
        if (n == 4) {
            return DataTypes.toStringType(3);
        }
        if (n == 5) {
            return DataTypes.toStringType(8);
        }
        if (n == 7) {
            return DataTypes.toStringType(6);
        }
        if (n == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(n);
    }

    private String encode(String string) {
        if (string == null) {
            return string;
        }
        return this.xmlCodec.encode(this.platformCodec.encode(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String string) throws IOException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.getBuffer();
            try {
                int n;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.close();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            finally {
                fileInputStream.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

