/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.ProtocolEncoder;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformZlibByteEncoder
extends DeflaterOutputStream
implements ProtocolEncoder {
    private Log log = LogFactory.getLog((Class)PlatformZlibByteEncoder.class);
    private static final int ZLIB_SIGNATURE = 65453;
    private Deflater deflater;

    public PlatformZlibByteEncoder(OutputStream outputStream) throws IOException {
        this(outputStream, PlatformZlibByteEncoder.createDeflater());
    }

    private PlatformZlibByteEncoder(OutputStream outputStream, Deflater deflater) throws IOException {
        super(outputStream, deflater);
        this.deflater = deflater;
        this.writeSignature(outputStream);
    }

    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing: " + this));
        }
        super.close();
    }

    public void end() throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Ending: " + this));
        }
        try {
            this.finish();
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Finishing PlatformZlibByteEncoder failed", (Throwable)iOException);
            }
            throw new PlatformException("Finishing PlatformZlibByteEncoder failed", iOException);
        }
        this.deflater.end();
    }

    private void writeSignature(OutputStream outputStream) throws IOException {
        this.writeShort(outputStream, 65453);
    }

    private void writeShort(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n >>> 8 & 0xFF);
        outputStream.write(n >>> 0 & 0xFF);
    }

    private static Deflater createDeflater() {
        return new Deflater(1);
    }
}

