/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.util;

import java.net.URLClassLoader;
import java.text.MessageFormat;
import java.util.Hashtable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StringResource {
    private static final String DEFAULT_BUNDLE_NAME = "local-strings";
    private static Hashtable resources = new Hashtable();
    private ResourceBundle bundle;

    public static synchronized StringResource getResource(Class clazz) {
        return StringResource.getResource(clazz.getPackage().getName());
    }

    public static synchronized StringResource getResource(String string) {
        return StringResource.getResource(string, DEFAULT_BUNDLE_NAME);
    }

    static synchronized StringResource getResource(Class clazz, String string) {
        return StringResource.getResource(clazz.getPackage().getName(), string);
    }

    static synchronized StringResource getResource(String string, String string2) {
        String string3 = string + '.' + string2;
        StringResource stringResource = (StringResource)resources.get(string3);
        if (stringResource == null) {
            stringResource = new StringResource(string3);
            resources.put(string3, stringResource);
        }
        return stringResource;
    }

    private StringResource(String string) {
        block7: {
            try {
                this.bundle = ResourceBundle.getBundle(string);
            }
            catch (MissingResourceException missingResourceException) {
                ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
                if (classLoader == null) {
                    classLoader = this.getClass().getClassLoader();
                } else {
                    try {
                        this.bundle = ResourceBundle.getBundle(string, Locale.getDefault(), classLoader);
                        return;
                    }
                    catch (MissingResourceException missingResourceException2) {
                        // empty catch block
                    }
                }
                Log log = LogFactory.getLog((Class)StringResource.class);
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Cannot find resource " + string + " " + classLoader));
                }
                if (!(classLoader instanceof URLClassLoader) || !log.isDebugEnabled()) break block7;
                log.debug((Object)((URLClassLoader)classLoader).getURLs());
            }
        }
    }

    public String getString(String string) {
        return MessageFormat.format(this.getStringInternal(string), null);
    }

    public String getString(String string, Object[] objectArray) {
        String string2 = this.getStringInternal(string);
        try {
            Object[] objectArray2 = objectArray;
            for (int i = 0; i < objectArray.length; ++i) {
                if (objectArray[i] != null) continue;
                if (objectArray2 == objectArray) {
                    objectArray2 = (Object[])objectArray.clone();
                }
                objectArray2[i] = "null";
            }
            return MessageFormat.format(string2, objectArray2);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(string2);
            for (int i = 0; i < objectArray.length; ++i) {
                stringBuffer.append(" arg[" + i + "]=" + objectArray[i]);
            }
            return stringBuffer.toString();
        }
    }

    public String getString(String string, Object object) {
        Object[] objectArray = new Object[]{object};
        return this.getString(string, objectArray);
    }

    public String getString(String string, Object object, Object object2) {
        Object[] objectArray = new Object[]{object, object2};
        return this.getString(string, objectArray);
    }

    public String getString(String string, Object object, Object object2, Object object3) {
        Object[] objectArray = new Object[]{object, object2, object3};
        return this.getString(string, objectArray);
    }

    public String getString(String string, Object object, Object object2, Object object3, Object object4) {
        Object[] objectArray = new Object[]{object, object2, object3, object4};
        return this.getString(string, objectArray);
    }

    private String getStringInternal(String string) {
        if (string == null) {
            String string2 = "key is null";
            throw new NullPointerException(string2);
        }
        if (this.bundle == null) {
            return string;
        }
        try {
            return this.bundle.getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            return "Cannot find message associated with key '" + string + "'";
        }
    }
}

