/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class DataRow
implements Cloneable,
Serializable {
    private static final long serialVersionUID = -3549819208790286520L;
    private static final boolean CHECK_INDEX = false;
    private int type;
    private List values;

    public DataRow(int n) {
        this(n, 0);
    }

    public DataRow(int n, int n2) {
        this.type = n2;
        this.values = this.createEmptyValues(n);
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.type = n;
    }

    public Object get(int n) {
        return this.values.get(n);
    }

    public void set(int n, Object object) {
        this.values.set(n, object);
    }

    public Object remove(int n) {
        return this.values.set(n, null);
    }

    public void clear() {
        if (this.values == null) {
            return;
        }
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            this.values.set(i, null);
        }
    }

    public int size() {
        return this.values.size();
    }

    public void copyTo(DataRow dataRow) {
        this.copy(this, dataRow);
    }

    public void copyFrom(DataRow dataRow) {
        this.copy(dataRow, this);
    }

    public DataRow getClone() {
        try {
            return (DataRow)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            Log log = LogFactory.getLog((Class)DataRow.class);
            if (log.isErrorEnabled()) {
                log.error((Object)"Could not clone", (Throwable)cloneNotSupportedException);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        DataRow dataRow = (DataRow)super.clone();
        dataRow.values = (List)((ArrayList)this.values).clone();
        return dataRow;
    }

    public boolean equals(Object object) {
        if (object instanceof DataRow) {
            DataRow dataRow = (DataRow)object;
            return this.type == dataRow.type && this.equalsValues(dataRow);
        }
        return false;
    }

    void increase() {
        this.values.add(null);
    }

    void increase(int n) {
        this.values.add(n, null);
    }

    void decrease() {
        this.values.remove(this.values.size() - 1);
    }

    void decrease(int n) {
        this.values.remove(n);
    }

    private boolean equalsValues(DataRow dataRow) {
        if (this.values.size() != dataRow.values.size()) {
            return false;
        }
        int n = this.values.size();
        for (int i = 0; i < n; ++i) {
            Object e;
            Object e2 = this.values.get(i);
            if (this.equalsValue(e2, e = dataRow.values.get(i))) continue;
            return false;
        }
        return true;
    }

    private boolean equalsValue(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    private void copy(DataRow dataRow, DataRow dataRow2) {
        int n = dataRow.size();
        int n2 = dataRow2.size();
        if (n == 0 || n2 == 0) {
            return;
        }
        int n3 = Math.min(n, n2);
        for (int i = 0; i < n3; ++i) {
            dataRow2.set(i, dataRow.get(i));
        }
    }

    private boolean contains(int n) {
        return this.contains(n, false);
    }

    private boolean contains(int n, boolean bl) {
        int n2 = bl ? this.values.size() : this.values.size() - 1;
        return n >= 0 && n <= n2;
    }

    private List createEmptyValues(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid count: " + n);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(null);
        }
        return arrayList;
    }
}

