/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import java.math.BigDecimal;
import java.util.Date;

public class DataTypes {
    public static final int UNDEFINED = 0;
    public static final int NULL = 1;
    public static final int STRING = 2;
    public static final int INT = 3;
    public static final int BOOLEAN = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int BIG_DECIMAL = 8;
    public static final int DECIMAL = 8;
    public static final int DATE = 9;
    public static final int TIME = 10;
    public static final int DATE_TIME = 11;
    public static final int BLOB = 12;
    public static final int FILE = 13;
    public static final String STR_UNDEFINED = "undefined";
    public static final String STR_NULL = "null";
    public static final String STR_STRING = "string";
    public static final String STR_INT = "int";
    public static final String STR_BOOLEAN = "boolean";
    public static final String STR_LONG = "long";
    public static final String STR_FLOAT = "float";
    public static final String STR_DOUBLE = "double";
    public static final String STR_BIG_DECIMAL = "bigdecimal";
    public static final String STR_DECIMAL = "bigdecimal";
    public static final String STR_DATE = "date";
    public static final String STR_TIME = "time";
    public static final String STR_DATE_TIME = "datetime";
    public static final String STR_BLOB = "blob";
    public static final String STR_FILE = "file";
    public static final int DEFAULT_SIZE_UNDEFINED = 0;
    public static final int DEFAULT_SIZE_NULL = 0;
    public static final int DEFAULT_SIZE_STRING = 32;
    public static final int DEFAULT_SIZE_INT = 4;
    public static final int DEFAULT_SIZE_BOOLEAN = 2;
    public static final int DEFAULT_SIZE_LONG = 8;
    public static final int DEFAULT_SIZE_FLOAT = 4;
    public static final int DEFAULT_SIZE_DOUBLE = 8;
    public static final int DEFAULT_SIZE_BIG_DECIMAL = 16;
    public static final int DEFAULT_SIZE_DECIMAL = 16;
    public static final int DEFAULT_SIZE_DATE = 6;
    public static final int DEFAULT_SIZE_TIME = 9;
    public static final int DEFAULT_SIZE_DATE_TIME = 17;
    public static final int DEFAULT_SIZE_BLOB = 256;
    public static final int DEFAULT_SIZE_FILE = 256;
    public static final String DEFAULT_VALUE_STRING = null;
    public static final int DEFAULT_VALUE_INT = 0;
    public static final boolean DEFAULT_VALUE_BOOLEAN = false;
    public static final long DEFAULT_VALUE_LONG = 0L;
    public static final float DEFAULT_VALUE_FLOAT = 0.0f;
    public static final double DEFAULT_VALUE_DOUBLE = 0.0;
    public static final BigDecimal DEFAULT_VALUE_BIG_DECIMAL;
    public static final BigDecimal DEFAULT_VALUE_DECIMAL;
    public static final Date DEFAULT_VALUE_DATE;
    public static final Date DEFAULT_VALUE_TIME;
    public static final Date DEFAULT_VALUE_DATE_TIME;
    public static final byte[] DEFAULT_VALUE_BLOB;
    public static final byte[] DEFAULT_VALUE_FILE;
    public static final Object DEFAULT_VALUE_OBJECT;

    public static int getDefaultSize(int n) {
        switch (n) {
            case 2: {
                return 32;
            }
            case 3: {
                return 4;
            }
            case 4: {
                return 2;
            }
            case 5: {
                return 8;
            }
            case 6: {
                return 4;
            }
            case 7: {
                return 8;
            }
            case 8: {
                return 16;
            }
            case 9: {
                return 6;
            }
            case 10: {
                return 9;
            }
            case 11: {
                return 17;
            }
            case 12: {
                return 256;
            }
            case 13: {
                return 256;
            }
            case 1: {
                return 0;
            }
        }
        return 0;
    }

    public static int getDefaultSize(String string) {
        return DataTypes.getDefaultSize(DataTypes.toIntType(string));
    }

    public static int toIntType(String string) {
        if (STR_STRING.equalsIgnoreCase(string)) {
            return 2;
        }
        if (STR_INT.equalsIgnoreCase(string)) {
            return 3;
        }
        if (STR_BOOLEAN.equalsIgnoreCase(string)) {
            return 4;
        }
        if (STR_LONG.equalsIgnoreCase(string)) {
            return 5;
        }
        if (STR_FLOAT.equalsIgnoreCase(string)) {
            return 6;
        }
        if (STR_DOUBLE.equalsIgnoreCase(string)) {
            return 7;
        }
        if ("bigdecimal".equalsIgnoreCase(string)) {
            return 8;
        }
        if (STR_DATE.equalsIgnoreCase(string)) {
            return 9;
        }
        if (STR_TIME.equalsIgnoreCase(string)) {
            return 10;
        }
        if (STR_DATE_TIME.equalsIgnoreCase(string)) {
            return 11;
        }
        if (STR_BLOB.equalsIgnoreCase(string)) {
            return 12;
        }
        if (STR_FILE.equalsIgnoreCase(string)) {
            return 13;
        }
        if (STR_NULL.equalsIgnoreCase(string)) {
            return 1;
        }
        return 0;
    }

    public static String toStringType(int n) {
        switch (n) {
            case 2: {
                return STR_STRING;
            }
            case 3: {
                return STR_INT;
            }
            case 4: {
                return STR_BOOLEAN;
            }
            case 5: {
                return STR_LONG;
            }
            case 6: {
                return STR_FLOAT;
            }
            case 7: {
                return STR_DOUBLE;
            }
            case 8: {
                return "bigdecimal";
            }
            case 9: {
                return STR_DATE;
            }
            case 10: {
                return STR_TIME;
            }
            case 11: {
                return STR_DATE_TIME;
            }
            case 12: {
                return STR_BLOB;
            }
            case 13: {
                return STR_FILE;
            }
            case 1: {
                return STR_NULL;
            }
        }
        return STR_UNDEFINED;
    }

    public static int findType(Object object) {
        return DataTypes.findType(object, true);
    }

    public static int findType(Object object, boolean bl) {
        if (object == null) {
            return bl ? 1 : 0;
        }
        if (object instanceof String) {
            return 2;
        }
        if (object instanceof Integer) {
            return 3;
        }
        if (object instanceof Boolean) {
            return 4;
        }
        if (object instanceof Long) {
            return 5;
        }
        if (object instanceof Float) {
            return 6;
        }
        if (object instanceof Double) {
            return 7;
        }
        if (object instanceof BigDecimal) {
            return 8;
        }
        if (object instanceof Date) {
            return 11;
        }
        if (object instanceof byte[]) {
            return 12;
        }
        return 0;
    }

    public static boolean isBinary(int n) {
        return n == 12;
    }

    private DataTypes() {
    }

    static {
        DEFAULT_VALUE_DECIMAL = DEFAULT_VALUE_BIG_DECIMAL = null;
        DEFAULT_VALUE_DATE = null;
        DEFAULT_VALUE_TIME = null;
        DEFAULT_VALUE_DATE_TIME = null;
        DEFAULT_VALUE_BLOB = null;
        DEFAULT_VALUE_FILE = null;
        DEFAULT_VALUE_OBJECT = null;
    }
}

