/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.Base64;
import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.data.XmlCodec;
import com.nexacro.xapi.tx.PlatformException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class PlatformXmlDataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformXmlDataSerializer.class);
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final String XML_NS = "http://www.nexacro.com/platform/dataset";
    private static final String VERSION = "5000";
    private static final int BUFFER_SIZE = 4096;
    private XmlCodec codec = new XmlCodec();
    private byte[] buffer;

    public void writeData(Writer writer, PlatformData platformData) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this));
        }
        try {
            this.write(writer, platformData);
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    public void writeData(Writer writer, DataSet dataSet) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this));
        }
        try {
            this.write(writer, dataSet);
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    void write(Writer writer, PlatformData platformData) throws IOException {
        int n = 0;
        this.writeBeginRoot(writer, n);
        this.writeVariableList(writer, platformData, ++n);
        this.writeDataSetList(writer, platformData, n--);
        this.writeEndRoot(writer, n);
        writer.flush();
    }

    void write(Writer writer, DataSet dataSet) throws IOException {
        int n = 0;
        this.writeDataSet(writer, null, dataSet, n);
        writer.flush();
    }

    void writeBeginRoot(Writer writer, int n) throws IOException {
        this.writeString(writer, "<Root xmlns=\"http://www.nexacro.com/platform/dataset\" ver=\"5000\">", n);
    }

    void writeEndRoot(Writer writer, int n) throws IOException {
        this.writeString(writer, "</Root>", n);
    }

    void writeVariableList(Writer writer, PlatformData platformData, int n) throws IOException {
        VariableList variableList = platformData.getVariableList();
        int n2 = variableList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + n2));
        }
        if (n2 == 0) {
            this.writeString(writer, "<Parameters/>", n);
        } else {
            this.writeString(writer, "<Parameters>", n++);
            for (int i = 0; i < n2; ++i) {
                this.writeVariable(writer, variableList.get(i), n);
            }
            this.writeString(writer, "</Parameters>", --n);
        }
    }

    void writeVariable(Writer writer, Variable variable, int n) throws IOException {
        if (DataTypes.isBinary(variable.getType())) {
            this.writeBinaryVariable(writer, variable, n);
        } else {
            this.writeStringVariable(writer, variable, n);
        }
    }

    void writeStringVariable(Writer writer, Variable variable, int n) throws IOException {
        String string = variable.getName();
        String string2 = this.getDataType(variable.getType());
        String string3 = this.getStringValue(variable);
        int n2 = string3 == null ? 0 : string3.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 64);
        stringBuffer.append("<Parameter id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        if (string3 == null) {
            stringBuffer.append("\"/>");
        } else {
            stringBuffer.append("\">").append(string3);
            stringBuffer.append("</Parameter>");
        }
        this.writeString(writer, stringBuffer.toString(), n);
    }

    void writeBinaryVariable(Writer writer, Variable variable, int n) throws IOException {
        String string = variable.getName();
        String string2 = this.getDataType(variable.getType());
        byte[] byArray = this.getBinaryValue(variable);
        if (byArray == null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("<Parameter id=\"").append(string);
            stringBuffer.append("\" type=\"").append(string2);
            stringBuffer.append("\"/>");
            this.writeString(writer, stringBuffer.toString(), n);
        } else {
            String string3 = "<Parameter id=\"" + string + "\" type=\"" + string2 + "\" encrypt=\"base64\">";
            String string4 = "</Parameter>";
            this.writeBinary(writer, byArray, string3, string4, n);
        }
    }

    String getStringValue(Variable variable) {
        int n = variable.getType();
        if (n == 4) {
            return variable.getBoolean() ? "1" : "0";
        }
        String string = variable.getString();
        if (string == null) {
            return string;
        }
        if (n == 2) {
            return this.encode(string);
        }
        return string;
    }

    byte[] getBinaryValue(Variable variable) {
        return variable.getBlob();
    }

    void writeDataSetList(Writer writer, PlatformData platformData, int n) throws IOException {
        DataSetList dataSetList = platformData.getDataSetList();
        int n2 = dataSetList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + n2));
        }
        for (int i = 0; i < n2; ++i) {
            this.writeDataSet(writer, platformData, dataSetList.get(i), n);
        }
    }

    void writeDataSet(Writer writer, PlatformData platformData, DataSet dataSet, int n) throws IOException {
        String string = dataSet.getName();
        String string2 = dataSet.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + string + ", alias=" + string2 + ", columnCount=" + dataSet.getColumnCount() + ", rowCount=" + dataSet.getRowCount() + ", removedRowCount=" + dataSet.getRemovedRowCount()));
        }
        this.writeString(writer, "<Dataset id=\"" + string2 + "\">", n);
        this.writeColumns(writer, dataSet, ++n);
        this.writeRows(writer, platformData, dataSet, n--);
        this.writeString(writer, "</Dataset>", n);
    }

    void writeColumns(Writer writer, DataSet dataSet, int n) throws IOException {
        this.writeString(writer, "<ColumnInfo>", n++);
        int n2 = dataSet.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.getType() == 0) {
                this.writeDefaultColumnHeader(writer, columnHeader, n);
                continue;
            }
            if (columnHeader.getType() == 1) {
                this.writeConstantColumnHeader(writer, dataSet, columnHeader, n);
                continue;
            }
            throw new IOException("Invalid column type: " + columnHeader.getType());
        }
        this.writeString(writer, "</ColumnInfo>", --n);
    }

    void writeDefaultColumnHeader(Writer writer, ColumnHeader columnHeader, int n) throws IOException {
        String string = columnHeader.getName();
        int n2 = columnHeader.getDataType();
        String string2 = this.getDataType(n2);
        int n3 = columnHeader.getDataSize();
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("<Column id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        stringBuffer.append("\" size=\"").append(n3);
        if (n2 == 13 || DataTypes.isBinary(n2)) {
            stringBuffer.append("\" encrypt=\"").append("base64");
        }
        stringBuffer.append("\"/>");
        this.writeString(writer, stringBuffer.toString(), n);
    }

    void writeConstantColumnHeader(Writer writer, DataSet dataSet, ColumnHeader columnHeader, int n) throws IOException {
        if (DataTypes.isBinary(columnHeader.getDataType())) {
            this.writeBinaryColumnHeader(writer, dataSet, (ConstantColumnHeader)columnHeader, n);
        } else {
            this.writeStringColumnHeader(writer, dataSet, (ConstantColumnHeader)columnHeader, n);
        }
    }

    void writeStringColumnHeader(Writer writer, DataSet dataSet, ConstantColumnHeader constantColumnHeader, int n) throws IOException {
        String string = constantColumnHeader.getName();
        int n2 = constantColumnHeader.getDataType();
        String string2 = this.getDataType(n2);
        int n3 = constantColumnHeader.getDataSize();
        String string3 = this.getStringValue(dataSet, constantColumnHeader);
        int n4 = string3 == null ? 0 : string3.length();
        StringBuffer stringBuffer = new StringBuffer(n4 + 64);
        stringBuffer.append("<ConstColumn id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        stringBuffer.append("\" size=\"").append(n3);
        if (string3 != null) {
            stringBuffer.append("\" value=\"").append(string3);
        }
        stringBuffer.append("\"/>");
        this.writeString(writer, stringBuffer.toString(), n);
    }

    void writeBinaryColumnHeader(Writer writer, DataSet dataSet, ConstantColumnHeader constantColumnHeader, int n) throws IOException {
        String string = constantColumnHeader.getName();
        int n2 = constantColumnHeader.getDataType();
        String string2 = this.getDataType(n2);
        int n3 = constantColumnHeader.getDataSize();
        byte[] byArray = this.getBinaryValue(dataSet, constantColumnHeader);
        if (byArray == null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("<ConstColumn id=\"").append(string);
            stringBuffer.append("\" type=\"").append(string2);
            stringBuffer.append("\" size=\"").append(n3);
            stringBuffer.append("\"/>");
            this.writeString(writer, stringBuffer.toString(), n);
        } else {
            String string3 = "<ConstColumn id=\"" + string + "\" type=\"" + string2 + "\" size=\"" + n3 + "\" encrypt=\"base64\" value=\"";
            String string4 = "\"></ConstColumn>";
            this.writeBinary(writer, byArray, string3, string4, n);
        }
    }

    String getStringValue(DataSet dataSet, ConstantColumnHeader constantColumnHeader) {
        int n = constantColumnHeader.getDataType();
        if (n == 4) {
            return constantColumnHeader.getBooleanValue(dataSet) ? "1" : "0";
        }
        String string = constantColumnHeader.getStringValue(dataSet);
        if (string == null) {
            return string;
        }
        if (n == 2) {
            return this.encode(string);
        }
        return string;
    }

    byte[] getBinaryValue(DataSet dataSet, ConstantColumnHeader constantColumnHeader) {
        return constantColumnHeader.getBlobValue(dataSet);
    }

    void writeRows(Writer writer, PlatformData platformData, DataSet dataSet, int n) throws IOException {
        int n2;
        boolean bl;
        this.writeString(writer, "<Rows>", n++);
        int n3 = dataSet.getSaveType();
        if (n3 == 0) {
            int n4 = n3 = platformData == null ? 2 : platformData.getSaveType();
        }
        if (n3 == 0) {
            n3 = 2;
        }
        int n5 = dataSet.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + n5));
        }
        if (bl = dataSet.isCheckingGetterDataIndex()) {
            dataSet.setCheckingGetterDataIndex(false);
        }
        for (n2 = 0; n2 < n5; ++n2) {
            this.writeRow(writer, dataSet, n2, n3, n);
        }
        if (n3 == 1 || n3 == 4 || n3 == 5) {
            n2 = dataSet.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + n2));
            }
            for (int i = 0; i < n2; ++i) {
                this.writeRemovedRow(writer, dataSet, i, n);
            }
        }
        if (bl) {
            dataSet.setCheckingGetterDataIndex(true);
        }
        this.writeString(writer, "</Rows>", --n);
    }

    void writeRow(Writer writer, DataSet dataSet, int n, int n2, int n3) throws IOException {
        int n4 = dataSet.getRowType(n);
        if (n2 != 1 && (n2 == 2 ? n4 == 3 : (n2 == 3 ? n4 == 0 || n4 == 3 : (n2 == 4 ? n4 == 0 || n4 == 1 || n4 == 2 : n2 == 5 && n4 == 0)))) {
            return;
        }
        if (n2 == 2) {
            this.writeString(writer, "<Row>", n3++);
        } else if (n4 == 1) {
            this.writeString(writer, "<Row type=\"insert\">", n3++);
        } else if (n4 == 2) {
            this.writeString(writer, "<Row type=\"update\">", n3++);
        } else if (n4 == 3) {
            this.writeString(writer, "<Row type=\"delete\">", n3++);
        } else {
            this.writeString(writer, "<Row>", n3++);
        }
        int n5 = dataSet.getColumnCount();
        for (int i = 0; i < n5; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            int n6 = columnHeader.getDataType();
            if (n6 == 13 || DataTypes.isBinary(n6)) {
                byte[] byArray = object = n6 == 13 ? this.getBinaryValueFromFile(dataSet, n, i) : this.getBinaryValue(dataSet, n, i);
                if (object == null) continue;
                String string2 = "<Col id=\"" + string + "\">";
                String string3 = "</Col>";
                this.writeBinary(writer, (byte[])object, string2, string3, n3);
                continue;
            }
            object = n6 == 13 ? this.getStringValueFromFile(dataSet, n, i) : this.getStringValue(dataSet, n, i);
            if (object == null) continue;
            this.writeString(writer, "<Col id=\"" + string + "\">" + (String)object + "</Col>", n3);
        }
        if ((n2 == 1 || n2 == 3 || n2 == 5) && n4 == 2) {
            this.writeSavedRow(writer, dataSet, n, n3);
        }
        this.writeString(writer, "</Row>", --n3);
    }

    void writeSavedRow(Writer writer, DataSet dataSet, int n, int n2) throws IOException {
        this.writeString(writer, "<OrgRow>", n2++);
        int n3 = dataSet.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            int n4 = columnHeader.getDataType();
            if (n4 == 13 || DataTypes.isBinary(n4)) {
                byte[] byArray = object = n4 == 13 ? this.getSavedBinaryValueFromFile(dataSet, n, i) : this.getSavedBinaryValue(dataSet, n, i);
                if (object == null) continue;
                String string2 = "<Col id=\"" + string + "\">";
                String string3 = "</Col>";
                this.writeBinary(writer, (byte[])object, string2, string3, n2);
                continue;
            }
            object = n4 == 13 ? this.getSavedStringValueFromFile(dataSet, n, i) : this.getSavedStringValue(dataSet, n, i);
            if (object == null) continue;
            this.writeString(writer, "<Col id=\"" + string + "\">" + (String)object + "</Col>", n2);
        }
        this.writeString(writer, "</OrgRow>", --n2);
    }

    void writeRemovedRow(Writer writer, DataSet dataSet, int n, int n2) throws IOException {
        this.writeString(writer, "<Row type=\"delete\">", n2++);
        int n3 = dataSet.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            int n4 = columnHeader.getDataType();
            if (n4 == 13 || DataTypes.isBinary(n4)) {
                byte[] byArray = object = n4 == 13 ? this.getRemovedBinaryValueFromFile(dataSet, n, i) : this.getRemovedBinaryValue(dataSet, n, i);
                if (object == null) continue;
                String string2 = "<Col id=\"" + string + "\">";
                String string3 = "</Col>";
                this.writeBinary(writer, (byte[])object, string2, string3, n2);
                continue;
            }
            object = n4 == 13 ? this.getRemovedStringValueFromFile(dataSet, n, i) : this.getRemovedStringValue(dataSet, n, i);
            if (object == null) continue;
            this.writeString(writer, "<Col id=\"" + string + "\">" + (String)object + "</Col>", n2);
        }
        this.writeString(writer, "</Row>", --n2);
    }

    String getStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getBoolean(n, n2) ? "1" : "0";
        }
        String string = dataSet.getString(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    byte[] getBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getBlob(n, n2);
    }

    String getStringValueFromFile(DataSet dataSet, int n, int n2) throws IOException {
        String string = dataSet.getString(n, n2);
        byte[] byArray = this.loadFile(string);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading data from file: filename=" + string + ", content=" + byArray));
        }
        return byArray == null ? null : this.encode(new String(byArray));
    }

    byte[] getBinaryValueFromFile(DataSet dataSet, int n, int n2) throws IOException {
        String string = dataSet.getString(n, n2);
        byte[] byArray = this.loadFile(string);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading data from file: filename=" + string + ", content=" + byArray));
        }
        return byArray;
    }

    String getSavedStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getSavedBooleanData(n, n2) ? "1" : "0";
        }
        String string = dataSet.getSavedStringData(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    byte[] getSavedBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getSavedBlobData(n, n2);
    }

    String getSavedStringValueFromFile(DataSet dataSet, int n, int n2) throws IOException {
        String string = dataSet.getSavedStringData(n, n2);
        byte[] byArray = this.loadFile(string);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading saved data from file: filename=" + string + ", content=" + byArray));
        }
        return byArray == null ? null : this.encode(new String(byArray));
    }

    byte[] getSavedBinaryValueFromFile(DataSet dataSet, int n, int n2) throws IOException {
        String string = dataSet.getSavedStringData(n, n2);
        byte[] byArray = this.loadFile(string);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading saved data from file: filename=" + string + ", content=" + byArray));
        }
        return byArray;
    }

    String getRemovedStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getRemovedBooleanData(n, n2) ? "1" : "0";
        }
        String string = dataSet.getRemovedStringData(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    byte[] getRemovedBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getRemovedBlobData(n, n2);
    }

    String getRemovedStringValueFromFile(DataSet dataSet, int n, int n2) throws IOException {
        String string = dataSet.getRemovedStringData(n, n2);
        byte[] byArray = this.loadFile(string);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading removed data from file: filename=" + string + ", content=" + byArray));
        }
        return byArray == null ? null : this.encode(new String(byArray));
    }

    byte[] getRemovedBinaryValueFromFile(DataSet dataSet, int n, int n2) throws IOException {
        String string = dataSet.getRemovedStringData(n, n2);
        byte[] byArray = this.loadFile(string);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading removed data from file: filename=" + string + ", content=" + byArray));
        }
        return byArray;
    }

    void writeString(Writer writer, String string, int n) throws IOException {
        if (n == 0) {
            writer.write(string);
            writer.write(NL);
        } else if (n < 6) {
            writer.write(TABS[n]);
            writer.write(string);
            writer.write(NL);
        } else {
            for (int i = 0; i < n; ++i) {
                writer.write(TABS[1]);
            }
            writer.write(string);
            writer.write(NL);
        }
    }

    void writeBinary(Writer writer, byte[] byArray, String string, String string2, int n) throws IOException {
        if (n == 0) {
            writer.write(string);
            String string3 = Base64.encodeBytes(byArray, 8);
            writer.write(string3);
            writer.write(string2);
            writer.write(NL);
        } else if (n < 6) {
            writer.write(TABS[n]);
            writer.write(string);
            String string4 = Base64.encodeBytes(byArray, 8);
            writer.write(string4);
            writer.write(string2);
            writer.write(NL);
        } else {
            for (int i = 0; i < n; ++i) {
                writer.write(TABS[1]);
            }
            writer.write(string);
            String string5 = Base64.encodeBytes(byArray, 8);
            writer.write(string5);
            writer.write(string2);
            writer.write(NL);
        }
    }

    String getDataType(int n) {
        if (n == 4) {
            return DataTypes.toStringType(3);
        }
        if (n == 5) {
            return DataTypes.toStringType(8);
        }
        if (n == 7) {
            return DataTypes.toStringType(6);
        }
        if (n == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(n);
    }

    String encode(String string) {
        return this.codec.encode(string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String string) throws IOException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.getBuffer();
            try {
                int n;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.close();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            finally {
                fileInputStream.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

