/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.DefaultVariableDataConverter;
import com.nexacro.xapi.data.VariableDataConverter;
import com.nexacro.xapi.data.datatype.DataType;
import com.nexacro.xapi.data.datatype.PlatformDataType;
import com.nexacro.xapi.util.PlatformGlobals;
import com.nexacro.xapi.util.StringUtils;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Variable
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 4514398994894395517L;
    private transient Log log = null;
    public static final String UNDEFINED_NAME = "UNDEFINED";
    private static final String NAME_CHECK_KEY = "platform.data.Variable.namecheck";
    private static final String DEFAULT_DATA_CONVERTER_KEY = "platform.data.Variable.defaultdataconverter";
    private String name;
    private int type;
    private String charset;
    private Object value;
    private boolean isConvertingToDataType = true;
    private VariableDataConverter dataConverter;
    private VariableDataConverter defaultDataConverter;

    public static Variable createVariable(String string, String string2) {
        Variable variable = new Variable(string, 2);
        variable.set(string2);
        return variable;
    }

    public static Variable createVariable(String string, int n) {
        Variable variable = new Variable(string, 3);
        variable.set(n);
        return variable;
    }

    public static Variable createVariable(String string, boolean bl) {
        Variable variable = new Variable(string, 4);
        variable.set(bl);
        return variable;
    }

    public static Variable createVariable(String string, long l) {
        Variable variable = new Variable(string, 5);
        variable.set(l);
        return variable;
    }

    public static Variable createVariable(String string, float f) {
        Variable variable = new Variable(string, 6);
        variable.set(f);
        return variable;
    }

    public static Variable createVariable(String string, double d) {
        Variable variable = new Variable(string, 7);
        variable.set(d);
        return variable;
    }

    public static Variable createVariable(String string, BigDecimal bigDecimal) {
        Variable variable = new Variable(string, 8);
        variable.set(bigDecimal);
        return variable;
    }

    public static Variable createVariable(String string, Date date) {
        Variable variable = new Variable(string, 11);
        variable.set(date);
        return variable;
    }

    public static Variable createVariable(String string, byte[] byArray) {
        Variable variable = new Variable(string, 12);
        variable.set(byArray);
        return variable;
    }

    public Variable(String string) {
        this(string, 0);
    }

    public Variable(String string, int n) {
        this(string, n, null);
    }

    public Variable(String string, int n, Object object) {
        this.setName(string);
        this.setType(n);
        this.set(object);
    }

    public Variable(String string, DataType dataType) {
        this(string, dataType, null);
    }

    public Variable(String string, DataType dataType, Object object) {
        this(string, PlatformDataType.getType(dataType), object);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.checkName(string);
        this.name = string;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int n) {
        this.checkType(n);
        this.type = n;
        this.value = this.getCurrentDataConverter().convert(this, this.value, n);
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public boolean isConvertingToDataType() {
        return this.isConvertingToDataType;
    }

    public void setConvertingToDataType(boolean bl) {
        this.isConvertingToDataType = bl;
    }

    public VariableDataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(VariableDataConverter variableDataConverter) {
        this.dataConverter = variableDataConverter;
    }

    public VariableDataConverter getCurrentDataConverter() {
        if (this.dataConverter == null) {
            if (this.defaultDataConverter == null) {
                block9: {
                    String string = PlatformGlobals.getStringProperty(DEFAULT_DATA_CONVERTER_KEY);
                    if (!StringUtils.isEmpty(string)) {
                        try {
                            Class<?> clazz = Class.forName(string);
                            this.defaultDataConverter = (VariableDataConverter)clazz.newInstance();
                            this.getLogger();
                            if (this.log.isDebugEnabled()) {
                                this.log.debug((Object)("Creating VariableDataConverter: type=" + URLEncoder.encode(string, "UTF-8") + ", defaultDataConverter=" + this.defaultDataConverter));
                            }
                        }
                        catch (Throwable throwable) {
                            this.getLogger();
                            if (!this.log.isErrorEnabled()) break block9;
                            try {
                                this.log.error((Object)("Creating VariableDataConverter failed: type=" + URLEncoder.encode(string, "UTF-8")), throwable);
                            }
                            catch (UnsupportedEncodingException unsupportedEncodingException) {
                                // empty catch block
                            }
                        }
                    }
                }
                if (this.defaultDataConverter == null) {
                    this.defaultDataConverter = new DefaultVariableDataConverter();
                }
            }
            return this.defaultDataConverter;
        }
        return this.dataConverter;
    }

    public Object getObject() {
        return this.getCurrentDataConverter().toObject(this, this.value);
    }

    public String getString() {
        int n = this.getType();
        String string = this.getCharset();
        return this.getCurrentDataConverter().toString(this, this.value, n, string);
    }

    public String getString(String string) {
        String string2 = this.getString();
        return string2 == null ? string : string2;
    }

    public int getInt() {
        return this.getCurrentDataConverter().toInt(this, this.value);
    }

    public boolean getBoolean() {
        return this.getCurrentDataConverter().toBoolean(this, this.value);
    }

    public long getLong() {
        return this.getCurrentDataConverter().toLong(this, this.value);
    }

    public float getFloat() {
        return this.getCurrentDataConverter().toFloat(this, this.value);
    }

    public double getDouble() {
        return this.getCurrentDataConverter().toDouble(this, this.value);
    }

    public BigDecimal getBigDecimal() {
        return this.getCurrentDataConverter().toBigDecimal(this, this.value);
    }

    public BigDecimal getDecimal() {
        return this.getBigDecimal();
    }

    public Date getDateTime() {
        return this.getCurrentDataConverter().toDateTime(this, this.value);
    }

    public byte[] getBlob() {
        String string = this.getCharset();
        return this.getCurrentDataConverter().toBlob(this, this.value, string);
    }

    public void set(Object object) {
        if (this.type == 0) {
            this.type = DataTypes.findType(object, false);
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Changed type: " + DataTypes.toStringType(this.type)));
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, object, this.type, this.charset) : object;
    }

    public void set(String string) {
        if (this.type == 0) {
            this.type = 2;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: string");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, string, this.type, this.charset) : string;
    }

    public void set(int n) {
        if (this.type == 0) {
            this.type = 3;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: int");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, n, this.type) : new Integer(n);
    }

    public void set(boolean bl) {
        if (this.type == 0) {
            this.type = 4;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: bool");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, bl, this.type) : (bl ? Boolean.TRUE : Boolean.FALSE);
    }

    public void set(long l) {
        if (this.type == 0) {
            this.type = 5;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: long");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, l, this.type) : new Long(l);
    }

    public void set(float f) {
        if (this.type == 0) {
            this.type = 6;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: float");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, f, this.type) : new Float(f);
    }

    public void set(double d) {
        if (this.type == 0) {
            this.type = 7;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: double");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, d, this.type) : new Double(d);
    }

    public void set(BigDecimal bigDecimal) {
        if (this.type == 0) {
            this.type = 8;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: decimal");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, bigDecimal, this.type) : bigDecimal;
    }

    public void set(Date date) {
        if (this.type == 0) {
            this.type = 11;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: datetime");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, date, this.type) : date;
    }

    public void set(byte[] byArray) {
        if (this.type == 0) {
            this.type = 12;
            this.getLogger();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Changed type: blob");
            }
        }
        this.value = this.isConvertingToDataType() ? this.getCurrentDataConverter().convert(this, byArray, this.type, this.charset) : (Object)byArray;
    }

    public Variable getClone() {
        try {
            return (Variable)this.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            this.getLogger();
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Could not clone", (Throwable)cloneNotSupportedException);
            }
            return null;
        }
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean equals(Object object) {
        if (object instanceof Variable) {
            Variable variable = (Variable)object;
            if (this.name.equals(variable.name) && this.type == variable.type && this.isConvertingToDataType == variable.isConvertingToDataType) {
                if (this.value == null) {
                    return variable.value == null;
                }
                return this.value.equals(variable.value);
            }
        }
        return false;
    }

    public String toString() {
        return super.toString() + "[name=" + this.name + ", type=" + this.type + ", isConvertingToDataType=" + this.isConvertingToDataType + "]";
    }

    private void checkName(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string.charAt(0) == ' ' && "".equals(string.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + string + "\"");
        }
        if (PlatformGlobals.getBooleanProperty(NAME_CHECK_KEY, false)) {
            this.checkNaming(string);
        }
    }

    private void checkNaming(String string) {
        if (string == null) {
            return;
        }
        char[] cArray = string.toCharArray();
        int n = cArray.length;
        char c = cArray[0];
        if (!(c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c == '_' || c == '$')) {
            throw new IllegalArgumentException("Invalid name: \"" + string + "\"");
        }
        for (int i = 1; i < n; ++i) {
            c = cArray[i];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9' || c == '_' || c == '$' || c == '-') continue;
            throw new IllegalArgumentException("Invalid name: \"" + string + "\"");
        }
    }

    private void checkType(int n) {
        if (n < 0 || n > 13) {
            throw new IllegalArgumentException("Invalid type: " + n);
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws Exception {
        objectInputStream.defaultReadObject();
        this.log = LogFactory.getLog((Class)Variable.class);
    }

    private void getLogger() {
        if (this.log == null) {
            this.log = LogFactory.getLog((Class)Variable.class);
        }
    }
}

