/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data;

import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class XmlCodec {
    public String encode(String string) {
        if (this.needToEncode(string)) {
            int n = string.length();
            int n2 = 3;
            StringBuffer stringBuffer = new StringBuffer(n + n2 * 5);
            for (int i = 0; i < n; ++i) {
                char c = string.charAt(i);
                if (this.needToEncode(c)) {
                    stringBuffer.append(this.encode(c));
                    continue;
                }
                stringBuffer.append(c);
            }
            return stringBuffer.toString();
        }
        return string;
    }

    public String encode(char c) {
        if (c < ' ') {
            return "&#" + c + ";";
        }
        if (c == ' ') {
            return "&#32;";
        }
        if (c == '<') {
            return "&lt;";
        }
        if (c == '>') {
            return "&gt;";
        }
        if (c == '&') {
            return "&amp;";
        }
        if (c == '\"') {
            return "&quot;";
        }
        if (c == '\'') {
            return "&apos;";
        }
        return String.valueOf(c);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decode(String string) {
        if (this.needToDecode(string)) {
            StringReader stringReader = new StringReader(string);
            try {
                String string2 = this.decode(stringReader);
                return string2;
            }
            catch (IOException iOException) {
                Log log = LogFactory.getLog((Class)XmlCodec.class);
                if (log.isErrorEnabled()) {
                    if (string.length() < 512) {
                        log.error((Object)("Could not decode: " + string), (Throwable)iOException);
                    } else {
                        log.error((Object)"Could not decode", (Throwable)iOException);
                    }
                }
            }
            finally {
                try {
                    ((Reader)stringReader).close();
                }
                catch (IOException iOException) {}
            }
            return string;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String decode(Reader reader) throws IOException {
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        int n = 5;
        char[] cArray = new char[n];
        try {
            int n2;
            while ((n2 = reader.read()) != -1) {
                if (n2 == 38) {
                    int n3;
                    int n4 = -1;
                    for (n3 = 0; n3 < n; ++n3) {
                        cArray[n3] = (char)reader.read();
                        if (cArray[n3] != ';') continue;
                        n4 = n3;
                        break;
                    }
                    if (n4 == -1) {
                        charArrayWriter.write(cArray);
                        continue;
                    }
                    if (n4 == 0) {
                        charArrayWriter.write(38);
                        charArrayWriter.write(59);
                        continue;
                    }
                    if (cArray[0] == '#') {
                        if (n4 == 3) {
                            n3 = (cArray[1] - 48) * 10 + (cArray[2] - 48);
                            if (n3 == 9) {
                                charArrayWriter.write(9);
                                continue;
                            }
                            if (n3 == 10) {
                                charArrayWriter.write(10);
                                continue;
                            }
                            if (n3 == 13) {
                                charArrayWriter.write(13);
                                continue;
                            }
                            if (n3 == 32) {
                                charArrayWriter.write(32);
                                continue;
                            }
                            if (n3 < 32) {
                                charArrayWriter.write(n3);
                                continue;
                            }
                            charArrayWriter.write(cArray, 0, n4);
                            continue;
                        }
                        charArrayWriter.write(cArray, 0, n4);
                        continue;
                    }
                    if (n4 == 3) {
                        if (cArray[0] == 'l' && cArray[1] == 't') {
                            charArrayWriter.write(60);
                            continue;
                        }
                        if (cArray[0] == 'g' && cArray[1] == 't') {
                            charArrayWriter.write(62);
                            continue;
                        }
                        charArrayWriter.write(cArray, 0, n4);
                        continue;
                    }
                    if (n4 == 4) {
                        if (cArray[0] == 'a' && cArray[1] == 'm' && cArray[2] == 'p') {
                            charArrayWriter.write(38);
                            continue;
                        }
                        charArrayWriter.write(cArray, 0, n4);
                        continue;
                    }
                    if (n4 != 5) continue;
                    if (cArray[0] == 'q' && cArray[1] == 'u' && cArray[2] == 'o' && cArray[3] == 't') {
                        charArrayWriter.write(34);
                        continue;
                    }
                    if (cArray[0] == 'a' && cArray[1] == 'p' && cArray[2] == 'o' && cArray[3] == 's') {
                        charArrayWriter.write(92);
                        continue;
                    }
                    charArrayWriter.write(cArray, 0, n4);
                    continue;
                }
                charArrayWriter.write(n2);
            }
            String string = charArrayWriter.toString();
            return string;
        }
        finally {
            charArrayWriter.close();
        }
    }

    public boolean needToEncode(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (!this.needToEncode(c)) continue;
            return true;
        }
        return false;
    }

    public boolean needToDecode(String string) {
        if (string == null || "".equals(string)) {
            return false;
        }
        return string.indexOf("&#") != -1 || string.indexOf("&lt;") != -1 || string.indexOf("&gt;") != -1 || string.indexOf("&amp;") != -1 || string.indexOf("&quot;") != -1 || string.indexOf("&apos;") != -1;
    }

    public boolean needToEncode(char c) {
        return c < ' ' || c == '<' || c == '>' || c == '&' || c == '\"' || c == '\'';
    }
}

