/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.datatype;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.datatype.DataType;
import com.nexacro.xapi.data.datatype.JavaDataType;
import com.nexacro.xapi.data.datatype.PlatformDataType;
import com.nexacro.xapi.data.datatype.SqlDataType;
import com.nexacro.xapi.util.PlatformGlobals;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DataTypeFactory {
    public static DataType NULL = JavaDataType.NULL;
    private static Map cacheMap = new HashMap();
    private static Map convertingMap = new HashMap();
    private static Map nodeMap = new HashMap();
    private static Map convertibleCacheMap = new HashMap();
    private static final String CONVERSION_BOOLEAN_STRING_KEY = "platform.data.DataType.conversion.booleanstring";
    private static final boolean IS_DEBUG = false;
    private static int debugStep;
    private static StringBuffer debugBuffer;
    static /* synthetic */ Class class$com$nexacro$xapi$data$datatype$DataTypeFactory;

    public static DataType getJavaDataType(int n) {
        return DataTypeFactory.getDataType("JAVA", n);
    }

    public static DataType getJavaDataType(String string) {
        return DataTypeFactory.getDataType("JAVA", string);
    }

    public static DataType getJavaDataType(Class clazz) {
        String string = JavaDataType.getSimpleName(clazz);
        DataType dataType = DataTypeFactory.getJavaDataType(string);
        if (dataType != null) {
            return dataType;
        }
        string = clazz.getName();
        dataType = DataTypeFactory.getJavaDataType(string);
        if (dataType != null) {
            return dataType;
        }
        int n = JavaDataType.getNewType();
        dataType = new DataType("JAVA", n, clazz.getName());
        DataTypeFactory.register(dataType);
        return dataType;
    }

    public static DataType getJavaDataType(DataType dataType) {
        if (dataType == null) {
            return null;
        }
        if ("JAVA".equalsIgnoreCase(dataType.getCategoryName())) {
            return dataType;
        }
        String string = dataType.getCategoryName() + "." + dataType.getTypeName() + "->" + "JAVA";
        return (DataType)convertingMap.get(string);
    }

    public static DataType getPlatformDataType(int n) {
        return DataTypeFactory.getDataType("PLATFORM", n);
    }

    public static DataType getPlatformDataType(String string) {
        return DataTypeFactory.getDataType("PLATFORM", string);
    }

    public static DataType getPlatformDataType(DataType dataType) {
        if (dataType == null) {
            return null;
        }
        if ("PLATFORM".equalsIgnoreCase(dataType.getCategoryName())) {
            return dataType;
        }
        DataType dataType2 = DataTypeFactory.getJavaDataType(dataType);
        String string = dataType2.getCategoryName() + "." + dataType2.getTypeName() + "->" + "PLATFORM";
        return (DataType)convertingMap.get(string);
    }

    public static DataType getSqlDataType(int n) {
        return DataTypeFactory.getDataType("SQL", n);
    }

    public static DataType getSqlDataType(String string) {
        return DataTypeFactory.getDataType("SQL", string);
    }

    public static DataType getSqlDataType(DataType dataType) {
        if (dataType == null) {
            return null;
        }
        if ("SQL".equalsIgnoreCase(dataType.getCategoryName())) {
            return dataType;
        }
        DataType dataType2 = DataTypeFactory.getJavaDataType(dataType);
        String string = dataType2.getCategoryName() + "." + dataType2.getTypeName() + "->" + "SQL";
        return (DataType)convertingMap.get(string);
    }

    public static DataType getDataType(String string, int n) {
        if (string == null) {
            return null;
        }
        String string2 = string + "." + n;
        return (DataType)cacheMap.get(string2.toUpperCase());
    }

    public static DataType getDataType(String string, String string2) {
        if (string == null) {
            return null;
        }
        if (string2 == null) {
            return null;
        }
        String string3 = string + "." + string2;
        return (DataType)cacheMap.get(string3.toUpperCase());
    }

    public static DataType getDataTypeOfValue(Object object) {
        if (object == null) {
            return NULL;
        }
        if (object instanceof String) {
            boolean bl = PlatformGlobals.getBooleanProperty(CONVERSION_BOOLEAN_STRING_KEY, true);
            if ((((String)object).equalsIgnoreCase("true") || ((String)object).equalsIgnoreCase("false")) && bl) {
                return PlatformDataType.BOOLEAN;
            }
            return PlatformDataType.STRING;
        }
        if (object instanceof Integer) {
            return PlatformDataType.INT;
        }
        if (object instanceof Boolean) {
            return PlatformDataType.BOOLEAN;
        }
        if (object instanceof Long) {
            return PlatformDataType.LONG;
        }
        if (object instanceof Float) {
            return PlatformDataType.FLOAT;
        }
        if (object instanceof Double) {
            return PlatformDataType.DOUBLE;
        }
        if (object instanceof BigDecimal) {
            return PlatformDataType.BIG_DECIMAL;
        }
        if (object instanceof Date) {
            return PlatformDataType.DATE;
        }
        if (object instanceof byte[]) {
            return PlatformDataType.BLOB;
        }
        if (object instanceof DataSet) {
            return PlatformDataType.DATASET;
        }
        return PlatformDataType.UNDEFINED;
    }

    public static void register(Class clazz) {
        Field[] fieldArray = clazz.getFields();
        int n = fieldArray.length;
        for (int i = 0; i < n; ++i) {
            Log log;
            try {
                if (!DataTypeFactory.isDataTypeField(fieldArray[i])) continue;
                DataType dataType = (DataType)fieldArray[i].get(null);
                DataTypeFactory.register(dataType);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                log = LogFactory.getLog((Class)(class$com$nexacro$xapi$data$datatype$DataTypeFactory == null ? DataTypeFactory.class$("com.nexacro.xapi.data.datatype.DataTypeFactory") : class$com$nexacro$xapi$data$datatype$DataTypeFactory));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not register data type: fields[" + i + "]=" + fieldArray[i]), (Throwable)illegalArgumentException);
                continue;
            }
            catch (IllegalAccessException illegalAccessException) {
                log = LogFactory.getLog((Class)(class$com$nexacro$xapi$data$datatype$DataTypeFactory == null ? DataTypeFactory.class$("com.nexacro.xapi.data.datatype.DataTypeFactory") : class$com$nexacro$xapi$data$datatype$DataTypeFactory));
                if (!log.isDebugEnabled()) continue;
                log.debug((Object)("Could not register data type: fields[" + i + "]=" + fieldArray[i]), (Throwable)illegalAccessException);
            }
        }
    }

    public static void register(DataType dataType) {
        if (dataType == null) {
            return;
        }
        String string = dataType.getCategoryName();
        if (string == null) {
            return;
        }
        dataType.getCategoryName();
        String string2 = string + "." + dataType.getType();
        cacheMap.put(string2.toUpperCase(), dataType);
        String string3 = string + "." + dataType.getTypeName();
        cacheMap.put(string3.toUpperCase(), dataType);
    }

    public static void bindConverting(DataType dataType, DataType dataType2) {
        String string = dataType.getCategoryName() + "." + dataType.getTypeName() + "->" + dataType2.getCategoryName();
        convertingMap.put(string, dataType2);
        DataTypeFactory.setAsConvertible(dataType, dataType2);
    }

    public static synchronized boolean isConvertible(DataType dataType, DataType dataType2) {
        if (dataType == null || dataType2 == null) {
            return false;
        }
        String string = DataTypeFactory.getPairKey(dataType, dataType2);
        Boolean bl = (Boolean)convertibleCacheMap.get(string);
        if (bl == null) {
            Node node = (Node)nodeMap.get(dataType.toString());
            Node node2 = new Node(dataType2);
            if (node == null) {
                return false;
            }
            String string2 = "" + Thread.currentThread().hashCode() + ":" + Math.random();
            bl = new Boolean(node.isLinkedTo(node2, string2));
            convertibleCacheMap.put(string, bl);
        }
        return bl;
    }

    public static synchronized void setAsConvertible(DataType dataType, DataType dataType2) {
        Node node;
        Node node2 = (Node)nodeMap.get(dataType.toString());
        if (node2 == null) {
            node2 = new Node(dataType);
            nodeMap.put(dataType.toString(), node2);
        }
        if ((node = (Node)nodeMap.get(dataType2.toString())) == null) {
            node = new Node(dataType2);
            nodeMap.put(dataType2.toString(), node);
        }
        if (node2.has(node)) {
            return;
        }
        node2.addAsToNode(node);
        convertibleCacheMap.clear();
    }

    static boolean isDataTypeField(Field field) {
        if (!Modifier.isFinal(field.getModifiers())) {
            return false;
        }
        if (!Modifier.isStatic(field.getModifiers())) {
            return false;
        }
        try {
            return field.get(null).getClass() == DataType.class;
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return false;
    }

    private static String getPairKey(DataType dataType, DataType dataType2) {
        return dataType.toString() + "->" + dataType2.toString();
    }

    static {
        JavaDataType.registerDefinedDataType();
        PlatformDataType.registerDefinedDataType();
        SqlDataType.registerDefinedDataType();
        JavaDataType.registerConvertible();
        PlatformDataType.registerConvertible();
        SqlDataType.registerConvertible();
        debugStep = -1;
        debugBuffer = new StringBuffer();
    }

    private static class Node {
        private final String name;
        private final List toNodeList;
        private String currentSearchKey;

        private Node(DataType dataType) {
            this.name = dataType.toString();
            this.toNodeList = new ArrayList();
        }

        public boolean isLinkedTo(Node node, String string) {
            if (string.equals(this.currentSearchKey)) {
                return false;
            }
            this.currentSearchKey = string;
            if (this.name.equals(node.name)) {
                return true;
            }
            Iterator iterator = this.toNodeList.iterator();
            while (iterator.hasNext()) {
                Node node2 = (Node)iterator.next();
                if (!node2.isLinkedTo(node, string)) continue;
                return true;
            }
            return false;
        }

        private void addAsToNode(Node node) {
            this.toNodeList.add(node);
        }

        private boolean has(Node node) {
            return this.toNodeList.contains(node);
        }
    }
}

