/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.datatype;

import com.nexacro.xapi.data.datatype.DataType;
import com.nexacro.xapi.data.datatype.DataTypeFactory;
import com.nexacro.xapi.data.datatype.JavaDataType;
import java.sql.Types;

public class SqlDataType {
    public static final String CATEGORY_NAME = "SQL";
    public static final DataType BIT = new DataType("SQL", -7, "BIT");
    public static final DataType TINYINT = new DataType("SQL", -6, "TINYINT");
    public static final DataType SMALLINT = new DataType("SQL", 5, "SMALLINT");
    public static final DataType INTEGER = new DataType("SQL", 4, "INTEGER");
    public static final DataType BIGINT = new DataType("SQL", -5, "BIGINT");
    public static final DataType FLOAT = new DataType("SQL", 6, "FLOAT");
    public static final DataType REAL = new DataType("SQL", 7, "REAL");
    public static final DataType DOUBLE = new DataType("SQL", 8, "DOUBLE");
    public static final DataType NUMERIC = new DataType("SQL", 2, "NUMERIC");
    public static final DataType DECIMAL = new DataType("SQL", 3, "DECIMAL");
    public static final DataType CHAR = new DataType("SQL", 1, "CHAR");
    public static final DataType VARCHAR = new DataType("SQL", 12, "VARCHAR");
    public static final DataType LONGVARCHAR = new DataType("SQL", -1, "LONGVARCHAR");
    public static final DataType DATE = new DataType("SQL", 91, "DATE");
    public static final DataType TIME = new DataType("SQL", 92, "TIME");
    public static final DataType TIMESTAMP = new DataType("SQL", 93, "TIMESTAMP");
    public static final DataType BINARY = new DataType("SQL", -2, "BINARY");
    public static final DataType VARBINARY = new DataType("SQL", -3, "VARBINARY");
    public static final DataType LONGVARBINARY = new DataType("SQL", -4, "LONGVARBINARY");
    public static final DataType NULL = new DataType("SQL", 0, "NULL");
    public static final DataType OTHER = new DataType("SQL", 1111, "OTHER");
    public static final DataType JAVA_OBJECT = new DataType("SQL", 2000, "JAVA_OBJECT");
    public static final DataType DISTINCT = new DataType("SQL", 2001, "DISTINCT");
    public static final DataType STRUCT = new DataType("SQL", 2002, "STRUCT");
    public static final DataType ARRAY = new DataType("SQL", 2003, "ARRAY");
    public static final DataType BLOB = new DataType("SQL", 2004, "BLOB");
    public static final DataType CLOB = new DataType("SQL", 2005, "CLOB");
    public static final DataType REF = new DataType("SQL", 2006, "REF");
    public static final DataType DATALINK = new DataType("SQL", 70, "DATALINK");
    public static final DataType BOOLEAN = new DataType("SQL", 16, "BOOLEAN");
    public static final DataType ROWID = new DataType("SQL", -8, "ROWID");
    public static final DataType NCHAR = new DataType("SQL", -15, "NCHAR");
    public static final DataType NTEXT = new DataType("SQL", -16, "NTEXT");
    public static final DataType NVARCHAR = new DataType("SQL", -9, "NVARCHAR");
    public static final DataType NCLOB = new DataType("SQL", 2011, "NCLOB");
    public static final DataType SQLXML = new DataType("SQL", 2009, "SQLXML");
    public static final DataType INVALID = new DataType("SQL", DataType.getMaxDefinitionValue(Types.class) + 1, "invalid");

    static void registerDefinedDataType() {
        DataTypeFactory.register(SqlDataType.class);
        DataTypeFactory.bindConverting(BIT, JavaDataType.BOOLEAN);
        DataTypeFactory.bindConverting(TINYINT, JavaDataType.SHORT);
        DataTypeFactory.bindConverting(SMALLINT, JavaDataType.INT);
        DataTypeFactory.bindConverting(INTEGER, JavaDataType.INT);
        DataTypeFactory.bindConverting(BIGINT, JavaDataType.LONG);
        DataTypeFactory.bindConverting(FLOAT, JavaDataType.FLOAT);
        DataTypeFactory.bindConverting(REAL, JavaDataType.DOUBLE);
        DataTypeFactory.bindConverting(DOUBLE, JavaDataType.DOUBLE);
        DataTypeFactory.bindConverting(NUMERIC, JavaDataType.BIG_DECIMAL);
        DataTypeFactory.bindConverting(DECIMAL, JavaDataType.BIG_DECIMAL);
        DataTypeFactory.bindConverting(CHAR, JavaDataType.CHAR);
        DataTypeFactory.bindConverting(VARCHAR, JavaDataType.STRING);
        DataTypeFactory.bindConverting(LONGVARCHAR, JavaDataType.STRING);
        DataTypeFactory.bindConverting(DATE, JavaDataType.ONLY_DATE);
        DataTypeFactory.bindConverting(TIME, JavaDataType.ONLY_TIME);
        DataTypeFactory.bindConverting(TIMESTAMP, JavaDataType.DATE);
        DataTypeFactory.bindConverting(BINARY, JavaDataType.BYTE_ARRAY);
        DataTypeFactory.bindConverting(VARBINARY, JavaDataType.BYTE_ARRAY);
        DataTypeFactory.bindConverting(LONGVARBINARY, JavaDataType.BYTE_ARRAY);
        DataTypeFactory.bindConverting(NULL, JavaDataType.NULL);
        DataTypeFactory.bindConverting(OTHER, JavaDataType.OBJECT);
        DataTypeFactory.bindConverting(JAVA_OBJECT, JavaDataType.OBJECT);
        DataTypeFactory.bindConverting(DISTINCT, JavaDataType.INVALID);
        DataTypeFactory.bindConverting(STRUCT, JavaDataType.INVALID);
        DataTypeFactory.bindConverting(ARRAY, JavaDataType.OBJECT_ARRAY);
        DataTypeFactory.bindConverting(BLOB, JavaDataType.BYTE_ARRAY);
        DataTypeFactory.bindConverting(CLOB, JavaDataType.CHAR_ARRAY);
        DataTypeFactory.bindConverting(REF, JavaDataType.INVALID);
        DataTypeFactory.bindConverting(DATALINK, JavaDataType.INVALID);
        DataTypeFactory.bindConverting(BOOLEAN, JavaDataType.BOOLEAN);
        DataTypeFactory.bindConverting(ROWID, JavaDataType.STRING);
        DataTypeFactory.bindConverting(NCHAR, JavaDataType.CHAR);
        DataTypeFactory.bindConverting(NVARCHAR, JavaDataType.STRING);
        DataTypeFactory.bindConverting(NTEXT, JavaDataType.STRING);
        DataTypeFactory.bindConverting(NCLOB, JavaDataType.CHAR_ARRAY);
        DataTypeFactory.bindConverting(SQLXML, JavaDataType.STRING);
        DataTypeFactory.bindConverting(INVALID, JavaDataType.INVALID);
        DataTypeFactory.bindConverting(JavaDataType.BYTE, BINARY);
        DataTypeFactory.bindConverting(JavaDataType.SHORT, INTEGER);
        DataTypeFactory.bindConverting(JavaDataType.INT, INTEGER);
        DataTypeFactory.bindConverting(JavaDataType.LONG, BIGINT);
        DataTypeFactory.bindConverting(JavaDataType.FLOAT, FLOAT);
        DataTypeFactory.bindConverting(JavaDataType.DOUBLE, DOUBLE);
        DataTypeFactory.bindConverting(JavaDataType.BOOLEAN, BOOLEAN);
        DataTypeFactory.bindConverting(JavaDataType.CHAR, CHAR);
        DataTypeFactory.bindConverting(JavaDataType.BYTE_OBJECT, BINARY);
        DataTypeFactory.bindConverting(JavaDataType.SHORT_OBJECT, INTEGER);
        DataTypeFactory.bindConverting(JavaDataType.INT_OBJECT, INTEGER);
        DataTypeFactory.bindConverting(JavaDataType.LONG_OBJECT, BIGINT);
        DataTypeFactory.bindConverting(JavaDataType.FLOAT_OBJECT, FLOAT);
        DataTypeFactory.bindConverting(JavaDataType.DOUBLE_OBJECT, DOUBLE);
        DataTypeFactory.bindConverting(JavaDataType.BOOLEAN_OBJECT, BOOLEAN);
        DataTypeFactory.bindConverting(JavaDataType.CHAR_OBJECT, CHAR);
        DataTypeFactory.bindConverting(JavaDataType.STRING, VARCHAR);
        DataTypeFactory.bindConverting(JavaDataType.ONLY_DATE, DATE);
        DataTypeFactory.bindConverting(JavaDataType.ONLY_TIME, TIME);
        DataTypeFactory.bindConverting(JavaDataType.DATE, TIMESTAMP);
        DataTypeFactory.bindConverting(JavaDataType.OBJECT, BINARY);
        DataTypeFactory.bindConverting(JavaDataType.NULL, NULL);
        DataTypeFactory.bindConverting(JavaDataType.BIG_DECIMAL, NUMERIC);
        DataTypeFactory.bindConverting(JavaDataType.OBJECT_ARRAY, ARRAY);
        DataTypeFactory.bindConverting(JavaDataType.BYTE_ARRAY, BINARY);
        DataTypeFactory.bindConverting(JavaDataType.CHAR_ARRAY, CLOB);
        DataTypeFactory.bindConverting(JavaDataType.INVALID, INVALID);
    }

    static void registerConvertible() {
        SqlDataType.setAsConvertible(BOOLEAN, BIT);
        SqlDataType.setAsConvertible(BIT, BOOLEAN);
        SqlDataType.setAsConvertible(INTEGER, DECIMAL);
        SqlDataType.setAsConvertible(REAL, DOUBLE);
        SqlDataType.setAsConvertible(DOUBLE, REAL);
        SqlDataType.setAsConvertible(DECIMAL, NUMERIC);
        SqlDataType.setAsConvertible(FLOAT, REAL);
        SqlDataType.setAsConvertible(REAL, FLOAT);
        SqlDataType.setAsConvertible(CLOB, VARCHAR);
        SqlDataType.setAsConvertible(VARCHAR, CLOB);
        SqlDataType.setAsConvertible(BLOB, VARBINARY);
        SqlDataType.setAsConvertible(VARBINARY, BLOB);
        SqlDataType.setAsConvertible(BLOB, BINARY);
        SqlDataType.setAsConvertible(BINARY, BLOB);
        SqlDataType.setAsConvertible(LONGVARBINARY, BLOB);
        SqlDataType.setAsConvertible(BLOB, LONGVARBINARY);
        SqlDataType.setAsConvertible(BIT, TINYINT);
        SqlDataType.setAsConvertible(TINYINT, SMALLINT);
        SqlDataType.setAsConvertible(SMALLINT, INTEGER);
        SqlDataType.setAsConvertible(INTEGER, BIGINT);
        SqlDataType.setAsConvertible(FLOAT, DOUBLE);
        SqlDataType.setAsConvertible(BIGINT, NUMERIC);
        SqlDataType.setAsConvertible(DOUBLE, NUMERIC);
        SqlDataType.setAsConvertible(CHAR, VARCHAR);
        SqlDataType.setAsConvertible(VARCHAR, LONGVARCHAR);
        SqlDataType.setAsConvertible(DOUBLE, VARCHAR);
        SqlDataType.setAsConvertible(NUMERIC, VARCHAR);
        SqlDataType.setAsConvertible(TIMESTAMP, VARCHAR);
        SqlDataType.setAsConvertible(DATE, TIMESTAMP);
        SqlDataType.setAsConvertible(TIME, TIMESTAMP);
        SqlDataType.setAsConvertible(BIGINT, TIMESTAMP);
        SqlDataType.setAsConvertible(BINARY, VARBINARY);
        SqlDataType.setAsConvertible(VARBINARY, LONGVARBINARY);
        SqlDataType.setAsConvertible(JavaDataType.LONG, DECIMAL);
        SqlDataType.setAsConvertible(DATE, JavaDataType.ONLY_DATE);
        SqlDataType.setAsConvertible(TIME, JavaDataType.ONLY_TIME);
        SqlDataType.setAsConvertible(JavaDataType.ONLY_DATE, DATE);
        SqlDataType.setAsConvertible(JavaDataType.ONLY_TIME, TIME);
        SqlDataType.setAsConvertible(ROWID, VARCHAR);
        SqlDataType.setAsConvertible(VARCHAR, ROWID);
        SqlDataType.setAsConvertible(NCHAR, CHAR);
        SqlDataType.setAsConvertible(CHAR, NCHAR);
        SqlDataType.setAsConvertible(NCHAR, VARCHAR);
        SqlDataType.setAsConvertible(NVARCHAR, VARCHAR);
        SqlDataType.setAsConvertible(VARCHAR, NVARCHAR);
        SqlDataType.setAsConvertible(NTEXT, LONGVARCHAR);
        SqlDataType.setAsConvertible(LONGVARCHAR, NTEXT);
        SqlDataType.setAsConvertible(NCLOB, CLOB);
        SqlDataType.setAsConvertible(CLOB, NCLOB);
        SqlDataType.setAsConvertible(NCLOB, VARCHAR);
        SqlDataType.setAsConvertible(VARCHAR, NCLOB);
        SqlDataType.setAsConvertible(SQLXML, VARCHAR);
    }

    private static void setAsConvertible(DataType dataType, DataType dataType2) {
        DataTypeFactory.setAsConvertible(dataType, dataType2);
    }

    private SqlDataType() {
    }
}

