/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import java.math.BigDecimal;
import java.util.Date;

class BigDecimalTypeConverter {
    public Object toObject(BigDecimal bigDecimal) {
        return bigDecimal;
    }

    public String toString(BigDecimal bigDecimal) {
        return bigDecimal == null ? DataTypes.DEFAULT_VALUE_STRING : bigDecimal.toString();
    }

    public int toInt(BigDecimal bigDecimal) {
        return bigDecimal == null ? 0 : bigDecimal.intValue();
    }

    public boolean toBoolean(BigDecimal bigDecimal) {
        return false;
    }

    public long toLong(BigDecimal bigDecimal) {
        return bigDecimal == null ? 0L : bigDecimal.longValue();
    }

    public float toFloat(BigDecimal bigDecimal) {
        return bigDecimal == null ? 0.0f : bigDecimal.floatValue();
    }

    public double toDouble(BigDecimal bigDecimal) {
        return bigDecimal == null ? 0.0 : bigDecimal.doubleValue();
    }

    public Date toDate(BigDecimal bigDecimal) {
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(BigDecimal bigDecimal) {
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(BigDecimal bigDecimal) {
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public byte[] toBlob(BigDecimal bigDecimal) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(BigDecimal bigDecimal, int n) {
        switch (n) {
            case 2: {
                return this.toString(bigDecimal);
            }
            case 3: {
                return new Integer(this.toInt(bigDecimal));
            }
            case 4: {
                return this.toBoolean(bigDecimal) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(bigDecimal));
            }
            case 6: {
                return new Float(this.toFloat(bigDecimal));
            }
            case 7: {
                return new Double(this.toDouble(bigDecimal));
            }
            case 8: {
                return this.toObject(bigDecimal);
            }
            case 9: {
                return this.toDate(bigDecimal);
            }
            case 10: {
                return this.toTime(bigDecimal);
            }
            case 11: {
                return this.toDateTime(bigDecimal);
            }
            case 12: {
                return this.toObject(bigDecimal);
            }
        }
        return this.toObject(bigDecimal);
    }
}

