/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class BlobTypeConverter {
    public Object toObject(byte[] byArray) {
        return byArray;
    }

    public String toString(byte[] byArray) {
        return this.toString(byArray, null);
    }

    public String toString(byte[] byArray, String string) {
        try {
            if (byArray == null) {
                return DataTypes.DEFAULT_VALUE_STRING;
            }
            if (string == null) {
                return new String(byArray);
            }
            return new String(byArray, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            Log log = LogFactory.getLog((Class)BlobTypeConverter.class);
            if (log.isDebugEnabled()) {
                try {
                    log.debug((Object)("Converting to type byte[] failed: value=" + (byArray != null ? URLEncoder.encode(new String(byArray), "UTF-8") : null) + ", charset=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null)), (Throwable)unsupportedEncodingException);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException2) {
                    // empty catch block
                }
            }
            return new String(byArray);
        }
    }

    public int toInt(byte[] byArray) {
        return 0;
    }

    public boolean toBoolean(byte[] byArray) {
        return false;
    }

    public long toLong(byte[] byArray) {
        return 0L;
    }

    public float toFloat(byte[] byArray) {
        return 0.0f;
    }

    public double toDouble(byte[] byArray) {
        return 0.0;
    }

    public BigDecimal toBigDecimal(byte[] byArray) {
        return DataTypes.DEFAULT_VALUE_BIG_DECIMAL;
    }

    public Date toDate(byte[] byArray) {
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(byte[] byArray) {
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(byte[] byArray) {
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public Object convert(byte[] byArray, int n) {
        return this.convert(byArray, n, null);
    }

    public Object convert(byte[] byArray, int n, String string) {
        switch (n) {
            case 2: {
                return this.toString(byArray, string);
            }
            case 3: {
                return new Integer(this.toInt(byArray));
            }
            case 4: {
                return this.toBoolean(byArray) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(byArray));
            }
            case 6: {
                return new Float(this.toFloat(byArray));
            }
            case 7: {
                return new Double(this.toDouble(byArray));
            }
            case 8: {
                return this.toBigDecimal(byArray);
            }
            case 9: {
                return this.toDate(byArray);
            }
            case 10: {
                return this.toTime(byArray);
            }
            case 11: {
                return this.toDateTime(byArray);
            }
            case 12: {
                return this.toObject(byArray);
            }
        }
        return this.toObject(byArray);
    }
}

