/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import java.math.BigDecimal;
import java.util.Date;

class BooleanTypeConverter {
    public Object toObject(boolean bl) {
        return bl ? Boolean.TRUE : Boolean.FALSE;
    }

    public String toString(boolean bl) {
        return String.valueOf(bl);
    }

    public int toInt(boolean bl) {
        return 0;
    }

    public long toLong(boolean bl) {
        return 0L;
    }

    public float toFloat(boolean bl) {
        return 0.0f;
    }

    public double toDouble(boolean bl) {
        return 0.0;
    }

    public BigDecimal toBigDecimal(boolean bl) {
        return DataTypes.DEFAULT_VALUE_BIG_DECIMAL;
    }

    public Date toDate(boolean bl) {
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public Date toTime(boolean bl) {
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public Date toDateTime(boolean bl) {
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public byte[] toBlob(boolean bl) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(boolean bl, int n) {
        switch (n) {
            case 2: {
                return this.toString(bl);
            }
            case 3: {
                return new Integer(this.toInt(bl));
            }
            case 4: {
                return this.toObject(bl);
            }
            case 5: {
                return new Long(this.toLong(bl));
            }
            case 6: {
                return new Float(this.toFloat(bl));
            }
            case 7: {
                return new Double(this.toDouble(bl));
            }
            case 8: {
                return this.toBigDecimal(bl);
            }
            case 9: {
                return this.toDate(bl);
            }
            case 10: {
                return this.toTime(bl);
            }
            case 11: {
                return this.toDateTime(bl);
            }
            case 12: {
                return this.toBlob(bl);
            }
        }
        return this.toObject(bl);
    }
}

