/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.util.DatetimeFormat;
import java.math.BigDecimal;
import java.util.Calendar;
import java.util.Date;

class DateTypeConverter {
    private static final int DEFAULT_YEAR = 1970;
    private static final int DEFAULT_MONTH = 0;
    private static final int DEFAULT_DATE = 1;
    private static final int DEFAULT_HOUR = 0;
    private static final int DEFAULT_MINUTE = 0;
    private static final int DEFAULT_SECOND = 0;
    private static final int DEFAULT_MILLISECOND = 0;
    private DatetimeFormat datetimeFormat = new DatetimeFormat();

    public Object toObject(Date date) {
        return date;
    }

    public String toString(Date date) {
        return this.toString(date, 11);
    }

    public String toString(Date date, int n) {
        if (date == null) {
            return DataTypes.DEFAULT_VALUE_STRING;
        }
        if (n == 9) {
            this.datetimeFormat.setFormat(2);
            return this.datetimeFormat.format(date);
        }
        if (n == 10) {
            this.datetimeFormat.setFormat(3);
            return this.datetimeFormat.format(date);
        }
        this.datetimeFormat.setFormat(0);
        return this.datetimeFormat.format(date);
    }

    public int toInt(Date date) {
        return 0;
    }

    public boolean toBoolean(Date date) {
        return false;
    }

    public long toLong(Date date) {
        return date == null ? 0L : date.getTime();
    }

    public float toFloat(Date date) {
        return 0.0f;
    }

    public double toDouble(Date date) {
        return 0.0;
    }

    public BigDecimal toBigDecimal(Date date) {
        return DataTypes.DEFAULT_VALUE_BIG_DECIMAL;
    }

    public Date toDate(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        return calendar.getTime();
    }

    public Date toTime(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(1, 1970);
        calendar.set(2, 0);
        calendar.set(5, 1);
        return calendar.getTime();
    }

    public byte[] toBlob(Date date) {
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public Object convert(Date date, int n) {
        switch (n) {
            case 2: {
                return this.toString(date);
            }
            case 3: {
                return new Integer(this.toInt(date));
            }
            case 4: {
                return this.toBoolean(date) ? Boolean.TRUE : Boolean.FALSE;
            }
            case 5: {
                return new Long(this.toLong(date));
            }
            case 6: {
                return new Float(this.toFloat(date));
            }
            case 7: {
                return new Double(this.toDouble(date));
            }
            case 8: {
                return this.toBigDecimal(date);
            }
            case 9: {
                return this.toDate(date);
            }
            case 10: {
                return this.toTime(date);
            }
            case 11: {
                return this.toObject(date);
            }
            case 12: {
                return this.toBlob(date);
            }
        }
        return this.toObject(date);
    }
}

