/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.data.util;

import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.util.BigDecimalTypeConverter;
import com.nexacro.xapi.data.util.BlobTypeConverter;
import com.nexacro.xapi.data.util.BooleanTypeConverter;
import com.nexacro.xapi.data.util.DateTypeConverter;
import com.nexacro.xapi.data.util.DoubleTypeConverter;
import com.nexacro.xapi.data.util.FloatTypeConverter;
import com.nexacro.xapi.data.util.IntegerTypeConverter;
import com.nexacro.xapi.data.util.LongTypeConverter;
import com.nexacro.xapi.data.util.StringTypeConverter;
import java.math.BigDecimal;
import java.util.Date;

public class TypeConverter {
    private static final StringTypeConverter STRING_CONVERTER = new StringTypeConverter();
    private static final IntegerTypeConverter INT_CONVERTER = new IntegerTypeConverter();
    private static final BooleanTypeConverter BOOLEAN_CONVERTER = new BooleanTypeConverter();
    private static final LongTypeConverter LONG_CONVERTER = new LongTypeConverter();
    private static final FloatTypeConverter FLOAT_CONVERTER = new FloatTypeConverter();
    private static final DoubleTypeConverter DOUBLE_CONVERTER = new DoubleTypeConverter();
    private static final BigDecimalTypeConverter BIG_DECIMAL_CONVERTER = new BigDecimalTypeConverter();
    private static final DateTypeConverter DATE_CONVERTER = new DateTypeConverter();
    private static final BlobTypeConverter BLOB_CONVERTER = new BlobTypeConverter();

    public static Object toObject(Object object) {
        return object;
    }

    public static String toString(Object object) {
        return TypeConverter.toString(object, 0);
    }

    public static String toString(Object object, int n) {
        return TypeConverter.toString(object, n, null);
    }

    public static String toString(Object object, int n, String string) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object;
        }
        if (object instanceof Integer) {
            return INT_CONVERTER.toString((Integer)object);
        }
        if (object instanceof Boolean) {
            return BOOLEAN_CONVERTER.toString((Boolean)object);
        }
        if (object instanceof Long) {
            return LONG_CONVERTER.toString((Long)object);
        }
        if (object instanceof Float) {
            return FLOAT_CONVERTER.toString(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DOUBLE_CONVERTER.toString((Double)object);
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toString((BigDecimal)object);
        }
        if (object instanceof Date) {
            return DATE_CONVERTER.toString((Date)object, n);
        }
        if (object instanceof byte[]) {
            return BLOB_CONVERTER.toString((byte[])object, string);
        }
        return object.toString();
    }

    public static int toInt(Object object) {
        if (object == null) {
            return 0;
        }
        if (object instanceof String) {
            return STRING_CONVERTER.toInt((String)object);
        }
        if (object instanceof Integer) {
            return (Integer)object;
        }
        if (object instanceof Boolean) {
            return BOOLEAN_CONVERTER.toInt((Boolean)object);
        }
        if (object instanceof Long) {
            return LONG_CONVERTER.toInt((Long)object);
        }
        if (object instanceof Float) {
            return FLOAT_CONVERTER.toInt(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DOUBLE_CONVERTER.toInt((Double)object);
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toInt((BigDecimal)object);
        }
        if (object instanceof Date) {
            return DATE_CONVERTER.toInt((Date)object);
        }
        if (object instanceof byte[]) {
            return BLOB_CONVERTER.toInt((byte[])object);
        }
        return 0;
    }

    public static boolean toBoolean(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof String) {
            return STRING_CONVERTER.toBoolean((String)object);
        }
        if (object instanceof Integer) {
            return INT_CONVERTER.toBoolean((Integer)object);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        if (object instanceof Long) {
            return LONG_CONVERTER.toBoolean((Long)object);
        }
        if (object instanceof Float) {
            return FLOAT_CONVERTER.toBoolean(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DOUBLE_CONVERTER.toBoolean((Double)object);
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toBoolean((BigDecimal)object);
        }
        if (object instanceof Date) {
            return DATE_CONVERTER.toBoolean((Date)object);
        }
        if (object instanceof byte[]) {
            return BLOB_CONVERTER.toBoolean((byte[])object);
        }
        return false;
    }

    public static long toLong(Object object) {
        if (object == null) {
            return 0L;
        }
        if (object instanceof String) {
            return STRING_CONVERTER.toLong((String)object);
        }
        if (object instanceof Integer) {
            return INT_CONVERTER.toLong((Integer)object);
        }
        if (object instanceof Boolean) {
            return BOOLEAN_CONVERTER.toLong((Boolean)object);
        }
        if (object instanceof Long) {
            return (Long)object;
        }
        if (object instanceof Float) {
            return FLOAT_CONVERTER.toLong(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DOUBLE_CONVERTER.toLong((Double)object);
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toLong((BigDecimal)object);
        }
        if (object instanceof Date) {
            return DATE_CONVERTER.toLong((Date)object);
        }
        if (object instanceof byte[]) {
            return BLOB_CONVERTER.toLong((byte[])object);
        }
        return 0L;
    }

    public static float toFloat(Object object) {
        if (object == null) {
            return 0.0f;
        }
        if (object instanceof String) {
            return STRING_CONVERTER.toFloat((String)object);
        }
        if (object instanceof Integer) {
            return INT_CONVERTER.toFloat((Integer)object);
        }
        if (object instanceof Boolean) {
            return BOOLEAN_CONVERTER.toFloat((Boolean)object);
        }
        if (object instanceof Long) {
            return LONG_CONVERTER.toFloat((Long)object);
        }
        if (object instanceof Float) {
            return ((Float)object).floatValue();
        }
        if (object instanceof Double) {
            return DOUBLE_CONVERTER.toFloat((Double)object);
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toFloat((BigDecimal)object);
        }
        if (object instanceof Date) {
            return DATE_CONVERTER.toFloat((Date)object);
        }
        if (object instanceof byte[]) {
            return BLOB_CONVERTER.toFloat((byte[])object);
        }
        return 0.0f;
    }

    public static double toDouble(Object object) {
        if (object == null) {
            return 0.0;
        }
        if (object instanceof String) {
            return STRING_CONVERTER.toDouble((String)object);
        }
        if (object instanceof Integer) {
            return INT_CONVERTER.toDouble((Integer)object);
        }
        if (object instanceof Boolean) {
            return BOOLEAN_CONVERTER.toDouble((Boolean)object);
        }
        if (object instanceof Long) {
            return LONG_CONVERTER.toDouble((Long)object);
        }
        if (object instanceof Float) {
            return FLOAT_CONVERTER.toDouble(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return (Double)object;
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toDouble((BigDecimal)object);
        }
        if (object instanceof Date) {
            return DATE_CONVERTER.toDouble((Date)object);
        }
        if (object instanceof byte[]) {
            return BLOB_CONVERTER.toDouble((byte[])object);
        }
        return 0.0;
    }

    public static BigDecimal toBigDecimal(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return STRING_CONVERTER.toBigDecimal((String)object);
        }
        if (object instanceof Integer) {
            return INT_CONVERTER.toBigDecimal((Integer)object);
        }
        if (object instanceof Boolean) {
            return BOOLEAN_CONVERTER.toBigDecimal((Boolean)object);
        }
        if (object instanceof Long) {
            return LONG_CONVERTER.toBigDecimal((Long)object);
        }
        if (object instanceof Float) {
            return FLOAT_CONVERTER.toBigDecimal(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DOUBLE_CONVERTER.toBigDecimal((Double)object);
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        if (object instanceof Date) {
            return DATE_CONVERTER.toBigDecimal((Date)object);
        }
        if (object instanceof byte[]) {
            return BLOB_CONVERTER.toBigDecimal((byte[])object);
        }
        return DataTypes.DEFAULT_VALUE_BIG_DECIMAL;
    }

    public static Date toDate(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return STRING_CONVERTER.toDate((String)object);
        }
        if (object instanceof Integer) {
            return INT_CONVERTER.toDate((Integer)object);
        }
        if (object instanceof Boolean) {
            return BOOLEAN_CONVERTER.toDate((Boolean)object);
        }
        if (object instanceof Long) {
            return LONG_CONVERTER.toDate((Long)object);
        }
        if (object instanceof Float) {
            return FLOAT_CONVERTER.toDate(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DOUBLE_CONVERTER.toDate((Double)object);
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toDate((BigDecimal)object);
        }
        if (object instanceof Date) {
            return DATE_CONVERTER.toDate((Date)object);
        }
        if (object instanceof byte[]) {
            return BLOB_CONVERTER.toDate((byte[])object);
        }
        return DataTypes.DEFAULT_VALUE_DATE;
    }

    public static Date toTime(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return STRING_CONVERTER.toTime((String)object);
        }
        if (object instanceof Integer) {
            return INT_CONVERTER.toTime((Integer)object);
        }
        if (object instanceof Boolean) {
            return BOOLEAN_CONVERTER.toTime((Boolean)object);
        }
        if (object instanceof Long) {
            return LONG_CONVERTER.toTime((Long)object);
        }
        if (object instanceof Float) {
            return FLOAT_CONVERTER.toTime(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DOUBLE_CONVERTER.toTime((Double)object);
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toTime((BigDecimal)object);
        }
        if (object instanceof Date) {
            return DATE_CONVERTER.toTime((Date)object);
        }
        if (object instanceof byte[]) {
            return BLOB_CONVERTER.toTime((byte[])object);
        }
        return DataTypes.DEFAULT_VALUE_TIME;
    }

    public static Date toDateTime(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return STRING_CONVERTER.toDateTime((String)object);
        }
        if (object instanceof Integer) {
            return INT_CONVERTER.toDateTime((Integer)object);
        }
        if (object instanceof Boolean) {
            return BOOLEAN_CONVERTER.toDateTime((Boolean)object);
        }
        if (object instanceof Long) {
            return LONG_CONVERTER.toDateTime((Long)object);
        }
        if (object instanceof Float) {
            return FLOAT_CONVERTER.toDateTime(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DOUBLE_CONVERTER.toDateTime((Double)object);
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toDateTime((BigDecimal)object);
        }
        if (object instanceof Date) {
            return (Date)object;
        }
        if (object instanceof byte[]) {
            return BLOB_CONVERTER.toDateTime((byte[])object);
        }
        return DataTypes.DEFAULT_VALUE_DATE_TIME;
    }

    public static byte[] toBlob(Object object) {
        return TypeConverter.toBlob(object, null);
    }

    public static byte[] toBlob(Object object, String string) {
        if (object == null) {
            return DataTypes.DEFAULT_VALUE_BLOB;
        }
        if (object instanceof String) {
            return STRING_CONVERTER.toBlob((String)object, string);
        }
        if (object instanceof Integer) {
            return INT_CONVERTER.toBlob((Integer)object);
        }
        if (object instanceof Boolean) {
            return BOOLEAN_CONVERTER.toBlob((Boolean)object);
        }
        if (object instanceof Long) {
            return LONG_CONVERTER.toBlob((Long)object);
        }
        if (object instanceof Float) {
            return FLOAT_CONVERTER.toBlob(((Float)object).floatValue());
        }
        if (object instanceof Double) {
            return DOUBLE_CONVERTER.toBlob((Double)object);
        }
        if (object instanceof BigDecimal) {
            return BIG_DECIMAL_CONVERTER.toBlob((BigDecimal)object);
        }
        if (object instanceof Date) {
            return DATE_CONVERTER.toBlob((Date)object);
        }
        if (object instanceof byte[]) {
            return (byte[])object;
        }
        return DataTypes.DEFAULT_VALUE_BLOB;
    }

    public static Object toObject(String string) {
        return STRING_CONVERTER.toObject(string);
    }

    public static int toInt(String string) {
        return STRING_CONVERTER.toInt(string);
    }

    public static boolean toBoolean(String string) {
        return STRING_CONVERTER.toBoolean(string);
    }

    public static long toLong(String string) {
        return STRING_CONVERTER.toLong(string);
    }

    public static float toFloat(String string) {
        return STRING_CONVERTER.toFloat(string);
    }

    public static double toDouble(String string) {
        return STRING_CONVERTER.toDouble(string);
    }

    public static BigDecimal toBigDecimal(String string) {
        return STRING_CONVERTER.toBigDecimal(string);
    }

    public static Date toDate(String string) {
        return STRING_CONVERTER.toDate(string);
    }

    public static Date toTime(String string) {
        return STRING_CONVERTER.toTime(string);
    }

    public static Date toDateTime(String string) {
        return STRING_CONVERTER.toDateTime(string);
    }

    public static byte[] toBlob(String string) {
        return TypeConverter.toBlob(string, null);
    }

    public static byte[] toBlob(String string, String string2) {
        return STRING_CONVERTER.toBlob(string, string2);
    }

    public static Object toObject(int n) {
        return INT_CONVERTER.toObject(n);
    }

    public static String toString(int n) {
        return INT_CONVERTER.toString(n);
    }

    public static boolean toBoolean(int n) {
        return INT_CONVERTER.toBoolean(n);
    }

    public static long toLong(int n) {
        return INT_CONVERTER.toLong(n);
    }

    public static float toFloat(int n) {
        return INT_CONVERTER.toFloat(n);
    }

    public static double toDouble(int n) {
        return INT_CONVERTER.toDouble(n);
    }

    public static BigDecimal toBigDecimal(int n) {
        return INT_CONVERTER.toBigDecimal(n);
    }

    public static Date toDate(int n) {
        return INT_CONVERTER.toDate(n);
    }

    public static Date toTime(int n) {
        return INT_CONVERTER.toTime(n);
    }

    public static Date toDateTime(int n) {
        return INT_CONVERTER.toDateTime(n);
    }

    public static byte[] toBlob(int n) {
        return INT_CONVERTER.toBlob(n);
    }

    public static Object toObject(boolean bl) {
        return BOOLEAN_CONVERTER.toObject(bl);
    }

    public static String toString(boolean bl) {
        return BOOLEAN_CONVERTER.toString(bl);
    }

    public static int toInt(boolean bl) {
        return BOOLEAN_CONVERTER.toInt(bl);
    }

    public static long toLong(boolean bl) {
        return BOOLEAN_CONVERTER.toLong(bl);
    }

    public static float toFloat(boolean bl) {
        return BOOLEAN_CONVERTER.toFloat(bl);
    }

    public static double toDouble(boolean bl) {
        return BOOLEAN_CONVERTER.toDouble(bl);
    }

    public static BigDecimal toBigDecimal(boolean bl) {
        return BOOLEAN_CONVERTER.toBigDecimal(bl);
    }

    public static Date toDate(boolean bl) {
        return BOOLEAN_CONVERTER.toDate(bl);
    }

    public static Date toTime(boolean bl) {
        return BOOLEAN_CONVERTER.toTime(bl);
    }

    public static Date toDateTime(boolean bl) {
        return BOOLEAN_CONVERTER.toDateTime(bl);
    }

    public static byte[] toBlob(boolean bl) {
        return BOOLEAN_CONVERTER.toBlob(bl);
    }

    public static Object toObject(long l) {
        return LONG_CONVERTER.toObject(l);
    }

    public static String toString(long l) {
        return LONG_CONVERTER.toString(l);
    }

    public static int toInt(long l) {
        return LONG_CONVERTER.toInt(l);
    }

    public static boolean toBoolean(long l) {
        return LONG_CONVERTER.toBoolean(l);
    }

    public static float toFloat(long l) {
        return LONG_CONVERTER.toFloat(l);
    }

    public static double toDouble(long l) {
        return LONG_CONVERTER.toDouble(l);
    }

    public static BigDecimal toBigDecimal(long l) {
        return LONG_CONVERTER.toBigDecimal(l);
    }

    public static Date toDate(long l) {
        return LONG_CONVERTER.toDate(l);
    }

    public static Date toTime(long l) {
        return LONG_CONVERTER.toTime(l);
    }

    public static Date toDateTime(long l) {
        return LONG_CONVERTER.toDateTime(l);
    }

    public static byte[] toBlob(long l) {
        return LONG_CONVERTER.toBlob(l);
    }

    public static Object toObject(float f) {
        return FLOAT_CONVERTER.toObject(f);
    }

    public static String toString(float f) {
        return FLOAT_CONVERTER.toString(f);
    }

    public static int toInt(float f) {
        return FLOAT_CONVERTER.toInt(f);
    }

    public static boolean toBoolean(float f) {
        return FLOAT_CONVERTER.toBoolean(f);
    }

    public static long toLong(float f) {
        return FLOAT_CONVERTER.toLong(f);
    }

    public static double toDouble(float f) {
        return FLOAT_CONVERTER.toDouble(f);
    }

    public static BigDecimal toBigDecimal(float f) {
        return FLOAT_CONVERTER.toBigDecimal(f);
    }

    public static Date toDate(float f) {
        return FLOAT_CONVERTER.toDate(f);
    }

    public static Date toTime(float f) {
        return FLOAT_CONVERTER.toTime(f);
    }

    public static Date toDateTime(float f) {
        return FLOAT_CONVERTER.toDateTime(f);
    }

    public static byte[] toBlob(float f) {
        return FLOAT_CONVERTER.toBlob(f);
    }

    public static Object toObject(double d) {
        return DOUBLE_CONVERTER.toObject(d);
    }

    public static String toString(double d) {
        return DOUBLE_CONVERTER.toString(d);
    }

    public static int toInt(double d) {
        return DOUBLE_CONVERTER.toInt(d);
    }

    public static boolean toBoolean(double d) {
        return DOUBLE_CONVERTER.toBoolean(d);
    }

    public static long toLong(double d) {
        return DOUBLE_CONVERTER.toLong(d);
    }

    public static float toFloat(double d) {
        return DOUBLE_CONVERTER.toFloat(d);
    }

    public static BigDecimal toBigDecimal(double d) {
        return DOUBLE_CONVERTER.toBigDecimal(d);
    }

    public static Date toDate(double d) {
        return DOUBLE_CONVERTER.toDate(d);
    }

    public static Date toTime(double d) {
        return DOUBLE_CONVERTER.toTime(d);
    }

    public static Date toDateTime(double d) {
        return DOUBLE_CONVERTER.toDateTime(d);
    }

    public static byte[] toBlob(double d) {
        return DOUBLE_CONVERTER.toBlob(d);
    }

    public static Object toObject(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toObject(bigDecimal);
    }

    public static String toString(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toString(bigDecimal);
    }

    public static int toInt(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toInt(bigDecimal);
    }

    public static boolean toBoolean(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toBoolean(bigDecimal);
    }

    public static long toLong(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toLong(bigDecimal);
    }

    public static float toFloat(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toFloat(bigDecimal);
    }

    public static double toDouble(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toDouble(bigDecimal);
    }

    public static Date toDate(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toDate(bigDecimal);
    }

    public static Date toTime(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toTime(bigDecimal);
    }

    public static Date toDateTime(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toDateTime(bigDecimal);
    }

    public static byte[] toBlob(BigDecimal bigDecimal) {
        return BIG_DECIMAL_CONVERTER.toBlob(bigDecimal);
    }

    public static Object toObject(Date date) {
        return DATE_CONVERTER.toObject(date);
    }

    public static String toString(Date date) {
        return DATE_CONVERTER.toString(date);
    }

    public static int toInt(Date date) {
        return DATE_CONVERTER.toInt(date);
    }

    public static boolean toBoolean(Date date) {
        return DATE_CONVERTER.toBoolean(date);
    }

    public static long toLong(Date date) {
        return DATE_CONVERTER.toLong(date);
    }

    public static float toFloat(Date date) {
        return DATE_CONVERTER.toFloat(date);
    }

    public static double toDouble(Date date) {
        return DATE_CONVERTER.toDouble(date);
    }

    public static BigDecimal toBigDecimal(Date date) {
        return DATE_CONVERTER.toBigDecimal(date);
    }

    public static Date toDate(Date date) {
        return DATE_CONVERTER.toDate(date);
    }

    public static Date toTime(Date date) {
        return DATE_CONVERTER.toTime(date);
    }

    public static byte[] toBlob(Date date) {
        return DATE_CONVERTER.toBlob(date);
    }

    public static Object toObject(byte[] byArray) {
        return BLOB_CONVERTER.toObject(byArray);
    }

    public static String toString(byte[] byArray) {
        return TypeConverter.toString(byArray, null);
    }

    public static String toString(byte[] byArray, String string) {
        return BLOB_CONVERTER.toString(byArray, string);
    }

    public static int toInt(byte[] byArray) {
        return BLOB_CONVERTER.toInt(byArray);
    }

    public static long toLong(byte[] byArray) {
        return BLOB_CONVERTER.toLong(byArray);
    }

    public static float toFloat(byte[] byArray) {
        return BLOB_CONVERTER.toFloat(byArray);
    }

    public static double toDouble(byte[] byArray) {
        return BLOB_CONVERTER.toDouble(byArray);
    }

    public static BigDecimal toBigDecimal(byte[] byArray) {
        return BLOB_CONVERTER.toBigDecimal(byArray);
    }

    public static Date toDate(byte[] byArray) {
        return BLOB_CONVERTER.toDate(byArray);
    }

    public static Date toTime(byte[] byArray) {
        return BLOB_CONVERTER.toTime(byArray);
    }

    public static Date toDateTime(byte[] byArray) {
        return BLOB_CONVERTER.toDateTime(byArray);
    }

    public static Object convert(Object object, int n) {
        return TypeConverter.convert(object, n, null);
    }

    public static Object convert(Object object, int n, String string) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return TypeConverter.convert((String)object, n, string);
        }
        if (object instanceof Integer) {
            return TypeConverter.convert((Integer)object, n);
        }
        if (object instanceof Boolean) {
            return TypeConverter.convert((Boolean)object, n);
        }
        if (object instanceof Long) {
            return TypeConverter.convert((Long)object, n);
        }
        if (object instanceof Float) {
            return TypeConverter.convert(((Float)object).floatValue(), n);
        }
        if (object instanceof Double) {
            return TypeConverter.convert((Double)object, n);
        }
        if (object instanceof BigDecimal) {
            return TypeConverter.convert((BigDecimal)object, n);
        }
        if (object instanceof Date) {
            return TypeConverter.convert((Date)object, n);
        }
        if (object instanceof byte[]) {
            return TypeConverter.convert((byte[])object, n, string);
        }
        return object;
    }

    public static Object convert(String string, int n) {
        return TypeConverter.convert(string, n, null);
    }

    public static Object convert(String string, int n, String string2) {
        return STRING_CONVERTER.convert(string, n, string2);
    }

    public static Object convert(int n, int n2) {
        return INT_CONVERTER.convert(n, n2);
    }

    public static Object convert(boolean bl, int n) {
        return BOOLEAN_CONVERTER.convert(bl, n);
    }

    public static Object convert(long l, int n) {
        return LONG_CONVERTER.convert(l, n);
    }

    public static Object convert(float f, int n) {
        return FLOAT_CONVERTER.convert(f, n);
    }

    public static Object convert(double d, int n) {
        return DOUBLE_CONVERTER.convert(d, n);
    }

    public static Object convert(BigDecimal bigDecimal, int n) {
        return BIG_DECIMAL_CONVERTER.convert(bigDecimal, n);
    }

    public static Object convert(Date date, int n) {
        return DATE_CONVERTER.convert(date, n);
    }

    public static Object convert(byte[] byArray, int n) {
        return TypeConverter.convert(byArray, n, null);
    }

    public static Object convert(byte[] byArray, int n, String string) {
        return BLOB_CONVERTER.convert(byArray, n, string);
    }

    private TypeConverter() {
    }
}

