/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.JavaTypePlatformResponse;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformUtils;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.JspWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class HttpJavaTypePlatformResponse
extends JavaTypePlatformResponse {
    private Log log = LogFactory.getLog((Class)HttpJavaTypePlatformResponse.class);
    private HttpServletResponse httpRes;

    public HttpJavaTypePlatformResponse(HttpServletResponse httpServletResponse) {
        this(httpServletResponse, (String)null);
    }

    public HttpJavaTypePlatformResponse(HttpServletResponse httpServletResponse, String string) {
        this(httpServletResponse, string, null);
    }

    public HttpJavaTypePlatformResponse(HttpServletResponse httpServletResponse, String string, String string2) {
        super(string, string2);
        this.httpRes = httpServletResponse;
    }

    public HttpJavaTypePlatformResponse(HttpServletResponse httpServletResponse, HttpServletRequest httpServletRequest) {
        this(httpServletResponse);
        this.setCheckLicense(!this.isLocalRequest(httpServletRequest));
    }

    public HttpJavaTypePlatformResponse(HttpServletResponse httpServletResponse, PlatformRequest platformRequest) {
        super(platformRequest);
        this.httpRes = httpServletResponse;
    }

    public HttpJavaTypePlatformResponse(HttpServletResponse httpServletResponse, Writer writer) {
        this(httpServletResponse, writer, (String)null);
    }

    public HttpJavaTypePlatformResponse(HttpServletResponse httpServletResponse, Writer writer, String string) {
        this(httpServletResponse, writer, string, null);
    }

    public HttpJavaTypePlatformResponse(HttpServletResponse httpServletResponse, Writer writer, String string, String string2) {
        super(writer, string, string2);
        this.httpRes = httpServletResponse;
    }

    public HttpJavaTypePlatformResponse(HttpServletResponse httpServletResponse, Writer writer, HttpServletRequest httpServletRequest) {
        this(httpServletResponse, writer);
        this.setCheckLicense(!this.isLocalRequest(httpServletRequest));
    }

    public HttpJavaTypePlatformResponse(HttpServletResponse httpServletResponse, Writer writer, PlatformRequest platformRequest) {
        super(writer, platformRequest);
        this.httpRes = httpServletResponse;
    }

    public void start() throws PlatformException {
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sending data to HTTP: " + this.toSimpleString()));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending data to HTTP: " + this.toSimpleString()));
        }
        String string = this.getHttpContentType();
        String string2 = this.getCurrentCharset();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending data: httpContentType=" + string + ", charset=" + string2));
        }
        this.httpRes.setContentType(string);
        if (this.getOutputStream() == null && this.getWriter() == null) {
            PrintWriter printWriter;
            if (this.isCharStream()) {
                try {
                    printWriter = this.httpRes.getWriter();
                    this.setWriter(printWriter);
                }
                catch (IOException iOException) {
                    if (this.log.isErrorEnabled()) {
                        this.log.error((Object)"Could not get HTTP Writer", (Throwable)iOException);
                    }
                    throw new PlatformException("Could not get HTTP Writer", iOException);
                }
            }
            try {
                printWriter = this.httpRes.getOutputStream();
                this.setOutputStream((OutputStream)((Object)printWriter));
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Could not get HTTP OutputStream", (Throwable)iOException);
                }
                throw new PlatformException("Could not get HTTP OutputStream", iOException);
            }
        }
        if (!this.useOutputStream() && this.getWriter() instanceof JspWriter) {
            try {
                ((JspWriter)this.getWriter()).clearBuffer();
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Could not clear JSP Buffer", (Throwable)iOException);
                }
                throw new PlatformException("Could not clear JSP Buffer", iOException);
            }
        }
        super.start();
    }

    String getHttpContentType() {
        String string = this.getCurrentContentType();
        String string2 = this.getCurrentCharset();
        return PlatformUtils.getHttpContentType(string, string2);
    }

    private boolean isLocalRequest(HttpServletRequest httpServletRequest) {
        String string = httpServletRequest.getServerName();
        return "localhost".equals(string) || "127.0.0.1".equals(string);
    }

    private boolean isCharStream() {
        if (this.getProtocolTypeCount() == 0) {
            String string = this.getCurrentContentType();
            return "PlatformXml".equals(string) || "MiXml".equals(string) || "PlatformHtml".equals(string);
        }
        return false;
    }
}

