/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.DefaultJavaTypeDataConverter;
import com.nexacro.xapi.tx.JavaTypeDataConverter;
import com.nexacro.xapi.tx.JavaTypeDataSerializer;
import com.nexacro.xapi.tx.JavaTypeDataSerializerFactory;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformTransaction;
import com.nexacro.xapi.tx.ProtocolEncoder;
import com.nexacro.xapi.tx.ProtocolFilterFactory;
import com.nexacro.xapi.util.PlatformGlobals;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JavaTypePlatformResponse
extends PlatformTransaction {
    private Log log = LogFactory.getLog((Class)JavaTypePlatformResponse.class);
    private static final String IO_CLOSE_KEY = "platform.tx.PlatformResponse.ioclose";
    private static final int INDEX_INIT = 0;
    private static final int INDEX_STARTED = 1;
    private static final int INDEX_HEAD = 2;
    private static final int INDEX_VARIABLE = 3;
    private static final int INDEX_DATASET = 4;
    private static final int INDEX_DATASET_HEADER = 5;
    private static final int INDEX_DATASET_ROW = 6;
    private static final int INDEX_TAIL = 7;
    private static final int INDEX_ENDED = 8;
    private static final String[] INDEX_NAMES = new String[]{"INIT", "STARTED", "HEAD", "VARIABLE", "DATASET", "DATASET_HEADER", "DATASET_ROW", "TAIL", "ENDED", "UNKNOWN"};
    private JavaTypeDataConverter dataConverter;
    private JavaTypeDataConverter defaultDataConverter = new DefaultJavaTypeDataConverter();
    private Object[][] values = new Object[][]{{null}, {null, null}, {null, null, null}, {null, null, null, null}, {null, null, null, null, null}};
    private OutputStream out;
    private Writer writer;
    private int index;
    private long startTime;
    private JavaTypeDataSerializer serializer;
    private OutputStream[] streamEncoders;
    private OutputStream streamEncoder;
    private Writer[] writerEncoders;
    private Writer writerEncoder;

    public JavaTypePlatformResponse() {
    }

    public JavaTypePlatformResponse(String string) {
        this(string, null);
    }

    public JavaTypePlatformResponse(String string, String string2) {
        super(string, string2);
    }

    public JavaTypePlatformResponse(PlatformRequest platformRequest) {
        this(platformRequest.getContentType(), platformRequest.getCharset());
        this.setCheckLicense(platformRequest.isCheckLicense());
    }

    public JavaTypePlatformResponse(OutputStream outputStream) {
        this(outputStream, (String)null);
    }

    public JavaTypePlatformResponse(OutputStream outputStream, String string) {
        this(outputStream, string, null);
    }

    public JavaTypePlatformResponse(OutputStream outputStream, String string, String string2) {
        super(string, string2);
        this.out = outputStream;
    }

    public JavaTypePlatformResponse(OutputStream outputStream, PlatformRequest platformRequest) {
        this(outputStream, platformRequest.getContentType(), platformRequest.getCharset());
        this.setCheckLicense(platformRequest.isCheckLicense());
    }

    public JavaTypePlatformResponse(Writer writer) {
        this(writer, (String)null);
    }

    public JavaTypePlatformResponse(Writer writer, String string) {
        this(writer, string, null);
    }

    public JavaTypePlatformResponse(Writer writer, String string, String string2) {
        super(string, string2);
        this.writer = writer;
    }

    public JavaTypePlatformResponse(Writer writer, PlatformRequest platformRequest) {
        this(writer, platformRequest.getContentType(), platformRequest.getCharset());
        this.setCheckLicense(platformRequest.isCheckLicense());
    }

    public JavaTypeDataConverter getDataConverter() {
        return this.dataConverter;
    }

    public void setDataConverter(JavaTypeDataConverter javaTypeDataConverter) {
        this.dataConverter = javaTypeDataConverter;
    }

    public void start() throws PlatformException {
        if (this.getIndex() > 0) {
            throw new PlatformException("Sending data failed. command=start, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkLicense();
        this.setStartTime(System.currentTimeMillis());
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sending data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset()));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset() + ", startTime=" + this.startTime));
        }
        this.checkStream();
        this.init();
        this.setIndex(1);
        this.serializer.writeHead();
        this.setIndex(2);
    }

    public void end() throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 6) {
            throw new PlatformException("Sending data failed. command=end, index=" + this.getIndexName(this.getIndex()));
        }
        this.serializer.writeTail();
        this.setIndex(7);
        this.destroy();
        this.setIndex(8);
        long l = System.currentTimeMillis();
        long l2 = l - this.getStartTime();
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + l2));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + l2 + ", endTime=" + l));
        }
    }

    public void sendVariable(String string, int n, Object object) throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 3) {
            throw new PlatformException("Sending data failed. command=variable, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkVariable(string, n, object);
        this.serializer.writeVariable(string, n, object);
        this.setIndex(3);
    }

    public void sendDataSet(String string) throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 6) {
            throw new PlatformException("Sending data failed. command=dataset, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkDataSet(string);
        this.serializer.writeDataSet(string);
        this.setIndex(4);
    }

    public void sendDataSetHeader(String string, int n, int n2) throws PlatformException {
        if (this.getIndex() != 4 && this.getIndex() != 5) {
            throw new PlatformException("Sending data failed. command=datasetheader, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkDataSetHeader(string, n, n2);
        this.serializer.writeDataSetHeader(string, n, n2);
        this.setIndex(5);
    }

    public void sendDataSetConstantHeader(String string, int n, int n2, Object object) throws PlatformException {
        if (this.getIndex() != 4 && this.getIndex() != 5) {
            throw new PlatformException("Sending data failed. command=datasetconstantheader, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkDataSetHeader(string, n, n2);
        this.serializer.writeDataSetConstantHeader(string, n, n2, object);
        this.setIndex(5);
    }

    public void sendDataSetRow(Object object) throws PlatformException {
        this.values[0][0] = object;
        this.sendDataSetRow(this.values[0]);
    }

    public void sendDataSetRow(Object object, Object object2) throws PlatformException {
        this.values[1][0] = object;
        this.values[1][1] = object2;
        this.sendDataSetRow(this.values[1]);
    }

    public void sendDataSetRow(Object object, Object object2, Object object3) throws PlatformException {
        this.values[2][0] = object;
        this.values[2][1] = object2;
        this.values[2][2] = object3;
        this.sendDataSetRow(this.values[2]);
    }

    public void sendDataSetRow(Object object, Object object2, Object object3, Object object4) throws PlatformException {
        this.values[3][0] = object;
        this.values[3][1] = object2;
        this.values[3][2] = object3;
        this.values[3][3] = object4;
        this.sendDataSetRow(this.values[3]);
    }

    public void sendDataSetRow(Object object, Object object2, Object object3, Object object4, Object object5) throws PlatformException {
        this.values[4][0] = object;
        this.values[4][1] = object2;
        this.values[4][2] = object3;
        this.values[4][3] = object4;
        this.values[4][4] = object5;
        this.sendDataSetRow(this.values[4]);
    }

    public void sendDataSetRow(Object[] objectArray) throws PlatformException {
        if (this.getIndex() != 5 && this.getIndex() != 6) {
            throw new PlatformException("Sending data failed. command=datasetrow, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkDataSetRow(objectArray);
        this.serializer.writeDataSetRow(objectArray);
        this.setIndex(6);
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    Writer getWriter() {
        return this.writer;
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    boolean useOutputStream() {
        return this.writer == null;
    }

    private void init() throws PlatformException {
        this.initSerializer();
        if (this.useOutputStream()) {
            this.initStreamEncoders(this.getOutputStream());
        } else {
            this.initWriterEncoders(this.getWriter());
        }
    }

    private void destroy() throws PlatformException {
        this.destroySerializer();
        if (this.useOutputStream()) {
            this.destroyStreamEncoders();
        } else {
            this.destroyWriterEncoders();
        }
    }

    private void initSerializer() throws PlatformException {
        String string = this.getCurrentContentType();
        JavaTypeDataSerializer javaTypeDataSerializer = JavaTypeDataSerializerFactory.getSerializer(string);
        if (javaTypeDataSerializer == null) {
            throw new PlatformException("Could not create JavaTypeDataSerializer: " + string);
        }
        this.serializer = javaTypeDataSerializer;
    }

    private void initStreamEncoders(OutputStream outputStream) throws PlatformException {
        int n = this.getProtocolTypeCount();
        OutputStream[] outputStreamArray = null;
        OutputStream outputStream2 = outputStream;
        if (n > 0) {
            outputStreamArray = new OutputStream[n];
            for (int i = 0; i < n; ++i) {
                String string = this.getProtocolType(i);
                outputStreamArray[i] = outputStream2 = ProtocolFilterFactory.getEncoder(string, outputStream2);
                if (outputStream2 != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + string);
            }
        }
        this.streamEncoders = outputStreamArray;
        this.streamEncoder = outputStream2;
        this.serializer.setCharset(this.getCurrentCharset());
        this.serializer.setDataConverter(this.getCurrentDataConverter());
        this.serializer.setOutputStream(outputStream2);
    }

    private void initWriterEncoders(Writer writer) throws PlatformException {
        int n = this.getProtocolTypeCount();
        Writer[] writerArray = null;
        Writer writer2 = writer;
        if (n > 0) {
            writerArray = new Writer[n];
            for (int i = 0; i < n; ++i) {
                String string = this.getProtocolType(i);
                writerArray[i] = writer2 = ProtocolFilterFactory.getEncoder(string, writer2);
                if (writer2 != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + string);
            }
        }
        this.writerEncoders = writerArray;
        this.writerEncoder = writer2;
        this.serializer.setCharset(this.getCurrentCharset());
        this.serializer.setDataConverter(this.getCurrentDataConverter());
        this.serializer.setWriter(writer2);
    }

    private void destroySerializer() throws PlatformException {
    }

    private void destroyStreamEncoders() throws PlatformException {
        int n = this.getProtocolTypeCount();
        OutputStream[] outputStreamArray = this.streamEncoders;
        OutputStream outputStream = this.streamEncoder;
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing OutputStream failed", (Throwable)iOException);
            }
            throw new PlatformException("Flushing OutputStream failed", iOException);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing OutputStream failed", (Throwable)iOException);
                }
                throw new PlatformException("Closing OutputStream failed", iOException);
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ((ProtocolEncoder)((Object)outputStreamArray[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + i + "]=" + outputStreamArray[i]));
            }
        }
    }

    private void destroyWriterEncoders() throws PlatformException {
        int n = this.getProtocolTypeCount();
        Writer[] writerArray = this.writerEncoders;
        Writer writer = this.writerEncoder;
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing Writer failed", (Throwable)iOException);
            }
            throw new PlatformException("Flushing Writer failed", iOException);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing Writer failed", (Throwable)iOException);
                }
                throw new PlatformException("Closing Writer failed", iOException);
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ((ProtocolEncoder)((Object)writerArray[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + i + "]=" + writerArray[i]));
            }
        }
    }

    private int getIndex() {
        return this.index;
    }

    private void setIndex(int n) {
        this.index = n;
    }

    private String getIndexName(int n) {
        int n2 = INDEX_NAMES.length;
        if (n >= 0 && n < n2) {
            return INDEX_NAMES[n];
        }
        return INDEX_NAMES[n2];
    }

    private long getStartTime() {
        return this.startTime;
    }

    private void setStartTime(long l) {
        this.startTime = l;
    }

    private void checkStream() throws PlatformException {
        if (this.out == null && this.writer == null) {
            throw new PlatformException("OutputStream and Writer are null");
        }
    }

    private JavaTypeDataConverter getCurrentDataConverter() {
        return this.dataConverter == null ? this.defaultDataConverter : this.dataConverter;
    }

    private void checkVariable(String string, int n, Object object) throws PlatformException {
        this.checkName(string);
        this.checkDataType(n);
    }

    private void checkDataSet(String string) {
        this.checkName(string);
    }

    private void checkDataSetHeader(String string, int n, int n2) {
        this.checkName(string);
        this.checkDataType(n);
        this.checkDataSize(n2);
    }

    private void checkDataSetRow(Object[] objectArray) {
        if (objectArray == null) {
            throw new IllegalArgumentException("Invalid values: " + objectArray);
        }
    }

    private void checkName(String string) {
        if (string == null || "".equals(string)) {
            throw new IllegalArgumentException("No name specified");
        }
        if (string.charAt(0) == ' ' && "".equals(string.trim())) {
            throw new IllegalArgumentException("Invalid name: \"" + string + "\"");
        }
    }

    private void checkDataType(int n) {
        if (n < 2 || n > 12) {
            throw new IllegalArgumentException("Invalid data type: " + n);
        }
    }

    private void checkDataSize(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Invalid data size: " + n);
        }
    }
}

