/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.tx.DataSerializerFactory;
import com.nexacro.xapi.tx.PartDataSerializer;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformTransaction;
import com.nexacro.xapi.tx.ProtocolEncoder;
import com.nexacro.xapi.tx.ProtocolFilterFactory;
import com.nexacro.xapi.util.PlatformGlobals;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PartPlatformResponse
extends PlatformTransaction {
    private Log log = LogFactory.getLog((Class)PartPlatformResponse.class);
    private static final String IO_CLOSE_KEY = "platform.tx.PlatformResponse.ioclose";
    private static final String AUTO_DATA_CLEAR_KEY = "platform.tx.PartPlatformResponse.autodataclear";
    private static final int INDEX_INIT = 0;
    private static final int INDEX_STARTED = 1;
    private static final int INDEX_HEAD = 2;
    private static final int INDEX_VARIABLE = 3;
    private static final int INDEX_DATASET = 4;
    private static final int INDEX_TAIL = 5;
    private static final int INDEX_ENDED = 6;
    private static final String[] INDEX_NAMES = new String[]{"INIT", "STARTED", "HEAD", "VARIABLE", "DATASET", "TAIL", "ENDED", "UNKNOWN"};
    private OutputStream out;
    private Writer writer;
    private boolean autoDataClear = PlatformGlobals.getBooleanProperty("platform.tx.PartPlatformResponse.autodataclear", true);
    private int index;
    private long startTime;
    private PartDataSerializer serializer;
    private OutputStream[] streamEncoders;
    private OutputStream streamEncoder;
    private Writer[] writerEncoders;
    private Writer writerEncoder;

    public PartPlatformResponse() {
    }

    public PartPlatformResponse(String string) {
        this(string, null);
    }

    public PartPlatformResponse(String string, String string2) {
        super(string, string2);
    }

    public PartPlatformResponse(PlatformRequest platformRequest) {
        this(platformRequest.getContentType(), platformRequest.getCharset());
        this.setCheckLicense(platformRequest.isCheckLicense());
    }

    public PartPlatformResponse(OutputStream outputStream) {
        this(outputStream, (String)null);
    }

    public PartPlatformResponse(OutputStream outputStream, String string) {
        this(outputStream, string, null);
    }

    public PartPlatformResponse(OutputStream outputStream, String string, String string2) {
        super(string, string2);
        this.out = outputStream;
    }

    public PartPlatformResponse(OutputStream outputStream, PlatformRequest platformRequest) {
        this(outputStream, platformRequest.getContentType(), platformRequest.getCharset());
        this.setCheckLicense(platformRequest.isCheckLicense());
    }

    public PartPlatformResponse(Writer writer) {
        this(writer, (String)null);
    }

    public PartPlatformResponse(Writer writer, String string) {
        this(writer, string, null);
    }

    public PartPlatformResponse(Writer writer, String string, String string2) {
        super(string, string2);
        this.writer = writer;
    }

    public PartPlatformResponse(Writer writer, PlatformRequest platformRequest) {
        this(writer, platformRequest.getContentType(), platformRequest.getCharset());
        this.setCheckLicense(platformRequest.isCheckLicense());
    }

    public boolean isAutoDataClear() {
        return this.autoDataClear;
    }

    public void setAutoDataClear(boolean bl) {
        this.autoDataClear = bl;
    }

    public void start() throws PlatformException {
        if (this.getIndex() > 0) {
            throw new PlatformException("Sending data failed. command=start, index=" + this.getIndexName(this.getIndex()));
        }
        this.checkLicense();
        this.setStartTime(System.currentTimeMillis());
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sending data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset()));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending data: " + this.toSimpleString() + ", contentType=" + this.getContentType() + ", charset=" + this.getCharset() + ", startTime=" + this.startTime));
        }
        this.checkStream();
        this.init();
        this.setIndex(1);
        this.serializer.writeHead();
        this.setIndex(2);
    }

    public void end() throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 4) {
            throw new PlatformException("Sending data failed. command=end, index=" + this.getIndexName(this.getIndex()));
        }
        this.serializer.writeTail();
        this.setIndex(5);
        this.destroy();
        this.setIndex(6);
        long l = System.currentTimeMillis();
        long l2 = l - this.getStartTime();
        if (this.isCurrentVerbose()) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + l2));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + l2 + ", endTime=" + l));
        }
    }

    public void sendVariable(Variable variable) throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 3) {
            throw new PlatformException("Sending data failed. command=variable, index=" + this.getIndexName(this.getIndex()));
        }
        if (variable == null) {
            throw new PlatformException("Variable is null");
        }
        this.serializer.writeVariable(variable);
        this.setIndex(3);
    }

    public void sendDataSet(DataSet dataSet) throws PlatformException {
        if (this.getIndex() < 2) {
            this.start();
        } else if (this.getIndex() > 4) {
            throw new PlatformException("Sending data failed. command=dataset, index=" + this.getIndexName(this.getIndex()));
        }
        if (dataSet == null) {
            throw new PlatformException("DataSet is null");
        }
        this.serializer.writeDataSet(dataSet);
        if (this.isAutoDataClear()) {
            dataSet.clearData();
        }
        this.setIndex(4);
    }

    OutputStream getOutputStream() {
        return this.out;
    }

    void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    Writer getWriter() {
        return this.writer;
    }

    void setWriter(Writer writer) {
        this.writer = writer;
    }

    boolean useOutputStream() {
        return this.writer == null;
    }

    private void init() throws PlatformException {
        this.initSerializer();
        if (this.useOutputStream()) {
            this.initStreamEncoders(this.getOutputStream());
        } else {
            this.initWriterEncoders(this.getWriter());
        }
    }

    private void destroy() throws PlatformException {
        this.destroySerializer();
        if (this.useOutputStream()) {
            this.destroyStreamEncoders();
        } else {
            this.destroyWriterEncoders();
        }
    }

    private void initSerializer() throws PlatformException {
        String string = this.getCurrentContentType();
        PartDataSerializer partDataSerializer = DataSerializerFactory.getPartSerializer(string);
        if (partDataSerializer == null) {
            throw new PlatformException("Could not create PartDataSerializer: " + string);
        }
        this.serializer = partDataSerializer;
    }

    private void initStreamEncoders(OutputStream outputStream) throws PlatformException {
        int n = this.getProtocolTypeCount();
        OutputStream[] outputStreamArray = null;
        OutputStream outputStream2 = outputStream;
        if (n > 0) {
            outputStreamArray = new OutputStream[n];
            for (int i = 0; i < n; ++i) {
                String string = this.getProtocolType(i);
                outputStreamArray[i] = outputStream2 = ProtocolFilterFactory.getEncoder(string, outputStream2);
                if (outputStream2 != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + string);
            }
        }
        this.streamEncoders = outputStreamArray;
        this.streamEncoder = outputStream2;
        this.serializer.setCharset(this.getCurrentCharset());
        this.serializer.setDataTypeChanger(this.getDataTypeChanger());
        this.serializer.setOutputStream(outputStream2);
    }

    private void initWriterEncoders(Writer writer) throws PlatformException {
        int n = this.getProtocolTypeCount();
        Writer[] writerArray = null;
        Writer writer2 = writer;
        if (n > 0) {
            writerArray = new Writer[n];
            for (int i = 0; i < n; ++i) {
                String string = this.getProtocolType(i);
                writerArray[i] = writer2 = ProtocolFilterFactory.getEncoder(string, writer2);
                if (writer2 != null) continue;
                throw new PlatformException("Could not create ProtocolEncoder: " + string);
            }
        }
        this.writerEncoders = writerArray;
        this.writerEncoder = writer2;
        this.serializer.setCharset(this.getCurrentCharset());
        this.serializer.setDataTypeChanger(this.getDataTypeChanger());
        this.serializer.setWriter(writer2);
    }

    private void destroySerializer() throws PlatformException {
    }

    private void destroyStreamEncoders() throws PlatformException {
        int n = this.getProtocolTypeCount();
        OutputStream[] outputStreamArray = this.streamEncoders;
        OutputStream outputStream = this.streamEncoder;
        try {
            outputStream.flush();
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing OutputStream failed", (Throwable)iOException);
            }
            throw new PlatformException("Flushing OutputStream failed", iOException);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                outputStream.close();
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing OutputStream failed", (Throwable)iOException);
                }
                throw new PlatformException("Closing OutputStream failed", iOException);
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ((ProtocolEncoder)((Object)outputStreamArray[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + i + "]=" + outputStreamArray[i]));
            }
        }
    }

    private void destroyWriterEncoders() throws PlatformException {
        int n = this.getProtocolTypeCount();
        Writer[] writerArray = this.writerEncoders;
        Writer writer = this.writerEncoder;
        try {
            writer.flush();
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Flushing Writer failed", (Throwable)iOException);
            }
            throw new PlatformException("Flushing Writer failed", iOException);
        }
        if (PlatformGlobals.getBooleanProperty(IO_CLOSE_KEY, false)) {
            try {
                writer.close();
            }
            catch (IOException iOException) {
                if (this.log.isErrorEnabled()) {
                    this.log.error((Object)"Closing Writer failed", (Throwable)iOException);
                }
                throw new PlatformException("Closing Writer failed", iOException);
            }
        }
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                ((ProtocolEncoder)((Object)writerArray[i])).end();
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("Ended ProtocolEncoder: encoders[" + i + "]=" + writerArray[i]));
            }
        }
    }

    private int getIndex() {
        return this.index;
    }

    private void setIndex(int n) {
        this.index = n;
    }

    private String getIndexName(int n) {
        int n2 = INDEX_NAMES.length;
        if (n >= 0 && n < n2) {
            return INDEX_NAMES[n];
        }
        return INDEX_NAMES[n2];
    }

    private long getStartTime() {
        return this.startTime;
    }

    private void setStartTime(long l) {
        this.startTime = l;
    }

    private void checkStream() throws PlatformException {
        if (this.out == null && this.writer == null) {
            throw new PlatformException("OutputStream and Writer are null");
        }
    }
}

