/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformResponse;
import com.nexacro.xapi.util.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformFileClient {
    private Log log = LogFactory.getLog((Class)PlatformFileClient.class);
    private File source;
    private File target;
    private String sourceContentType;
    private String targetContentType;
    private String sourceCharset;
    private String targetCharset;
    private List sourceProtocolTypes;
    private List targetProtocolTypes;
    private boolean verbose;

    public PlatformFileClient(String string) {
        this(string, string);
    }

    public PlatformFileClient(String string, String string2) {
        this(new File(string), new File(string2));
    }

    public PlatformFileClient(File file) {
        this(file, file);
    }

    public PlatformFileClient(File file, String string) {
        this(file, file, string);
    }

    public PlatformFileClient(File file, String string, String string2) {
        this(file, file, string, string2);
    }

    public PlatformFileClient(File file, File file2) {
        this(file, file2, null, null);
    }

    public PlatformFileClient(File file, File file2, String string) {
        this(file, file2, string, null);
    }

    public PlatformFileClient(File file, File file2, String string, String string2) {
        this.source = file;
        this.target = file2;
        this.sourceContentType = string;
        this.targetContentType = string;
        this.sourceCharset = string2;
        this.targetCharset = string2;
    }

    public File getSource() {
        return this.source;
    }

    public void setSource(File file) {
        this.source = file;
    }

    public File getTarget() {
        return this.target;
    }

    public void setTarget(File file) {
        this.target = file;
    }

    public void setContentType(String string) {
        this.setSourceContentType(string);
        this.setTargetContentType(string);
    }

    public String getSourceContentType() {
        return this.sourceContentType;
    }

    public void setSourceContentType(String string) {
        this.sourceContentType = string;
    }

    public String getTargetContentType() {
        return this.targetContentType;
    }

    public void setTargetContentType(String string) {
        this.targetContentType = string;
    }

    public void setCharset(String string) {
        this.setSourceCharset(string);
        this.setTargetCharset(string);
    }

    public String getSourceCharset() {
        return this.sourceCharset;
    }

    public void setSourceCharset(String string) {
        this.sourceCharset = string;
    }

    public String getTargetCharset() {
        return this.targetCharset;
    }

    public void setTargetCharset(String string) {
        this.targetCharset = string;
    }

    public void addProtocolType(String string) {
        this.addSourceProtocolType(string);
        this.addTargetProtocolType(string);
    }

    public void removeProtocolType(String string) {
        this.removeSourceProtocolType(string);
        this.removeTargetProtocolType(string);
    }

    public void clearProtocolTypes() {
        this.clearSourceProtocolTypes();
        this.clearTargetProtocolTypes();
    }

    public String getSourceProtocolType(int n) {
        return this.sourceProtocolTypes == null ? null : (String)this.sourceProtocolTypes.get(n);
    }

    public void addSourceProtocolType(String string) {
        if (this.sourceProtocolTypes == null) {
            this.sourceProtocolTypes = new ArrayList();
        }
        if (this.sourceProtocolTypes.contains(string)) {
            throw new IllegalArgumentException("Duplicate protocol type: " + string);
        }
        this.sourceProtocolTypes.add(string);
    }

    public void removeSourceProtocolType(int n) {
        this.sourceProtocolTypes.remove(n);
    }

    public void removeSourceProtocolType(String string) {
        this.sourceProtocolTypes.remove(string);
    }

    public boolean containsSourceProtocolType(String string) {
        return this.sourceProtocolTypes == null ? false : this.sourceProtocolTypes.contains(string);
    }

    public void clearSourceProtocolTypes() {
        if (this.getSourceProtocolTypeCount() > 0) {
            this.sourceProtocolTypes.clear();
        }
    }

    public int getSourceProtocolTypeCount() {
        return this.sourceProtocolTypes == null ? 0 : this.sourceProtocolTypes.size();
    }

    public String getTargetProtocolType(int n) {
        return this.targetProtocolTypes == null ? null : (String)this.targetProtocolTypes.get(n);
    }

    public void addTargetProtocolType(String string) {
        if (this.targetProtocolTypes == null) {
            this.targetProtocolTypes = new ArrayList();
        }
        if (this.targetProtocolTypes.contains(string)) {
            throw new IllegalArgumentException("Duplicate protocol type: " + string);
        }
        this.targetProtocolTypes.add(string);
    }

    public void removeTargetProtocolType(int n) {
        this.targetProtocolTypes.remove(n);
    }

    public void removeTargetProtocolType(String string) {
        this.targetProtocolTypes.remove(string);
    }

    public boolean containsTargetProtocolType(String string) {
        return this.targetProtocolTypes == null ? false : this.targetProtocolTypes.contains(string);
    }

    public void clearTargetProtocolTypes() {
        if (this.getTargetProtocolTypeCount() > 0) {
            this.targetProtocolTypes.clear();
        }
    }

    public int getTargetProtocolTypeCount() {
        return this.targetProtocolTypes == null ? 0 : this.targetProtocolTypes.size();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public void sendData(PlatformData platformData) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving data: target=" + this.target + ", contentType=" + this.targetContentType + ", charset=" + this.targetCharset));
        }
        this.makeParentDirs(this.target);
        FileOutputStream fileOutputStream = null;
        try {
            fileOutputStream = new FileOutputStream(this.target);
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not create FileOutputStream: target=" + this.target), (Throwable)iOException);
            }
            throw new PlatformException("Could not create FileOutputStream: target=" + this.target, iOException);
        }
        try {
            PlatformResponse platformResponse = new PlatformResponse(fileOutputStream);
            platformResponse.setContentType(this.getTargetCurrentContentType());
            platformResponse.setCharset(this.getTargetCurrentCharset());
            int n = this.getTargetProtocolTypeCount();
            for (int i = 0; i < n; ++i) {
                platformResponse.addProtocolType(this.getTargetProtocolType(i));
            }
            platformResponse.setData(platformData);
            platformResponse.sendData();
        }
        catch (PlatformException platformException) {
            throw new PlatformException("Saving file failed: target=" + this.target, platformException);
        }
        finally {
            block16: {
                try {
                    if (fileOutputStream != null) {
                        ((OutputStream)fileOutputStream).close();
                    }
                }
                catch (IOException iOException) {
                    if (!this.log.isWarnEnabled()) break block16;
                    this.log.warn((Object)("Closing OutputStream failed: target=" + this.target), (Throwable)iOException);
                }
            }
        }
    }

    public PlatformData receiveData() throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Loading data: source=" + this.source + ", contentType=" + this.sourceContentType + ", charset=" + this.sourceCharset));
        }
        FileInputStream fileInputStream = null;
        try {
            fileInputStream = new FileInputStream(this.source);
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not create FileInputStream: source=" + this.source), (Throwable)iOException);
            }
            throw new PlatformException("Could not create FileInputStream: source=" + this.source, iOException);
        }
        try {
            PlatformRequest platformRequest = new PlatformRequest(fileInputStream);
            platformRequest.setContentType(this.getSourceCurrentContentType());
            platformRequest.setCharset(this.getSourceCurrentCharset());
            int n = this.getSourceProtocolTypeCount();
            for (int i = 0; i < n; ++i) {
                platformRequest.addProtocolType(this.getSourceProtocolType(i));
            }
            platformRequest.receiveData();
            PlatformData platformData = platformRequest.getData();
            return platformData;
        }
        catch (PlatformException platformException) {
            throw new PlatformException("Loading file failed: source=" + this.source, platformException);
        }
        finally {
            block15: {
                try {
                    if (fileInputStream != null) {
                        ((InputStream)fileInputStream).close();
                    }
                }
                catch (IOException iOException) {
                    if (!this.log.isWarnEnabled()) break block15;
                    this.log.warn((Object)("Closing InputStream failed: source=" + this.source), (Throwable)iOException);
                }
            }
            this.close();
        }
    }

    public void close() {
    }

    private String getSourceCurrentContentType() {
        String string = this.getSourceContentType();
        return StringUtils.isEmpty(string) ? this.getDefaultContentType() : string;
    }

    private String getTargetCurrentContentType() {
        String string = this.getTargetContentType();
        return StringUtils.isEmpty(string) ? this.getDefaultContentType() : string;
    }

    private String getSourceCurrentCharset() {
        String string = this.getSourceCharset();
        return StringUtils.isEmpty(string) ? this.getDefaultCharset() : string;
    }

    private String getTargetCurrentCharset() {
        String string = this.getTargetCharset();
        return StringUtils.isEmpty(string) ? this.getDefaultCharset() : string;
    }

    private String getDefaultContentType() {
        return "PlatformXml";
    }

    private String getDefaultCharset() {
        return "UTF-8";
    }

    private void makeParentDirs(File file) {
        File file2 = file.getParentFile();
        if (file2 != null && !file2.exists()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Creating parent dir: file=" + file));
            }
            file2.mkdirs();
        }
    }
}

