/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.PlatformRequest;
import com.nexacro.xapi.tx.PlatformResponse;
import com.nexacro.xapi.tx.PlatformUtils;
import com.nexacro.xapi.tx.StreamLog;
import com.nexacro.xapi.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformHttpClient {
    private Log log = LogFactory.getLog((Class)PlatformHttpClient.class);
    private static final String STREAM_LOG_PREFIX = "xapi_http";
    private static final String STREAM_LOG_SUFFIX = "req";
    private String spec;
    private URL url;
    private URLConnection connection;
    private String contentType;
    private String charset;
    private List protocolTypes;
    private boolean verbose;
    private StreamLog streamLog;
    private List requestHeaderKeyList;
    private Map requestHeaderMap;
    private List responseHeaderKeyList;
    private Map responseHeaderMap;

    public PlatformHttpClient(String string) {
        this(string, null);
    }

    public PlatformHttpClient(String string, String string2) {
        this(string, string2, null);
    }

    public PlatformHttpClient(String string, String string2, String string3) {
        this.spec = string;
        this.contentType = string2;
        this.charset = string3;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String string) {
        this.contentType = string;
    }

    public String getCharset() {
        return this.charset;
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public String getProtocolType(int n) {
        return this.protocolTypes == null ? null : (String)this.protocolTypes.get(n);
    }

    public void addProtocolType(String string) {
        if (this.protocolTypes == null) {
            this.protocolTypes = new ArrayList();
        }
        if (this.protocolTypes.contains(string)) {
            throw new IllegalArgumentException("Duplicate protocol type: " + string);
        }
        this.protocolTypes.add(string);
    }

    public void removeProtocolType(int n) {
        this.protocolTypes.remove(n);
    }

    public void removeProtocolType(String string) {
        this.protocolTypes.remove(string);
    }

    public boolean containsProtocolType(String string) {
        return this.protocolTypes == null ? false : this.protocolTypes.contains(string);
    }

    public void clearProtocolTypes() {
        if (this.getProtocolTypeCount() > 0) {
            this.protocolTypes.clear();
        }
    }

    public int getProtocolTypeCount() {
        return this.protocolTypes == null ? 0 : this.protocolTypes.size();
    }

    public void addRequestHeader(String string, String string2) {
        this.checkRequestHeader(string, string2);
        if (this.requestHeaderKeyList == null || this.requestHeaderMap == null) {
            this.requestHeaderKeyList = new ArrayList();
            this.requestHeaderMap = new HashMap();
        }
        this.requestHeaderKeyList.add(string);
        this.requestHeaderMap.put(string, string2);
    }

    String getRequestHeaderKey(int n) {
        return this.requestHeaderKeyList == null ? null : (String)this.requestHeaderKeyList.get(n);
    }

    String getRequestHeaderValue(String string) {
        return this.requestHeaderMap == null ? null : (String)this.requestHeaderMap.get(string);
    }

    int getRequestHeaderCount() {
        return this.requestHeaderKeyList == null ? 0 : this.requestHeaderKeyList.size();
    }

    void addResponseHeader(String string, String string2) {
        if (string == null) {
            return;
        }
        if (this.responseHeaderKeyList == null || this.responseHeaderMap == null) {
            this.responseHeaderKeyList = new ArrayList();
            this.responseHeaderMap = new HashMap();
        }
        this.responseHeaderKeyList.add(string);
        this.responseHeaderMap.put(string, string2);
    }

    String getResponseHeaderKey(int n) {
        return this.responseHeaderKeyList == null ? null : (String)this.responseHeaderKeyList.get(n);
    }

    String getResponseHeaderValue(String string) {
        return this.responseHeaderMap == null ? null : (String)this.responseHeaderMap.get(string);
    }

    int getResponseHeaderCount() {
        return this.responseHeaderKeyList == null ? 0 : this.responseHeaderKeyList.size();
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean bl) {
        this.verbose = bl;
    }

    public boolean isStreamLogEnabled() {
        return this.streamLog == null ? false : this.streamLog.isLogEnabled();
    }

    public void setStreamLogEnabled(boolean bl) {
        this.checkStreamLog();
        this.streamLog.setLogEnabled(bl);
    }

    public String getStreamLogDir() {
        return this.streamLog == null ? null : this.streamLog.getLogDir();
    }

    public void setStreamLogDir(String string) {
        this.checkStreamLog();
        this.streamLog.setLogDir(string);
    }

    public int getStreamLogMaxSize() {
        return this.streamLog == null ? 0 : this.streamLog.getLogMaxSize();
    }

    public void setStreamLogMaxSize(int n) {
        this.checkStreamLog();
        this.streamLog.setLogMaxSize(n);
    }

    public void sendData(PlatformData platformData) throws PlatformException {
        boolean bl = this.isVerbose();
        long l = System.currentTimeMillis();
        if (bl) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sending data: " + this.toSimpleString() + ", spec=" + this.spec + ", contentType=" + this.contentType + ", charset=" + this.charset));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending data: " + this.toSimpleString() + ", spec=" + this.spec + ", contentType=" + this.contentType + ", charset=" + this.charset + ", startTime=" + l));
        }
        OutputStream outputStream = null;
        try {
            this.init(true);
            outputStream = this.connection.getOutputStream();
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not create OutputStream: connection=" + this.connection), (Throwable)iOException);
            }
            throw new PlatformException("Could not create OutputStream: connection=" + this.connection, iOException);
        }
        try {
            PlatformResponse platformResponse = new PlatformResponse(outputStream);
            platformResponse.setContentType(this.getCurrentContentType());
            platformResponse.setCharset(this.getCurrentCharset());
            int n = this.getProtocolTypeCount();
            for (int i = 0; i < n; ++i) {
                platformResponse.addProtocolType(this.getProtocolType(i));
            }
            platformResponse.setData(platformData);
            platformResponse.sendData();
        }
        catch (PlatformException platformException) {
            throw new PlatformException("Sending data failed: connection=" + this.connection, platformException);
        }
        finally {
            block23: {
                try {
                    if (outputStream != null) {
                        outputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (!this.log.isWarnEnabled()) break block23;
                    this.log.warn((Object)("Closing OutputStream failed: connection=" + this.connection), (Throwable)iOException);
                }
            }
        }
        long l2 = System.currentTimeMillis();
        long l3 = l2 - l;
        if (bl) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + l3));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sent data: " + this.toSimpleString() + ", elapsedTime=" + l3 + ", endTime=" + l2));
        }
    }

    public PlatformData receiveData() throws PlatformException {
        boolean bl = this.isVerbose();
        long l = System.currentTimeMillis();
        if (bl) {
            if (this.log.isInfoEnabled()) {
                this.log.info((Object)("Receiving data: " + this.toSimpleString() + ", spec=" + this.spec + ", contentType=" + this.contentType + ", charset=" + this.charset));
            }
        } else if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Receiving data: " + this.toSimpleString() + ", spec=" + this.spec + ", contentType=" + this.contentType + ", charset=" + this.charset + ", startTime=" + l));
        }
        InputStream inputStream = null;
        try {
            this.init(false);
            inputStream = this.connection.getInputStream();
        }
        catch (IOException iOException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not create InputStream: connection=" + this.connection), (Throwable)iOException);
            }
            throw new PlatformException("Could not create InputStream: connection=" + this.connection, iOException);
        }
        try {
            PlatformRequest platformRequest = new PlatformRequest(inputStream);
            platformRequest.setContentType(this.getCurrentContentType());
            platformRequest.setCharset(this.getCurrentCharset());
            int n = this.getProtocolTypeCount();
            for (int i = 0; i < n; ++i) {
                platformRequest.addProtocolType(this.getProtocolType(i));
            }
            if (this.streamLog != null && this.streamLog.isLogEnabled()) {
                platformRequest.setStreamLogEnabled(true);
                platformRequest.setStreamLogDir(this.streamLog.getLogDir());
                platformRequest.setStreamLogMaxSize(this.streamLog.getLogMaxSize());
                platformRequest.setStreamLogPrefix(STREAM_LOG_PREFIX);
                platformRequest.setStreamLogSuffix(STREAM_LOG_SUFFIX);
            }
            platformRequest.receiveData();
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            if (bl) {
                if (this.log.isInfoEnabled()) {
                    this.log.info((Object)("Received data: " + this.toSimpleString() + ", elapsedTime=" + l3));
                }
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Received data: " + this.toSimpleString() + ", elapsedTime=" + l3 + ", endTime=" + l2));
            }
            PlatformData platformData = platformRequest.getData();
            return platformData;
        }
        catch (PlatformException platformException) {
            throw new PlatformException("Receiving data failed: connection=" + this.connection, platformException);
        }
        finally {
            block23: {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException iOException) {
                    if (!this.log.isWarnEnabled()) break block23;
                    this.log.warn((Object)("Closing InputStream failed: connection=" + this.connection), (Throwable)iOException);
                }
            }
            this.close();
        }
    }

    public void close() {
        this.close(this.connection);
        this.connection = null;
    }

    void init(boolean bl) throws IOException {
        if (this.url == null) {
            this.url = new URL(this.spec);
        }
        if (this.connection == null) {
            this.connection = this.open(this.url, bl);
        }
    }

    URLConnection open(URL uRL, boolean bl) throws IOException {
        HttpURLConnection httpURLConnection = (HttpURLConnection)uRL.openConnection();
        String string = this.getHttpContentType();
        httpURLConnection.setRequestProperty("Content-Type", string);
        int n = this.getRequestHeaderCount();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getRequestHeaderKey(i);
            String string3 = this.getRequestHeaderValue(string2);
            httpURLConnection.setRequestProperty(string2, string3);
        }
        if (bl) {
            httpURLConnection.setRequestMethod("POST");
            httpURLConnection.setDoOutput(true);
            httpURLConnection.setDoInput(true);
        } else {
            httpURLConnection.setRequestMethod("GET");
        }
        return httpURLConnection;
    }

    void close(URLConnection uRLConnection) {
        int n;
        if (uRLConnection == null) {
            return;
        }
        Map<String, List<String>> map = uRLConnection.getHeaderFields();
        int n2 = n = map == null ? 0 : map.size();
        if (n > 0) {
            Iterator<Map.Entry<String, List<String>>> iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, List<String>> entry = iterator.next();
                String string = entry.getKey();
                if (string == null) continue;
                String string2 = uRLConnection.getHeaderField(string);
                this.addResponseHeader(string, string2);
            }
        }
        if (uRLConnection instanceof HttpURLConnection) {
            ((HttpURLConnection)uRLConnection).disconnect();
        }
    }

    String toSimpleString() {
        String string = this.getClass().getName();
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string + "@" + Integer.toHexString(this.hashCode());
        }
        return string.substring(n + 1) + "@" + Integer.toHexString(this.hashCode());
    }

    private String getHttpContentType() {
        String string = this.getCurrentContentType();
        String string2 = this.getCurrentCharset();
        return PlatformUtils.getHttpContentType(string, string2);
    }

    private String getCurrentContentType() {
        String string = this.getContentType();
        return StringUtils.isEmpty(string) ? this.getDefaultContentType() : string;
    }

    private String getCurrentCharset() {
        String string = this.getCharset();
        return StringUtils.isEmpty(string) ? this.getDefaultCharset() : string;
    }

    private String getDefaultContentType() {
        return "PlatformXml";
    }

    private String getDefaultCharset() {
        return "UTF-8";
    }

    private void checkStreamLog() {
        if (this.streamLog == null) {
            this.streamLog = new StreamLog();
        }
    }

    private void checkRequestHeader(String string, String string2) {
        if (string == null) {
            throw new IllegalArgumentException("No header key specified");
        }
        if ("".equals(string)) {
            throw new IllegalArgumentException("No header key specified");
        }
        if (string.charAt(0) == ' ' && "".equals(string.trim())) {
            throw new IllegalArgumentException("Invalid header key: \"" + string + "\"");
        }
        if ("content-type".equals(string.toLowerCase())) {
            throw new IllegalArgumentException("Invalid header key: \"" + string + "\"");
        }
    }
}

