/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.ProtocolDecoder;
import com.nexacro.xapi.tx.ProtocolEncoder;
import com.nexacro.xapi.tx.impl.PlatformZlibByteDecoder;
import com.nexacro.xapi.tx.impl.PlatformZlibByteEncoder;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ProtocolFilterFactory {
    private static final String SUFFIX_BYTE_ENCODER = ".byteEncoder";
    private static final String SUFFIX_CHAR_ENCODER = ".charEncoder";
    private static final String SUFFIX_BYTE_DECODER = ".byteDecoder";
    private static final String SUFFIX_CHAR_DECODER = ".charDecoder";
    private static Map filters = new HashMap();

    public static OutputStream getEncoder(String string, OutputStream outputStream) {
        block4: {
            Class clazz = (Class)filters.get(string + SUFFIX_BYTE_ENCODER);
            try {
                Class[] classArray = new Class[]{OutputStream.class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{outputStream};
                Object t = constructor.newInstance(objectArray);
                if (t instanceof ProtocolEncoder && t instanceof OutputStream) {
                    return (OutputStream)t;
                }
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not create ProtocolEncoder: type=" + URLEncoder.encode(string, "UTF-8") + ", obj=" + t));
                }
            }
            catch (Throwable throwable) {
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Could not create ProtocolEncoder: type=" + string), throwable);
            }
        }
        return null;
    }

    public static Writer getEncoder(String string, Writer writer) {
        block4: {
            Class clazz = (Class)filters.get(string + SUFFIX_CHAR_ENCODER);
            try {
                Class[] classArray = new Class[]{Writer.class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{writer};
                Object t = constructor.newInstance(objectArray);
                if (t instanceof ProtocolEncoder && t instanceof Writer) {
                    return (Writer)t;
                }
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not create ProtocolEncoder: type=" + URLEncoder.encode(string, "UTF-8") + ", obj=" + t));
                }
            }
            catch (Throwable throwable) {
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (!log.isErrorEnabled()) break block4;
                log.error((Object)("Could not create ProtocolEncoder: type=" + string), throwable);
            }
        }
        return null;
    }

    public static InputStream getDecoder(String string, InputStream inputStream) {
        block6: {
            Class clazz = (Class)filters.get(string + SUFFIX_BYTE_DECODER);
            try {
                Class[] classArray = new Class[]{InputStream.class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{inputStream};
                Object t = constructor.newInstance(objectArray);
                if (t instanceof ProtocolDecoder && t instanceof InputStream) {
                    return (InputStream)t;
                }
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not create ProtocolDecoder: type=" + URLEncoder.encode(string, "UTF-8") + ", obj=" + t));
                }
            }
            catch (Throwable throwable) {
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (!log.isErrorEnabled()) break block6;
                try {
                    log.error((Object)("Could not create ProtocolDecoder: type=" + URLEncoder.encode(string, "UTF-8")), throwable);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    public static Reader getDecoder(String string, Reader reader) {
        block6: {
            Class clazz = (Class)filters.get(string + SUFFIX_CHAR_DECODER);
            try {
                Class[] classArray = new Class[]{Reader.class};
                Constructor constructor = clazz.getConstructor(classArray);
                Object[] objectArray = new Object[]{reader};
                Object t = constructor.newInstance(objectArray);
                if (t instanceof ProtocolDecoder && t instanceof Reader) {
                    return (Reader)t;
                }
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (log.isWarnEnabled()) {
                    log.warn((Object)("Could not create ProtocolDecoder: type=" + URLEncoder.encode(string, "UTF-8") + ", obj=" + t));
                }
            }
            catch (Throwable throwable) {
                Log log = LogFactory.getLog((Class)ProtocolFilterFactory.class);
                if (!log.isErrorEnabled()) break block6;
                try {
                    log.error((Object)("Could not create ProtocolDecoder: type=" + URLEncoder.encode(string, "UTF-8")), throwable);
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
            }
        }
        return null;
    }

    private static void initEncoders(Map map) {
        map.put("PlatformZlib.byteEncoder", PlatformZlibByteEncoder.class);
    }

    private static void initDecoders(Map map) {
        map.put("PlatformZlib.byteDecoder", PlatformZlibByteDecoder.class);
    }

    private ProtocolFilterFactory() {
    }

    static {
        ProtocolFilterFactory.initEncoders(filters);
        ProtocolFilterFactory.initDecoders(filters);
    }
}

