/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.util.DatetimeFormat;
import java.io.File;
import java.util.Date;

class StreamLog {
    private static final int KILO = 1024;
    private static final int MEGA = 1024000;
    public static final int IO_BUFFER_SIZE = 4096;
    public static final int SKIP_BUFFER_SIZE = 2048;
    private static final String DEFAULT_LOG_DIR = ".";
    private static final int DEFAULT_LOG_MAX_SIZE = 4096000;
    private static final String DEFAULT_LOG_PREFIX = "xapi";
    private static final String DEFAULT_LOG_SUFFIX = "req";
    private DatetimeFormat dateFormat = new DatetimeFormat();
    private boolean isLogEnabled;
    private String logDir;
    private int logMaxSize;
    private String logPrefix;
    private String logSuffix;
    private boolean isExceededSize;

    public boolean isLogEnabled() {
        return this.isLogEnabled;
    }

    public void setLogEnabled(boolean bl) {
        this.isLogEnabled = bl;
    }

    public String getLogDir() {
        if (this.isEmpty(this.logDir)) {
            return DEFAULT_LOG_DIR;
        }
        int n = this.logDir.length();
        char c = this.logDir.charAt(n - 1);
        String string = c == '/' || c == '\\' ? this.logDir.substring(0, n - 1) : this.logDir;
        return File.separatorChar == '/' ? string.replace('\\', '/') : string.replace('/', '\\');
    }

    public void setLogDir(String string) {
        this.logDir = string;
    }

    public String getLogPath() {
        String string = this.getLogDir();
        String string2 = this.getLogPrefix();
        String string3 = this.getLogSuffix();
        String string4 = string2 + "_" + this.getCurrentDateString() + DEFAULT_LOG_DIR + string3;
        return string + File.separator + string4;
    }

    public int getLogMaxSize() {
        return this.logMaxSize <= 0 ? 4096000 : this.logMaxSize;
    }

    public void setLogMaxSize(int n) {
        this.logMaxSize = n;
    }

    public String getLogPrefix() {
        return this.isEmpty(this.logPrefix) ? DEFAULT_LOG_PREFIX : this.logPrefix;
    }

    public void setLogPrefix(String string) {
        this.logPrefix = string;
    }

    public String getLogSuffix() {
        return this.isEmpty(this.logSuffix) ? DEFAULT_LOG_SUFFIX : this.logSuffix;
    }

    public void setLogSuffix(String string) {
        this.logSuffix = string;
    }

    public boolean isExceededSize() {
        return this.isExceededSize;
    }

    public void setExceededSize(boolean bl) {
        this.isExceededSize = bl;
    }

    private String getCurrentDateString() {
        return this.getDateString(System.currentTimeMillis());
    }

    private String getDateString(long l) {
        Date date = new Date(l);
        StringBuffer stringBuffer = new StringBuffer();
        this.dateFormat.setFormat(2);
        stringBuffer.append(this.dateFormat.format(date));
        stringBuffer.append('_');
        this.dateFormat.setFormat(3);
        stringBuffer.append(this.dateFormat.format(date));
        return stringBuffer.toString();
    }

    private boolean isEmpty(String string) {
        return string == null || string.trim().length() == 0;
    }
}

