/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx;

import com.nexacro.xapi.tx.StreamLog;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StreamLogReader
extends Reader {
    private Reader in;
    private StreamLog streamLog;
    private CharArrayWriter buffer;

    public StreamLogReader(Reader reader, StreamLog streamLog) {
        this.in = reader;
        this.streamLog = streamLog;
    }

    public int read() throws IOException {
        int n = this.in.read();
        if (n != -1 && this.checkBuffer(1)) {
            this.buffer.write(n);
        }
        return n;
    }

    public int read(char[] cArray) throws IOException {
        return this.read(cArray, 0, cArray.length);
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.in.read(cArray, n, n2);
        if (n3 > 0 && this.checkBuffer(n3)) {
            this.buffer.write(cArray, n, n3);
        }
        return n3;
    }

    public long skip(long l) throws IOException {
        long l2;
        int n;
        if (l <= 0L) {
            return 0L;
        }
        char[] cArray = new char[2048];
        for (l2 = l; l2 > 0L && (n = this.in.read(cArray, 0, (int)Math.min(2048L, l2))) >= 0; l2 -= (long)n) {
            if (n <= 0 || !this.checkBuffer(n)) continue;
            this.buffer.write(cArray, 0, n);
        }
        return l - l2;
    }

    public boolean ready() throws IOException {
        return this.in.ready();
    }

    public void close() throws IOException {
        this.in.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void storeStreamLog() throws IOException {
        File file;
        Log log = LogFactory.getLog((Class)StreamLogReader.class);
        String string = this.streamLog.getLogPath();
        File file2 = new File(string);
        boolean bl = file2.exists();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Storing stream: path=" + URLEncoder.encode(string, "UTF-8") + ", exists=" + bl));
        }
        if (bl) {
            try {
                Thread.sleep(5L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            string = this.streamLog.getLogPath();
            file2 = new File(string);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Storing stream: path=" + URLEncoder.encode(string, "UTF-8")));
            }
        }
        if (!(file = file2.getParentFile()).exists()) {
            file.mkdirs();
        }
        FileWriter fileWriter = new FileWriter(file2);
        try {
            if (this.buffer == null) {
                if (this.in == null) {
                    fileWriter.write("The buffer does not exist. in=null");
                } else if (this.in.ready()) {
                    this.copy(this.in, fileWriter);
                } else {
                    fileWriter.write("The buffer does not exist. in.ready()=false");
                }
            } else {
                fileWriter.write(this.buffer.toCharArray());
                if (this.streamLog.isExceededSize()) {
                    int n = this.streamLog.getLogMaxSize();
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("The buffer was exceeded. maxSize=" + n));
                    }
                    fileWriter.write(System.getProperty("line.separator"));
                    fileWriter.write("The buffer was exceeded. maxSize=" + n);
                } else if (this.in.ready()) {
                    this.copy(this.in, fileWriter);
                }
            }
        }
        finally {
            fileWriter.close();
        }
    }

    private long copy(Reader reader, Writer writer) throws IOException {
        char[] cArray = new char[4096];
        long l = 0L;
        int n = 0;
        while (-1 != (n = reader.read(cArray))) {
            writer.write(cArray, 0, n);
            l += (long)n;
        }
        return l;
    }

    private boolean checkBuffer(int n) {
        if (this.streamLog.isExceededSize()) {
            return false;
        }
        if (this.buffer == null) {
            this.buffer = new CharArrayWriter();
        }
        if (this.buffer.size() + n > this.streamLog.getLogMaxSize()) {
            this.streamLog.setExceededSize(true);
            return false;
        }
        return true;
    }
}

