/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import java.io.ByteArrayOutputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class EmptyElementInputStream
extends FilterInputStream {
    private Log log = LogFactory.getLog((Class)EmptyElementInputStream.class);
    private static final byte[] EMPTY_SUFFIX = " empty=\"true\"/>".getBytes();
    private byte[] buffer;
    private int pos;

    public EmptyElementInputStream(InputStream inputStream) {
        super(inputStream);
    }

    public int read() throws IOException {
        throw new IOException("Unsupported operation");
    }

    public int read(byte[] byArray) throws IOException {
        return this.read(byArray, 0, byArray.length);
    }

    public int read(byte[] byArray, int n, int n2) throws IOException {
        if (this.buffer == null || this.buffer.length - this.pos <= 0) {
            return this.readFromSource(byArray, n, n2);
        }
        return this.readFromBuffer(byArray, n, n2);
    }

    private int readFromBuffer(byte[] byArray, int n, int n2) throws IOException {
        int n3 = this.buffer.length - this.pos;
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buffer, this.pos, byArray, n, n4);
        this.pos += n4;
        return n4;
    }

    private int readFromSource(byte[] byArray, int n, int n2) throws IOException {
        int n3 = super.read(byArray, n, n2);
        if (n3 <= 0) {
            return n3;
        }
        int n4 = this.indexOfEmptyElement(byArray, n, n3);
        if (n4 == -1) {
            int n5;
            byte by = byArray[n + n3 - 1];
            if (by == 47 && (n5 = super.read()) != -1) {
                if (n5 == 62) {
                    this.buffer = EMPTY_SUFFIX;
                    this.pos = 0;
                    --n3;
                } else {
                    this.buffer = new byte[]{(byte)n5};
                    this.pos = 0;
                }
            }
            return n3;
        }
        if (n4 == 0) {
            this.initBuffer(byArray, n, n3, n4);
            System.arraycopy(this.buffer, 0, byArray, n, n3);
            this.pos = n3;
            return n3;
        }
        this.initBuffer(byArray, n, n3, n4);
        return n4 - n;
    }

    private void initBuffer(byte[] byArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        byte[] byArray2 = EMPTY_SUFFIX;
        int n6 = n + n2;
        int n7 = n3;
        int n8 = n6 - n3 + byArray2.length * 4;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n8);
        byteArrayOutputStream.write(byArray2);
        while ((n5 = n6 - (n4 = n7 + 2)) != 0) {
            n7 = this.indexOfEmptyElement(byArray, n4, n5);
            if (n7 == -1) {
                byte by = byArray[n4 + n5 - 1];
                if (by == 47) {
                    int n9 = super.read();
                    if (n9 == -1) {
                        byteArrayOutputStream.write(byArray, n4, n5);
                        break;
                    }
                    if (n9 == 62) {
                        byteArrayOutputStream.write(byArray, n4, n5 - 1);
                        byteArrayOutputStream.write(byArray2);
                        break;
                    }
                    byteArrayOutputStream.write(byArray, n4, n5);
                    byteArrayOutputStream.write(n9);
                    break;
                }
                byteArrayOutputStream.write(byArray, n4, n5);
                break;
            }
            byteArrayOutputStream.write(byArray, n4, n7 - n4);
            byteArrayOutputStream.write(byArray2);
        }
        byteArrayOutputStream.close();
        this.buffer = byteArrayOutputStream.toByteArray();
        this.pos = 0;
    }

    private int indexOfEmptyElement(byte[] byArray, int n, int n2) {
        int n3 = n + n2 - 1;
        for (int i = n; i < n3; ++i) {
            if (byArray[i] != 47 || byArray[i + 1] != 62) continue;
            return i;
        }
        return -1;
    }
}

