/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import java.io.CharArrayWriter;
import java.io.FilterReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class EmptyElementReader
extends FilterReader {
    private Log log = LogFactory.getLog((Class)EmptyElementReader.class);
    private static final char[] EMPTY_SUFFIX = " empty=\"true\"/>".toCharArray();
    private char[] buffer;
    private int pos;

    public EmptyElementReader(Reader reader) {
        super(reader);
    }

    public int read() throws IOException {
        throw new IOException("Unsupported operation");
    }

    public int read(char[] cArray, int n, int n2) throws IOException {
        if (this.buffer == null || this.buffer.length - this.pos <= 0) {
            return this.readFromSource(cArray, n, n2);
        }
        return this.readFromBuffer(cArray, n, n2);
    }

    private int readFromBuffer(char[] cArray, int n, int n2) throws IOException {
        int n3 = this.buffer.length - this.pos;
        int n4 = n3 < n2 ? n3 : n2;
        System.arraycopy(this.buffer, this.pos, cArray, n, n4);
        this.pos += n4;
        return n4;
    }

    private int readFromSource(char[] cArray, int n, int n2) throws IOException {
        int n3 = super.read(cArray, n, n2);
        if (n3 <= 0) {
            return n3;
        }
        int n4 = this.indexOfEmptyElement(cArray, n, n3);
        if (n4 == -1) {
            int n5;
            if (cArray[n + n3 - 1] == '/' && (n5 = super.read()) != -1) {
                if (n5 == 62) {
                    this.buffer = EMPTY_SUFFIX;
                    this.pos = 0;
                    --n3;
                } else {
                    this.buffer = new char[]{(char)n5};
                    this.pos = 0;
                }
            }
            return n3;
        }
        if (n4 == 0) {
            this.initBuffer(cArray, n, n3, n4);
            System.arraycopy(this.buffer, 0, cArray, n, n3);
            this.pos = n3;
            return n3;
        }
        this.initBuffer(cArray, n, n3, n4);
        return n4 - n;
    }

    private void initBuffer(char[] cArray, int n, int n2, int n3) throws IOException {
        int n4;
        int n5;
        char[] cArray2 = EMPTY_SUFFIX;
        int n6 = n + n2;
        int n7 = n3;
        int n8 = n6 - n3 + cArray2.length * 4;
        CharArrayWriter charArrayWriter = new CharArrayWriter(n8);
        charArrayWriter.write(cArray2);
        while ((n5 = n6 - (n4 = n7 + 2)) != 0) {
            n7 = this.indexOfEmptyElement(cArray, n4, n5);
            if (n7 == -1) {
                char c = cArray[n4 + n5 - 1];
                if (c == '/') {
                    int n9 = super.read();
                    if (n9 == -1) {
                        charArrayWriter.write(cArray, n4, n5);
                        break;
                    }
                    if (n9 == 62) {
                        charArrayWriter.write(cArray, n4, n5 - 1);
                        charArrayWriter.write(cArray2);
                        break;
                    }
                    charArrayWriter.write(cArray, n4, n5);
                    charArrayWriter.write(n9);
                    break;
                }
                charArrayWriter.write(cArray, n4, n5);
                break;
            }
            charArrayWriter.write(cArray, n4, n7 - n4);
            charArrayWriter.write(cArray2);
        }
        charArrayWriter.close();
        this.buffer = charArrayWriter.toCharArray();
        this.pos = 0;
    }

    private int indexOfEmptyElement(char[] cArray, int n, int n2) {
        int n3 = n + n2 - 1;
        for (int i = n; i < n3; ++i) {
            if (cArray[i] != '/' || cArray[i + 1] != '>') continue;
            return i;
        }
        return -1;
    }
}

