/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.PlatformCodec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MiBinaryDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)MiBinaryDataSerializer.class);
    private static final int[] MONTH_DAYS = new int[]{0, 31, 59, 90, 120, 151, 181, 212, 243, 273, 304, 334, 365};
    private static final String CHARSET = "UTF-8";
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private Map columnIndexesMap = new HashMap();
    private byte[] buffer;

    public void setProperty(String string, Object object) {
    }

    public void writeData(OutputStream outputStream, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, CHARSET) : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            this.write(outputStream, platformData, dataTypeChanger);
        }
        catch (IOException iOException) {
            String string2 = "MiBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string2), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string2, iOException);
        }
    }

    public void writeData(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        String string2 = "MiBinary";
        throw new UnsupportedOperationException("Unsupported content type: " + string2);
    }

    private void write(OutputStream outputStream, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        DataOutputStream dataOutputStream = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
        int n = platformData.getDataSetCount();
        dataOutputStream.writeShort(n + 1);
        this.writeVariableList(dataOutputStream, platformData, dataTypeChanger);
        this.writeDataSetList(dataOutputStream, platformData, dataTypeChanger);
        dataOutputStream.flush();
    }

    private void writeVariableList(DataOutputStream dataOutputStream, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        VariableList variableList = platformData.getVariableList();
        int n = variableList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + n));
        }
        dataOutputStream.writeShort(65040);
        dataOutputStream.writeShort(4000);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeShort(n);
        for (int i = 0; i < n; ++i) {
            Variable variable = variableList.get(i);
            this.writeVariable(dataOutputStream2, variable, dataTypeChanger);
        }
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.writeLength(dataOutputStream, byArray.length);
        dataOutputStream.write(byArray);
    }

    private void writeVariable(DataOutputStream dataOutputStream, Variable variable, DataTypeChanger dataTypeChanger) throws IOException {
        String string = variable.getName();
        int n = variable.getType();
        byte[] byArray = string.getBytes(CHARSET);
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
        switch (n) {
            case 2: {
                this.writeValue(dataOutputStream, variable.getString());
                break;
            }
            case 3: {
                this.writeValue(dataOutputStream, variable.getInt());
                break;
            }
            case 4: {
                this.writeValue(dataOutputStream, variable.getBoolean());
                break;
            }
            case 5: {
                this.writeValue(dataOutputStream, variable.getLong());
                break;
            }
            case 6: {
                this.writeValue(dataOutputStream, variable.getFloat());
                break;
            }
            case 7: {
                this.writeValue(dataOutputStream, variable.getDouble());
                break;
            }
            case 8: {
                this.writeValue(dataOutputStream, variable.getString());
                break;
            }
            case 9: {
                this.writeValue(dataOutputStream, variable.getDateTime());
                break;
            }
            case 10: {
                this.writeValue(dataOutputStream, variable.getDateTime());
                break;
            }
            case 11: {
                this.writeValue(dataOutputStream, variable.getDateTime());
                break;
            }
            case 12: {
                this.writeValue(dataOutputStream, variable.getBlob());
                break;
            }
            case 13: {
                this.writeEmptyValue(dataOutputStream);
                break;
            }
            case 1: {
                this.writeEmptyValue(dataOutputStream);
                break;
            }
            default: {
                this.writeEmptyValue(dataOutputStream);
            }
        }
    }

    private void writeDataSetList(DataOutputStream dataOutputStream, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        DataSetList dataSetList = platformData.getDataSetList();
        int n = dataSetList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + n));
        }
        for (int i = 0; i < n; ++i) {
            DataSet dataSet = dataSetList.get(i);
            this.writeDataSet(dataOutputStream, platformData, dataSet, dataTypeChanger);
        }
    }

    private void writeDataSet(DataOutputStream dataOutputStream, PlatformData platformData, DataSet dataSet, DataTypeChanger dataTypeChanger) throws IOException {
        String string = dataSet.getName();
        String string2 = dataSet.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + (string != null ? URLEncoder.encode(string, CHARSET) : null) + ", alias=" + (string2 != null ? URLEncoder.encode(string2, CHARSET) : null) + ", columnCount=" + dataSet.getColumnCount() + ", rowCount=" + dataSet.getRowCount() + ", removedRowCount=" + dataSet.getRemovedRowCount()));
        }
        dataOutputStream.writeShort(65025);
        dataOutputStream.writeShort(4000);
        int[] nArray = this.getTargetDataTypes(dataSet, dataTypeChanger);
        this.writeColumnHeaders(dataOutputStream, dataSet, nArray);
        this.writeRows(dataOutputStream, platformData, dataSet, nArray);
        dataOutputStream.writeInt(0);
    }

    private void writeColumnHeaders(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray) throws IOException {
        String string = dataSet.getAlias();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = string.getBytes(CHARSET);
        dataOutputStream2.writeShort(byArray.length);
        dataOutputStream2.write(byArray);
        this.writeConstantColumnHeaders(dataOutputStream2, dataSet, nArray);
        this.writeDefaultColumnHeaders(dataOutputStream2, dataSet, nArray);
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.writeLength(dataOutputStream, byArray2.length);
        dataOutputStream.write(byArray2);
    }

    private void writeDefaultColumnHeaders(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray) throws IOException {
        ColumnHeader columnHeader;
        int n;
        int n2 = dataSet.getColumnCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            columnHeader = dataSet.getColumn(n);
            if (columnHeader.isConstant()) continue;
            ++n3;
        }
        dataOutputStream.writeShort(n3);
        for (n = 0; n < n2; ++n) {
            columnHeader = dataSet.getColumn(n);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            byte[] byArray = string.getBytes(CHARSET);
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            int n4 = nArray[n];
            int n5 = columnHeader.getDataSize();
            switch (n4) {
                case 2: {
                    dataOutputStream.writeShort(1);
                    break;
                }
                case 3: {
                    dataOutputStream.writeShort(2);
                    break;
                }
                case 4: {
                    dataOutputStream.writeShort(2);
                    break;
                }
                case 5: {
                    dataOutputStream.writeShort(5);
                    break;
                }
                case 6: {
                    dataOutputStream.writeShort(4);
                    break;
                }
                case 7: {
                    dataOutputStream.writeShort(4);
                    break;
                }
                case 8: {
                    dataOutputStream.writeShort(1);
                    break;
                }
                case 9: {
                    dataOutputStream.writeShort(8);
                    break;
                }
                case 10: {
                    dataOutputStream.writeShort(8);
                    break;
                }
                case 11: {
                    dataOutputStream.writeShort(8);
                    break;
                }
                case 12: {
                    dataOutputStream.writeShort(9);
                    break;
                }
                case 13: {
                    dataOutputStream.writeShort(9);
                    break;
                }
                case 1: {
                    dataOutputStream.writeShort(0);
                    break;
                }
                default: {
                    dataOutputStream.writeShort(0);
                }
            }
            dataOutputStream.writeShort(n5);
            dataOutputStream.writeShort(1);
        }
    }

    private void writeConstantColumnHeaders(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray) throws IOException {
        ColumnHeader columnHeader;
        int n;
        dataOutputStream.writeShort(65040);
        dataOutputStream.writeShort(4000);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        int n2 = dataSet.getColumnCount();
        int n3 = 0;
        for (n = 0; n < n2; ++n) {
            columnHeader = dataSet.getColumn(n);
            if (!columnHeader.isConstant()) continue;
            ++n3;
        }
        dataOutputStream2.writeShort(n3);
        block15: for (n = 0; n < n2; ++n) {
            columnHeader = dataSet.getColumn(n);
            if (!columnHeader.isConstant()) continue;
            ConstantColumnHeader constantColumnHeader = (ConstantColumnHeader)columnHeader;
            String string = constantColumnHeader.getName();
            byte[] byArray = string.getBytes(CHARSET);
            dataOutputStream2.writeShort(byArray.length);
            dataOutputStream2.write(byArray);
            int n4 = constantColumnHeader.getDataType();
            int n5 = nArray[n];
            if (n4 == 13) {
                this.writeValue(dataOutputStream2, constantColumnHeader.getStringValue(dataSet));
                continue;
            }
            if (n5 == 13) {
                n5 = n4;
            }
            switch (n5) {
                case 2: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getStringValue(dataSet));
                    continue block15;
                }
                case 3: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getIntValue(dataSet));
                    continue block15;
                }
                case 4: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getBooleanValue(dataSet));
                    continue block15;
                }
                case 5: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getLongValue(dataSet));
                    continue block15;
                }
                case 6: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getFloatValue(dataSet));
                    continue block15;
                }
                case 7: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getDoubleValue(dataSet));
                    continue block15;
                }
                case 8: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getStringValue(dataSet));
                    continue block15;
                }
                case 9: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getDateTimeValue(dataSet));
                    continue block15;
                }
                case 10: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getDateTimeValue(dataSet));
                    continue block15;
                }
                case 11: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getDateTimeValue(dataSet));
                    continue block15;
                }
                case 12: {
                    this.writeValue(dataOutputStream2, constantColumnHeader.getBlobValue(dataSet));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(dataOutputStream2);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(dataOutputStream2);
                }
            }
        }
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.writeLength(dataOutputStream, byArray.length);
        dataOutputStream.write(byArray);
    }

    private void writeRows(DataOutputStream dataOutputStream, PlatformData platformData, DataSet dataSet, int[] nArray) throws IOException {
        Object object;
        OutputStream outputStream;
        int n;
        boolean bl;
        int n2 = dataSet.getSaveType();
        if (n2 == 0) {
            n2 = platformData.getSaveType();
        }
        if (n2 == 0) {
            n2 = 2;
        }
        int n3 = dataSet.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + n3));
        }
        if (bl = dataSet.isCheckingGetterDataIndex()) {
            dataSet.setCheckingGetterDataIndex(false);
        }
        for (n = 0; n < n3; ++n) {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            outputStream = new DataOutputStream(byteArrayOutputStream);
            this.writeRow((DataOutputStream)outputStream, dataSet, nArray, n, n2);
            ((FilterOutputStream)outputStream).close();
            byteArrayOutputStream.close();
            object = byteArrayOutputStream.toByteArray();
            if (((byte[])object).length <= 0) continue;
            this.writeLength(dataOutputStream, ((byte[])object).length);
            dataOutputStream.write((byte[])object);
        }
        if (n2 == 1 || n2 == 4 || n2 == 5) {
            n = dataSet.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + n));
            }
            for (int i = 0; i < n; ++i) {
                outputStream = new ByteArrayOutputStream();
                object = new DataOutputStream(outputStream);
                this.writeRemovedRow((DataOutputStream)object, dataSet, nArray, i);
                ((FilterOutputStream)object).close();
                ((ByteArrayOutputStream)outputStream).close();
                byte[] byArray = ((ByteArrayOutputStream)outputStream).toByteArray();
                if (byArray.length <= 0) continue;
                this.writeLength(dataOutputStream, byArray.length);
                dataOutputStream.write(byArray);
            }
        }
        if (bl) {
            dataSet.setCheckingGetterDataIndex(true);
        }
    }

    private void writeRow(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray, int n, int n2) throws IOException {
        int n3 = dataSet.getRowType(n);
        if (n2 != 1 && (n2 == 2 ? n3 == 3 : (n2 == 3 ? n3 == 0 || n3 == 3 : (n2 == 4 ? n3 == 0 || n3 == 1 || n3 == 2 : n2 == 5 && n3 == 0)))) {
            return;
        }
        int[] nArray2 = this.getColumnIndexes(dataSet);
        int n4 = nArray2.length;
        if (n2 == 2) {
            dataOutputStream.writeShort(1);
        } else {
            switch (n3) {
                case 0: {
                    dataOutputStream.writeShort(1);
                    break;
                }
                case 1: {
                    dataOutputStream.writeShort(2);
                    break;
                }
                case 2: {
                    dataOutputStream.writeShort(4);
                    break;
                }
                case 3: {
                    dataOutputStream.writeShort(8);
                    break;
                }
                default: {
                    dataOutputStream.writeShort(1);
                }
            }
        }
        dataOutputStream.writeShort(n4);
        block21: for (int i = 0; i < n4; ++i) {
            int n5 = nArray2[i];
            int n6 = dataSet.getColumn(n5).getDataType();
            int n7 = nArray[n5];
            if (n6 == 13) {
                if (n7 == 2) {
                    this.writeStringFromFile(dataOutputStream, dataSet.getString(n, n5));
                    continue;
                }
                if (n7 == 12 || n7 == 13) {
                    this.writeBlobFromFile(dataOutputStream, dataSet.getString(n, n5));
                    continue;
                }
                this.writeEmptyValue(dataOutputStream);
                continue;
            }
            switch (n7) {
                case 2: {
                    this.writeValue(dataOutputStream, dataSet.getString(n, n5));
                    continue block21;
                }
                case 3: {
                    this.writeValue(dataOutputStream, dataSet.getInt(n, n5));
                    continue block21;
                }
                case 4: {
                    this.writeValue(dataOutputStream, dataSet.getBoolean(n, n5));
                    continue block21;
                }
                case 5: {
                    this.writeValue(dataOutputStream, dataSet.getLong(n, n5));
                    continue block21;
                }
                case 6: {
                    this.writeValue(dataOutputStream, dataSet.getFloat(n, n5));
                    continue block21;
                }
                case 7: {
                    this.writeValue(dataOutputStream, dataSet.getDouble(n, n5));
                    continue block21;
                }
                case 8: {
                    this.writeValue(dataOutputStream, dataSet.getString(n, n5));
                    continue block21;
                }
                case 9: {
                    this.writeValue(dataOutputStream, dataSet.getDateTime(n, n5));
                    continue block21;
                }
                case 10: {
                    this.writeValue(dataOutputStream, dataSet.getDateTime(n, n5));
                    continue block21;
                }
                case 11: {
                    this.writeValue(dataOutputStream, dataSet.getDateTime(n, n5));
                    continue block21;
                }
                case 12: {
                    this.writeValue(dataOutputStream, dataSet.getBlob(n, n5));
                    continue block21;
                }
                case 13: {
                    this.writeValue(dataOutputStream, dataSet.getBlob(n, n5));
                    continue block21;
                }
                case 1: {
                    this.writeEmptyValue(dataOutputStream);
                    continue block21;
                }
                default: {
                    this.writeEmptyValue(dataOutputStream);
                }
            }
        }
        if ((n2 == 1 || n2 == 3 || n2 == 5) && n3 == 2) {
            this.writeSavedRow(dataOutputStream, dataSet, nArray, n);
        }
    }

    private void writeSavedRow(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray, int n) throws IOException {
        int[] nArray2 = this.getColumnIndexes(dataSet);
        int n2 = nArray2.length;
        dataOutputStream.writeShort(0);
        block15: for (int i = 0; i < n2; ++i) {
            int n3 = nArray2[i];
            int n4 = dataSet.getColumn(n3).getDataType();
            int n5 = nArray[n3];
            if (n4 == 13) {
                if (n5 == 2) {
                    this.writeStringFromFile(dataOutputStream, dataSet.getSavedStringData(n, n3));
                    continue;
                }
                if (n5 == 12 || n5 == 13) {
                    this.writeBlobFromFile(dataOutputStream, dataSet.getSavedStringData(n, n3));
                    continue;
                }
                this.writeEmptyValue(dataOutputStream);
                continue;
            }
            switch (n5) {
                case 2: {
                    this.writeValue(dataOutputStream, dataSet.getSavedStringData(n, n3));
                    continue block15;
                }
                case 3: {
                    this.writeValue(dataOutputStream, dataSet.getSavedIntData(n, n3));
                    continue block15;
                }
                case 4: {
                    this.writeValue(dataOutputStream, dataSet.getSavedBooleanData(n, n3));
                    continue block15;
                }
                case 5: {
                    this.writeValue(dataOutputStream, dataSet.getSavedLongData(n, n3));
                    continue block15;
                }
                case 6: {
                    this.writeValue(dataOutputStream, dataSet.getSavedFloatData(n, n3));
                    continue block15;
                }
                case 7: {
                    this.writeValue(dataOutputStream, dataSet.getSavedDoubleData(n, n3));
                    continue block15;
                }
                case 8: {
                    this.writeValue(dataOutputStream, dataSet.getSavedStringData(n, n3));
                    continue block15;
                }
                case 9: {
                    this.writeValue(dataOutputStream, dataSet.getSavedDateTimeData(n, n3));
                    continue block15;
                }
                case 10: {
                    this.writeValue(dataOutputStream, dataSet.getSavedDateTimeData(n, n3));
                    continue block15;
                }
                case 11: {
                    this.writeValue(dataOutputStream, dataSet.getSavedDateTimeData(n, n3));
                    continue block15;
                }
                case 12: {
                    this.writeValue(dataOutputStream, dataSet.getSavedBlobData(n, n3));
                    continue block15;
                }
                case 13: {
                    this.writeValue(dataOutputStream, dataSet.getSavedBlobData(n, n3));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(dataOutputStream);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(dataOutputStream);
                }
            }
        }
    }

    private void writeRemovedRow(DataOutputStream dataOutputStream, DataSet dataSet, int[] nArray, int n) throws IOException {
        int[] nArray2 = this.getColumnIndexes(dataSet);
        int n2 = nArray2.length;
        dataOutputStream.writeShort(8);
        dataOutputStream.writeShort(n2);
        block15: for (int i = 0; i < n2; ++i) {
            int n3 = nArray2[i];
            int n4 = dataSet.getColumn(n3).getDataType();
            int n5 = nArray[n3];
            if (n4 == 13) {
                if (n5 == 2) {
                    this.writeStringFromFile(dataOutputStream, dataSet.getRemovedStringData(n, n3));
                    continue;
                }
                if (n5 == 12 || n5 == 13) {
                    this.writeBlobFromFile(dataOutputStream, dataSet.getRemovedStringData(n, n3));
                    continue;
                }
                this.writeEmptyValue(dataOutputStream);
                continue;
            }
            switch (n5) {
                case 2: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedStringData(n, n3));
                    continue block15;
                }
                case 3: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedIntData(n, n3));
                    continue block15;
                }
                case 4: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedBooleanData(n, n3));
                    continue block15;
                }
                case 5: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedLongData(n, n3));
                    continue block15;
                }
                case 6: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedFloatData(n, n3));
                    continue block15;
                }
                case 7: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedDoubleData(n, n3));
                    continue block15;
                }
                case 8: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedStringData(n, n3));
                    continue block15;
                }
                case 9: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedDateTimeData(n, n3));
                    continue block15;
                }
                case 10: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedDateTimeData(n, n3));
                    continue block15;
                }
                case 11: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedDateTimeData(n, n3));
                    continue block15;
                }
                case 12: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedBlobData(n, n3));
                    continue block15;
                }
                case 13: {
                    this.writeValue(dataOutputStream, dataSet.getRemovedBlobData(n, n3));
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(dataOutputStream);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(dataOutputStream);
                }
            }
        }
    }

    private void writeValue(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeShort(0);
        } else {
            String string2 = this.platformCodec.encode(string);
            dataOutputStream.writeShort(8);
            byte[] byArray = string2.getBytes(CHARSET);
            this.writeLength(dataOutputStream, byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    private void writeValue(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeShort(3);
        dataOutputStream.writeInt(n);
    }

    private void writeValue(DataOutputStream dataOutputStream, boolean bl) throws IOException {
        dataOutputStream.writeShort(3);
        int n = bl ? 1 : 0;
        dataOutputStream.writeInt(n);
    }

    private void writeValue(DataOutputStream dataOutputStream, long l) throws IOException {
        dataOutputStream.writeShort(6);
        int[] nArray = this.toInts(new BigDecimal(String.valueOf(l)));
        dataOutputStream.writeInt(nArray[0]);
        dataOutputStream.writeInt(nArray[1]);
    }

    private void writeValue(DataOutputStream dataOutputStream, float f) throws IOException {
        dataOutputStream.writeShort(5);
        dataOutputStream.writeDouble(f);
    }

    private void writeValue(DataOutputStream dataOutputStream, double d) throws IOException {
        dataOutputStream.writeShort(5);
        dataOutputStream.writeDouble(d);
    }

    private void writeValue(DataOutputStream dataOutputStream, Date date) throws IOException {
        if (date == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(7);
            double d = this.toDouble(date);
            dataOutputStream.writeDouble(d);
        }
    }

    private void writeValue(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        if (byArray == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(13);
            this.writeLength(dataOutputStream, byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    private void writeEmptyValue(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeStringFromFile(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeShort(0);
            return;
        } else {
            File file = new File(string);
            if (file.canRead()) {
                dataOutputStream.writeShort(8);
                int n = (int)file.length();
                this.writeLength(dataOutputStream, n);
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = this.getBuffer();
                try {
                    int n2;
                    while ((n2 = fileInputStream.read(byArray)) != -1) {
                        dataOutputStream.write(byArray, 0, n2);
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)("Load data from file: file=" + file));
                    return;
                }
                finally {
                    fileInputStream.close();
                }
            } else {
                dataOutputStream.writeShort(0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void writeBlobFromFile(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeShort(0);
            return;
        } else {
            File file = new File(string);
            if (file.canRead()) {
                dataOutputStream.writeShort(13);
                int n = (int)file.length();
                this.writeLength(dataOutputStream, n);
                FileInputStream fileInputStream = new FileInputStream(file);
                byte[] byArray = this.getBuffer();
                try {
                    int n2;
                    while ((n2 = fileInputStream.read(byArray)) != -1) {
                        dataOutputStream.write(byArray, 0, n2);
                    }
                    if (!this.log.isDebugEnabled()) return;
                    this.log.debug((Object)("Load data from file: file=" + file));
                    return;
                }
                finally {
                    fileInputStream.close();
                }
            } else {
                dataOutputStream.writeShort(0);
            }
        }
    }

    private void writeLength(DataOutputStream dataOutputStream, int n) throws IOException {
        if (n < 32768) {
            dataOutputStream.writeShort(n);
        } else {
            dataOutputStream.writeInt(n | Integer.MIN_VALUE);
        }
    }

    private int[] getTargetDataTypes(DataSet dataSet, DataTypeChanger dataTypeChanger) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (dataTypeChanger == null) {
                nArray[i] = columnHeader.getDataType();
                continue;
            }
            String string = dataSet.getAlias();
            String string2 = columnHeader.getName();
            int n2 = columnHeader.getDataType();
            nArray[i] = dataTypeChanger.getDataType(string, string2, n2);
        }
        return nArray;
    }

    private int[] getColumnIndexes(DataSet dataSet) {
        String string = dataSet.getName() + "@" + dataSet.hashCode();
        int[] nArray = (int[])this.columnIndexesMap.get(string);
        if (nArray == null) {
            nArray = this.sortColumnIndexes(dataSet);
            this.columnIndexesMap.put(string, nArray);
        }
        return nArray;
    }

    private int[] sortColumnIndexes(DataSet dataSet) {
        int n;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = dataSet.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            object = dataSet.getColumn(i);
            if (((ColumnHeader)object).isConstant()) continue;
            arrayList.add(((ColumnHeader)object).getName());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        object = arrayList.iterator();
        block1: while (object.hasNext()) {
            String string = (String)object.next();
            int n3 = arrayList2.size();
            for (n = 0; n < n3; ++n) {
                String string2 = (String)arrayList2.get(n);
                if (string.compareToIgnoreCase(string2) >= 0) continue;
                arrayList2.add(n, string);
                continue block1;
            }
            arrayList2.add(string);
        }
        int n4 = arrayList2.size();
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = dataSet.indexOfColumn(arrayList2.get(n).toString());
        }
        return nArray;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }

    private int[] toInts(BigDecimal bigDecimal) {
        int[] nArray = new int[2];
        String string = bigDecimal.scale() == 4 ? bigDecimal.toString() : bigDecimal.setScale(4, 4).toString();
        int n = string.indexOf(46);
        if (n >= 0) {
            string = string.substring(0, n) + string.substring(n + 1, string.length());
        }
        long l = Long.parseLong(string);
        nArray[0] = (int)(l >> 32);
        nArray[1] = (int)(0xFFFFFFFFL & l);
        return nArray;
    }

    private double toDouble(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        int n4 = calendar.get(11);
        int n5 = calendar.get(12);
        int n6 = calendar.get(13);
        return this.toDouble(n, n2, n3, n4, n5, n6);
    }

    private double toDouble(int n, int n2, int n3, int n4, int n5, int n6) {
        boolean bl = (n & 3) == 0 && (n % 100 != 0 || n % 400 == 0);
        long l = (long)n * 365L + (long)(n / 4) - (long)(n / 100) + (long)(n / 400) + (long)MONTH_DAYS[n2 - 1] + (long)n3;
        if (n2 <= 2 && bl) {
            --l;
        }
        double d = (double)((long)n4 * 3600L + (long)n5 * 60L + (long)n6) / 86400.0;
        return (double)l + (l >= 0L ? d : -d);
    }
}

