/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.Base64;
import com.nexacro.xapi.tx.impl.EmptyElementInputStream;
import com.nexacro.xapi.tx.impl.EmptyElementReader;
import com.nexacro.xapi.util.SequenceReader;
import com.nexacro.xapi.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class MiXmlDataDeserializer
extends DefaultHandler
implements DataDeserializer {
    private Log log = LogFactory.getLog((Class)MiXmlDataDeserializer.class);
    private static final boolean CHECK_EMPTY_ELEMENT = true;
    private static final String PREFIX_FILE = "xapi_";
    private static final String SUFFIX_FILE = ".tmp";
    private static final int INDEX_UNDEFINED = 0;
    private static final int INDEX_VARIABLE = 1;
    private static final int INDEX_COLUMN_HEADER = 2;
    private static final int INDEX_CONSTANT_COLUMN_HEADER = 3;
    private static final int INDEX_DATA_ROW = 4;
    private static final int INDEX_DATA_CELL = 5;
    private static final int INDEX_SAVED_DATA_ROW = 6;
    private static final int INDEX_SAVED_DATA_CELL = 7;
    private int index;
    private PlatformData data;
    private Variable var;
    private DataSet ds;
    private int[] dataTypes;
    private boolean isStoreDataChanges;
    private boolean isCheckingSetterDataIndex;
    private ColumnHeader header;
    private String rowType;
    private String name;
    private StringBuffer value = new StringBuffer();
    private boolean isEmpty;
    private DataTypeChanger dataTypeChanger;

    public void setProperty(String string, Object object) {
    }

    public PlatformData readData(InputStream inputStream, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Reading data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            byte[] byArray = this.readHeader(inputStream);
            String string2 = this.findEncoding(byArray);
            if (string2 == null) {
                string2 = string;
            }
            InputStream inputStream2 = inputStream;
            inputStream2 = new EmptyElementInputStream(inputStream);
            inputStream2 = new BufferedInputStream(inputStream2);
            SequenceInputStream sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(byArray), inputStream2);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)sequenceInputStream, string2);
            InputSource inputSource = new InputSource(inputStreamReader);
            inputSource.setEncoding(string2);
            return this.read(inputSource, dataTypeChanger);
        }
        catch (IOException iOException) {
            String string3 = "MiXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string3), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string3, iOException);
        }
    }

    public PlatformData readData(Reader reader, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Reading data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        Reader reader2 = null;
        try {
            char[] cArray = this.readHeader(reader);
            String string2 = this.findEncoding(cArray);
            reader2 = reader;
            reader2 = new EmptyElementReader(reader);
            reader2 = new BufferedReader(reader2);
            SequenceReader sequenceReader = new SequenceReader(new CharArrayReader(cArray), reader2);
            InputSource inputSource = new InputSource(sequenceReader);
            if (string2 == null) {
                inputSource.setEncoding(string);
            } else {
                inputSource.setEncoding(string2);
            }
            PlatformData platformData = this.read(inputSource, dataTypeChanger);
            return platformData;
        }
        catch (IOException iOException) {
            String string3 = "MiXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string3), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string3, iOException);
        }
        finally {
            if (reader2 != null) {
                try {
                    reader2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private PlatformData read(InputSource inputSource, DataTypeChanger dataTypeChanger) throws IOException, PlatformException {
        try {
            this.dataTypeChanger = dataTypeChanger;
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
            sAXParserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            sAXParserFactory.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)this);
            return this.getData();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "MiXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)parserConfigurationException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = "MiXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)sAXException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, sAXException);
        }
    }

    private byte[] readHeader(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            n = inputStream.read();
            byteArrayOutputStream.write(n);
        } while (n != -1 && n != 62);
        return byteArrayOutputStream.toByteArray();
    }

    private char[] readHeader(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        do {
            n = reader.read();
            charArrayWriter.write(n);
        } while (n != -1 && n != 62);
        return charArrayWriter.toCharArray();
    }

    private String findEncoding(byte[] byArray) {
        return this.findEncoding(new String(byArray));
    }

    private String findEncoding(char[] cArray) {
        return this.findEncoding(new String(cArray));
    }

    private String findEncoding(String string) {
        String string2;
        int n;
        int n2;
        int n3;
        int n4 = string.indexOf("encoding");
        if (n4 != -1 && (n3 = string.indexOf(61, n4 + 8)) != -1 && (n2 = string.indexOf(34, n3 + 1)) != -1 && (n = string.indexOf(34, ++n2)) != -1 && (string2 = string.substring(n2, n).trim()).length() > 0) {
            return string2;
        }
        return null;
    }

    PlatformData getData() {
        return this.data;
    }

    void setData(PlatformData platformData) {
        this.data = platformData;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("record".equals(string3)) {
            if (this.dataTypes == null) {
                this.dataTypes = this.getSourceDataTypes(this.ds, this.dataTypeChanger);
            }
            this.rowType = attributes.getValue("type");
            this.ds.newRow();
            this.index = 4;
        } else if ("org_record".equals(string3)) {
            this.index = 6;
        } else if ("colinfo".equals(string3)) {
            this.header = this.createColumnHeader(attributes);
            this.index = 2;
        } else if ("param".equals(string3)) {
            String string4 = attributes.getValue("id");
            int n = this.toDataType(attributes.getValue("type"));
            this.isEmpty = "true".equals(attributes.getValue("empty"));
            this.var = new Variable(string4, n);
            this.index = 1;
        } else if ("column".equals(string3)) {
            this.header = this.createColumnHeader(attributes);
            this.isEmpty = "true".equals(attributes.getValue("empty"));
            this.index = 3;
        } else if ("dataset".equals(string3)) {
            String string5 = attributes.getValue("id");
            this.ds = new DataSet(string5);
            this.isStoreDataChanges = this.ds.isStoreDataChanges();
            this.isCheckingSetterDataIndex = this.ds.isCheckingSetterDataIndex();
            if (this.isStoreDataChanges) {
                this.ds.stopStoreDataChanges();
            }
            if (this.isCheckingSetterDataIndex) {
                this.ds.setCheckingSetterDataIndex(false);
            }
        } else if (!"params".equals(string3)) {
            if ("root".equals(string3)) {
                this.data = new PlatformData();
            } else {
                if (this.index == 4) {
                    this.name = string3;
                    this.index = 5;
                } else if (this.index == 6) {
                    this.name = string3;
                    this.index = 7;
                }
                this.isEmpty = "true".equals(attributes.getValue("empty"));
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if (string3.equals(this.name)) {
            if (this.index == 5) {
                if (!this.isEmpty) {
                    int n = this.ds.indexOfColumn(this.name);
                    int n2 = this.dataTypes[n];
                    int n3 = this.ds.getColumn(n).getDataType();
                    if (n3 == 13) {
                        if (n2 == 2 || n2 == 12) {
                            try {
                                File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                                this.writeValueToFile(Base64.decode(this.value.toString()), file);
                                this.ds.set(this.ds.getRowCount() - 1, this.name, file.getAbsolutePath());
                            }
                            catch (IOException iOException) {
                                int n4 = this.ds.getRowCount() - 1;
                                if (this.log.isErrorEnabled()) {
                                    this.log.error((Object)("Could not save: rowIndex=" + n4 + ", columnIndex=" + n), (Throwable)iOException);
                                }
                            }
                        }
                    } else if (DataTypes.isBinary(n2)) {
                        this.ds.set(this.ds.getRowCount() - 1, this.name, Base64.decode(this.value.toString()));
                    } else {
                        this.ds.set(this.ds.getRowCount() - 1, this.name, this.value.toString());
                    }
                }
                this.index = 4;
            } else if (this.index == 7) {
                if (!this.isEmpty) {
                    int n = this.ds.indexOfColumn(this.name);
                    int n5 = this.dataTypes[n];
                    int n6 = this.ds.getColumn(n).getDataType();
                    if (n6 == 13) {
                        if (n5 == 2 || n5 == 12) {
                            try {
                                File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                                this.writeValueToFile(Base64.decode(this.value.toString()), file);
                                this.ds.setSavedData(this.ds.getRowCount() - 1, this.name, (Object)file.getAbsolutePath());
                            }
                            catch (IOException iOException) {
                                int n7 = this.ds.getRowCount() - 1;
                                if (this.log.isErrorEnabled()) {
                                    this.log.error((Object)("Could not save: rowIndex=" + n7 + ", columnIndex=" + n), (Throwable)iOException);
                                }
                            }
                        }
                    } else if (DataTypes.isBinary(n5)) {
                        this.ds.setSavedData(this.ds.getRowCount() - 1, this.name, (Object)Base64.decode(this.value.toString()));
                    } else {
                        this.ds.setSavedData(this.ds.getRowCount() - 1, this.name, (Object)this.value.toString());
                    }
                }
                this.index = 6;
            }
            this.name = null;
            this.value.setLength(0);
            this.isEmpty = false;
        } else if ("record".equals(string3)) {
            if ("insert".equals(this.rowType)) {
                this.ds.setRowType(this.ds.getRowCount() - 1, 1);
            } else if ("update".equals(this.rowType)) {
                this.ds.setRowType(this.ds.getRowCount() - 1, 2);
            } else if ("delete".equals(this.rowType)) {
                this.ds.setRowType(this.ds.getRowCount() - 1, 3);
            } else {
                this.ds.setRowType(this.ds.getRowCount() - 1, 0);
            }
            this.index = 0;
        } else if ("org_record".equals(string3)) {
            this.index = 4;
        } else if ("colinfo".equals(string3)) {
            this.ds.addColumn(this.header);
            this.header = null;
            this.index = 0;
        } else if ("param".equals(string3)) {
            if (!this.isEmpty) {
                this.var.set(this.value.toString());
            }
            this.data.addVariable(this.var);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding Variable: " + this.var));
            }
            this.var = null;
            this.value.setLength(0);
            this.isEmpty = false;
            this.index = 0;
        } else if ("column".equals(string3)) {
            String string4 = this.header.getName();
            int n = this.header.getDataType();
            int n8 = this.header.getDataSize();
            Object object = null;
            if (!this.isEmpty) {
                object = this.value.toString();
                if (DataTypes.isBinary(n)) {
                    object = Base64.decode((String)object);
                }
            }
            this.ds.addConstantColumn(string4, n, n8, object);
            this.header = null;
            this.value.setLength(0);
            this.isEmpty = false;
            this.index = 0;
        } else if ("dataset".equals(string3)) {
            if (this.isStoreDataChanges) {
                this.ds.startStoreDataChanges(true);
            }
            if (this.isCheckingSetterDataIndex) {
                this.ds.setCheckingSetterDataIndex(true);
            }
            this.data.addDataSet(this.ds);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Adding DataSet: " + this.ds));
            }
            this.dataTypes = null;
            this.ds = null;
            this.index = 0;
        } else if ("params".equals(string3)) {
            this.index = 0;
        } else if ("root".equals(string3)) {
            this.index = 0;
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.index == 1 || this.index == 3 || this.index == 5 || this.index == 7) {
            this.value.append(cArray, n, n2);
        }
    }

    private ColumnHeader createColumnHeader(Attributes attributes) {
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("type");
        String string3 = attributes.getValue("size");
        int n = this.toDataType(string2);
        int n2 = StringUtils.toInt(string3, DataTypes.getDefaultSize(n));
        return new ColumnHeader(string, n, n2);
    }

    private int[] getSourceDataTypes(DataSet dataSet, DataTypeChanger dataTypeChanger) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            String string;
            String string2;
            int n2;
            int n3;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            nArray[i] = n3 = columnHeader.getDataType();
            if (dataTypeChanger == null || (n2 = dataTypeChanger.getDataType(string2 = dataSet.getAlias(), string = columnHeader.getName(), n3)) == n3) continue;
            int n4 = columnHeader.getDataSize();
            if (columnHeader.isConstant()) {
                if (n2 == 13) continue;
                object = ((ConstantColumnHeader)columnHeader).getValue();
                ConstantColumnHeader constantColumnHeader = new ConstantColumnHeader(string, object, n2, n4);
                dataSet.setColumn(i, constantColumnHeader);
                continue;
            }
            object = new ColumnHeader(string, n2, n4);
            dataSet.setColumn(i, (ColumnHeader)object);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeValueToFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            fileOutputStream.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving data to file: file=" + file));
        }
    }

    private int toDataType(String string) {
        if (string == null) {
            return 2;
        }
        if ("STRING".equals(string)) {
            return 2;
        }
        if ("INT".equals(string)) {
            return 3;
        }
        if ("DECIMAL".equals(string)) {
            return 7;
        }
        if ("CURRENCY".equals(string)) {
            return 8;
        }
        if ("DATE".equals(string)) {
            return 11;
        }
        if ("BLOB".equals(string)) {
            return 12;
        }
        if ("URL".equals(string)) {
            return 2;
        }
        if ("LONG".equals(string)) {
            return 2;
        }
        if ("CHAR".equals(string)) {
            return 2;
        }
        if ("FILE".equals(string)) {
            return 12;
        }
        if ("UNKNOWN".equals(string)) {
            return 2;
        }
        if ("EMPTY".equals(string)) {
            return 2;
        }
        return 2;
    }
}

