/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.Base64;
import com.nexacro.xapi.tx.impl.PlatformCodec;
import com.nexacro.xapi.tx.impl.XmlCodec;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MiXmlDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog((Class)MiXmlDataSerializer.class);
    private static final boolean NULL_IS_SINGLE_TAG = true;
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final int BUFFER_SIZE = 4096;
    private PlatformCodec platformCodec = new PlatformCodec();
    private XmlCodec xmlCodec = new XmlCodec();
    private byte[] buffer;

    public void setProperty(String string, Object object) {
    }

    public void writeData(OutputStream outputStream, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            this.writeData(new OutputStreamWriter(outputStream, string), platformData, dataTypeChanger, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)"Unsupported charset: ", (Throwable)unsupportedEncodingException);
            }
            throw new PlatformException("Unsupported charset: " + string, unsupportedEncodingException);
        }
    }

    public void writeData(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Writing data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        try {
            this.write(writer, platformData, dataTypeChanger, string);
        }
        catch (IOException iOException) {
            String string2 = "MiXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string2), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string2, iOException);
        }
    }

    private void write(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws IOException {
        int n = 0;
        this.writeHeader(writer, platformData, string, n);
        this.writeBeginRoot(writer, n);
        this.writeVariableList(writer, platformData, dataTypeChanger, ++n);
        this.writeDataSetList(writer, platformData, dataTypeChanger, n--);
        this.writeEndRoot(writer, n);
        writer.flush();
    }

    private void writeHeader(Writer writer, PlatformData platformData, String string, int n) throws IOException {
        if (string == null) {
            this.writeString(writer, "<?xml version=\"1.0\"?>", n);
        } else {
            this.writeString(writer, "<?xml version=\"1.0\" encoding=\"" + string + "\"?>", n);
        }
    }

    private void writeBeginRoot(Writer writer, int n) throws IOException {
        this.writeString(writer, "<root>", n);
    }

    private void writeEndRoot(Writer writer, int n) throws IOException {
        this.writeString(writer, "</root>", n);
    }

    private void writeVariableList(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger, int n) throws IOException {
        VariableList variableList = platformData.getVariableList();
        int n2 = variableList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + n2));
        }
        if (n2 == 0) {
            this.writeString(writer, "<params/>", n);
        } else {
            this.writeString(writer, "<params>", n++);
            for (int i = 0; i < n2; ++i) {
                this.writeVariable(writer, variableList.get(i), dataTypeChanger, n);
            }
            this.writeString(writer, "</params>", --n);
        }
    }

    private void writeVariable(Writer writer, Variable variable, DataTypeChanger dataTypeChanger, int n) throws IOException {
        if (DataTypes.isBinary(variable.getType())) {
            this.writeBinaryVariable(writer, variable, n);
        } else {
            this.writeStringVariable(writer, variable, n);
        }
    }

    private void writeStringVariable(Writer writer, Variable variable, int n) throws IOException {
        String string = variable.getName();
        String string2 = this.toMiType(variable.getType());
        String string3 = this.getStringValue(variable);
        int n2 = string3 == null ? 0 : string3.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 64);
        stringBuffer.append("<param id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        if (string3 == null) {
            stringBuffer.append("\"/>");
        } else {
            stringBuffer.append("\">").append(string3);
            stringBuffer.append("</param>");
        }
        this.writeString(writer, stringBuffer.toString(), n);
    }

    private void writeBinaryVariable(Writer writer, Variable variable, int n) throws IOException {
        String string = variable.getName();
        String string2 = this.toMiType(variable.getType());
        byte[] byArray = this.getBinaryValue(variable);
        if (byArray == null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("<param id=\"").append(string);
            stringBuffer.append("\" type=\"").append(string2);
            stringBuffer.append("\"/>");
            this.writeString(writer, stringBuffer.toString(), n);
        } else {
            String string3 = "<param id=\"" + string + "\" type=\"" + string2 + "\" encrypt=\"base64\">";
            String string4 = "</param>";
            this.writeBinary(writer, byArray, string3, string4, n);
        }
    }

    private String getStringValue(Variable variable) {
        int n = variable.getType();
        if (n == 4) {
            return variable.getBoolean() ? "1" : "0";
        }
        String string = variable.getString();
        if (string == null) {
            return string;
        }
        if (n == 2) {
            return this.encode(string);
        }
        return string;
    }

    private byte[] getBinaryValue(Variable variable) {
        return variable.getBlob();
    }

    private void writeDataSetList(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger, int n) throws IOException {
        DataSetList dataSetList = platformData.getDataSetList();
        int n2 = dataSetList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + n2));
        }
        for (int i = 0; i < n2; ++i) {
            this.writeDataSet(writer, platformData, dataSetList.get(i), dataTypeChanger, n);
        }
    }

    private void writeDataSet(Writer writer, PlatformData platformData, DataSet dataSet, DataTypeChanger dataTypeChanger, int n) throws IOException {
        String string = dataSet.getName();
        String string2 = dataSet.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", alias=" + (string2 != null ? URLEncoder.encode(string2, "UTF-8") : null) + ", columnCount=" + dataSet.getColumnCount() + ", rowCount=" + dataSet.getRowCount() + ", removedRowCount=" + dataSet.getRemovedRowCount()));
        }
        this.writeString(writer, "<dataset id=\"" + string2 + "\">", n);
        int[] nArray = this.getTargetDataTypes(dataSet, dataTypeChanger);
        this.writeColumns(writer, dataSet, nArray, ++n);
        this.writeRows(writer, platformData, dataSet, nArray, n--);
        this.writeString(writer, "</dataset>", n);
    }

    private void writeColumns(Writer writer, DataSet dataSet, int[] nArray, int n) throws IOException {
        int n2;
        ColumnHeader columnHeader;
        int n3;
        int n4 = dataSet.getColumnCount();
        for (n3 = 0; n3 < n4; ++n3) {
            columnHeader = dataSet.getColumn(n3);
            if (columnHeader.getType() == 0) continue;
            if (columnHeader.getType() == 1) {
                n2 = nArray[n3];
                this.writeConstantColumnHeader(writer, dataSet, columnHeader, n2, n);
                continue;
            }
            throw new IOException("Invalid column type: " + columnHeader.getType());
        }
        for (n3 = 0; n3 < n4; ++n3) {
            columnHeader = dataSet.getColumn(n3);
            if (columnHeader.getType() != 0) continue;
            n2 = nArray[n3];
            this.writeDefaultColumnHeader(writer, columnHeader, n2, n);
        }
    }

    private void writeDefaultColumnHeader(Writer writer, ColumnHeader columnHeader, int n, int n2) throws IOException {
        String string = columnHeader.getName();
        String string2 = this.toMiType(n);
        int n3 = columnHeader.getDataSize();
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("<colinfo id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        stringBuffer.append("\" size=\"").append(n3);
        if (n == 13 || DataTypes.isBinary(n)) {
            stringBuffer.append("\" encrypt=\"").append("base64");
        }
        stringBuffer.append("\"/>");
        this.writeString(writer, stringBuffer.toString(), n2);
    }

    private void writeConstantColumnHeader(Writer writer, DataSet dataSet, ColumnHeader columnHeader, int n, int n2) throws IOException {
        if (DataTypes.isBinary(columnHeader.getDataType())) {
            this.writeBinaryColumnHeader(writer, dataSet, (ConstantColumnHeader)columnHeader, n, n2);
        } else {
            this.writeStringColumnHeader(writer, dataSet, (ConstantColumnHeader)columnHeader, n, n2);
        }
    }

    private void writeStringColumnHeader(Writer writer, DataSet dataSet, ConstantColumnHeader constantColumnHeader, int n, int n2) throws IOException {
        if (n == 13) {
            n = 2;
        }
        String string = constantColumnHeader.getName();
        String string2 = this.toMiType(n);
        int n3 = constantColumnHeader.getDataSize();
        String string3 = this.getStringValue(dataSet, constantColumnHeader);
        int n4 = string3 == null ? 0 : string3.length();
        StringBuffer stringBuffer = new StringBuffer(n4 + 64);
        stringBuffer.append("<column id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        stringBuffer.append("\" size=\"").append(n3);
        if (string3 == null) {
            stringBuffer.append("\"/>");
        } else {
            stringBuffer.append("\">").append(string3);
            stringBuffer.append("</column>");
        }
        this.writeString(writer, stringBuffer.toString(), n2);
    }

    private void writeBinaryColumnHeader(Writer writer, DataSet dataSet, ConstantColumnHeader constantColumnHeader, int n, int n2) throws IOException {
        String string = constantColumnHeader.getName();
        String string2 = this.toMiType(n);
        int n3 = constantColumnHeader.getDataSize();
        byte[] byArray = this.getBinaryValue(dataSet, constantColumnHeader);
        if (byArray == null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("<column id=\"").append(string);
            stringBuffer.append("\" type=\"").append(string2);
            stringBuffer.append("\" size=\"").append(n3);
            stringBuffer.append("\"/>");
            this.writeString(writer, stringBuffer.toString(), n2);
        } else {
            String string3 = "<column id=\"" + string + "\" type=\"" + string2 + "\" size=\"" + n3 + "\" encrypt=\"base64\">";
            String string4 = "</column>";
            this.writeBinary(writer, byArray, string3, string4, n2);
        }
    }

    private String getStringValue(DataSet dataSet, ConstantColumnHeader constantColumnHeader) {
        int n = constantColumnHeader.getDataType();
        if (n == 4) {
            return constantColumnHeader.getBooleanValue(dataSet) ? "1" : "0";
        }
        String string = constantColumnHeader.getStringValue(dataSet);
        if (string == null) {
            return string;
        }
        if (n == 2) {
            return this.encode(string);
        }
        return string;
    }

    private byte[] getBinaryValue(DataSet dataSet, ConstantColumnHeader constantColumnHeader) {
        return constantColumnHeader.getBlobValue(dataSet);
    }

    private void writeRows(Writer writer, PlatformData platformData, DataSet dataSet, int[] nArray, int n) throws IOException {
        int n2;
        boolean bl;
        int n3 = dataSet.getSaveType();
        if (n3 == 0) {
            n3 = platformData.getSaveType();
        }
        if (n3 == 0) {
            n3 = 2;
        }
        int n4 = dataSet.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + n4));
        }
        if (bl = dataSet.isCheckingGetterDataIndex()) {
            dataSet.setCheckingGetterDataIndex(false);
        }
        for (n2 = 0; n2 < n4; ++n2) {
            this.writeRow(writer, dataSet, nArray, n2, n3, n);
        }
        if (n3 == 1 || n3 == 4 || n3 == 5) {
            n2 = dataSet.getRemovedRowCount();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing removed rows: removedCount=" + n2));
            }
            for (int i = 0; i < n2; ++i) {
                this.writeRemovedRow(writer, dataSet, nArray, i, n);
            }
        }
        if (bl) {
            dataSet.setCheckingGetterDataIndex(true);
        }
    }

    private void writeRow(Writer writer, DataSet dataSet, int[] nArray, int n, int n2, int n3) throws IOException {
        int n4 = dataSet.getRowType(n);
        if (n2 != 1 && (n2 == 2 ? n4 == 3 : (n2 == 3 ? n4 == 0 || n4 == 3 : (n2 == 4 ? n4 == 0 || n4 == 1 || n4 == 2 : n2 == 5 && n4 == 0)))) {
            return;
        }
        if (n2 == 2) {
            this.writeString(writer, "<record>", n3++);
        } else if (n4 == 1) {
            this.writeString(writer, "<record type=\"insert\">", n3++);
        } else if (n4 == 2) {
            this.writeString(writer, "<record type=\"update\">", n3++);
        } else if (n4 == 3) {
            this.writeString(writer, "<record type=\"delete\">", n3++);
        } else {
            this.writeString(writer, "<record>", n3++);
        }
        int n5 = dataSet.getColumnCount();
        for (int i = 0; i < n5; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            int n6 = columnHeader.getDataType();
            int n7 = nArray[i];
            if (n7 == 13 || DataTypes.isBinary(n7)) {
                byte[] byArray = object = n6 == 13 ? this.getBinaryValueFromFile(dataSet, n, i, n7) : this.getBinaryValue(dataSet, n, i);
                if (object == null) {
                    this.writeString(writer, "<" + string + "/>", n3);
                    continue;
                }
                String string2 = "<" + string + ">";
                String string3 = "</" + string + ">";
                this.writeBinary(writer, (byte[])object, string2, string3, n3);
                continue;
            }
            object = n6 == 13 ? this.getStringValueFromFile(dataSet, n, i, n7) : this.getStringValue(dataSet, n, i);
            if (object == null) {
                this.writeString(writer, "<" + string + "/>", n3);
                continue;
            }
            this.writeString(writer, "<" + string + ">" + (String)object + "</" + string + ">", n3);
        }
        if ((n2 == 1 || n2 == 3 || n2 == 5) && n4 == 2) {
            this.writeSavedRow(writer, dataSet, nArray, n, n3);
        }
        this.writeString(writer, "</record>", --n3);
    }

    private void writeSavedRow(Writer writer, DataSet dataSet, int[] nArray, int n, int n2) throws IOException {
        this.writeString(writer, "<org_record>", n2++);
        int n3 = dataSet.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            int n4 = columnHeader.getDataType();
            int n5 = nArray[i];
            if (n5 == 13 || DataTypes.isBinary(n5)) {
                byte[] byArray = object = n4 == 13 ? this.getSavedBinaryValueFromFile(dataSet, n, i, n5) : this.getSavedBinaryValue(dataSet, n, i);
                if (object == null) {
                    this.writeString(writer, "<" + string + "/>", n2);
                    continue;
                }
                String string2 = "<" + string + ">";
                String string3 = "</" + string + ">";
                this.writeBinary(writer, (byte[])object, string2, string3, n2);
                continue;
            }
            object = n4 == 13 ? this.getSavedStringValueFromFile(dataSet, n, i, n5) : this.getSavedStringValue(dataSet, n, i);
            if (object == null) {
                this.writeString(writer, "<" + string + "/>", n2);
                continue;
            }
            this.writeString(writer, "<" + string + ">" + (String)object + "</" + string + ">", n2);
        }
        this.writeString(writer, "</org_record>", --n2);
    }

    private void writeRemovedRow(Writer writer, DataSet dataSet, int[] nArray, int n, int n2) throws IOException {
        this.writeString(writer, "<record type=\"delete\">", n2++);
        int n3 = dataSet.getColumnCount();
        for (int i = 0; i < n3; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            String string = columnHeader.getName();
            int n4 = columnHeader.getDataType();
            int n5 = nArray[i];
            if (n5 == 13 || DataTypes.isBinary(n5)) {
                byte[] byArray = object = n4 == 13 ? this.getRemovedBinaryValueFromFile(dataSet, n, i, n5) : this.getRemovedBinaryValue(dataSet, n, i);
                if (object == null) {
                    this.writeString(writer, "<" + string + "/>", n2);
                    continue;
                }
                String string2 = "<" + string + ">";
                String string3 = "</" + string + ">";
                this.writeBinary(writer, (byte[])object, string2, string3, n2);
                continue;
            }
            object = n4 == 13 ? this.getRemovedStringValueFromFile(dataSet, n, i, n5) : this.getRemovedStringValue(dataSet, n, i);
            if (object == null) {
                this.writeString(writer, "<" + string + "/>", n2);
                continue;
            }
            this.writeString(writer, "<" + string + ">" + (String)object + "</" + string + ">", n2);
        }
        this.writeString(writer, "</record>", --n2);
    }

    private String getStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getBoolean(n, n2) ? "1" : "0";
        }
        String string = dataSet.getString(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    private byte[] getBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getBlob(n, n2);
    }

    private String getStringValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 2) {
            String string = dataSet.getString(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray == null ? null : this.encode(new String(byArray));
        }
        return null;
    }

    private byte[] getBinaryValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 12 || n3 == 13) {
            String string = dataSet.getString(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray;
        }
        return null;
    }

    private String getSavedStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getSavedBooleanData(n, n2) ? "1" : "0";
        }
        String string = dataSet.getSavedStringData(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    private byte[] getSavedBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getSavedBlobData(n, n2);
    }

    private String getSavedStringValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 2) {
            String string = dataSet.getSavedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray == null ? null : this.encode(new String(byArray));
        }
        return null;
    }

    private byte[] getSavedBinaryValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 12 || n3 == 13) {
            String string = dataSet.getSavedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading saved data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray;
        }
        return null;
    }

    private String getRemovedStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getRemovedBooleanData(n, n2) ? "1" : "0";
        }
        String string = dataSet.getRemovedStringData(n, n2);
        if (n3 == 2) {
            string = this.encode(string);
        }
        return string;
    }

    private byte[] getRemovedBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getRemovedBlobData(n, n2);
    }

    private String getRemovedStringValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 2) {
            String string = dataSet.getRemovedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray == null ? null : this.encode(new String(byArray));
        }
        return null;
    }

    private byte[] getRemovedBinaryValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 12 || n3 == 13) {
            String string = dataSet.getRemovedStringData(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading removed data from file: filename=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null) + ", content=" + byArray));
            }
            return byArray;
        }
        return null;
    }

    private void writeString(Writer writer, String string, int n) throws IOException {
        if (n == 0) {
            writer.write(string);
            writer.write(NL);
        } else if (n < 6) {
            writer.write(TABS[n]);
            writer.write(string);
            writer.write(NL);
        } else {
            for (int i = 0; i < n; ++i) {
                writer.write(TABS[0]);
            }
            writer.write(string);
            writer.write(NL);
        }
    }

    private void writeBinary(Writer writer, byte[] byArray, String string, String string2, int n) throws IOException {
        if (n == 0) {
            writer.write(string);
            String string3 = Base64.encodeBytes(byArray, 8);
            writer.write(string3);
            writer.write(string2);
            writer.write(NL);
        } else if (n < 6) {
            writer.write(TABS[n]);
            writer.write(string);
            String string4 = Base64.encodeBytes(byArray, 8);
            writer.write(string4);
            writer.write(string2);
            writer.write(NL);
        } else {
            for (int i = 0; i < n; ++i) {
                writer.write(TABS[0]);
            }
            writer.write(string);
            String string5 = Base64.encodeBytes(byArray, 8);
            writer.write(string5);
            writer.write(string2);
            writer.write(NL);
        }
    }

    private int[] getTargetDataTypes(DataSet dataSet, DataTypeChanger dataTypeChanger) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (dataTypeChanger == null) {
                nArray[i] = columnHeader.getDataType();
                continue;
            }
            String string = dataSet.getAlias();
            String string2 = columnHeader.getName();
            int n2 = columnHeader.getDataType();
            nArray[i] = dataTypeChanger.getDataType(string, string2, n2);
        }
        return nArray;
    }

    private String toMiType(int n) {
        switch (n) {
            case 2: {
                return "STRING";
            }
            case 3: {
                return "INT";
            }
            case 4: {
                return "INT";
            }
            case 5: {
                return "CURRENCY";
            }
            case 6: {
                return "DECIMAL";
            }
            case 7: {
                return "DECIMAL";
            }
            case 8: {
                return "STRING";
            }
            case 9: {
                return "DATE";
            }
            case 10: {
                return "DATE";
            }
            case 11: {
                return "DATE";
            }
            case 12: {
                return "BLOB";
            }
            case 13: {
                return "BLOB";
            }
            case 0: {
                return "STRING";
            }
            case 1: {
                return "STRING";
            }
        }
        return "STRING";
    }

    private String encode(String string) {
        if (string == null) {
            return string;
        }
        return this.xmlCodec.encode(this.platformCodec.encode(string));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String string) throws IOException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.getBuffer();
            try {
                int n;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.close();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            finally {
                fileInputStream.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }
}

