/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformBinaryDataDeserializer
implements DataDeserializer {
    private Log log = LogFactory.getLog((Class)PlatformBinaryDataDeserializer.class);
    private static final String CHARSET = "UTF-8";
    private static final int BUFFER_SIZE = 4096;
    private static final boolean COLUMN_SORT = false;
    private static final int TIMEZONE_OFFSET = PlatformBinaryDataDeserializer.getTimezoneOffset();
    private static final String PREFIX_FILE = "xapi_";
    private static final String SUFFIX_FILE = ".tmp";
    private Map properties;
    private boolean isEmptyToNull;
    private byte[] buffer;

    private static int getTimezoneOffset() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(15) + calendar.get(16);
    }

    private Object getProperty(String string) {
        return this.properties == null ? null : this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }

    public PlatformData readData(InputStream inputStream, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Reading data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, CHARSET) : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.init();
        try {
            return this.read(inputStream, dataTypeChanger);
        }
        catch (IOException iOException) {
            String string2 = "PlatformBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string2), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string2, iOException);
        }
    }

    public PlatformData readData(Reader reader, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        String string2 = "PlatformBinary";
        throw new UnsupportedOperationException("Unsupported content type: " + string2);
    }

    protected PlatformData read(InputStream inputStream, DataTypeChanger dataTypeChanger) throws IOException {
        DataInputStream dataInputStream = inputStream instanceof DataInputStream ? (DataInputStream)inputStream : new DataInputStream(inputStream);
        PlatformData platformData = new PlatformData();
        short s = dataInputStream.readShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading data: mark=0x" + Integer.toHexString(s)));
        }
        boolean bl = false;
        if (s == -496) {
            this.readVariableList(dataInputStream, platformData, dataTypeChanger);
        } else if (s == -511) {
            bl = true;
        } else {
            throw new IOException("Invalid mark: 0x" + Integer.toHexString(s));
        }
        int n = 0;
        while (true) {
            if (bl) {
                bl = false;
            } else {
                s = this.readShort(inputStream);
            }
            if (s == -1) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)"Reading DataSet: mark=-1");
                break;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Reading DataSet: mark=0x" + Integer.toHexString(s)));
            }
            if (s != -511) {
                throw new IOException("Invalid DataSet mark: 0x" + Integer.toHexString(s));
            }
            this.readDataSet(dataInputStream, platformData, dataTypeChanger, n);
            ++n;
        }
        return platformData;
    }

    protected void readVariableList(DataInputStream dataInputStream, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        short s = dataInputStream.readShort();
        int n = this.readLength(dataInputStream);
        int n2 = dataInputStream.readShort();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading VariableList: version=" + s + ", size=" + n + ", count=" + n2));
        }
        if (s != 5000) {
            throw new IOException("Invalid version: " + s);
        }
        for (int i = 0; i < n2; ++i) {
            this.readVariable(dataInputStream, platformData, dataTypeChanger, i);
        }
    }

    protected void readVariable(DataInputStream dataInputStream, PlatformData platformData, DataTypeChanger dataTypeChanger, int n) throws IOException {
        short s = dataInputStream.readShort();
        String string = new String(this.readBytes(dataInputStream, s), CHARSET);
        short s2 = dataInputStream.readShort();
        int n2 = this.variantTypeToDataType(s2);
        Object object = this.readValue(dataInputStream, s2);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading Variable: index=" + n + ", length=" + s + ", name=" + URLEncoder.encode(string, CHARSET) + ", type=" + s2 + ", dataType=" + n2));
        }
        Variable variable = new Variable(string, n2);
        if (!this.isNull(object, n2)) {
            variable.set(object);
        }
        platformData.addVariable(variable);
    }

    protected void readDataSet(DataInputStream dataInputStream, PlatformData platformData, DataTypeChanger dataTypeChanger, int n) throws IOException {
        short s = dataInputStream.readShort();
        int n2 = this.readLength(dataInputStream);
        short s2 = dataInputStream.readShort();
        String string = new String(this.readBytes(dataInputStream, s2), CHARSET);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Reading DataSet: index=" + n + ", version=" + s + ", size=" + n2 + ", name=" + URLEncoder.encode(string, CHARSET)));
        }
        if (s != 5000) {
            throw new IOException("Invalid version: " + s);
        }
        DataSet dataSet = new DataSet(string);
        boolean bl = dataSet.isStoreDataChanges();
        boolean bl2 = dataSet.isCheckingSetterDataIndex();
        if (bl) {
            dataSet.stopStoreDataChanges();
        }
        if (bl2) {
            dataSet.setCheckingSetterDataIndex(false);
        }
        this.readConstantColumnHeaders(dataInputStream, dataSet);
        this.readDefaultColumnHeaders(dataInputStream, dataSet);
        int[] nArray = this.getSourceDataTypes(dataSet, dataTypeChanger);
        this.readDataRows(dataInputStream, dataSet, nArray);
        if (bl) {
            dataSet.startStoreDataChanges(true);
        }
        if (bl2) {
            dataSet.setCheckingSetterDataIndex(true);
        }
        platformData.addDataSet(dataSet);
    }

    protected void readDefaultColumnHeaders(DataInputStream dataInputStream, DataSet dataSet) throws IOException {
        int n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            short s = dataInputStream.readShort();
            String string = new String(this.readBytes(dataInputStream, s), CHARSET);
            short s2 = dataInputStream.readShort();
            int n2 = this.columnTypeToDataType(s2);
            short s3 = dataInputStream.readShort();
            short s4 = dataInputStream.readShort();
            if ((s4 & 0xF000) == 24576) {
                short s5 = dataInputStream.readShort();
                String string2 = new String(this.readBytes(dataInputStream, s5), CHARSET);
                dataSet.addColumn(string, n2, (int)s3);
                continue;
            }
            dataSet.addColumn(string, n2, (int)s3);
        }
    }

    protected void readConstantColumnHeaders(DataInputStream dataInputStream, DataSet dataSet) throws IOException {
        short s = dataInputStream.readShort();
        short s2 = dataInputStream.readShort();
        int n = this.readLength(dataInputStream);
        int n2 = dataInputStream.readShort();
        if (s != -496) {
            throw new IOException("Invalid ConstantColumnHeader mark: 0x" + Integer.toHexString(s));
        }
        if (s2 != 5000) {
            throw new IOException("Invalid version: " + s2);
        }
        for (int i = 0; i < n2; ++i) {
            short s3 = dataInputStream.readShort();
            String string = new String(this.readBytes(dataInputStream, s3), CHARSET);
            short s4 = dataInputStream.readShort();
            int n3 = this.variantTypeToDataType(s4);
            int n4 = DataTypes.getDefaultSize(n3);
            Object object = this.readValue(dataInputStream, s4);
            dataSet.addConstantColumn(string, n3, n4, object);
        }
    }

    protected void readDataRows(DataInputStream dataInputStream, DataSet dataSet, int[] nArray) throws IOException {
        int n;
        int[] nArray2 = this.getColumnIndexes(dataSet);
        int[] nArray3 = new int[nArray2.length];
        for (n = 0; n < nArray3.length; ++n) {
            nArray3[n] = dataSet.getColumn(nArray2[n]).getDataType();
        }
        n = 0;
        while (true) {
            Object object;
            int n2;
            int n3;
            int n4;
            int n5;
            int n6;
            int n7 = this.readLength(dataInputStream);
            short s = dataInputStream.readShort();
            if (n7 == 0 && s == 0) {
                if (!this.log.isDebugEnabled()) break;
                this.log.debug((Object)("Finish reading rows: i=" + n + ", size=" + n7 + ", rowType=0x" + Integer.toHexString(s)));
                break;
            }
            int n8 = nArray2.length;
            int n9 = dataInputStream.readShort();
            if (s == 8) {
                n6 = dataSet.newRemovedRow();
                for (n5 = 0; n5 < n9; ++n5) {
                    if (n5 >= n8) {
                        this.readValue(dataInputStream);
                        continue;
                    }
                    n4 = nArray2[n5];
                    n3 = nArray3[n5];
                    n2 = nArray[n4];
                    Object object2 = null;
                    if (n3 == 13) {
                        if (n2 == 2 || n2 == 12) {
                            object = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                            this.readValueToFile(dataInputStream, (File)object);
                            object2 = ((File)object).getAbsolutePath();
                        }
                    } else {
                        object2 = this.readValue(dataInputStream);
                    }
                    if (this.isNull(object2, n2)) continue;
                    dataSet.setRemovedData(n6, n4, object2);
                }
            } else {
                n6 = dataSet.newRow();
                for (n5 = 0; n5 < n9; ++n5) {
                    if (n5 >= n8) {
                        this.readValue(dataInputStream);
                        continue;
                    }
                    n4 = nArray2[n5];
                    n3 = nArray3[n5];
                    n2 = nArray[n4];
                    Object object3 = null;
                    if (n3 == 13) {
                        if (n2 == 2 || n2 == 12) {
                            object = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                            this.readValueToFile(dataInputStream, (File)object);
                            object3 = ((File)object).getAbsolutePath();
                        }
                    } else {
                        object3 = this.readValue(dataInputStream);
                    }
                    if (this.isNull(object3, n2)) continue;
                    dataSet.set(n6, n4, object3);
                }
                if (s != 0 && s != 1) {
                    if (s == 2) {
                        dataSet.setRowType(n6, 1);
                    } else if (s == 4) {
                        dataSet.setRowType(n6, 2);
                        n5 = dataInputStream.readShort();
                        if (n5 > 0) {
                            for (n4 = 0; n4 < n5; ++n4) {
                                if (n4 >= n8) {
                                    this.readValue(dataInputStream);
                                    continue;
                                }
                                n3 = nArray2[n4];
                                n2 = nArray3[n4];
                                int n10 = nArray[n3];
                                object = null;
                                if (n2 == 13) {
                                    if (n10 == 2 || n10 == 12) {
                                        File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                                        this.readValueToFile(dataInputStream, file);
                                        object = file.getAbsolutePath();
                                    }
                                } else {
                                    object = this.readValue(dataInputStream);
                                }
                                if (this.isNull(object, n10)) continue;
                                dataSet.setSavedData(n6, n3, object);
                            }
                        }
                    }
                }
            }
            ++n;
        }
    }

    protected Object readValue(DataInputStream dataInputStream) throws IOException {
        return this.readValue(dataInputStream, dataInputStream.readShort());
    }

    protected Object readValue(DataInputStream dataInputStream, short s) throws IOException {
        switch (s) {
            case 0: {
                return null;
            }
            case 1: {
                return null;
            }
            case 2: {
                short s2 = dataInputStream.readShort();
                return s2 == 0 ? Boolean.FALSE : Boolean.TRUE;
            }
            case 3: {
                int n = dataInputStream.readInt();
                return new Integer(n);
            }
            case 4: {
                double d = dataInputStream.readDouble();
                return new Double(d);
            }
            case 21: {
                int n = this.readLength(dataInputStream);
                String string = new String(this.readBytes(dataInputStream, n), CHARSET);
                return string;
            }
            case 26: {
                int n = this.readLength(dataInputStream);
                byte[] byArray = this.readBytes(dataInputStream, n);
                return byArray;
            }
            case 40: {
                int n = this.readLength(dataInputStream);
                String string = new String(this.readBytes(dataInputStream, n));
                return new BigDecimal(string);
            }
            case 41: {
                long l = this.reviseTimeValue((long)dataInputStream.readDouble());
                return new Date(l);
            }
        }
        throw new IOException("Invalid data type: 0x" + Integer.toHexString(s));
    }

    protected void readValueToFile(DataInputStream dataInputStream, File file) throws IOException {
        this.readValueToFile(dataInputStream, dataInputStream.readShort(), file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void readValueToFile(DataInputStream dataInputStream, short s, File file) throws IOException {
        if (s != 21 && s != 26) throw new IOException("Invalid data type: 0x" + Integer.toHexString(s));
        int n = this.readLength(dataInputStream);
        byte[] byArray = this.getBuffer();
        int n2 = byArray.length;
        int n3 = 0;
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            int n4;
            do {
                int n5;
                if ((n5 = n - n3) > n2) {
                    n5 = n2;
                }
                if ((n4 = dataInputStream.read(byArray, 0, n5)) == -1) {
                    throw new EOFException();
                }
                fileOutputStream.write(byArray, 0, n4);
            } while ((n3 += n4) != n);
            if (!this.log.isDebugEnabled()) return;
            this.log.debug((Object)("Saving data to file: type=" + s + ", file=" + file));
            return;
        }
        finally {
            fileOutputStream.close();
        }
    }

    protected int readLength(DataInputStream dataInputStream) throws IOException {
        int n = dataInputStream.readShort();
        if ((n & 0x8000) == 0) {
            return n;
        }
        n = n << 16 & 0xFFFF0000 | dataInputStream.readShort() & 0xFFFF;
        return n &= Integer.MAX_VALUE;
    }

    protected byte[] readBytes(DataInputStream dataInputStream, int n) throws IOException {
        int n2;
        byte[] byArray = new byte[n];
        int n3 = 0;
        while ((n3 += (n2 = dataInputStream.read(byArray, n3, n - n3))) != n) {
        }
        return byArray;
    }

    protected int[] getSourceDataTypes(DataSet dataSet, DataTypeChanger dataTypeChanger) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            String string;
            String string2;
            int n2;
            int n3;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            nArray[i] = n3 = columnHeader.getDataType();
            if (dataTypeChanger == null || (n2 = dataTypeChanger.getDataType(string2 = dataSet.getAlias(), string = columnHeader.getName(), n3)) == n3) continue;
            int n4 = columnHeader.getDataSize();
            if (columnHeader.isConstant()) {
                if (n2 == 13) continue;
                object = ((ConstantColumnHeader)columnHeader).getValue();
                ConstantColumnHeader constantColumnHeader = new ConstantColumnHeader(string, object, n2, n4);
                dataSet.setColumn(i, constantColumnHeader);
                continue;
            }
            object = new ColumnHeader(string, n2, n4);
            dataSet.setColumn(i, (ColumnHeader)object);
        }
        return nArray;
    }

    protected int[] getColumnIndexes(DataSet dataSet) {
        return this.getNormalColumnIndexes(dataSet);
    }

    private int[] sortColumnIndexes(DataSet dataSet) {
        int n;
        Object object;
        ArrayList<String> arrayList = new ArrayList<String>();
        int n2 = dataSet.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            object = dataSet.getColumn(i);
            if (((ColumnHeader)object).isConstant()) continue;
            arrayList.add(((ColumnHeader)object).getName());
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        object = arrayList.iterator();
        block1: while (object.hasNext()) {
            String string = (String)object.next();
            int n3 = arrayList2.size();
            for (n = 0; n < n3; ++n) {
                String string2 = (String)arrayList2.get(n);
                if (string.compareToIgnoreCase(string2) >= 0) continue;
                arrayList2.add(n, string);
                continue block1;
            }
            arrayList2.add(string);
        }
        int n4 = arrayList2.size();
        int[] nArray = new int[n4];
        for (n = 0; n < n4; ++n) {
            nArray[n] = dataSet.indexOfColumn(arrayList2.get(n).toString());
        }
        return nArray;
    }

    private int[] getNormalColumnIndexes(DataSet dataSet) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            nArray[n2++] = i;
        }
        int[] nArray2 = new int[n2];
        System.arraycopy(nArray, 0, nArray2, 0, n2);
        return nArray2;
    }

    protected int variantTypeToDataType(short s) {
        switch (s) {
            case 0: {
                return 0;
            }
            case 1: {
                return 0;
            }
            case 2: {
                return 4;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return 7;
            }
            case 21: {
                return 2;
            }
            case 26: {
                return 12;
            }
            case 40: {
                return 8;
            }
            case 41: {
                return 11;
            }
        }
        return 0;
    }

    protected int columnTypeToDataType(short s) {
        switch (s) {
            case 0: {
                return 0;
            }
            case 1: {
                return 2;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 7;
            }
            case 4: {
                return 8;
            }
            case 5: {
                return 9;
            }
            case 6: {
                return 10;
            }
            case 7: {
                return 11;
            }
            case 8: {
                return 12;
            }
        }
        return 0;
    }

    private short readShort(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            return -1;
        }
        return (short)((n2 << 8) + (n << 0));
    }

    private long reviseTimeValue(long l) {
        return l - (long)TIMEZONE_OFFSET;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }

    private boolean isNull(Object object, int n) {
        return this.isEmptyToNull() && n == 2 && "".equals(object);
    }

    private void init() {
        this.isEmptyToNull = this.getEmptyToNull();
    }

    private boolean isEmptyToNull() {
        return this.isEmptyToNull;
    }

    private boolean getEmptyToNull() {
        Object object = this.getProperty("deserializer.data.emptytonull");
        if ("true".equals(object)) {
            return true;
        }
        if ("false".equals(object)) {
            return false;
        }
        String string = System.getProperty("xapi.deserializer.data.emptytonull");
        return "true".equals(string);
    }
}

