/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.JavaTypeDataConverter;
import com.nexacro.xapi.tx.JavaTypeDataSerializer;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.PlatformCodec;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformBinaryJavaTypeDataSerializer
implements JavaTypeDataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformBinaryJavaTypeDataSerializer.class);
    private static final String CHARSET = "UTF-8";
    private PlatformCodec platformCodec = new PlatformCodec();
    private VariableList vl;
    private JavaTypeDataConverter dataConverter;
    private DataOutputStream out;
    private Object dataClass;
    private String dsName;
    private List columnHeaders = new ArrayList();
    private List constantColumnHeaders = new ArrayList();

    public void setProperty(String string, Object object) {
    }

    public void setCharset(String string) {
    }

    public void setDataConverter(JavaTypeDataConverter javaTypeDataConverter) {
        this.dataConverter = javaTypeDataConverter;
    }

    public void setOutputStream(OutputStream outputStream) throws PlatformException {
        this.out = outputStream instanceof DataOutputStream ? (DataOutputStream)outputStream : new DataOutputStream(outputStream);
    }

    public void setWriter(Writer writer) throws PlatformException {
        String string = "PlatformBinary";
        throw new UnsupportedOperationException("Unsupported content type: " + string);
    }

    public void writeHead() throws PlatformException {
    }

    public void writeTail() throws PlatformException {
        try {
            if (this.dataClass == Variable.class) {
                this.writeVariableList(this.out, this.vl, this.dataConverter);
            } else if (this.dataClass == DataSet.class || this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                this.writeColumnHeaders(this.out, this.dsName, this.columnHeaders, this.constantColumnHeaders, this.dataConverter);
                this.out.writeInt(0);
            } else if (this.dataClass == Object.class) {
                this.out.writeInt(0);
            }
            this.out.flush();
        }
        catch (IOException iOException) {
            String string = "PlatformBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    public void writeVariable(String string, int n, Object object) throws PlatformException {
        if (this.vl == null) {
            this.vl = new VariableList();
        }
        Variable variable = new Variable(string, n);
        variable.setConvertingToDataType(false);
        variable.set(object);
        this.vl.add(variable);
        this.dataClass = Variable.class;
    }

    public void writeDataSet(String string) throws PlatformException {
        try {
            String string2 = string;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing DataSet: name=" + string + ", alias=" + string2));
            }
            if (this.dataClass == Variable.class) {
                this.writeVariableList(this.out, this.vl, this.dataConverter);
            } else if (this.dataClass == DataSet.class) {
                this.writeColumnHeaders(this.out, this.dsName, this.columnHeaders, this.constantColumnHeaders, this.dataConverter);
                this.dsName = null;
                this.out.writeInt(0);
            } else if (this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                this.writeColumnHeaders(this.out, this.dsName, this.columnHeaders, this.constantColumnHeaders, this.dataConverter);
                this.dsName = null;
                this.constantColumnHeaders.clear();
                this.columnHeaders.clear();
                this.out.writeInt(0);
            } else if (this.dataClass == Object.class) {
                this.dsName = null;
                this.constantColumnHeaders.clear();
                this.columnHeaders.clear();
                this.out.writeInt(0);
            }
            this.out.writeShort(65025);
            this.out.writeShort(5000);
            this.dsName = string;
            this.dataClass = DataSet.class;
        }
        catch (IOException iOException) {
            String string3 = "PlatformBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string3), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string3, iOException);
        }
    }

    public void writeDataSetHeader(String string, int n, int n2) throws PlatformException {
        this.columnHeaders.add(new ColumnHeader(string, n, n2));
        this.dataClass = ColumnHeader.class;
    }

    public void writeDataSetConstantHeader(String string, int n, int n2, Object object) throws PlatformException {
        this.constantColumnHeaders.add(new ConstantColumnHeader(string, object, n, n2));
        this.dataClass = ConstantColumnHeader.class;
    }

    public void writeDataSetRow(Object[] objectArray) throws PlatformException {
        try {
            if (this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                this.writeColumnHeaders(this.out, this.dsName, this.columnHeaders, this.constantColumnHeaders, this.dataConverter);
            }
            this.writeRowData(this.out, this.columnHeaders, objectArray, this.dataConverter);
            this.dataClass = Object.class;
        }
        catch (IOException iOException) {
            String string = "PlatformBinary";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    private void writeVariableList(DataOutputStream dataOutputStream, VariableList variableList, JavaTypeDataConverter javaTypeDataConverter) throws IOException {
        int n = variableList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + n));
        }
        if (n == 0) {
            return;
        }
        dataOutputStream.writeShort(65040);
        dataOutputStream.writeShort(5000);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        dataOutputStream2.writeShort(n);
        for (int i = 0; i < n; ++i) {
            Variable variable = variableList.get(i);
            this.writeVariable(dataOutputStream2, variable, javaTypeDataConverter);
        }
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.writeLength(dataOutputStream, byArray.length);
        dataOutputStream.write(byArray);
    }

    private void writeVariable(DataOutputStream dataOutputStream, Variable variable, JavaTypeDataConverter javaTypeDataConverter) throws IOException {
        String string = variable.getName();
        int n = variable.getType();
        byte[] byArray = string.getBytes(CHARSET);
        dataOutputStream.writeShort(byArray.length);
        dataOutputStream.write(byArray);
        Object object = variable.getObject();
        switch (n) {
            case 2: {
                String string2 = javaTypeDataConverter.toString(object);
                this.writeValue(dataOutputStream, string2);
                break;
            }
            case 3: {
                int n2 = javaTypeDataConverter.toInt(object);
                this.writeValue(dataOutputStream, n2);
                break;
            }
            case 4: {
                boolean bl = javaTypeDataConverter.toBoolean(object);
                this.writeValue(dataOutputStream, bl);
                break;
            }
            case 5: {
                long l = javaTypeDataConverter.toLong(object);
                this.writeValue(dataOutputStream, l);
                break;
            }
            case 6: {
                float f = javaTypeDataConverter.toFloat(object);
                this.writeValue(dataOutputStream, f);
                break;
            }
            case 7: {
                double d = javaTypeDataConverter.toDouble(object);
                this.writeValue(dataOutputStream, d);
                break;
            }
            case 8: {
                BigDecimal bigDecimal = javaTypeDataConverter.toBigDecimal(object);
                this.writeValue(dataOutputStream, bigDecimal);
                break;
            }
            case 9: {
                Date date = javaTypeDataConverter.toDateTime(object);
                this.writeDateValue(dataOutputStream, date);
                break;
            }
            case 10: {
                Date date = javaTypeDataConverter.toDateTime(object);
                this.writeTimeValue(dataOutputStream, date);
                break;
            }
            case 11: {
                Date date = javaTypeDataConverter.toDateTime(object);
                this.writeValue(dataOutputStream, date);
                break;
            }
            case 12: {
                byte[] byArray2 = javaTypeDataConverter.toBlob(object);
                this.writeValue(dataOutputStream, byArray2);
                break;
            }
            default: {
                this.writeEmptyValue(dataOutputStream);
            }
        }
    }

    private void writeColumnHeaders(DataOutputStream dataOutputStream, String string, List list, List list2, JavaTypeDataConverter javaTypeDataConverter) throws IOException {
        String string2 = string;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        byte[] byArray = string2.getBytes(CHARSET);
        dataOutputStream2.writeShort(byArray.length);
        dataOutputStream2.write(byArray);
        this.writeConstantColumnHeaders(dataOutputStream2, list2, javaTypeDataConverter);
        this.writeDefaultColumnHeaders(dataOutputStream2, list);
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        this.writeLength(dataOutputStream, byArray2.length);
        dataOutputStream.write(byArray2);
    }

    private void writeDefaultColumnHeaders(DataOutputStream dataOutputStream, List list) throws IOException {
        int n = list.size();
        dataOutputStream.writeShort(n);
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = (ColumnHeader)list.get(i);
            String string = columnHeader.getName();
            byte[] byArray = string.getBytes(CHARSET);
            dataOutputStream.writeShort(byArray.length);
            dataOutputStream.write(byArray);
            int n2 = columnHeader.getDataType();
            int n3 = columnHeader.getDataSize();
            switch (n2) {
                case 2: {
                    dataOutputStream.writeShort(1);
                    break;
                }
                case 3: {
                    dataOutputStream.writeShort(2);
                    break;
                }
                case 4: {
                    dataOutputStream.writeShort(2);
                    break;
                }
                case 5: {
                    dataOutputStream.writeShort(4);
                    break;
                }
                case 6: {
                    dataOutputStream.writeShort(3);
                    break;
                }
                case 7: {
                    dataOutputStream.writeShort(3);
                    break;
                }
                case 8: {
                    dataOutputStream.writeShort(4);
                    break;
                }
                case 9: {
                    dataOutputStream.writeShort(5);
                    break;
                }
                case 10: {
                    dataOutputStream.writeShort(6);
                    break;
                }
                case 11: {
                    dataOutputStream.writeShort(7);
                    break;
                }
                case 12: {
                    dataOutputStream.writeShort(8);
                    break;
                }
                case 13: {
                    dataOutputStream.writeShort(0);
                    break;
                }
                case 1: {
                    dataOutputStream.writeShort(0);
                    break;
                }
                default: {
                    dataOutputStream.writeShort(0);
                }
            }
            dataOutputStream.writeShort(n3);
            dataOutputStream.writeShort(1);
        }
    }

    private void writeConstantColumnHeaders(DataOutputStream dataOutputStream, List list, JavaTypeDataConverter javaTypeDataConverter) throws IOException {
        dataOutputStream.writeShort(65040);
        dataOutputStream.writeShort(5000);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        int n = list.size();
        dataOutputStream2.writeShort(n);
        block15: for (int i = 0; i < n; ++i) {
            ConstantColumnHeader constantColumnHeader = (ConstantColumnHeader)list.get(i);
            String string = constantColumnHeader.getName();
            byte[] byArray = string.getBytes(CHARSET);
            dataOutputStream2.writeShort(byArray.length);
            dataOutputStream2.write(byArray);
            int n2 = constantColumnHeader.getDataType();
            Object object = constantColumnHeader.getValue();
            switch (n2) {
                case 2: {
                    String string2 = javaTypeDataConverter.toString(object);
                    this.writeValue(dataOutputStream2, string2);
                    continue block15;
                }
                case 3: {
                    int n3 = javaTypeDataConverter.toInt(object);
                    this.writeValue(dataOutputStream2, n3);
                    continue block15;
                }
                case 4: {
                    boolean bl = javaTypeDataConverter.toBoolean(object);
                    this.writeValue(dataOutputStream2, bl);
                    continue block15;
                }
                case 5: {
                    long l = javaTypeDataConverter.toLong(object);
                    this.writeValue(dataOutputStream2, l);
                    continue block15;
                }
                case 6: {
                    float f = javaTypeDataConverter.toFloat(object);
                    this.writeValue(dataOutputStream2, f);
                    continue block15;
                }
                case 7: {
                    double d = javaTypeDataConverter.toDouble(object);
                    this.writeValue(dataOutputStream2, d);
                    continue block15;
                }
                case 8: {
                    BigDecimal bigDecimal = javaTypeDataConverter.toBigDecimal(object);
                    this.writeValue(dataOutputStream2, bigDecimal);
                    continue block15;
                }
                case 9: {
                    Date date = javaTypeDataConverter.toDateTime(object);
                    this.writeDateValue(dataOutputStream2, date);
                    continue block15;
                }
                case 10: {
                    Date date = javaTypeDataConverter.toDateTime(object);
                    this.writeTimeValue(dataOutputStream2, date);
                    continue block15;
                }
                case 11: {
                    Date date = javaTypeDataConverter.toDateTime(object);
                    this.writeValue(dataOutputStream2, date);
                    continue block15;
                }
                case 12: {
                    byte[] byArray2 = javaTypeDataConverter.toBlob(object);
                    this.writeValue(dataOutputStream2, byArray2);
                    continue block15;
                }
                case 13: {
                    this.writeEmptyValue(dataOutputStream2);
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(dataOutputStream2);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(dataOutputStream2);
                }
            }
        }
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        this.writeLength(dataOutputStream, byArray.length);
        dataOutputStream.write(byArray);
    }

    private void writeRowData(DataOutputStream dataOutputStream, List list, Object[] objectArray, JavaTypeDataConverter javaTypeDataConverter) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DataOutputStream dataOutputStream2 = new DataOutputStream(byteArrayOutputStream);
        this.writeRow(dataOutputStream2, list, objectArray, javaTypeDataConverter);
        dataOutputStream2.close();
        byteArrayOutputStream.close();
        byte[] byArray = byteArrayOutputStream.toByteArray();
        if (byArray.length > 0) {
            this.writeLength(dataOutputStream, byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    private void writeRow(DataOutputStream dataOutputStream, List list, Object[] objectArray, JavaTypeDataConverter javaTypeDataConverter) throws IOException {
        int n = list.size();
        dataOutputStream.writeShort(1);
        dataOutputStream.writeShort(n);
        block15: for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = (ColumnHeader)list.get(i);
            int n2 = columnHeader.getDataType();
            Object object = objectArray[i];
            switch (n2) {
                case 2: {
                    String string = javaTypeDataConverter.toString(object);
                    this.writeValue(dataOutputStream, string);
                    continue block15;
                }
                case 3: {
                    int n3 = javaTypeDataConverter.toInt(object);
                    this.writeValue(dataOutputStream, n3);
                    continue block15;
                }
                case 4: {
                    boolean bl = javaTypeDataConverter.toBoolean(object);
                    this.writeValue(dataOutputStream, bl);
                    continue block15;
                }
                case 5: {
                    long l = javaTypeDataConverter.toLong(object);
                    this.writeValue(dataOutputStream, l);
                    continue block15;
                }
                case 6: {
                    float f = javaTypeDataConverter.toFloat(object);
                    this.writeValue(dataOutputStream, f);
                    continue block15;
                }
                case 7: {
                    double d = javaTypeDataConverter.toDouble(object);
                    this.writeValue(dataOutputStream, d);
                    continue block15;
                }
                case 8: {
                    BigDecimal bigDecimal = javaTypeDataConverter.toBigDecimal(object);
                    this.writeValue(dataOutputStream, bigDecimal);
                    continue block15;
                }
                case 9: {
                    Date date = javaTypeDataConverter.toDateTime(object);
                    this.writeDateValue(dataOutputStream, date);
                    continue block15;
                }
                case 10: {
                    Date date = javaTypeDataConverter.toDateTime(object);
                    this.writeTimeValue(dataOutputStream, date);
                    continue block15;
                }
                case 11: {
                    Date date = javaTypeDataConverter.toDateTime(object);
                    this.writeValue(dataOutputStream, date);
                    continue block15;
                }
                case 12: {
                    byte[] byArray = javaTypeDataConverter.toBlob(object);
                    this.writeValue(dataOutputStream, byArray);
                    continue block15;
                }
                case 13: {
                    this.writeEmptyValue(dataOutputStream);
                    continue block15;
                }
                case 1: {
                    this.writeEmptyValue(dataOutputStream);
                    continue block15;
                }
                default: {
                    this.writeEmptyValue(dataOutputStream);
                }
            }
        }
    }

    private void writeValue(DataOutputStream dataOutputStream, String string) throws IOException {
        if (string == null) {
            dataOutputStream.writeShort(0);
        } else {
            String string2 = this.platformCodec.encode(string);
            dataOutputStream.writeShort(21);
            byte[] byArray = string2.getBytes(CHARSET);
            this.writeLength(dataOutputStream, byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    private void writeValue(DataOutputStream dataOutputStream, int n) throws IOException {
        dataOutputStream.writeShort(3);
        dataOutputStream.writeInt(n);
    }

    private void writeValue(DataOutputStream dataOutputStream, boolean bl) throws IOException {
        dataOutputStream.writeShort(3);
        int n = bl ? 1 : 0;
        dataOutputStream.writeInt(n);
    }

    private void writeValue(DataOutputStream dataOutputStream, long l) throws IOException {
        dataOutputStream.writeShort(40);
        String string = String.valueOf(l);
        byte[] byArray = string.getBytes();
        this.writeLength(dataOutputStream, byArray.length);
        dataOutputStream.write(byArray);
    }

    private void writeValue(DataOutputStream dataOutputStream, float f) throws IOException {
        dataOutputStream.writeShort(4);
        dataOutputStream.writeDouble(f);
    }

    private void writeValue(DataOutputStream dataOutputStream, double d) throws IOException {
        dataOutputStream.writeShort(4);
        dataOutputStream.writeDouble(d);
    }

    private void writeValue(DataOutputStream dataOutputStream, BigDecimal bigDecimal) throws IOException {
        if (bigDecimal == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(40);
            String string = bigDecimal.toString();
            byte[] byArray = string.getBytes();
            this.writeLength(dataOutputStream, byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    private void writeDateValue(DataOutputStream dataOutputStream, Date date) throws IOException {
        if (date == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(41);
            long l = date.getTime();
            dataOutputStream.writeDouble(l);
        }
    }

    private void writeTimeValue(DataOutputStream dataOutputStream, Date date) throws IOException {
        if (date == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(41);
            long l = date.getTime();
            dataOutputStream.writeDouble(l);
        }
    }

    private void writeValue(DataOutputStream dataOutputStream, Date date) throws IOException {
        if (date == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(41);
            long l = date.getTime();
            dataOutputStream.writeDouble(l);
        }
    }

    private void writeValue(DataOutputStream dataOutputStream, byte[] byArray) throws IOException {
        if (byArray == null) {
            dataOutputStream.writeShort(0);
        } else {
            dataOutputStream.writeShort(26);
            this.writeLength(dataOutputStream, byArray.length);
            dataOutputStream.write(byArray);
        }
    }

    private void writeEmptyValue(DataOutputStream dataOutputStream) throws IOException {
        dataOutputStream.writeShort(0);
    }

    private void writeLength(DataOutputStream dataOutputStream, int n) throws IOException {
        if (n < 32768) {
            dataOutputStream.writeShort(n);
        } else {
            dataOutputStream.writeInt(n | Integer.MIN_VALUE);
        }
    }
}

