/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.util.TypeConverter;
import com.nexacro.xapi.tx.DataDeserializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.Base64;
import com.nexacro.xapi.tx.impl.EmptyElementInputStream;
import com.nexacro.xapi.tx.impl.EmptyElementReader;
import com.nexacro.xapi.util.PlatformGlobals;
import com.nexacro.xapi.util.SequenceReader;
import com.nexacro.xapi.util.StringUtils;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayReader;
import java.io.CharArrayWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class PlatformXmlDataDeserializer
extends DefaultHandler
implements DataDeserializer {
    private Log log = LogFactory.getLog((Class)PlatformXmlDataDeserializer.class);
    private static final boolean REMOVE_ENCODING_TAG = false;
    private static final String PARSER_FACTORY_KEY = "platform.tx.DataDeserializer.platformxml.parserfactory";
    private static final String PREFIX_FILE = "xapi_";
    private static final String SUFFIX_FILE = ".tmp";
    protected static final int INDEX_UNDEFINED = 0;
    protected static final int INDEX_VARIABLE = 1;
    protected static final int INDEX_DATA_ROW = 2;
    protected static final int INDEX_DATA_CELL = 3;
    protected static final int INDEX_SAVED_DATA_ROW = 4;
    protected static final int INDEX_SAVED_DATA_CELL = 5;
    private static ThreadLocal parserThreadLocal;
    private Map properties;
    private boolean isEmptyToNull;
    private int index;
    private PlatformData data;
    private Variable var;
    private DataSet ds;
    private int[] dataTypes;
    private boolean isStoreDataChanges;
    private boolean isCheckingSetterDataIndex;
    private String rowType;
    private String columnName;
    private StringBuffer value = new StringBuffer();
    private boolean isEmpty;
    private DataTypeChanger dataTypeChanger;

    private Object getProperty(String string) {
        return this.properties == null ? null : this.properties.get(string);
    }

    public void setProperty(String string, Object object) {
        if (this.properties == null) {
            this.properties = new HashMap();
        }
        this.properties.put(string, object);
    }

    public PlatformData readData(InputStream inputStream, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Reading data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.init();
        try {
            byte[] byArray = this.readHeader(inputStream);
            String string2 = this.findEncoding(byArray);
            if (string2 == null) {
                string2 = string;
            }
            InputStream inputStream2 = inputStream;
            if (this.isEmptyToNull()) {
                inputStream2 = new EmptyElementInputStream(inputStream);
                inputStream2 = new BufferedInputStream(inputStream2);
            }
            byte[] byArray2 = byArray;
            SequenceInputStream sequenceInputStream = new SequenceInputStream(new ByteArrayInputStream(byArray2), inputStream2);
            InputStreamReader inputStreamReader = new InputStreamReader((InputStream)sequenceInputStream, string2);
            InputSource inputSource = new InputSource(inputStreamReader);
            inputSource.setEncoding(string2);
            return this.read(inputSource, dataTypeChanger);
        }
        catch (IOException iOException) {
            String string3 = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string3), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string3, iOException);
        }
    }

    public PlatformData readData(Reader reader, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            try {
                this.log.debug((Object)("Reading data: this=" + this + ", charset=" + (string != null ? URLEncoder.encode(string, "UTF-8") : null)));
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        this.init();
        Reader reader2 = null;
        try {
            char[] cArray = this.readHeader(reader);
            String string2 = this.findEncoding(cArray);
            reader2 = reader;
            if (this.isEmptyToNull()) {
                reader2 = new EmptyElementReader(reader);
                reader2 = new BufferedReader(reader2);
            }
            SequenceReader sequenceReader = new SequenceReader(new CharArrayReader(cArray), reader2);
            InputSource inputSource = new InputSource(sequenceReader);
            if (string2 == null) {
                inputSource.setEncoding(string);
            } else {
                inputSource.setEncoding(string2);
            }
            PlatformData platformData = this.read(inputSource, dataTypeChanger);
            return platformData;
        }
        catch (IOException iOException) {
            String string3 = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string3), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string3, iOException);
        }
        finally {
            if (reader2 != null) {
                try {
                    reader2.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    protected int getCurrentIndex() {
        return this.index;
    }

    protected void setCurrentIndex(int n) {
        this.index = n;
    }

    protected Variable getCurrentVariable() {
        return this.var;
    }

    protected void setCurrentVariable(Variable variable) {
        this.var = variable;
    }

    protected DataSet getCurrentDataSet() {
        return this.ds;
    }

    protected void setCurrentDataSet(DataSet dataSet) {
        this.ds = dataSet;
    }

    protected int[] getCurrentDataTypes() {
        return this.dataTypes;
    }

    protected void setCurrentDataTypes(int[] nArray) {
        this.dataTypes = nArray;
    }

    protected String getCurrentRowType() {
        return this.rowType;
    }

    protected void setCurrentRowType(String string) {
        this.rowType = string;
    }

    protected String getCurrentColumnName() {
        return this.columnName;
    }

    protected void setCurrentColumnName(String string) {
        this.columnName = string;
    }

    protected boolean getCurrentIsEmpty() {
        return this.isEmpty;
    }

    protected void setCurrentIsEmpty(boolean bl) {
        this.isEmpty = bl;
    }

    protected String getCurrentValue() {
        return this.value.toString();
    }

    protected void addCurrentValue(char[] cArray, int n, int n2) {
        this.value.append(cArray, n, n2);
    }

    protected void clearCurrentValue() {
        this.value.setLength(0);
    }

    protected PlatformData getData() {
        return this.data;
    }

    protected void setData(PlatformData platformData) {
        this.data = platformData;
    }

    protected DataTypeChanger getDataTypeChanger() {
        return this.dataTypeChanger;
    }

    protected void setDataTypeChanger(DataTypeChanger dataTypeChanger) {
        this.dataTypeChanger = dataTypeChanger;
    }

    protected PlatformData read(InputSource inputSource, DataTypeChanger dataTypeChanger) throws PlatformException {
        try {
            this.setDataTypeChanger(dataTypeChanger);
            SAXParser sAXParser = this.getSAXParser();
            XMLReader xMLReader = sAXParser.getXMLReader();
            xMLReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            xMLReader.setFeature("http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            xMLReader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            xMLReader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            sAXParser.parse(inputSource, (DefaultHandler)this);
            return this.getData();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)parserConfigurationException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, parserConfigurationException);
        }
        catch (SAXException sAXException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)sAXException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, sAXException);
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not deserialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not deserialize: contentType=" + string, iOException);
        }
    }

    private byte[] readHeader(InputStream inputStream) throws IOException {
        int n;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        do {
            n = inputStream.read();
            byteArrayOutputStream.write(n);
        } while (n != -1 && n != 62);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    private char[] readHeader(Reader reader) throws IOException {
        int n;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        do {
            n = reader.read();
            charArrayWriter.write(n);
        } while (n != -1 && n != 62);
        charArrayWriter.close();
        return charArrayWriter.toCharArray();
    }

    private String findEncoding(byte[] byArray) {
        return this.findEncoding(new String(byArray));
    }

    private String findEncoding(char[] cArray) {
        return this.findEncoding(new String(cArray));
    }

    private String findEncoding(String string) {
        String string2;
        int n;
        int n2;
        int n3;
        int n4 = string.indexOf("encoding");
        if (n4 != -1 && (n3 = string.indexOf(61, n4 + 8)) != -1 && (n2 = string.indexOf(34, n3 + 1)) != -1 && (n = string.indexOf(34, ++n2)) != -1 && (string2 = string.substring(n2, n).trim()).length() > 0) {
            return string2;
        }
        return null;
    }

    private byte[] removeEncoding(byte[] byArray) {
        int n;
        int n2;
        int n3;
        String string = new String(byArray);
        int n4 = string.indexOf("encoding");
        if (n4 != -1 && (n3 = string.indexOf(61, n4 + 8)) != -1 && (n2 = string.indexOf(34, n3 + 1)) != -1 && (n = string.indexOf(34, ++n2)) != -1) {
            String string2 = string.substring(0, n4).trim();
            String string3 = string.substring(n + 1).trim();
            if ("?>".equals(string3)) {
                return (string2 + string3).getBytes();
            }
            return (string2 + ' ' + string3).getBytes();
        }
        return byArray;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        if ("Col".equals(string3)) {
            this.startDataSetCell(attributes);
        } else if ("Row".equals(string3)) {
            this.startDataSetRow(attributes);
        } else if ("OrgRow".equals(string3)) {
            this.startDataSetSavedRow(attributes);
        } else if ("Column".equals(string3)) {
            this.startDataSetDefaultColumn(attributes);
        } else if ("Parameter".equals(string3)) {
            this.startVariable(attributes);
        } else if ("ConstColumn".equals(string3)) {
            this.startDataSetConstantColumn(attributes);
        } else if ("Rows".equals(string3)) {
            this.startDataSetRowList(attributes);
        } else if (!"ColumnInfo".equals(string3)) {
            if ("Dataset".equals(string3)) {
                this.startDataSet(attributes);
            } else if (!"Parameters".equals(string3) && "Root".equals(string3)) {
                this.startData();
            }
        }
    }

    public void endElement(String string, String string2, String string3) throws SAXException {
        if ("Col".equals(string3)) {
            this.endDataSetCell();
        } else if ("Row".equals(string3)) {
            this.endDataSetRow();
        } else if ("OrgRow".equals(string3)) {
            this.endDataSetSavedRow();
        } else if ("Column".equals(string3)) {
            this.endDataSetDefaultColumn();
        } else if ("Parameter".equals(string3)) {
            this.endVariable();
        } else if ("ConstColumn".equals(string3)) {
            this.endDataSetConstantColumn();
        } else if ("Rows".equals(string3)) {
            this.endDataSetRowList();
        } else if ("ColumnInfo".equals(string3)) {
            this.endDataSetColumnList();
        } else if ("Dataset".equals(string3)) {
            this.endDataSet();
        } else if ("Parameters".equals(string3)) {
            this.endVariableList();
        } else if ("Root".equals(string3)) {
            this.endData();
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        int n3 = this.getCurrentIndex();
        if (n3 == 1 || n3 == 3 || n3 == 5) {
            this.addCurrentValue(cArray, n, n2);
        }
    }

    protected void startData() {
        this.setData(new PlatformData());
    }

    protected void endData() {
        this.setCurrentIndex(0);
    }

    protected void endVariableList() {
        this.setCurrentIndex(0);
    }

    protected void startVariable(Attributes attributes) {
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("type");
        int n = this.getDataType(string2);
        boolean bl = "true".equals(attributes.getValue("empty"));
        if (this.isEmptyToNull()) {
            this.setCurrentIsEmpty(bl);
        }
        Variable variable = new Variable(string, n);
        this.setCurrentVariable(variable);
        this.setCurrentIndex(1);
    }

    protected void endVariable() {
        Variable variable = this.getCurrentVariable();
        int n = variable.getType();
        String string = this.getCurrentValue();
        if (!this.isNull(string, n)) {
            variable.set(string);
        }
        this.getData().addVariable(variable);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding Variable: " + variable));
        }
        this.setCurrentVariable(null);
        this.clearCurrentValue();
        this.setCurrentIsEmpty(false);
        this.setCurrentIndex(0);
    }

    protected void startDataSet(Attributes attributes) {
        String string = attributes.getValue("id");
        DataSet dataSet = new DataSet(string);
        this.isStoreDataChanges = dataSet.isStoreDataChanges();
        this.isCheckingSetterDataIndex = dataSet.isCheckingSetterDataIndex();
        if (this.isStoreDataChanges) {
            dataSet.stopStoreDataChanges();
        }
        if (this.isCheckingSetterDataIndex) {
            dataSet.setCheckingSetterDataIndex(false);
        }
        this.setCurrentDataSet(dataSet);
    }

    protected void endDataSet() {
        DataSet dataSet = this.getCurrentDataSet();
        if (this.isStoreDataChanges) {
            dataSet.startStoreDataChanges(true);
        }
        if (this.isCheckingSetterDataIndex) {
            dataSet.setCheckingSetterDataIndex(true);
        }
        this.getData().addDataSet(dataSet);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding DataSet: " + dataSet));
        }
        this.setCurrentDataSet(null);
        this.setCurrentIndex(0);
    }

    protected void endDataSetColumnList() {
        this.setCurrentIndex(0);
    }

    protected void startDataSetDefaultColumn(Attributes attributes) {
        DataSet dataSet = this.getCurrentDataSet();
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("type");
        String string3 = attributes.getValue("size");
        int n = this.getDataType(string2);
        int n2 = StringUtils.toInt(string3, DataTypes.getDefaultSize(n));
        dataSet.addColumn(string, n, n2);
    }

    protected void endDataSetDefaultColumn() {
        this.setCurrentIndex(0);
    }

    protected void startDataSetConstantColumn(Attributes attributes) {
        DataSet dataSet = this.getCurrentDataSet();
        String string = attributes.getValue("id");
        String string2 = attributes.getValue("type");
        String string3 = attributes.getValue("size");
        String string4 = attributes.getValue("value");
        int n = this.getDataType(string2);
        int n2 = StringUtils.toInt(string3, DataTypes.getDefaultSize(n));
        Object object = DataTypes.isBinary(n) ? Base64.decode(string4) : (Object)TypeConverter.convert(string4, n);
        dataSet.addConstantColumn(string, n, n2, object);
    }

    protected void endDataSetConstantColumn() {
        this.setCurrentIndex(0);
    }

    protected void startDataSetRowList(Attributes attributes) {
        int[] nArray = this.getSourceDataTypes(this.getCurrentDataSet(), this.getDataTypeChanger());
        this.setCurrentDataTypes(nArray);
    }

    protected void endDataSetRowList() {
        this.setCurrentDataTypes(null);
        this.setCurrentIndex(0);
    }

    protected void startDataSetRow(Attributes attributes) {
        DataSet dataSet = this.getCurrentDataSet();
        this.setCurrentRowType(attributes.getValue("type"));
        dataSet.newRow();
        this.setCurrentIndex(2);
    }

    protected void endDataSetRow() {
        DataSet dataSet = this.getCurrentDataSet();
        String string = this.getCurrentRowType();
        if ("insert".equals(string)) {
            dataSet.setRowType(dataSet.getRowCount() - 1, 1);
        } else if ("update".equals(string)) {
            dataSet.setRowType(dataSet.getRowCount() - 1, 2);
        } else if ("delete".equals(string)) {
            dataSet.setRowType(dataSet.getRowCount() - 1, 3);
        } else {
            dataSet.setRowType(dataSet.getRowCount() - 1, 0);
        }
        this.setCurrentIndex(0);
    }

    protected void startDataSetSavedRow(Attributes attributes) {
        this.setCurrentIndex(4);
    }

    protected void endDataSetSavedRow() {
        this.setCurrentIndex(2);
        DataSet dataSet = this.getCurrentDataSet();
        int n = dataSet.getRowCount() - 1;
        if (!dataSet.hasSavedRow(n) && dataSet.getColumnCount() > 0) {
            dataSet.setSavedData(n, 0, null);
        }
    }

    protected void startDataSetCell(Attributes attributes) {
        String string = attributes.getValue("id");
        boolean bl = "true".equals(attributes.getValue("empty"));
        if (this.isEmptyToNull()) {
            this.setCurrentIsEmpty(bl);
        }
        this.setCurrentColumnName(string);
        if (this.getCurrentIndex() == 2) {
            this.setCurrentIndex(3);
        } else if (this.getCurrentIndex() == 4) {
            this.setCurrentIndex(5);
        }
    }

    protected void endDataSetCell() {
        int n = this.getCurrentIndex();
        DataSet dataSet = this.getCurrentDataSet();
        int[] nArray = this.getCurrentDataTypes();
        String string = this.getCurrentColumnName();
        String string2 = this.getCurrentValue();
        int n2 = dataSet.indexOfColumn(string);
        int n3 = nArray[n2];
        int n4 = dataSet.getColumn(n2).getDataType();
        boolean bl = this.isNull(string2, n3);
        if (n == 3) {
            if (n4 == 13) {
                if (n3 == 2 || n3 == 12) {
                    try {
                        File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                        if (!bl) {
                            this.writeValueToFile(Base64.decode(string2), file);
                        }
                        dataSet.set(dataSet.getRowCount() - 1, string, file.getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        int n5 = dataSet.getRowCount() - 1;
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("Could not save: rowIndex=" + n5 + ", columnIndex=" + n2), (Throwable)iOException);
                        }
                    }
                }
            } else if (!bl) {
                if (DataTypes.isBinary(n3)) {
                    dataSet.set(dataSet.getRowCount() - 1, string, Base64.decode(string2));
                } else {
                    dataSet.set(dataSet.getRowCount() - 1, string, string2);
                }
            }
            this.setCurrentIndex(2);
        } else if (n == 5) {
            if (n4 == 13) {
                if (n3 == 2 || n3 == 12) {
                    try {
                        File file = File.createTempFile(PREFIX_FILE, SUFFIX_FILE);
                        if (!bl) {
                            this.writeValueToFile(Base64.decode(string2), file);
                        }
                        dataSet.setSavedData(dataSet.getRowCount() - 1, string, (Object)file.getAbsolutePath());
                    }
                    catch (IOException iOException) {
                        int n6 = dataSet.getRowCount() - 1;
                        if (this.log.isErrorEnabled()) {
                            this.log.error((Object)("Could not save: rowIndex=" + n6 + ", columnIndex=" + n2), (Throwable)iOException);
                        }
                    }
                }
            } else if (!bl) {
                if (DataTypes.isBinary(n3)) {
                    dataSet.setSavedData(dataSet.getRowCount() - 1, string, (Object)Base64.decode(string2));
                } else {
                    dataSet.setSavedData(dataSet.getRowCount() - 1, string, (Object)string2);
                }
            }
            this.setCurrentIndex(4);
        }
        this.setCurrentColumnName(null);
        this.clearCurrentValue();
        this.setCurrentIsEmpty(false);
    }

    protected int[] getSourceDataTypes(DataSet dataSet, DataTypeChanger dataTypeChanger) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            Object object;
            String string;
            String string2;
            int n2;
            int n3;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            nArray[i] = n3 = columnHeader.getDataType();
            if (dataTypeChanger == null || (n2 = dataTypeChanger.getDataType(string2 = dataSet.getAlias(), string = columnHeader.getName(), n3)) == n3) continue;
            int n4 = columnHeader.getDataSize();
            if (columnHeader.isConstant()) {
                if (n2 == 13) continue;
                object = ((ConstantColumnHeader)columnHeader).getValue();
                ConstantColumnHeader constantColumnHeader = new ConstantColumnHeader(string, object, n2, n4);
                dataSet.setColumn(i, constantColumnHeader);
                continue;
            }
            object = new ColumnHeader(string, n2, n4);
            dataSet.setColumn(i, (ColumnHeader)object);
        }
        return nArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeValueToFile(byte[] byArray, File file) throws IOException {
        FileOutputStream fileOutputStream = new FileOutputStream(file);
        try {
            fileOutputStream.write(byArray);
        }
        finally {
            fileOutputStream.close();
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Saving data to file: file=" + file));
        }
    }

    private boolean isNull(String string, int n) {
        if (this.getCurrentIsEmpty()) {
            return true;
        }
        return this.isEmptyToNull() && n == 2 && "".equals(string);
    }

    private void init() {
        this.isEmptyToNull = this.getEmptyToNull();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("init: isEmptyToNull=" + this.isEmptyToNull));
        }
    }

    private boolean isEmptyToNull() {
        return this.isEmptyToNull;
    }

    private boolean getEmptyToNull() {
        Object object = this.getProperty("deserializer.data.emptytonull");
        if ("true".equals(object)) {
            return true;
        }
        if ("false".equals(object)) {
            return false;
        }
        String string = System.getProperty("xapi.deserializer.data.emptytonull");
        return "true".equals(string);
    }

    private int getDataType(String string) {
        if ("binary".equalsIgnoreCase(string)) {
            return 12;
        }
        if ("float".equalsIgnoreCase(string)) {
            return 7;
        }
        return DataTypes.toIntType(string);
    }

    private SAXParser getSAXParser() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        String string = PlatformGlobals.getStringProperty(PARSER_FACTORY_KEY);
        if ("threadlocal".equals(string)) {
            return this.getSAXParserFromThreadLocal();
        }
        return this.createSAXParser();
    }

    private SAXParser createSAXParser() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        sAXParserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        sAXParserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        return sAXParserFactory.newSAXParser();
    }

    private SAXParser getSAXParserFromThreadLocal() throws FactoryConfigurationError, ParserConfigurationException, SAXException {
        if (parserThreadLocal == null) {
            parserThreadLocal = new ThreadLocal();
        }
        SAXParser sAXParser = (SAXParser)parserThreadLocal.get();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Getting SAXParser: thread=" + Thread.currentThread().getName() + ", parser=" + sAXParser));
        }
        if (sAXParser == null) {
            sAXParser = this.createSAXParser();
            parserThreadLocal.set(sAXParser);
        }
        return sAXParser;
    }
}

