/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.ConstantColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.util.TypeConverter;
import com.nexacro.xapi.tx.JavaTypeDataConverter;
import com.nexacro.xapi.tx.JavaTypeDataSerializer;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.impl.Base64;
import com.nexacro.xapi.tx.impl.PlatformCodec;
import com.nexacro.xapi.tx.impl.XmlCodec;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformXmlJavaTypeDataSerializer
implements JavaTypeDataSerializer {
    private Log log = LogFactory.getLog((Class)PlatformXmlJavaTypeDataSerializer.class);
    private static final boolean NULL_IS_SINGLE_TAG = true;
    private static final boolean WRITE_NULL_VALUE = false;
    private static final String NL = System.getProperty("line.separator");
    private static final String[] TABS = new String[]{"", "\t", "\t\t", "\t\t\t", "\t\t\t\t", "\t\t\t\t\t"};
    private static final String XML_NS = "http://www.nexacro.com/platform/dataset";
    private static final String VERSION = "5000";
    private PlatformCodec platformCodec = new PlatformCodec();
    private XmlCodec xmlCodec = new XmlCodec();
    private String charset;
    private JavaTypeDataConverter dataConverter;
    private Writer out;
    private int depth;
    private Class dataClass;
    private List columnHeaders = new ArrayList();

    public void setProperty(String string, Object object) {
    }

    public void setCharset(String string) {
        this.charset = string;
    }

    public void setDataConverter(JavaTypeDataConverter javaTypeDataConverter) {
        this.dataConverter = javaTypeDataConverter;
    }

    public void setOutputStream(OutputStream outputStream) throws PlatformException {
        try {
            this.out = this.charset == null ? new OutputStreamWriter(outputStream) : new OutputStreamWriter(outputStream, this.charset);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)unsupportedEncodingException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, unsupportedEncodingException);
        }
    }

    public void setWriter(Writer writer) throws PlatformException {
        this.out = writer;
    }

    public void writeHead() throws PlatformException {
        try {
            if (this.charset == null) {
                this.writeString(this.out, "<?xml version=\"1.0\"?>", this.depth);
            } else {
                this.writeString(this.out, "<?xml version=\"1.0\" encoding=\"" + this.charset + "\"?>", this.depth);
            }
            this.writeString(this.out, "<Root xmlns=\"http://www.nexacro.com/platform/dataset\" ver=\"5000\">", this.depth);
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    public void writeTail() throws PlatformException {
        try {
            if (this.dataClass == Variable.class) {
                --this.depth;
                this.writeString(this.out, "</Parameters>", this.depth);
                --this.depth;
            } else if (this.dataClass == DataSet.class) {
                this.writeString(this.out, "</Dataset>", this.depth);
                --this.depth;
            } else if (this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                --this.depth;
                this.writeString(this.out, "</ColumnInfo>", this.depth);
                --this.depth;
                this.writeString(this.out, "</Dataset>", this.depth);
                --this.depth;
            } else if (this.dataClass == Object.class) {
                --this.depth;
                this.writeString(this.out, "</Rows>", this.depth);
                --this.depth;
                this.writeString(this.out, "</Dataset>", this.depth);
                --this.depth;
            }
            this.writeString(this.out, "</Root>", this.depth);
            this.out.flush();
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    public void writeVariable(String string, int n, Object object) throws PlatformException {
        try {
            if (this.dataClass == null) {
                ++this.depth;
                this.writeString(this.out, "<Parameters>", this.depth);
                ++this.depth;
            }
            if (DataTypes.isBinary(n)) {
                this.writeBinaryVariable(string, n, object);
            } else {
                this.writeStringVariable(string, n, object);
            }
            this.dataClass = Variable.class;
        }
        catch (IOException iOException) {
            String string2 = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string2), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string2, iOException);
        }
    }

    public void writeDataSet(String string) throws PlatformException {
        try {
            String string2 = string;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Writing DataSet: name=" + string + ", alias=" + string2));
            }
            if (this.dataClass == Variable.class) {
                --this.depth;
                this.writeString(this.out, "</Parameters>", this.depth);
            } else if (this.dataClass == DataSet.class) {
                this.writeString(this.out, "</Dataset>", this.depth);
            } else if (this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                this.columnHeaders.clear();
                --this.depth;
                this.writeString(this.out, "</ColumnInfo>", this.depth);
                --this.depth;
                this.writeString(this.out, "</Dataset>", this.depth);
            } else if (this.dataClass == Object.class) {
                this.columnHeaders.clear();
                --this.depth;
                this.writeString(this.out, "</Rows>", this.depth);
                --this.depth;
                this.writeString(this.out, "</Dataset>", this.depth);
            } else {
                ++this.depth;
            }
            this.writeString(this.out, "<Dataset id=\"" + string2 + "\">", this.depth);
            this.dataClass = DataSet.class;
        }
        catch (IOException iOException) {
            String string3 = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string3), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string3, iOException);
        }
    }

    public void writeDataSetHeader(String string, int n, int n2) throws PlatformException {
        try {
            if (this.dataClass == DataSet.class) {
                ++this.depth;
                this.writeString(this.out, "<ColumnInfo>", this.depth);
                ++this.depth;
            }
            this.columnHeaders.add(new ColumnHeader(string, n, n2));
            this.writeDefaultColumnHeader(string, n, n2);
            this.dataClass = ColumnHeader.class;
        }
        catch (IOException iOException) {
            String string2 = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string2), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string2, iOException);
        }
    }

    public void writeDataSetConstantHeader(String string, int n, int n2, Object object) throws PlatformException {
        try {
            if (this.dataClass == DataSet.class) {
                ++this.depth;
                this.writeString(this.out, "<ColumnInfo>", this.depth);
                ++this.depth;
            }
            this.writeConstantColumnHeader(string, n, n2, object);
            this.dataClass = ConstantColumnHeader.class;
        }
        catch (IOException iOException) {
            String string2 = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string2), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string2, iOException);
        }
    }

    public void writeDataSetRow(Object[] objectArray) throws PlatformException {
        try {
            if (this.dataClass == ColumnHeader.class || this.dataClass == ConstantColumnHeader.class) {
                --this.depth;
                this.writeString(this.out, "</ColumnInfo>", this.depth);
                this.writeString(this.out, "<Rows>", this.depth);
                ++this.depth;
            }
            this.writeRow(this.columnHeaders, objectArray);
            this.dataClass = Object.class;
        }
        catch (IOException iOException) {
            String string = "PlatformXml";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string, iOException);
        }
    }

    private void writeStringVariable(String string, int n, Object object) throws IOException {
        String string2 = this.getDataType(n);
        String string3 = this.getStringValue(n, object);
        int n2 = string3 == null ? 0 : string3.length();
        StringBuffer stringBuffer = new StringBuffer(n2 + 64);
        stringBuffer.append("<Parameter id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        if (string3 == null) {
            stringBuffer.append("\"/>");
        } else {
            stringBuffer.append("\">").append(string3);
            stringBuffer.append("</Parameter>");
        }
        this.writeString(this.out, stringBuffer.toString(), this.depth);
    }

    private void writeBinaryVariable(String string, int n, Object object) throws IOException {
        String string2 = this.getDataType(n);
        byte[] byArray = this.getBinaryValue(n, object);
        if (byArray == null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("<Parameter id=\"").append(string);
            stringBuffer.append("\" type=\"").append(string2);
            stringBuffer.append("\"/>");
            this.writeString(this.out, stringBuffer.toString(), this.depth);
        } else {
            String string3 = "<Parameter id=\"" + string + "\" type=\"" + string2 + "\" encrypt=\"base64\">";
            String string4 = "</Parameter>";
            this.writeBinary(this.out, byArray, string3, string4, this.depth);
        }
    }

    private void writeDefaultColumnHeader(String string, int n, int n2) throws IOException {
        String string2 = this.getDataType(n);
        StringBuffer stringBuffer = new StringBuffer(64);
        stringBuffer.append("<Column id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        stringBuffer.append("\" size=\"").append(n2);
        if (n == 13 || DataTypes.isBinary(n)) {
            stringBuffer.append("\" encrypt=\"").append("base64");
        }
        stringBuffer.append("\"/>");
        this.writeString(this.out, stringBuffer.toString(), this.depth);
    }

    private void writeConstantColumnHeader(String string, int n, int n2, Object object) throws IOException {
        if (DataTypes.isBinary(n)) {
            this.writeBinaryColumnHeader(string, n, n2, object);
        } else {
            this.writeStringColumnHeader(string, n, n2, object);
        }
    }

    private void writeStringColumnHeader(String string, int n, int n2, Object object) throws IOException {
        if (n == 13) {
            n = 2;
        }
        String string2 = this.getDataType(n);
        String string3 = this.getStringValue(n, object);
        int n3 = string3 == null ? 0 : string3.length();
        StringBuffer stringBuffer = new StringBuffer(n3 + 64);
        stringBuffer.append("<ConstColumn id=\"").append(string);
        stringBuffer.append("\" type=\"").append(string2);
        stringBuffer.append("\" size=\"").append(n2);
        if (string3 != null) {
            stringBuffer.append("\" value=\"").append(string3);
        }
        stringBuffer.append("\"/>");
        this.writeString(this.out, stringBuffer.toString(), this.depth);
    }

    private void writeBinaryColumnHeader(String string, int n, int n2, Object object) throws IOException {
        String string2 = this.getDataType(n);
        byte[] byArray = this.getBinaryValue(n, object);
        if (byArray == null) {
            StringBuffer stringBuffer = new StringBuffer(64);
            stringBuffer.append("<ConstColumn id=\"").append(string);
            stringBuffer.append("\" type=\"").append(string2);
            stringBuffer.append("\" size=\"").append(n2);
            stringBuffer.append("\"/>");
            this.writeString(this.out, stringBuffer.toString(), this.depth);
        } else {
            String string3 = "<ConstColumn id=\"" + string + "\" type=\"" + string2 + "\" size=\"" + n2 + "\" encrypt=\"base64\" value=\"";
            String string4 = "\"></ConstColumn>";
            this.writeBinary(this.out, byArray, string3, string4, this.depth);
        }
    }

    private void writeRow(List list, Object[] objectArray) throws IOException {
        this.writeString(this.out, "<Row>", this.depth++);
        int n = Math.min(list.size(), objectArray.length);
        for (int i = 0; i < n; ++i) {
            Object object;
            ColumnHeader columnHeader = (ColumnHeader)list.get(i);
            String string = columnHeader.getName();
            int n2 = columnHeader.getDataType();
            if (n2 == 13 || DataTypes.isBinary(n2)) {
                object = this.getBinaryValue(n2, objectArray[i]);
                if (object == null) continue;
                String string2 = "<Col id=\"" + string + "\">";
                String string3 = "</Col>";
                this.writeBinary(this.out, (byte[])object, string2, string3, this.depth);
                continue;
            }
            object = this.getStringValue(n2, objectArray[i]);
            if (object == null) continue;
            this.writeString(this.out, "<Col id=\"" + string + "\">" + (String)object + "</Col>", this.depth);
        }
        this.writeString(this.out, "</Row>", --this.depth);
    }

    private String getStringValue(int n, Object object) {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 2: {
                String string = this.dataConverter.toString(object, this.charset);
                return this.encode(string);
            }
            case 3: {
                int n2 = this.dataConverter.toInt(object);
                return (String)TypeConverter.convert(n2, 2);
            }
            case 4: {
                boolean bl = this.dataConverter.toBoolean(object);
                return bl ? "1" : "0";
            }
            case 5: {
                long l = this.dataConverter.toLong(object);
                return (String)TypeConverter.convert(l, 2);
            }
            case 8: {
                BigDecimal bigDecimal = this.dataConverter.toBigDecimal(object);
                return (String)TypeConverter.convert(bigDecimal, 2);
            }
            case 6: {
                float f = this.dataConverter.toFloat(object);
                return (String)TypeConverter.convert(f, 2);
            }
            case 7: {
                double d = this.dataConverter.toDouble(object);
                return (String)TypeConverter.convert(d, 2);
            }
            case 9: 
            case 10: 
            case 11: {
                Date date = this.dataConverter.toDateTime(object);
                return (String)TypeConverter.convert(date, 2);
            }
            case 12: {
                byte[] byArray = this.dataConverter.toBlob(object, this.charset);
                return (String)TypeConverter.convert(byArray, 2);
            }
        }
        return null;
    }

    private byte[] getBinaryValue(int n, Object object) {
        if (object == null) {
            return null;
        }
        switch (n) {
            case 2: {
                String string = this.dataConverter.toString(object, this.charset);
                return (byte[])TypeConverter.convert(string, 12);
            }
            case 3: {
                int n2 = this.dataConverter.toInt(object);
                return (byte[])TypeConverter.convert(n2, 12);
            }
            case 4: {
                boolean bl = this.dataConverter.toBoolean(object);
                return (byte[])TypeConverter.convert(bl, 12);
            }
            case 5: {
                long l = this.dataConverter.toLong(object);
                return (byte[])TypeConverter.convert(l, 12);
            }
            case 8: {
                BigDecimal bigDecimal = this.dataConverter.toBigDecimal(object);
                return (byte[])TypeConverter.convert(bigDecimal, 12);
            }
            case 6: {
                float f = this.dataConverter.toFloat(object);
                return (byte[])TypeConverter.convert(f, 12);
            }
            case 7: {
                double d = this.dataConverter.toDouble(object);
                return (byte[])TypeConverter.convert(d, 12);
            }
            case 9: 
            case 10: 
            case 11: {
                Date date = this.dataConverter.toDateTime(object);
                return (byte[])TypeConverter.convert(date, 12);
            }
            case 12: {
                byte[] byArray = this.dataConverter.toBlob(object, this.charset);
                return (byte[])TypeConverter.convert(byArray, 12);
            }
        }
        return null;
    }

    private void writeString(Writer writer, String string, int n) throws IOException {
        if (n == 0) {
            writer.write(string);
            writer.write(NL);
        } else if (n < 6) {
            writer.write(TABS[n]);
            writer.write(string);
            writer.write(NL);
        } else {
            for (int i = 0; i < n; ++i) {
                writer.write(TABS[1]);
            }
            writer.write(string);
            writer.write(NL);
        }
    }

    private void writeBinary(Writer writer, byte[] byArray, String string, String string2, int n) throws IOException {
        if (n == 0) {
            writer.write(string);
            String string3 = Base64.encodeBytes(byArray, 8);
            writer.write(string3);
            writer.write(string2);
            writer.write(NL);
        } else if (n < 6) {
            writer.write(TABS[n]);
            writer.write(string);
            String string4 = Base64.encodeBytes(byArray, 8);
            writer.write(string4);
            writer.write(string2);
            writer.write(NL);
        } else {
            for (int i = 0; i < n; ++i) {
                writer.write(TABS[1]);
            }
            writer.write(string);
            String string5 = Base64.encodeBytes(byArray, 8);
            writer.write(string5);
            writer.write(string2);
            writer.write(NL);
        }
    }

    private String getDataType(int n) {
        if (n == 4) {
            return DataTypes.toStringType(3);
        }
        if (n == 5) {
            return DataTypes.toStringType(8);
        }
        if (n == 7) {
            return DataTypes.toStringType(6);
        }
        if (n == 13) {
            return DataTypes.toStringType(12);
        }
        return DataTypes.toStringType(n);
    }

    private String encode(String string) {
        if (string == null) {
            return string;
        }
        return this.xmlCodec.encode(this.platformCodec.encode(string));
    }
}

