/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.tx.impl;

import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xapi.tx.ProtocolDecoder;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformZlibByteDecoder
extends InflaterInputStream
implements ProtocolDecoder {
    private Log log = LogFactory.getLog((Class)PlatformZlibByteDecoder.class);
    private static final int ZLIB_SIGNATURE = 65453;
    private Inflater inflater;

    public PlatformZlibByteDecoder(InputStream inputStream) throws IOException {
        this(inputStream, PlatformZlibByteDecoder.createInflater());
    }

    private PlatformZlibByteDecoder(InputStream inputStream, Inflater inflater) throws IOException {
        super(inputStream, inflater);
        this.inflater = inflater;
        this.readSignature();
    }

    public void close() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing: " + this));
        }
        super.close();
    }

    public void end() throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Ending: " + this));
        }
        this.inflater.end();
    }

    private void readSignature() throws IOException {
        int n = this.readShort(this.in);
        if (!this.isValidSignature(n)) {
            String string = "0x" + Integer.toHexString(n);
            throw new IOException("Invalid ZLIB data format: signature=" + string);
        }
    }

    private boolean isValidSignature(int n) {
        return n == 65453;
    }

    private int readShort(InputStream inputStream) throws IOException {
        int n;
        int n2 = inputStream.read();
        if ((n2 | (n = inputStream.read())) < 0) {
            throw new EOFException("Reading short failed");
        }
        return (n2 << 8) + (n << 0);
    }

    private static Inflater createInflater() {
        return new Inflater();
    }
}

