/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.util;

import java.util.Calendar;
import java.util.Date;

public class DatetimeFormat {
    public static final int FORMAT_FULL_DATE_TIME = 0;
    public static final int FORMAT_DATE_TIME = 1;
    public static final int FORMAT_DATE = 2;
    public static final int FORMAT_FULL_TIME = 3;
    public static final int FORMAT_TIME = 4;
    private static final int[] SIZES_FORMAT = new int[]{"yyyyMMddHHmmssSSS".length(), "yyyyMMddHHmmss".length(), "yyyyMMdd".length(), "HHmmssSSS".length(), "HHmmss".length()};
    private int format;

    public DatetimeFormat() {
    }

    public DatetimeFormat(int n) {
        this.format = n;
    }

    public int getFormat() {
        return this.format;
    }

    public void setFormat(int n) {
        this.checkFormat(n);
        this.format = n;
    }

    public String format(Date date) {
        if (date == null) {
            return null;
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        StringBuffer stringBuffer = this.createStringBuffer(this.format);
        switch (this.format) {
            case 0: {
                this.appendFullDateTime(stringBuffer, calendar);
                break;
            }
            case 1: {
                this.appendDateTime(stringBuffer, calendar);
                break;
            }
            case 2: {
                this.appendDate(stringBuffer, calendar);
                break;
            }
            case 3: {
                this.appendFullTime(stringBuffer, calendar);
                break;
            }
            case 4: {
                this.appendTime(stringBuffer, calendar);
            }
        }
        return stringBuffer.toString();
    }

    public Date parse(String string) {
        if (string == null) {
            return null;
        }
        if (!this.isValidLength(this.format, string)) {
            return null;
        }
        switch (this.format) {
            case 0: {
                return this.parseFullDateTime(string);
            }
            case 1: {
                return this.parseDateTime(string);
            }
            case 2: {
                return this.parseDate(string);
            }
            case 3: {
                return this.parseFullTime(string);
            }
            case 4: {
                return this.parseTime(string);
            }
        }
        return this.parseFullDateTime(string);
    }

    private StringBuffer appendFullDateTime(StringBuffer stringBuffer, Calendar calendar) {
        this.appendDate(stringBuffer, calendar);
        this.appendFullTime(stringBuffer, calendar);
        return stringBuffer;
    }

    private StringBuffer appendDateTime(StringBuffer stringBuffer, Calendar calendar) {
        this.appendDate(stringBuffer, calendar);
        this.appendTime(stringBuffer, calendar);
        return stringBuffer;
    }

    private StringBuffer appendDate(StringBuffer stringBuffer, Calendar calendar) {
        int n = calendar.get(1);
        int n2 = calendar.get(2) + 1;
        int n3 = calendar.get(5);
        stringBuffer.append(n);
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        return stringBuffer;
    }

    private StringBuffer appendFullTime(StringBuffer stringBuffer, Calendar calendar) {
        this.appendTime(stringBuffer, calendar);
        int n = calendar.get(14);
        if (n < 10) {
            stringBuffer.append("00");
        } else if (n < 100) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        return stringBuffer;
    }

    private StringBuffer appendTime(StringBuffer stringBuffer, Calendar calendar) {
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        if (n < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n);
        if (n2 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n2);
        if (n3 < 10) {
            stringBuffer.append('0');
        }
        stringBuffer.append(n3);
        return stringBuffer;
    }

    private Date parseFullDateTime(String string) {
        char[] cArray = string.toCharArray();
        int n = this.toInt(cArray, 0, 4);
        int n2 = this.toInt(cArray, 4, 2);
        int n3 = this.toInt(cArray, 6, 2);
        int n4 = this.toInt(cArray, 8, 2);
        int n5 = this.toInt(cArray, 10, 2);
        int n6 = this.toInt(cArray, 12, 2);
        int n7 = this.toInt(cArray, 14, 3);
        Calendar calendar = Calendar.getInstance();
        this.applyDate(calendar, n, n2, n3);
        this.applyFullTime(calendar, n4, n5, n6, n7);
        return calendar.getTime();
    }

    private Date parseDateTime(String string) {
        char[] cArray = string.toCharArray();
        int n = this.toInt(cArray, 0, 4);
        int n2 = this.toInt(cArray, 4, 2);
        int n3 = this.toInt(cArray, 6, 2);
        int n4 = this.toInt(cArray, 8, 2);
        int n5 = this.toInt(cArray, 10, 2);
        int n6 = this.toInt(cArray, 12, 2);
        int n7 = 0;
        Calendar calendar = Calendar.getInstance();
        this.applyDate(calendar, n, n2, n3);
        this.applyFullTime(calendar, n4, n5, n6, n7);
        return calendar.getTime();
    }

    private Date parseDate(String string) {
        char[] cArray = string.toCharArray();
        int n = this.toInt(cArray, 0, 4);
        int n2 = this.toInt(cArray, 4, 2);
        int n3 = this.toInt(cArray, 6, 2);
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        Calendar calendar = Calendar.getInstance();
        this.applyDate(calendar, n, n2, n3);
        this.applyFullTime(calendar, n4, n5, n6, n7);
        return calendar.getTime();
    }

    private Date parseFullTime(String string) {
        char[] cArray = string.toCharArray();
        int n = this.toInt(cArray, 0, 2);
        int n2 = this.toInt(cArray, 2, 2);
        int n3 = this.toInt(cArray, 4, 2);
        int n4 = this.toInt(cArray, 6, 3);
        Calendar calendar = Calendar.getInstance();
        this.applyFullTime(calendar, n, n2, n3, n4);
        return calendar.getTime();
    }

    private Date parseTime(String string) {
        char[] cArray = string.toCharArray();
        int n = this.toInt(cArray, 0, 2);
        int n2 = this.toInt(cArray, 2, 2);
        int n3 = this.toInt(cArray, 4, 2);
        int n4 = 0;
        Calendar calendar = Calendar.getInstance();
        this.applyFullTime(calendar, n, n2, n3, n4);
        return calendar.getTime();
    }

    private void applyDate(Calendar calendar, int n, int n2, int n3) {
        calendar.set(1, n);
        calendar.set(2, n2 - 1);
        calendar.set(5, n3);
    }

    private void applyFullTime(Calendar calendar, int n, int n2, int n3, int n4) {
        calendar.set(11, n);
        calendar.set(12, n2);
        calendar.set(13, n3);
        calendar.set(14, n4);
    }

    private int toInt(char[] cArray, int n, int n2) {
        if (n2 == 2) {
            int n3 = cArray[n] - 48;
            int n4 = cArray[n + 1] - 48;
            return n3 * 10 + n4;
        }
        if (n2 == 4) {
            int n5 = cArray[n] - 48;
            int n6 = cArray[n + 1] - 48;
            int n7 = cArray[n + 2] - 48;
            int n8 = cArray[n + 3] - 48;
            return n5 * 1000 + n6 * 100 + n7 * 10 + n8;
        }
        if (n2 == 3) {
            int n9 = cArray[n] - 48;
            int n10 = cArray[n + 1] - 48;
            int n11 = cArray[n + 2] - 48;
            return n9 * 100 + n10 * 10 + n11;
        }
        if (n2 == 1) {
            int n12 = cArray[n] - 48;
            return n12;
        }
        return Integer.parseInt(new String(cArray, n, n2));
    }

    private StringBuffer createStringBuffer(int n) {
        return new StringBuffer(SIZES_FORMAT[n]);
    }

    private boolean isValidLength(int n, String string) {
        return string.length() == SIZES_FORMAT[n];
    }

    private void checkFormat(int n) {
        if (n < 0 || n > 4) {
            throw new IllegalArgumentException();
        }
    }
}

