/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.util;

import com.nexacro.xapi.license.A.D;
import com.nexacro.xapi.license.InvalidLicenseException;
import com.nexacro.xapi.license.License;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.List;

public class JarInfo {
    public void info(OutputStream outputStream) throws IOException {
        this.info(new OutputStreamWriter(outputStream));
    }

    public void info(Writer writer) throws IOException {
        this.infoManifest(writer);
        if (this.checkClasspath()) {
            this.infoLicense(writer);
        } else {
            this.infoClasspath(writer);
        }
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void infoManifest(Writer writer) throws IOException {
        String string = System.getProperty("line.separator");
        writer.write("--- Manifest ---");
        writer.write(string);
        URL uRL = this.getClass().getResource("/com/nexacro/xapi/util/JarInfo.class");
        String string2 = uRL.getProtocol();
        String string3 = uRL.getHost();
        String string4 = uRL.getFile();
        int n = string4.indexOf(33);
        if (n == -1) {
            writer.write("File not found");
            writer.flush();
            return;
        }
        URL uRL2 = new URL(string2, string3, string4.substring(0, n + 1) + "/META-INF/MANIFEST.MF");
        InputStream inputStream = uRL2.openStream();
        InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
        try {
            int n2;
            char[] cArray = new char[1024];
            while ((n2 = inputStreamReader.read(cArray)) != -1) {
                writer.write(cArray, 0, n2);
            }
            writer.flush();
        }
        finally {
            try {
                ((Reader)inputStreamReader).close();
            }
            catch (IOException iOException) {}
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private void infoLicense(Writer writer) throws IOException {
        try {
            License license = License.getInstance(0);
            this.writeLogs(writer, D.B);
            this.writeLicense(writer, license);
        }
        catch (InvalidLicenseException invalidLicenseException) {
            this.writeLogs(writer, D.B);
            this.writeThrowable(writer, invalidLicenseException);
        }
    }

    private void writeLogs(Writer writer, List list) throws IOException {
        int n = list.size();
        if (n > 0) {
            String string = System.getProperty("line.separator");
            writer.write("--- Log ---");
            writer.write(string);
            for (int i = 0; i < n; ++i) {
                writer.write(list.get(i).toString());
                writer.write(string);
            }
            writer.write(string);
        }
    }

    private void writeLicense(Writer writer, License license) throws IOException {
        String string = System.getProperty("line.separator");
        writer.write("--- License ---");
        writer.write(string);
        String[] stringArray = new String[]{"product.name", "product.version", "product.function", "customer.name", "server.cpuCoreCount", "server.ipAddress", "date.activation", "date.term", "date.term.unit"};
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String string2 = stringArray[i];
            String string3 = license.getFeature(string2);
            if (string3 == null) {
                string3 = "";
            }
            writer.write(string2);
            writer.write(": ");
            writer.write(string3);
            writer.write(string);
        }
        if ("nexacro platform".equals(license.getProductName()) && !license.isValidTime()) {
            writer.write(string);
            writer.write("License has expired");
        }
    }

    private void writeThrowable(Writer writer, Throwable throwable) throws IOException {
        String string = System.getProperty("line.separator");
        writer.write("--- Exception ---");
        writer.write(string);
        writer.write(this.toString(throwable));
    }

    private boolean checkClasspath() {
        try {
            Class.forName("org.apache.commons.logging.LogFactory");
            return true;
        }
        catch (Throwable throwable) {
            return false;
        }
    }

    private void infoClasspath(Writer writer) throws IOException {
        String string = System.getProperty("line.separator");
        writer.write("--- Log ---");
        writer.write(string);
        writer.write("Apache Commons Logging not found.");
    }

    private String toString(Throwable throwable) throws IOException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        printWriter.close();
        stringWriter.close();
        return stringWriter.toString();
    }

    public static void main(String[] stringArray) throws IOException {
        new JarInfo().info(System.out);
    }
}

