/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xapi.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformGlobals {
    private static final String PROPERTIES_NAME = "x-api.properties";
    private static final String DEFAULT_VALUE_STRING = null;
    private static final char DEFAULT_VALUE_CHAR = ' ';
    private static final int DEFAULT_VALUE_INT = 0;
    private static final boolean DEFAULT_VALUE_BOOLEAN = false;
    private static Map map = new HashMap();

    private PlatformGlobals() {
    }

    public static Object getProperty(String string) {
        return map.get(string);
    }

    public static void setProperty(String string, Object object) {
        map.put(string, object);
    }

    public static void removeProperty(String string) {
        map.remove(string);
    }

    public static String getStringProperty(String string) {
        return PlatformGlobals.getStringProperty(string, DEFAULT_VALUE_STRING);
    }

    public static String getStringProperty(String string, String string2) {
        Object object = PlatformGlobals.getProperty(string);
        return object == null ? string2 : object.toString();
    }

    public static char getCharProperty(String string) {
        return PlatformGlobals.getCharProperty(string, ' ');
    }

    public static char getCharProperty(String string, char c) {
        Object object = PlatformGlobals.getProperty(string);
        if (object instanceof String) {
            String string2 = object.toString();
            if (string2.length() > 1) {
                string2 = string2.trim();
            }
            if (string2.length() == 1) {
                return string2.charAt(0);
            }
        } else if (object instanceof Character) {
            return ((Character)object).charValue();
        }
        return c;
    }

    public static int getIntProperty(String string) {
        return PlatformGlobals.getIntProperty(string, 0);
    }

    public static int getIntProperty(String string, int n) {
        Object object = PlatformGlobals.getProperty(string);
        if (object instanceof String) {
            try {
                return Integer.parseInt(object.toString());
            }
            catch (NumberFormatException numberFormatException) {
            }
        } else if (object instanceof Integer) {
            return (Integer)object;
        }
        return n;
    }

    public static void setProperty(String string, int n) {
        PlatformGlobals.setProperty(string, new Integer(n));
    }

    public static boolean getBooleanProperty(String string) {
        return PlatformGlobals.getBooleanProperty(string, false);
    }

    public static boolean getBooleanProperty(String string, boolean bl) {
        Object object = PlatformGlobals.getProperty(string);
        if (object instanceof String) {
            String string2 = object.toString().toLowerCase();
            return "true".equals(string2) || "on".equals(string2) || "yes".equals(string2);
        }
        if (object instanceof Boolean) {
            return (Boolean)object;
        }
        return bl;
    }

    public static void setProperty(String string, boolean bl) {
        PlatformGlobals.setProperty(string, bl ? Boolean.TRUE : Boolean.FALSE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load(URL uRL) {
        if (uRL == null) {
            return;
        }
        InputStream inputStream = null;
        try {
            inputStream = uRL.openStream();
            Properties properties = new Properties();
            properties.load(inputStream);
            map.putAll(properties);
        }
        catch (IOException iOException) {
            Log log = LogFactory.getLog((Class)PlatformGlobals.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not load properties file", (Throwable)iOException);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static URL getResource(String string) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.getResource(string);
        }
        catch (Throwable throwable) {
            Log log = LogFactory.getLog((Class)PlatformGlobals.class);
            if (log.isTraceEnabled()) {
                log.trace((Object)"Could not find properties file", throwable);
            }
            return null;
        }
    }

    static {
        PlatformGlobals.load(PlatformGlobals.getResource(PROPERTIES_NAME));
    }
}

