/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.data;

import com.nexacro.xeni.data.importformats.ImportFormat;
import java.io.StringReader;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.helpers.DefaultHandler;

public class GridImportFormatFactory
extends DefaultHandler {
    private static final Log oLogger = LogFactory.getLog(GridImportFormatFactory.class);
    private static GridImportFormatFactory oGridImportFormatFactory;
    private ImportFormat importformat;

    public static GridImportFormatFactory getInstance() {
        if (oGridImportFormatFactory == null) {
            oGridImportFormatFactory = new GridImportFormatFactory();
        }
        return oGridImportFormatFactory;
    }

    public ImportFormat readFormatString(String string) {
        InputSource inputSource = new InputSource(new StringReader(string));
        SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
        sAXParserFactory.setNamespaceAware(true);
        try {
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            sAXParser.parse(inputSource, (DefaultHandler)this);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return this.importformat;
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) {
        if ("Sheet".equals(string3)) {
            this.startSheet(attributes);
        } else if ("Import".equals(string3)) {
            this.startData();
        }
    }

    public void endElement(String string, String string2, String string3) {
        if ("Sheet".equals(string3) || "Import".equals(string3)) {
            // empty if block
        }
    }

    public void characters(char[] cArray, int n, int n2) {
    }

    protected void startData() {
        this.setData(new ImportFormat());
    }

    protected void setData(ImportFormat importFormat) {
        this.importformat = importFormat;
    }

    protected ImportFormat getData() {
        return this.importformat;
    }

    protected void startSheet(Attributes attributes) {
        String string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        for (int i = 0; i < attributes.getLength(); ++i) {
            String string5 = attributes.getQName(i);
            String string6 = attributes.getValue(i);
            if ("command".equalsIgnoreCase(string5)) {
                string = string6;
            }
            if ("output".equalsIgnoreCase(string5)) {
                string2 = string6;
            }
            if ("head".equalsIgnoreCase(string5)) {
                string3 = string6;
            }
            if (!"body".equalsIgnoreCase(string5)) continue;
            string4 = string6;
        }
        this.getData().addSheet(string, string2, string3, string4);
    }
}

