/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.data.exportformats;

import com.nexacro.xeni.data.exportformats.FormatCell;
import com.nexacro.xeni.data.exportformats.FormatColumn;
import com.nexacro.xeni.data.exportformats.FormatRow;
import java.util.ArrayList;
import java.util.List;

public class ExportFormat {
    private String id = null;
    private List<FormatColumn> columns = new ArrayList<FormatColumn>();
    private List<FormatRow> rows = new ArrayList<FormatRow>();
    private List<FormatCell> head = new ArrayList<FormatCell>();
    private List<FormatCell> body = new ArrayList<FormatCell>();
    private List<FormatCell> summary = new ArrayList<FormatCell>();
    protected static final int DATA_BAND_HEAD = 3;
    protected static final int DATA_BAND_BODY = 4;
    protected static final int DATA_BAND_SUMMARY = 5;

    public String getId() {
        return this.id;
    }

    public void setId(String string) {
        this.id = string;
    }

    public void addColumn(String string) {
        FormatColumn formatColumn = new FormatColumn();
        formatColumn.setSize(string);
        this.columns.add(formatColumn);
    }

    public FormatColumn getColumn(int n) {
        return this.columns.get(n);
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void addRow(String string, String string2) {
        FormatRow formatRow = new FormatRow();
        formatRow.setSize(string);
        formatRow.setBand(string2 == null ? "body" : string2);
        this.rows.add(formatRow);
    }

    public FormatRow getRow(int n) {
        return this.rows.get(n);
    }

    public int getRowCount() {
        return this.rows.size();
    }

    public int getRowCountOfEachBand(String string) {
        int n = 0;
        for (int i = 0; i < this.rows.size(); ++i) {
            FormatRow formatRow = this.rows.get(i);
            if (formatRow == null || !formatRow.getBand().equals(string)) continue;
            ++n;
        }
        return n;
    }

    public void addCell(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8, String string9, String string10, String string11, String string12) {
        FormatCell formatCell = new FormatCell();
        if (string == null) {
            formatCell.setRow("0");
        } else {
            formatCell.setRow(string);
        }
        if (string2 == null) {
            formatCell.setCol("0");
        } else {
            formatCell.setCol(string2);
        }
        if (string3 == null) {
            formatCell.setRowspan("1");
        } else {
            formatCell.setRowspan(string3);
        }
        if (string4 == null) {
            formatCell.setColspan("1");
        } else {
            formatCell.setColspan(string4);
        }
        if (string5 == null) {
            formatCell.setStyle("");
        } else {
            formatCell.setStyle(string5);
        }
        if (string6 == null) {
            formatCell.setStyle1("");
        } else {
            formatCell.setStyle1(string6);
        }
        if (string7 == null) {
            formatCell.setStyle2("");
        } else {
            formatCell.setStyle2(string7);
        }
        if (string8 == null) {
            formatCell.setText("");
        } else {
            formatCell.setText(string8);
        }
        if (string12 == null) {
            formatCell.setType("");
        } else {
            formatCell.setType(string12);
        }
        if (n == 3) {
            this.head.add(formatCell);
        } else if (n == 4) {
            this.body.add(formatCell);
        } else if (n == 5) {
            this.summary.add(formatCell);
        }
    }

    public int getHeadCellCount() {
        return this.head.size();
    }

    public FormatCell getHeadCell(int n) {
        return this.head.get(n);
    }

    public int getBodyCellCount() {
        return this.body.size();
    }

    public FormatCell getBodyCell(int n) {
        return this.body.get(n);
    }

    public int getSummaryCellCount() {
        return this.summary.size();
    }

    public FormatCell getSummary(int n) {
        return this.summary.get(n);
    }
}

