/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.extend;

import com.nexacro.xapi.data.ColumnHeader;
import com.nexacro.xapi.data.DataSet;
import com.nexacro.xapi.data.DataSetList;
import com.nexacro.xapi.data.DataTypes;
import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.Variable;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.DataSerializer;
import com.nexacro.xapi.tx.DataTypeChanger;
import com.nexacro.xapi.tx.PlatformException;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class PlatformCsvDataSerializer
implements DataSerializer {
    private Log log = LogFactory.getLog(PlatformCsvDataSerializer.class);
    private char etx = (char)3;
    private String CR = "\r\n";
    private static final int BUFFER_SIZE = 4096;
    private byte[] buffer;

    public void setProperty(String string, Object object) {
    }

    public void writeData(OutputStream outputStream, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this + ", charset=" + string));
        }
        try {
            this.writeData(new OutputStreamWriter(outputStream, string), platformData, dataTypeChanger, string);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Unsupported charset: " + string), (Throwable)unsupportedEncodingException);
            }
            throw new PlatformException("Unsupported charset: " + string, (Throwable)unsupportedEncodingException);
        }
    }

    public void writeData(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws PlatformException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing data: this=" + this + ", charset=" + string));
        }
        try {
            this.write(writer, platformData, dataTypeChanger, string);
        }
        catch (IOException iOException) {
            String string2 = "PlatformSsv";
            if (this.log.isErrorEnabled()) {
                this.log.error((Object)("Could not serialize: contentType=" + string2), (Throwable)iOException);
            }
            throw new PlatformException("Could not serialize: contentType=" + string2, (Throwable)iOException);
        }
    }

    private void write(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger, String string) throws IOException {
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"write(Writer, PlatformData, DataTypeChanger, String): started");
        }
        this.writeHeader(writer, platformData, string);
        this.writeVariableList(writer, platformData, dataTypeChanger);
        this.writeDataSetList(writer, platformData, dataTypeChanger);
        writer.flush();
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)"write(Writer, PlatformData, DataTypeChanger, String): finished");
        }
    }

    private void writeHeader(Writer writer, PlatformData platformData, String string) throws IOException {
        if (string == null) {
            writer.write("CSV");
        } else {
            writer.write("CSV:" + string);
        }
    }

    private void writeVariableList(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        VariableList variableList = platformData.getVariableList();
        int n = variableList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing VariableList: count=" + n));
        }
        if (n > 0) {
            writer.write(this.CR);
            for (int i = 0; i < n; ++i) {
                if (i > 0) {
                    writer.write(44);
                }
                this.writeVariable(writer, variableList.get(i), dataTypeChanger);
            }
        }
    }

    private void writeVariable(Writer writer, Variable variable, DataTypeChanger dataTypeChanger) throws IOException {
        if (DataTypes.isBinary((int)variable.getType())) {
            this.writeBinaryVariable(writer, variable);
        } else {
            this.writeStringVariable(writer, variable);
        }
    }

    private void writeStringVariable(Writer writer, Variable variable) throws IOException {
        String string = variable.getName();
        String string2 = this.getDataType(variable.getType());
        String string3 = this.getStringValue(variable);
        int n = string3 == null ? 0 : string3.length();
        StringBuffer stringBuffer = new StringBuffer(n + 32);
        if (string3 == null) {
            stringBuffer.append(string).append('=');
        } else {
            stringBuffer.append(string).append('=').append(string3);
        }
        writer.write(stringBuffer.toString());
        if (this.log.isTraceEnabled()) {
            this.log.trace((Object)("writeString(Writer, Variable): name=" + string + ", type=" + string2 + ", value=" + string3));
        }
    }

    private void writeBinaryVariable(Writer writer, Variable variable) throws IOException {
        String string = variable.getName();
        String string2 = this.getDataType(variable.getType());
        byte[] byArray = this.getBinaryValue(variable);
        if (byArray == null) {
            StringBuffer stringBuffer = new StringBuffer(32);
            stringBuffer.append(string).append('=');
            writer.write(stringBuffer.toString());
        } else {
            String string3 = Base64.encodeBase64String((byte[])byArray);
            int n = string3 == null ? 0 : string3.length();
            StringBuffer stringBuffer = new StringBuffer(n + 32);
            stringBuffer.append(string).append('=');
            if (string3 != null) {
                stringBuffer.append(string3);
            }
            writer.write(stringBuffer.toString());
        }
    }

    private String getStringValue(Variable variable) {
        int n = variable.getType();
        if (n == 4) {
            return variable.getBoolean() ? "1" : "0";
        }
        String string = variable.getString();
        return string;
    }

    private byte[] getBinaryValue(Variable variable) {
        return variable.getBlob();
    }

    private void writeDataSetList(Writer writer, PlatformData platformData, DataTypeChanger dataTypeChanger) throws IOException {
        DataSetList dataSetList = platformData.getDataSetList();
        int n = dataSetList.size();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSetList: count=" + n));
        }
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                writer.write(this.CR);
            }
            this.writeDataSet(writer, platformData, dataSetList.get(i), dataTypeChanger);
        }
    }

    private void writeDataSet(Writer writer, PlatformData platformData, DataSet dataSet, DataTypeChanger dataTypeChanger) throws IOException {
        String string = dataSet.getName();
        String string2 = dataSet.getAlias();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing DataSet: name=" + string + ", alias=" + string2 + ", columnCount=" + dataSet.getColumnCount() + ", rowCount=" + dataSet.getRowCount() + ", removedRowCount=" + dataSet.getRemovedRowCount()));
        }
        writer.write(this.CR);
        writer.write("Dataset:" + string2);
        int[] nArray = this.getTargetDataTypes(dataSet, dataTypeChanger);
        this.writeColumns(writer, dataSet, nArray);
        this.writeRows(writer, platformData, dataSet, nArray);
    }

    private void writeColumns(Writer writer, DataSet dataSet, int[] nArray) throws IOException {
        int n = dataSet.getColumnCount();
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            int n2 = nArray[i];
            if (i > 0) {
                stringBuffer.append(',');
            }
            if (columnHeader.getType() == 0) {
                this.writeDefaultColumnHeader(stringBuffer, columnHeader, n2);
                continue;
            }
            if (columnHeader.getType() == 1) continue;
            throw new IOException("Invalid column type: " + columnHeader.getType());
        }
        if (stringBuffer.length() > 0) {
            writer.write(this.CR);
            writer.write(stringBuffer.toString());
        }
    }

    private void writeDefaultColumnHeader(StringBuffer stringBuffer, ColumnHeader columnHeader, int n) throws IOException {
        String string = columnHeader.getName();
        String string2 = this.getDataType(n);
        int n2 = columnHeader.getDataSize();
        stringBuffer.append(string);
        stringBuffer.append(':');
        stringBuffer.append(string2);
        stringBuffer.append('(');
        stringBuffer.append(n2);
        stringBuffer.append(')');
    }

    private void writeRows(Writer writer, PlatformData platformData, DataSet dataSet, int[] nArray) throws IOException {
        boolean bl;
        int n = dataSet.getSaveType();
        if (n == 0) {
            n = platformData.getSaveType();
        }
        if (n == 0) {
            n = 2;
        }
        int n2 = dataSet.getRowCount();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Writing rows: count=" + n2));
        }
        if (bl = dataSet.isCheckingGetterDataIndex()) {
            dataSet.setCheckingGetterDataIndex(false);
        }
        for (int i = 0; i < n2; ++i) {
            this.writeRow(writer, dataSet, nArray, i, n);
        }
        if (bl) {
            dataSet.setCheckingGetterDataIndex(true);
        }
    }

    private void writeRow(Writer writer, DataSet dataSet, int[] nArray, int n, int n2) throws IOException {
        int n3 = dataSet.getRowType(n);
        if ((n % 10 == 0 || n == dataSet.getRowCount() - 1) && this.log.isTraceEnabled()) {
            this.log.trace((Object)("writeRow(Writer, DataSet, int[], int, int): row=" + n + ", saveType=" + n2 + ", rowType=" + n3));
        }
        if (n2 != 1 && (n2 == 2 ? n3 == 3 : (n2 == 3 ? n3 == 0 || n3 == 3 : (n2 == 4 ? n3 == 0 || n3 == 1 || n3 == 2 : n2 == 5 && n3 == 0)))) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n4 = dataSet.getColumnCount();
        for (int i = 0; i < n4; ++i) {
            Object object;
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (columnHeader.isConstant()) continue;
            if (i > 0) {
                stringBuffer.append(',');
            }
            int n5 = columnHeader.getDataType();
            int n6 = nArray[i];
            if (n6 == 13 || DataTypes.isBinary((int)n6)) {
                byte[] byArray = object = n5 == 13 ? this.getBinaryValueFromFile(dataSet, n, i, n6) : this.getBinaryValue(dataSet, n, i);
                if (object == null) continue;
                String string = Base64.encodeBase64String((byte[])object);
                stringBuffer.append(string);
                continue;
            }
            object = n5 == 13 ? this.getStringValueFromFile(dataSet, n, i, n6) : this.getStringValue(dataSet, n, i);
            if (object == null) continue;
            stringBuffer.append((String)object);
        }
        writer.write(this.CR);
        writer.write(stringBuffer.toString());
    }

    private byte[] getBinaryValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 12 || n3 == 13) {
            String string = dataSet.getString(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + string + ", content=" + byArray));
            }
            return byArray;
        }
        return null;
    }

    private String getStringValueFromFile(DataSet dataSet, int n, int n2, int n3) throws IOException {
        if (n3 == 2) {
            String string = dataSet.getString(n, n2);
            byte[] byArray = this.loadFile(string);
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Loading data from file: filename=" + string + ", content=" + byArray));
            }
            return byArray == null ? null : new String(byArray);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] loadFile(String string) throws IOException {
        if (string == null) {
            return null;
        }
        File file = new File(string);
        if (file.canRead()) {
            FileInputStream fileInputStream = new FileInputStream(file);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byte[] byArray = this.getBuffer();
            try {
                int n;
                while ((n = fileInputStream.read(byArray)) != -1) {
                    byteArrayOutputStream.write(byArray, 0, n);
                }
                byteArrayOutputStream.close();
                byte[] byArray2 = byteArrayOutputStream.toByteArray();
                return byArray2;
            }
            finally {
                fileInputStream.close();
            }
        }
        return null;
    }

    private byte[] getBuffer() {
        if (this.buffer == null) {
            this.buffer = new byte[4096];
        }
        return this.buffer;
    }

    private byte[] getBinaryValue(DataSet dataSet, int n, int n2) {
        return dataSet.getBlob(n, n2);
    }

    private String getStringValue(DataSet dataSet, int n, int n2) {
        int n3 = dataSet.getColumn(n2).getDataType();
        if (n3 == 4) {
            return dataSet.getBoolean(n, n2) ? "1" : "0";
        }
        String string = dataSet.getString(n, n2);
        return string;
    }

    private int[] getTargetDataTypes(DataSet dataSet, DataTypeChanger dataTypeChanger) {
        int n = dataSet.getColumnCount();
        int[] nArray = new int[n];
        for (int i = 0; i < n; ++i) {
            ColumnHeader columnHeader = dataSet.getColumn(i);
            if (dataTypeChanger == null) {
                nArray[i] = columnHeader.getDataType();
                continue;
            }
            String string = dataSet.getAlias();
            String string2 = columnHeader.getName();
            int n2 = columnHeader.getDataType();
            nArray[i] = dataTypeChanger.getDataType(string, string2, n2);
        }
        return nArray;
    }

    private String getDataType(int n) {
        if (n == 4) {
            return DataTypes.toStringType((int)3);
        }
        if (n == 5) {
            return DataTypes.toStringType((int)8);
        }
        if (n == 7) {
            return DataTypes.toStringType((int)6);
        }
        if (n == 13) {
            return DataTypes.toStringType((int)12);
        }
        return DataTypes.toStringType((int)n);
    }
}

