/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.manager;

import com.nexacro.xeni.data.ExportData;
import com.nexacro.xeni.data.ExportDataFactory;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExportImportFileManager
extends TimerTask {
    private static final Log oLogger = LogFactory.getLog(ExportImportFileManager.class);
    private static ExportImportFileManager INSTANCE = null;
    private static Timer TIMER = null;
    private String sExportPath = null;
    private String sImportPath = null;
    private int m_iStorageTime = 0;
    SimpleDateFormat m_oSdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    private boolean bFileManage = true;

    public static synchronized ExportImportFileManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ExportImportFileManager();
        }
        return INSTANCE;
    }

    public synchronized Timer newTimerInstance() {
        if (TIMER == null) {
            TIMER = new Timer();
        }
        return TIMER;
    }

    public Timer getTimer() {
        return TIMER;
    }

    public void setServiceDir(String string, String string2, boolean bl) {
        this.sExportPath = string;
        this.sImportPath = string2 + '/';
        this.bFileManage = bl;
    }

    public void setServiceDir(String string, boolean bl) {
        this.sExportPath = string;
        this.bFileManage = bl;
    }

    public void setStorageTime(int n) {
        this.m_iStorageTime = n;
    }

    public void run() {
        if (oLogger.isInfoEnabled()) {
            oLogger.info((Object)("run file manager [ " + this.m_oSdf.format(System.currentTimeMillis()) + " ]"));
        }
        this.removeUncompletedChunkedData();
        if (this.bFileManage) {
            this.deleteExportFile();
        }
    }

    public void deleteExportFile() {
        File file;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)"Find file has been exported.");
        }
        if (!(file = new File(this.sExportPath)).exists()) {
            boolean bl;
            if (oLogger.isInfoEnabled()) {
                oLogger.info((Object)("The directory does not exist [ " + this.sExportPath + " ]"));
            }
            if (bl = file.mkdir()) {
                if (oLogger.isInfoEnabled()) {
                    oLogger.info((Object)"'Export' path has been created.");
                }
            } else {
                if (oLogger.isWarnEnabled()) {
                    oLogger.warn((Object)("Fail to creat directory [ " + this.sExportPath + " ]"));
                    oLogger.warn((Object)"File Monitor Thread Terminated.");
                }
                this.getTimer().cancel();
                return;
            }
        }
        this.deleteFile(file);
    }

    private void deleteFile(File file) {
        boolean bl = false;
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            for (File file2 : fileArray) {
                if (file2.isDirectory()) {
                    this.deleteFile(file2);
                    continue;
                }
                if (!bl) {
                    Calendar calendar = Calendar.getInstance();
                    Date date = calendar.getTime();
                    calendar.setTimeInMillis(file2.lastModified());
                    calendar.add(13, this.m_iStorageTime);
                    Date date2 = calendar.getTime();
                    if (date.getTime() < date2.getTime()) continue;
                    if (file2.delete()) {
                        bl = true;
                        if (!oLogger.isInfoEnabled()) continue;
                        oLogger.info((Object)("Succeeded in deleting files [ " + file2.getName() + " ]"));
                        continue;
                    }
                    if (!oLogger.isWarnEnabled()) continue;
                    oLogger.warn((Object)("Failed to delete the file is in using [ " + file2.getName() + " ]"));
                    continue;
                }
                file2.delete();
            }
        }
        if (bl) {
            file.delete();
        }
    }

    public void removeUncompletedChunkedData() {
        HashMap<String, ExportData> hashMap = ExportDataFactory.getExportDataFactoryInstance().getExportDataFactory();
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)"Find chunk data uncompleted");
        }
        Set<String> set = hashMap.keySet();
        Iterator<String> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next();
            ExportData exportData = hashMap.get(string);
            Calendar calendar = Calendar.getInstance();
            Date date = calendar.getTime();
            long l = exportData.getLastAccTime();
            calendar.setTimeInMillis(l);
            Date date2 = calendar.getTime();
            calendar.add(13, this.m_iStorageTime);
            Date date3 = calendar.getTime();
            if (date.getTime() < date3.getTime()) continue;
            iterator.remove();
            if (!oLogger.isInfoEnabled()) continue;
            oLogger.info((Object)("Succeeded in deleting uncompleted chunk data [ " + string + " ]"));
        }
    }

    public void deleteImportFile() {
        File file;
        if (oLogger.isDebugEnabled()) {
            oLogger.debug((Object)"Find file has been imported.");
        }
        if (!(file = new File(this.sImportPath)).exists()) {
            boolean bl;
            if (oLogger.isInfoEnabled()) {
                oLogger.info((Object)("The directory does not exist [ " + this.sImportPath + " ]"));
            }
            if (bl = file.mkdir()) {
                if (oLogger.isInfoEnabled()) {
                    oLogger.info((Object)"'Import' path has been created.");
                }
            } else {
                if (oLogger.isWarnEnabled()) {
                    oLogger.warn((Object)("Fail to creat directory [ " + this.sImportPath + " ]"));
                    oLogger.warn((Object)"File Monitor Thread Terminated.");
                }
                this.getTimer().cancel();
                return;
            }
        }
        this.deleteFile(file);
    }
}

