/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.services;

import com.nexacro.xapi.data.PlatformData;
import com.nexacro.xapi.data.VariableList;
import com.nexacro.xapi.tx.HttpPlatformResponse;
import com.nexacro.xapi.tx.PlatformException;
import com.nexacro.xeni.manager.ExportImportFileManager;
import com.nexacro.xeni.services.GridExportImportAgent;
import com.nexacro.xeni.util.XeniProperties;
import java.io.IOException;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GridExportImportServlet
extends HttpServlet {
    private static final long serialVersionUID = -8877137699076711995L;
    private static final Log objLogger = LogFactory.getLog(GridExportImportServlet.class);
    private static String sAbsExportPath = null;
    private static String sAbsImportPath = null;
    private static String sDownloadUrl = null;
    private static String sExportUserPath = null;
    private static String sImportUserPath = null;
    private static String sExportUserUrl = null;
    private static String sExportRedirect = null;
    private static String sSeckeyword = null;
    private static int iRunPeriodSec = 1800;
    private static int iStorageTimeSec = 600;
    private static boolean isEnableMonitor = true;
    private static String sNumberFmt_lang = "ko";
    private static boolean isCsvQuote = true;
    private static boolean bOutExportPath = false;
    private static boolean bOutImportPath = false;

    public void init() throws ServletException {
        String string;
        Object object;
        int n;
        String string2;
        super.init();
        ServletContext servletContext = this.getServletContext();
        sExportUserPath = servletContext.getInitParameter("export-path");
        if (sExportUserPath == null || sExportUserPath.equalsIgnoreCase("")) {
            sExportUserPath = "export/";
        } else {
            if (sExportUserPath.startsWith("file://")) {
                sExportUserPath = sExportUserPath.substring(7);
                bOutExportPath = true;
            } else if (sExportUserPath.startsWith("/")) {
                sExportUserPath = sExportUserPath.substring(1);
            }
            if (!sExportUserPath.endsWith("/")) {
                sExportUserPath = sExportUserPath + "/";
            }
        }
        sExportUserUrl = servletContext.getInitParameter("export-url");
        sImportUserPath = servletContext.getInitParameter("import-path");
        if (sImportUserPath == null || sImportUserPath.equals("")) {
            sImportUserPath = "import";
        } else if (sImportUserPath.startsWith("file://")) {
            if (!(sImportUserPath = sImportUserPath.substring(7)).endsWith("/")) {
                sImportUserPath = sImportUserPath + "/";
            }
            bOutImportPath = true;
        } else {
            if (sImportUserPath.startsWith("/")) {
                sImportUserPath = sImportUserPath.substring(1);
            }
            if (sImportUserPath.endsWith("/")) {
                int n2 = sImportUserPath.lastIndexOf(47);
                sImportUserPath = sImportUserPath.substring(0, n2);
            }
        }
        String string3 = servletContext.getInitParameter("monitor-enabled");
        if (string3 != null && "false".equalsIgnoreCase(string3)) {
            isEnableMonitor = false;
        }
        if ((string2 = servletContext.getInitParameter("monitor-cycle-time")) != null && string2.length() > 0) {
            n = string2.indexOf(47);
            iRunPeriodSec = n > 0 ? (((String[])(object = string2.split("/"))).length > 1 && object[1].equalsIgnoreCase("sec") ? Integer.parseInt(object[0]) : Integer.parseInt(object[0]) * 60) : Integer.parseInt(string2) * 60;
        }
        if ((string2 = servletContext.getInitParameter("file-storage-time")) != null && string2.length() > 0) {
            n = string2.indexOf(47);
            iStorageTimeSec = n > 0 ? (((String[])(object = string2.split("/"))).length > 1 && object[1].equalsIgnoreCase("sec") ? Integer.parseInt(object[0]) : Integer.parseInt(object[0]) * 60) : Integer.parseInt(string2) * 60;
        }
        if ((string = servletContext.getInitParameter("numFmt-lang")) != null && string.length() > 0) {
            sNumberFmt_lang = string;
        }
        if ((object = servletContext.getInitParameter("csv-quote")) != null && "false".equalsIgnoreCase((String)object)) {
            isCsvQuote = false;
        }
        sExportRedirect = servletContext.getInitParameter("export-redirect");
        sSeckeyword = servletContext.getInitParameter("security-keyword");
    }

    public void doGet(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        GridExportImportAgent gridExportImportAgent = new GridExportImportAgent();
        int n = gridExportImportAgent.sendExportFileStream(httpServletRequest, httpServletResponse, sAbsExportPath);
        if (n < 0) {
            if (sExportRedirect != null && sExportRedirect.length() > 0) {
                httpServletResponse.sendRedirect(sExportRedirect);
            } else {
                this.sendErrorMessage(httpServletResponse, n, gridExportImportAgent.getErrorMessage());
            }
        }
    }

    public void doPost(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws ServletException, IOException {
        try {
            this.processRequest(httpServletRequest, httpServletResponse);
        }
        catch (PlatformException platformException) {
            this.sendErrorMessage(httpServletResponse, -3101, "Platform Error ( " + platformException.getMessage() + " )");
            platformException.printStackTrace();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.sendErrorMessage(httpServletResponse, -3201, "Illegal Argument ( " + illegalArgumentException.getMessage() + " )");
            illegalArgumentException.printStackTrace();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.sendErrorMessage(httpServletResponse, -3301, "Index Out Of Bounds ( " + indexOutOfBoundsException.getMessage() + " )");
            indexOutOfBoundsException.printStackTrace();
        }
        catch (IllegalStateException illegalStateException) {
            this.sendErrorMessage(httpServletResponse, -3401, "Illegal State ( " + illegalStateException.getMessage() + " )");
            illegalStateException.printStackTrace();
        }
        catch (NullPointerException nullPointerException) {
            this.sendErrorMessage(httpServletResponse, -2004, nullPointerException + "");
            nullPointerException.printStackTrace();
        }
        catch (IOException iOException) {
            this.sendErrorMessage(httpServletResponse, -2003, iOException + "");
            iOException.printStackTrace();
        }
        catch (Exception exception) {
            this.sendErrorMessage(httpServletResponse, -2001, exception + "");
            exception.printStackTrace();
        }
    }

    private void sendErrorMessage(HttpServletResponse httpServletResponse, int n, String string) {
        block4: {
            PlatformData platformData = new PlatformData();
            VariableList variableList = platformData.getVariableList();
            variableList.add("ErrorCode", n);
            variableList.add("ErrorMsg", string);
            HttpPlatformResponse httpPlatformResponse = new HttpPlatformResponse(httpServletResponse, "PlatformSsv", "UTF-8");
            httpPlatformResponse.setData(platformData);
            if (objLogger.isInfoEnabled()) {
                objLogger.info((Object)string);
            }
            if (objLogger.isDebugEnabled()) {
                objLogger.debug((Object)("RESPONSE DATA XML ============================ \n" + platformData.saveXml()));
            }
            try {
                httpPlatformResponse.sendData();
            }
            catch (PlatformException platformException) {
                if (!objLogger.isInfoEnabled()) break block4;
                objLogger.info((Object)platformException.getMessage());
            }
        }
    }

    private void processRequest(HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) throws Exception {
        String string;
        String string2 = null;
        int n = 0;
        long l = System.currentTimeMillis();
        this.setPath(httpServletRequest);
        if (isEnableMonitor) {
            this.executeTimerSchedule();
        }
        GridExportImportAgent gridExportImportAgent = new GridExportImportAgent();
        boolean bl = ServletFileUpload.isMultipartContent((HttpServletRequest)httpServletRequest);
        boolean bl2 = false;
        String string3 = httpServletRequest.getHeader("user-agent");
        if (string3 != null) {
            if (objLogger.isDebugEnabled()) {
                objLogger.debug((Object)("Request user-agent : " + string3));
            }
            boolean bl3 = bl2 = (string = XeniProperties.getStringProperty("xeni.security.agent")) == null ? false : string3.contains(string);
        }
        if (bl || bl2) {
            string2 = "import";
            n = gridExportImportAgent.gridImport(sAbsImportPath, sNumberFmt_lang, isEnableMonitor, httpServletRequest, httpServletResponse, sSeckeyword);
        } else {
            string2 = "export";
            string = new VariableList();
            string.add("csv-quote", isCsvQuote);
            n = gridExportImportAgent.gridExport(sAbsExportPath, sDownloadUrl, bOutExportPath, httpServletRequest, httpServletResponse, (VariableList)string);
        }
        if (n < 0) {
            this.sendErrorMessage(httpServletResponse, n, gridExportImportAgent.getErrorMessage());
        }
        if (objLogger.isInfoEnabled()) {
            long l2 = System.currentTimeMillis();
            long l3 = l2 - l;
            objLogger.info((Object)(string2 + " running time.......[ " + l3 + " ]"));
        }
    }

    private void setPath(HttpServletRequest httpServletRequest) {
        String string;
        if (sAbsExportPath == null || sAbsImportPath == null) {
            string = httpServletRequest.getSession().getServletContext().getRealPath("/");
            if (!(string = string.replaceAll("\\\\", "/")).endsWith("/")) {
                string = string + "/";
            }
            sAbsExportPath = bOutExportPath ? sExportUserPath : string + sExportUserPath;
            sAbsImportPath = bOutImportPath ? sImportUserPath : string + sImportUserPath;
        }
        string = null;
        string = sExportUserUrl != null && !"".equals(sExportUserUrl) ? sExportUserUrl : httpServletRequest.getRequestURL().toString();
        if (bOutExportPath) {
            sDownloadUrl = string;
        } else {
            int n = string.lastIndexOf("/");
            String string2 = string.substring(0, n + 1);
            sDownloadUrl = string2 + sExportUserPath;
        }
    }

    private void executeTimerSchedule() {
        ExportImportFileManager exportImportFileManager = ExportImportFileManager.getInstance();
        Timer timer = exportImportFileManager.getTimer();
        if (timer == null) {
            timer = exportImportFileManager.newTimerInstance();
            exportImportFileManager.setServiceDir(sAbsExportPath, sAbsImportPath, isEnableMonitor);
            exportImportFileManager.setStorageTime(iStorageTimeSec);
            timer.scheduleAtFixedRate((TimerTask)exportImportFileManager, iRunPeriodSec * 1000, (long)(iRunPeriodSec * 1000));
        }
    }
}

