/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.data;

import com.nexacro.xapi.data.DataSet;
import com.nexacro.xeni.data.GridExportFormatFactory;
import com.nexacro.xeni.data.exportformats.ExportFormat;
import com.nexacro.xeni.services.GridExportImportServlet;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;

public class ExportData {
    private DataSet dsCommand = new DataSet();
    private DataSet dsStyle = new DataSet();
    private DataSet dsCell = new DataSet();
    private ExportFormat gridformat = null;
    private String sAppendUrl = null;
    private boolean bAppendExport = false;
    private static final Log oLogger = LogFactory.getLog(GridExportImportServlet.class);
    private long lLastAccTime = 0L;

    public void setAppendExport(String string) {
        this.bAppendExport = true;
        this.sAppendUrl = string;
    }

    public boolean isAppendExport() {
        return this.bAppendExport;
    }

    public String getAppendExportUrl() {
        return this.sAppendUrl;
    }

    public void setCmdDataset(DataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        String string = this.dsCommand.getName();
        if (string == null) {
            this.dsCommand.setName(dataSet.getName());
            this.dsCommand.copyFrom(dataSet, true);
            String string2 = dataSet.getString(0, "format");
            GridExportFormatFactory gridExportFormatFactory = new GridExportFormatFactory();
            this.gridformat = gridExportFormatFactory.readFormatString(string2);
        } else {
            this.dsCommand.copyDataFrom(dataSet);
        }
    }

    public void setStyleDataset(DataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        String string = this.dsStyle.getName();
        if (string == null) {
            this.dsStyle.setName(dataSet.getName());
            this.dsStyle.copyFrom(dataSet, true);
        } else {
            this.dsStyle.copyDataFrom(dataSet, true);
        }
    }

    public void setCellDataset(DataSet dataSet) {
        if (dataSet == null) {
            return;
        }
        String string = this.dsCell.getName();
        if (string == null) {
            this.dsCell.setName(dataSet.getName());
            this.dsCell.copyFrom(dataSet, true);
        } else {
            this.dsCell.copyDataFrom(dataSet, true);
        }
    }

    public String export(String string, String string2) {
        String string3;
        block4: {
            HSSFWorkbook hSSFWorkbook = new HSSFWorkbook();
            HSSFSheet hSSFSheet = hSSFWorkbook.createSheet("test sheet");
            HSSFRow hSSFRow = hSSFSheet.createRow(0);
            HSSFCell hSSFCell = null;
            hSSFCell = hSSFRow.createCell(0);
            hSSFCell.setCellValue("Grid");
            hSSFCell = hSSFRow.createCell(1);
            hSSFCell.setCellValue("Export");
            hSSFCell = hSSFRow.createCell(2);
            hSSFCell.setCellValue("Import");
            string3 = this.dsCommand.getString(0, "item") + ".xls";
            String string4 = string + "export" + "/" + string3;
            File file = new File(string4);
            File file2 = file.getParentFile();
            if (!file2.exists()) {
                file2.mkdirs();
            }
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                hSSFWorkbook.write((OutputStream)fileOutputStream);
                fileOutputStream.close();
                if (oLogger.isInfoEnabled()) {
                    oLogger.info((Object)("have been saved export file.....[ " + file.getAbsolutePath() + " ]"));
                }
            }
            catch (Exception exception) {
                if (!oLogger.isInfoEnabled()) break block4;
                oLogger.info((Object)exception);
            }
        }
        return string2 + "export" + "/" + string3;
    }

    public DataSet getCmdDataset() {
        return this.dsCommand;
    }

    public DataSet getStyleDataset() {
        return this.dsStyle;
    }

    public DataSet getCellDataset() {
        return this.dsCell;
    }

    public void setLastAccTime(long l) {
        this.lLastAccTime = l;
    }

    public long getLastAccTime() {
        return this.lLastAccTime;
    }

    public ExportFormat getGridFormat() {
        return this.gridformat;
    }
}

