/*
 * Decompiled with CFR 0.152.
 */
package com.nexacro.xeni.extend;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;

public class XeniCSVReader {
    private BufferedReader bufreader;
    private boolean hasnextline = true;

    public XeniCSVReader(BufferedReader bufferedReader) {
        this.bufreader = bufferedReader;
    }

    public String[] readNext() throws IOException {
        String string = this.getNextLine();
        if (string == null) {
            return null;
        }
        return this.hasnextline ? this.parseLine(string) : null;
    }

    private String getNextLine() throws IOException {
        String string = this.bufreader.readLine();
        if (string == null) {
            this.hasnextline = false;
        }
        return this.hasnextline ? string : null;
    }

    private String[] parseLine(String string) throws IOException {
        boolean bl = false;
        StringBuilder stringBuilder = new StringBuilder();
        ArrayList<String> arrayList = new ArrayList<String>();
        do {
            if (bl) {
                stringBuilder.append("\n");
                string = this.getNextLine();
                if (string == null) break;
            }
            for (int i = 0; i < string.length(); ++i) {
                char c = string.charAt(i);
                if (c == '\\') {
                    if (this.isEscapable(string, bl, i)) {
                        stringBuilder.append(string.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    stringBuilder.append(c);
                    continue;
                }
                if (c == '\"') {
                    if (this.isEscapedQuote(string, bl, i)) {
                        stringBuilder.append(string.charAt(i + 1));
                        ++i;
                        continue;
                    }
                    boolean bl2 = bl = !bl;
                    if (i <= 2 || string.charAt(i - 1) == ',' || string.length() <= i + 1 || string.charAt(i + 1) == ',') continue;
                    stringBuilder.append(c);
                    continue;
                }
                if (c == ',' && !bl) {
                    arrayList.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                    continue;
                }
                stringBuilder.append(c);
            }
        } while (bl);
        arrayList.add(stringBuilder.toString());
        return arrayList.toArray(new String[0]);
    }

    private boolean isEscapedQuote(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && string.charAt(n + 1) == '\"';
    }

    private boolean isEscapable(String string, boolean bl, int n) {
        return bl && string.length() > n + 1 && (string.charAt(n + 1) == '\"' || string.charAt(n + 1) == '\\');
    }
}

